/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Statement;

public class ConfiguracaoProtocoloSFranco {
    public static final String TAG_SF = "sfranco";
    public static final String TAG_CODIGO_NO_SF = "codigo";
    public static final String TAG_LOTE_ATUAL = "lote";
    public static final String TAG_FAIXA_CIP_INICIO = "faixaCipInicio";
    public static final String TAG_FAIXA_CIP_FINAL = "faixaCipFinal";
    public static final String TAG_CIP_ATUAL = "cipAtual";
    public static final String TAG_USA_ETIQUETA = "usaEtiqueta";
    public static final String TAG_IGNORAR_VERSAO = "ignorarVersao";
    private int codigoNoSFranco;
    private int loteAtual;
    private BigInteger faixaCipInicio;
    private BigInteger faixaCipFinal;
    private BigInteger cipAtual;
    private boolean usaEtiqueta;
    private boolean ignorarVersaoLayout;

    public ConfiguracaoProtocoloSFranco(String xml) {
        this.setXML(xml);
    }

    public void setXML(String xml) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, TAG_SF);
            this.codigoNoSFranco = StringUtil.getInt(xml, TAG_CODIGO_NO_SF);
            this.loteAtual = StringUtil.getInt(xml, TAG_LOTE_ATUAL);
            this.faixaCipInicio = StringUtil.getBigInteger(xml, TAG_FAIXA_CIP_INICIO);
            this.faixaCipFinal = StringUtil.getBigInteger(xml, TAG_FAIXA_CIP_FINAL);
            this.usaEtiqueta = StringUtil.getValor(xml, TAG_USA_ETIQUETA).equals("TRUE");
            this.ignorarVersaoLayout = StringUtil.getValor(xml, TAG_IGNORAR_VERSAO).equals("TRUE");
            this.cipAtual = Funcoes.textoVazio(StringUtil.getValor(xml, TAG_CIP_ATUAL)) ? StringUtil.getBigInteger(xml, TAG_FAIXA_CIP_INICIO) : StringUtil.getBigInteger(xml, TAG_CIP_ATUAL);
        }
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_SF);
            xml.escrever(TAG_CODIGO_NO_SF, String.valueOf(this.codigoNoSFranco));
            xml.escrever(TAG_LOTE_ATUAL, String.valueOf(this.loteAtual));
            xml.escrever(TAG_FAIXA_CIP_INICIO, String.valueOf(this.faixaCipInicio));
            xml.escrever(TAG_FAIXA_CIP_FINAL, String.valueOf(this.faixaCipFinal));
            xml.escrever(TAG_CIP_ATUAL, String.valueOf(this.cipAtual));
            xml.escrever(TAG_USA_ETIQUETA, this.usaEtiqueta ? "TRUE" : "FALSE");
            xml.escrever(TAG_IGNORAR_VERSAO, this.ignorarVersaoLayout ? "TRUE" : "FALSE");
            xml.fechar(TAG_SF);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConfiguracaoProtocoloSFranco");
        }
        return xml.getXML();
    }

    public BigInteger getProximoCipDisponivel() {
        BigInteger proximoCod = this.cipAtual.add(BigInteger.ONE);
        if (proximoCod.compareTo(this.faixaCipInicio) < 0) {
            proximoCod = this.faixaCipInicio;
        }
        return proximoCod;
    }

    public BigInteger geraCip(Statement st, int codigoFilial, int codigoLabExterno) throws SQLException {
        if (!this.existeCipDisponivel()) {
            return null;
        }
        StringBuilder bui = new StringBuilder();
        this.cipAtual = this.getProximoCipDisponivel();
        bui.append("update labexterno set lae_configuracao = '").append(this.getXML()).append("'");
        bui.append(" where fil_codigo = ").append(codigoFilial);
        bui.append(" and lae_codigo = ").append(codigoLabExterno);
        st.execute(bui.toString());
        return this.cipAtual;
    }

    public boolean existeCipDisponivel() {
        return this.getProximoCipDisponivel().compareTo(this.faixaCipFinal) <= 0;
    }

    public BigInteger getQtCipRestante() {
        return this.faixaCipFinal.subtract(this.getProximoCipDisponivel().subtract(BigInteger.ONE));
    }

    public int getCodigoNoSFranco() {
        return this.codigoNoSFranco;
    }

    public void setCodigoNoSFranco(int codigoNoSFranco) {
        this.codigoNoSFranco = codigoNoSFranco;
    }

    public int getLoteAtual() {
        return this.loteAtual;
    }

    public void setLoteAtual(int loteAtual) {
        this.loteAtual = loteAtual;
    }

    public BigInteger getFaixaCipInicio() {
        return this.faixaCipInicio;
    }

    public void setFaixaCipInicio(BigInteger faixaCipInicio) {
        this.faixaCipInicio = faixaCipInicio;
    }

    public BigInteger getFaixaCipFinal() {
        return this.faixaCipFinal;
    }

    public void setFaixaCipFinal(BigInteger faixaCipFinal) {
        this.faixaCipFinal = faixaCipFinal;
    }

    public BigInteger getCipAtual() {
        return this.cipAtual;
    }

    public boolean isUsaEtiqueta() {
        return this.usaEtiqueta;
    }

    public void setUsaEtiqueta(boolean usaEtiqueta) {
        this.usaEtiqueta = usaEtiqueta;
    }

    public boolean isIgnorarVersaoLayout() {
        return this.ignorarVersaoLayout;
    }

    public void setIgnorarVersaoLayout(boolean ignorarVersaoLayout) {
        this.ignorarVersaoLayout = ignorarVersaoLayout;
    }
}

