/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.sf;

import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class CampoSFranco {
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_COMENTARIO = "comentario";
    private String codigo;
    private String comentario;

    public CampoSFranco(String codigo, String comentario) {
        this.codigo = codigo;
        this.comentario = comentario;
    }

    public CampoSFranco(String xml) {
        this.setXml(xml);
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getComentario() {
        return this.comentario;
    }

    public void setComentario(String comentario) {
        this.comentario = comentario;
    }

    public void addComentario(String comentario) {
        this.comentario = this.comentario.concat((this.comentario.length() > 0 ? "\n" : "") + comentario);
    }

    public String getXml() throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        this.escreveXml(xml);
        return xml.getXML();
    }

    public void escreveXml(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(TAG_CAMPO);
        xml.escrever(TAG_CODIGO, this.codigo);
        xml.escrever(TAG_COMENTARIO, this.comentario);
        xml.fechar(TAG_CAMPO);
    }

    private void setXml(String xml) {
        String xmlCampo = StringUtil.getValor(xml, TAG_CAMPO);
        this.codigo = StringUtil.getValor(xmlCampo, TAG_CODIGO);
        this.comentario = StringUtil.getValor(xmlCampo, TAG_COMENTARIO);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CampoSFranco) {
            CampoSFranco outroCampo = (CampoSFranco)obj;
            return this.codigo.equalsIgnoreCase(outroCampo.getCodigo());
        }
        return false;
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }
}

