/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.saomarcos.CamposResultadosSaoMarcos;
import jalis.laboratorio.util.parsers.saomarcos.ImportacaoSaoMarcos;
import jalis.model.vo.cadastro.exame.ExameSaoMarcosVO;
import jalis.service.integracaolaboratorioexterno.ExameSaoMarcosService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JProgressBar;

public class ParserImportacaoSaoMarcos {
    public static Map<String, ExameSaoMarcosVO> importarExamesSaoMarcos(HashMap<String, String> file, int codigoLabExterno, JProgressBar progress, ImportacaoSaoMarcos telaImportacao) throws Exception {
        HashMap<String, ExameSaoMarcosVO> examesNovos = new HashMap<String, ExameSaoMarcosVO>();
        boolean arquivoResultado = false;
        Map<String, ExameSaoMarcosVO> examesAntigos = ParserImportacaoSaoMarcos.loadExamesSaoMarcos(codigoLabExterno);
        HashMap<String, ExameSaoMarcosVO> examesExcluidos = new HashMap<String, ExameSaoMarcosVO>();
        String dadosAdicionais = file.get("DadosAdicionais");
        String camposResultado = file.get("ParametroResultado");
        String exames = file.get("ExamesAmostras");
        HashMap<String, String> mapAdicionais = ParserImportacaoSaoMarcos.extrairDadosAdicionais(dadosAdicionais);
        HashMap<String, List<CamposResultadosSaoMarcos>> mapResultados = ParserImportacaoSaoMarcos.extrairResultados(camposResultado);
        if (!Funcoes.textoVazio(exames)) {
            String[] linhas = exames.split("\n");
            for (String s : linhas) {
                String[] exame = s.split("=");
                if (!ParserImportacaoSaoMarcos.linhaValida(exame[1], "exame".toUpperCase()) || !ParserImportacaoSaoMarcos.validaExame(exame, 4).booleanValue()) continue;
                ExameSaoMarcosVO exameSaoMarcosVO = new ExameSaoMarcosVO();
                exameSaoMarcosVO.setFilCodigo(Integer.valueOf(Variaveis.filialPadrao));
                exameSaoMarcosVO.setSmaCodExame(exame[0]);
                exameSaoMarcosVO.setDescricaoExame(exame[1]);
                exameSaoMarcosVO.setSmaCodMaterial(exame[2]);
                exameSaoMarcosVO.setSmaDescricaoMaterial(exame[3]);
                exameSaoMarcosVO.setLaeCodigo(codigoLabExterno);
                exameSaoMarcosVO.setSmaxml(ParserImportacaoSaoMarcos.getXml(exameSaoMarcosVO, mapResultados, mapAdicionais));
                examesNovos.put(exameSaoMarcosVO.getSmaCodExame(), exameSaoMarcosVO);
            }
            ParserImportacaoSaoMarcos.deletaExames(codigoLabExterno, progress);
            ParserImportacaoSaoMarcos.inserirExamesSaoMarcos(examesNovos, codigoLabExterno, progress);
            examesExcluidos.putAll(examesAntigos);
            for (String ex : examesNovos.keySet()) {
                if (!ParserImportacaoSaoMarcos.contemExameLista(examesExcluidos, ex)) continue;
                examesExcluidos.remove(ex);
            }
            Conexao.arquivaSQL();
        }
        return examesExcluidos;
    }

    private static String getXml(ExameSaoMarcosVO exameSaoMarcos, HashMap<String, List<CamposResultadosSaoMarcos>> mapResultados, HashMap<String, String> mapAdicionais) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("saomarcos");
        xml.escrever("codigo", exameSaoMarcos.getSmaCodExame().toString());
        xml.escrever("descricao", exameSaoMarcos.getDescricaoExame());
        xml.escrever("material", exameSaoMarcos.getSmaDescricaoMaterial());
        xml.escrever("desc_material", exameSaoMarcos.getSmaDescricaoMaterial());
        xml = ParserImportacaoSaoMarcos.importarDadosAdicionais(xml, mapAdicionais, exameSaoMarcos.getSmaCodExame(), false);
        xml.abrir("resultados");
        xml.escrever("observacao", "Observa\u00e7\u00e3o do exame");
        xml.escrever("dataresultado", "Data do resultado");
        xml = ParserImportacaoSaoMarcos.importarResultados(xml, exameSaoMarcos.getSmaCodExame(), mapResultados);
        xml.fechar("resultados");
        xml.fechar("saomarcos");
        return xml.getXML();
    }

    private static XMLStringBuilder importarResultados(XMLStringBuilder xml, String smaCodExame, HashMap<String, List<CamposResultadosSaoMarcos>> mapResultados) throws XMLStringBuilderException {
        for (String key : mapResultados.keySet()) {
            if (!ParserImportacaoSaoMarcos.keySetValido(key, smaCodExame)) continue;
            List<CamposResultadosSaoMarcos> camposResultados = mapResultados.get(key);
            for (CamposResultadosSaoMarcos camposResultadosSaoMarcos : camposResultados) {
                xml.abrir("campo");
                xml.escrever("atributo", camposResultadosSaoMarcos.getNomeParametro());
                xml.escrever("nome-parametro", camposResultadosSaoMarcos.getDescricaoParametro());
                xml.escrever("linharesultado", camposResultadosSaoMarcos.getLinhaResultado());
                xml.escrever("metodo", camposResultadosSaoMarcos.getMetodo());
                xml.escrever("conclusao", camposResultadosSaoMarcos.getConclusao());
                xml.escrever("vlr_referencia", camposResultadosSaoMarcos.getValorReferencia());
                xml.escrever("observacao", camposResultadosSaoMarcos.getObservacao());
                xml.escrever("resultado", camposResultadosSaoMarcos.getResultado());
                xml.fechar("campo");
            }
        }
        return xml;
    }

    private static XMLStringBuilder importarDadosAdicionais(XMLStringBuilder xml, HashMap<String, String> mapAdicionais, String smaCodExame, boolean dadosAdicionais) throws XMLStringBuilderException {
        for (String key : mapAdicionais.keySet()) {
            if (!ParserImportacaoSaoMarcos.keySetValido(key, smaCodExame)) continue;
            String[] keyAdds = mapAdicionais.get(key).split(";");
            String tag = StringUtil.getValor(xml.toString(), "dados_adicionais");
            if (!dadosAdicionais) {
                xml.abrir("dados_adicionais");
            }
            for (String adicional : keyAdds) {
                xml.abrir("dado");
                xml.abrir("descricao");
                xml.escrever(adicional);
                xml.fechar("descricao");
                xml.fechar("dado");
            }
            if (dadosAdicionais) continue;
            xml.fechar("dados_adicionais");
        }
        return xml;
    }

    private static HashMap<String, List<CamposResultadosSaoMarcos>> extrairResultados(String resultados) throws Exception {
        HashMap<String, List<CamposResultadosSaoMarcos>> mapResultados = new HashMap<String, List<CamposResultadosSaoMarcos>>();
        if (!Funcoes.textoVazio(resultados)) {
            String[] linhas = resultados.split("\n");
            String codigoExame = "";
            ArrayList<CamposResultadosSaoMarcos> listaResultados = new ArrayList<CamposResultadosSaoMarcos>();
            for (String s : linhas) {
                String[] aCamposResultados;
                if (!ParserImportacaoSaoMarcos.linhaValida(s, "codigo".toUpperCase()) || !ParserImportacaoSaoMarcos.validaExame(aCamposResultados = s.split("="), 5).booleanValue()) continue;
                if (ParserImportacaoSaoMarcos.validaCodigoExame(codigoExame, aCamposResultados[0])) {
                    if (!Funcoes.textoVazio(codigoExame)) {
                        mapResultados.put(codigoExame, listaResultados);
                    }
                    codigoExame = aCamposResultados[0];
                    listaResultados = new ArrayList();
                }
                String descricaoResultado = aCamposResultados[2];
                String parametroResultado = aCamposResultados[3];
                String linha = aCamposResultados[4];
                CamposResultadosSaoMarcos camposResultados = new CamposResultadosSaoMarcos();
                camposResultados.setCodigoExame(codigoExame);
                camposResultados.setNomeParametro(parametroResultado);
                camposResultados.setDescricaoParametro(descricaoResultado);
                camposResultados.setLinhaResultado(linha);
                camposResultados.setMetodo("M\u00e9todo");
                camposResultados.setConclusao("Conclus\u00e3o");
                camposResultados.setValorReferencia("Valor refer\u00eancia");
                camposResultados.setObservacao("Observa\u00e7\u00e3o");
                camposResultados.setResultado("Resultado");
                listaResultados.add(camposResultados);
            }
        }
        return mapResultados;
    }

    private static HashMap<String, String> extrairDadosAdicionais(String dadosAdicionais) {
        HashMap<String, String> mapDadosAdicionais = new HashMap<String, String>();
        if (!Funcoes.textoVazio(dadosAdicionais)) {
            String[] linhas;
            for (String s : linhas = dadosAdicionais.split("\n")) {
                String add;
                String[] aDadosAdicionais;
                if (!ParserImportacaoSaoMarcos.linhaValida(s.toUpperCase(), "codigo".toUpperCase()) || !ParserImportacaoSaoMarcos.validaExame(aDadosAdicionais = s.split("="), 4).booleanValue()) continue;
                String codigoExame = aDadosAdicionais[0];
                String dados = aDadosAdicionais[3];
                if (ParserImportacaoSaoMarcos.contemExame(mapDadosAdicionais, codigoExame) && !ParserImportacaoSaoMarcos.contemAdicional(dados, add = mapDadosAdicionais.get(codigoExame))) {
                    dados = dados + ";" + add;
                }
                mapDadosAdicionais.put(codigoExame, dados);
            }
        }
        return mapDadosAdicionais;
    }

    private static boolean contemExame(HashMap<String, String> mapDadosAdicionais, String codigoExame) {
        return mapDadosAdicionais.containsKey(codigoExame);
    }

    private static boolean contemAdicional(String dados, String add) {
        return add.contentEquals(dados);
    }

    private static Boolean validaExame(String[] aDadosAdicionais, int posicao) {
        return aDadosAdicionais.length == posicao;
    }

    private static Map<String, ExameSaoMarcosVO> loadExamesSaoMarcos(int codigoLabExterno) throws SQLException {
        ExameSaoMarcosService serviceExameSaoMarcos = new ExameSaoMarcosService();
        return serviceExameSaoMarcos.loadExamesSaoMarcos(codigoLabExterno, Variaveis.filialPadrao);
    }

    private static void deletaExames(int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        IntegracaoLabExternoUtil.deletaExame(Conexao.getStatement(), Variaveis.filialPadrao, codigoLabExterno, 12, new Object[0]);
    }

    private static void inserirExamesSaoMarcos(Map<String, ExameSaoMarcosVO> exames, int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        for (String mnemonico : exames.keySet()) {
            ExameSaoMarcosVO exame = exames.get(mnemonico);
            IntegracaoLabExternoUtil.insertExame(Conexao.getStatement(), Variaveis.filialPadrao, codigoLabExterno, 12, exame.getSmaCodExame(), StringUtil.textoDB(exame.getDescricaoExame()), exame.getSmaCodMaterial(), exame.getSmaDescricaoMaterial(), exame.getSmaxml());
            ParserImportacaoSaoMarcos.incrementarBarra(progress);
        }
    }

    public static List<String> importarDadosAdicionais(HashMap<String, String> arquivo, int codigoLabExterno, JProgressBar progress, ImportacaoSaoMarcos importacaoSaoMarcos) throws Exception {
        ExameSaoMarcosService serviceExameSaoMarcos = new ExameSaoMarcosService();
        String dadosAdicionais = arquivo.get("DadosAdicionais");
        ArrayList<String> listaDadosAdicionais = new ArrayList<String>();
        HashMap<String, String> mapAdicionais = ParserImportacaoSaoMarcos.extrairDadosAdicionais(dadosAdicionais);
        Map<String, ExameSaoMarcosVO> mapExames = serviceExameSaoMarcos.loadExamesSaoMarcos(codigoLabExterno, Variaveis.filialPadrao);
        if (mapExames.isEmpty()) {
            throw new SQLException("\u00c9 necess\u00e1rio fazer primeiro a importa\u00e7\u00e3o da lista de exames.");
        }
        for (String keyAdicional : mapAdicionais.keySet()) {
            if (!ParserImportacaoSaoMarcos.possuiExames(mapExames, keyAdicional)) {
                listaDadosAdicionais.add(keyAdicional);
                continue;
            }
            ParserImportacaoSaoMarcos.incrementarBarra(progress);
            ExameSaoMarcosVO exameSaoMarcos = mapExames.get(keyAdicional);
            StringBuilder buf = new StringBuilder();
            String xml = exameSaoMarcos.getSmaxml();
            buf.append(xml);
            XMLStringBuilder novoXML = new XMLStringBuilder();
            StringUtil.setValor(buf, "dados_adicionais", ParserImportacaoSaoMarcos.importarDadosAdicionais(novoXML, mapAdicionais, exameSaoMarcos.getSmaCodExame(), true).getXML());
            exameSaoMarcos.setSmaxml(buf.toString());
            serviceExameSaoMarcos.atualizarXml(exameSaoMarcos.getFilCodigo().toString(), codigoLabExterno, keyAdicional, exameSaoMarcos.getSmaxml().toString());
        }
        Conexao.arquivaSQL();
        return listaDadosAdicionais;
    }

    public static List<String> importarCamposResultado(HashMap<String, String> arquivo, int codigoLabExterno, JProgressBar progress, ImportacaoSaoMarcos importacaoSaoMarcos) throws Exception {
        ExameSaoMarcosService serviceExameSaoMarcos = new ExameSaoMarcosService();
        String camposResultado = arquivo.get("ParametroResultado");
        HashMap<String, List<CamposResultadosSaoMarcos>> mapResultados = ParserImportacaoSaoMarcos.extrairResultados(camposResultado);
        ArrayList<String> examesNaoImportados = new ArrayList<String>();
        String codigoExame = "";
        Map<String, ExameSaoMarcosVO> mapExames = serviceExameSaoMarcos.loadExamesSaoMarcos(codigoLabExterno, Variaveis.filialPadrao);
        if (ParserImportacaoSaoMarcos.listaVazia(mapExames)) {
            throw new SQLException("\u00c9 necess\u00e1rio fazer primeiro a importa\u00e7\u00e3o da lista de exames.");
        }
        for (String keyResultados : mapResultados.keySet()) {
            if (ParserImportacaoSaoMarcos.validaCodigoExame(codigoExame, keyResultados)) {
                if (!ParserImportacaoSaoMarcos.possuiExames(mapExames, keyResultados)) {
                    examesNaoImportados.add(keyResultados);
                } else {
                    ParserImportacaoSaoMarcos.incrementarBarra(progress);
                    ExameSaoMarcosVO exameSaoMarcos = mapExames.get(keyResultados);
                    StringBuilder buf = new StringBuilder();
                    String xml = exameSaoMarcos.getSmaxml();
                    buf.append(xml);
                    XMLStringBuilder novoXML = new XMLStringBuilder();
                    StringUtil.setValor(buf, "resultados", ParserImportacaoSaoMarcos.importarResultados(novoXML, exameSaoMarcos.getSmaCodExame(), mapResultados).getXML());
                    exameSaoMarcos.setSmaxml(buf.toString());
                    serviceExameSaoMarcos.atualizarXml(exameSaoMarcos.getFilCodigo().toString(), codigoLabExterno, exameSaoMarcos.getSmaCodExame(), exameSaoMarcos.getSmaxml().toString());
                }
            }
            codigoExame = keyResultados;
        }
        Conexao.arquivaSQL();
        return examesNaoImportados;
    }

    private static boolean possuiExames(Map<String, ExameSaoMarcosVO> mapExames, String key) {
        return mapExames.get(key) != null;
    }

    private static boolean listaVazia(Map<String, ExameSaoMarcosVO> mapExames) {
        return mapExames == null || mapExames.isEmpty();
    }

    private static boolean contemExameLista(Map<String, ExameSaoMarcosVO> examesExcluidos, String ex) {
        return examesExcluidos.containsKey(ex);
    }

    private static boolean linhaValida(String s, String tag) {
        return !s.equalsIgnoreCase(tag);
    }

    private static boolean validaCodigoExame(String codigoExame, String codigoResultado) {
        return Funcoes.textoVazio(codigoExame) || !codigoExame.equals(codigoResultado);
    }

    private static void incrementarBarra(JProgressBar progress) {
        if (ParserImportacaoSaoMarcos.existeBarra(progress)) {
            progress.setValue(progress.getValue() + 1);
        }
    }

    private static boolean existeBarra(JProgressBar progress) {
        return progress != null;
    }

    private static boolean keySetValido(String key, String smaCodExame) {
        return key.equalsIgnoreCase(smaCodExame);
    }
}

