/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.saomarcos.ParserImportacaoSaoMarcos;
import jalis.model.vo.cadastro.exame.ExameSaoMarcosVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportacaoSaoMarcos
extends AbstractImportadorLabExterno {
    public static final String PLANILHAEXAME = "ExamesAmostras";
    public static final String PLANILHAADICIONAIS = "DadosAdicionais";
    public static final String PLANILHARESULTADO = "ParametroResultado";
    private static final String titulo = "Importa\u00e7\u00e3o de Exames";
    private static final String descricao = "Importa\u00e7\u00e3o de exames do Lab. S\u00e3o Marcos a partir de arquivo XLS";
    private static final String tituloThread = "Thread de Importa\u00e7\u00e3o de Campos de Resultados";
    private JButton buttonImportarDadosAdicionais = ComponenteFactory.novoJButton("Importar Dados Adicionais", 'D', this);
    private JButton buttonImportarCamposResultados = ComponenteFactory.novoJButton("Importar Campos Resultado", 'r', this);

    public ImportacaoSaoMarcos(int codigoLabExterno) {
        super(titulo, descricao, codigoLabExterno, Protocolo.SaoMarcos);
        this.carregarBotao();
    }

    private void carregarBotao() {
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().removeAll();
        this.getPanelBotoes().add(this.getButtonImportar());
        this.getPanelBotoes().add(this.buttonImportarCamposResultados);
        this.getPanelBotoes().add(this.buttonImportarDadosAdicionais);
        this.getPanelBotoes().add(this.getButtonFechar());
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    public boolean importarArquivo() {
        boolean retorno = false;
        try {
            FileInputStream fis = this.getArquivo();
            if (this.existeArquivo(fis)) {
                HashMap<String, String> arquivo = ImportacaoSaoMarcos.lerArquivoXls(fis);
                if (this.listaVazia(arquivo)) {
                    throw new Exception();
                }
                this.atualizarBarraProgresso(arquivo);
                Map<String, ExameSaoMarcosVO> excluidos = ParserImportacaoSaoMarcos.importarExamesSaoMarcos(arquivo, this.codigoLabExterno, this.progress, this);
                this.progress.setValue(this.progress.getMaximum());
                StringBuilder bui = new StringBuilder();
                this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda").toString());
                Thread.sleep(50L);
                if (this.listaPreenchida(excluidos.size())) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("+--------+-------------------------------------------------------------------------+\n");
                    bui.append("| CODIGO | DESCRI\u00c7\u00c3O EXAME                                                         |\n");
                    bui.append("+--------+-------------------------------------------------------------------------+");
                    for (String ex : excluidos.keySet()) {
                        bui.append("\n| ").append(StringUtil.formatarColuna(Funcoes.preencheZero(excluidos.get(ex).getSmaCodExame(), 6), 7, 'e'));
                        bui.append("| ").append(StringUtil.formatarColuna(excluidos.get(ex).getDescricaoExame(), 73, 'e')).append("|");
                    }
                    bui.append("\n+--------+-------------------------------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                    this.progress.setVisible(false);
                    retorno = true;
                }
            }
            retorno = true;
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage()), e.getStackTrace());
        }
        return retorno;
    }

    private boolean listaVazia(HashMap<String, String> arquivo) {
        return arquivo == null || arquivo.isEmpty();
    }

    private FileInputStream getArquivo() throws FileNotFoundException {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. ".concat(this.protocolo.name()).concat(" (*.xls)"), "xls"));
        FileInputStream fis = null;
        if (this.arquivoSelecionado(chooser)) {
            File file = chooser.getSelectedFile();
            fis = new FileInputStream(file);
        }
        return fis;
    }

    public static HashMap<String, String> lerArquivoXls(InputStream input) throws InvalidFormatException, IOException {
        HashMap<String, String> listaDados = new HashMap<String, String>();
        new WorkbookFactory();
        Workbook workbook = WorkbookFactory.create((InputStream)input);
        Sheet sheet = null;
        sheet = workbook.getSheet(PLANILHAEXAME);
        if (ImportacaoSaoMarcos.existePlanilha(sheet)) {
            String exames = ImportacaoSaoMarcos.leDadosXls(sheet);
            listaDados.put(PLANILHAEXAME, exames);
        }
        if (ImportacaoSaoMarcos.existePlanilha(sheet = workbook.getSheet(PLANILHAADICIONAIS))) {
            String dadosAdicionais = ImportacaoSaoMarcos.leDadosXls(sheet);
            listaDados.put(PLANILHAADICIONAIS, dadosAdicionais);
        }
        if (ImportacaoSaoMarcos.existePlanilha(sheet = workbook.getSheet(PLANILHARESULTADO))) {
            String camposResultados = ImportacaoSaoMarcos.leDadosXls(sheet);
            listaDados.put(PLANILHARESULTADO, camposResultados);
        }
        return listaDados;
    }

    private static boolean existePlanilha(Sheet sheet) {
        return null != sheet;
    }

    private static String leDadosXls(Sheet sheet) {
        StringBuilder buf = new StringBuilder();
        for (Row row : sheet) {
            Iterator cellIterator = row.cellIterator();
            boolean qt = false;
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                switch (cell.getCellType()) {
                    case 0: {
                        Double valor = cell.getNumericCellValue();
                        String valorFormatado = new BigDecimal(valor).setScale(0, 4).toPlainString();
                        buf.append(valorFormatado).append("=");
                        break;
                    }
                    case 1: {
                        buf.append(cell.getStringCellValue()).append("=");
                    }
                }
            }
            buf.replace(buf.length() - 1, buf.length(), "\n");
        }
        return buf.toString();
    }

    private void importarDadosAdicionais() {
        try {
            FileInputStream fis = this.getArquivo();
            if (this.existeArquivo(fis)) {
                HashMap<String, String> arquivo = ImportacaoSaoMarcos.lerArquivoXls(fis);
                StringBuilder bui = new StringBuilder();
                this.atualizarBarraProgresso(arquivo);
                List<String> excluidos = ParserImportacaoSaoMarcos.importarDadosAdicionais(arquivo, this.codigoLabExterno, this.progress, this);
                this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda").toString());
                this.progress.setValue(this.progress.getMaximum());
                Thread.sleep(50L);
                if (this.listaPreenchida(excluidos.size())) {
                    bui.append("\n\nOs seguintes exames abaixo n\u00e3o foram encontrados na lista de exames: \n\n");
                    bui.append("+--------+\n");
                    bui.append("| CODIGO | \n");
                    bui.append("+--------+");
                    for (String ex : excluidos) {
                        bui.append("\n| ").append(StringUtil.formatarColuna(ex, 7, 'e')).append("|");
                    }
                    bui.append("\n+--------+");
                    this.setTextoInformacoes(bui.toString());
                    this.progress.setVisible(false);
                }
            }
        }
        catch (SQLException ex) {
            this.anexarTextoInformacoes(ex.getMessage());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage()), e.getStackTrace());
        }
    }

    private void importarResultados() {
        boolean retorno = false;
        try {
            FileInputStream fis = this.getArquivo();
            if (this.existeArquivo(fis)) {
                HashMap<String, String> arquivo = ImportacaoSaoMarcos.lerArquivoXls(fis);
                StringBuilder bui = new StringBuilder();
                this.atualizarBarraProgresso(arquivo);
                List<String> excluidos = ParserImportacaoSaoMarcos.importarCamposResultado(arquivo, this.codigoLabExterno, this.progress, this);
                this.progress.setValue(this.progress.getMaximum());
                this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda").toString());
                Thread.sleep(50L);
                if (this.listaPreenchida(excluidos.size())) {
                    bui.append("\n\nOs seguintes exames abaixo n\u00e3o foram encontrados na tabela exame: \n\n");
                    bui.append("+--------++\n");
                    bui.append("| CODIGO |\n");
                    bui.append("+--------+");
                    for (String ex : excluidos) {
                        bui.append("\n| ").append(StringUtil.formatarColuna(ex, 7, 'e')).append("|");
                    }
                    bui.append("\n+--------+");
                    this.setTextoInformacoes(bui.toString());
                    this.progress.setVisible(false);
                    retorno = true;
                }
            }
        }
        catch (SQLException ex) {
            this.anexarTextoInformacoes(ex.getMessage());
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage()), e.getStackTrace());
        }
    }

    private void atualizarBarraProgresso(HashMap<String, String> arquivo) throws InterruptedException {
        this.setTextoInformacoes("");
        this.anexarTextoInformacoes("Importando exames...\n");
        Thread.sleep(50L);
        this.progress.setValue(0);
        this.progress.setVisible(true);
        if (this.validaProgress()) {
            String exames = arquivo.get(PLANILHAEXAME);
            if (!Funcoes.textoVazio(exames)) {
                String[] linhas = exames.split("\n");
                this.progress.setMaximum(linhas.length);
            }
            this.progress.setValue(0);
        }
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        this.getButtonImportar().setEnabled(habilitar);
        this.getButtonImportar().setEnabled(habilitar);
        this.buttonImportarCamposResultados.setEnabled(habilitar);
        this.buttonImportarDadosAdicionais.setEnabled(habilitar);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportarDadosAdicionais) {
            this.habilitarBotoes(false);
            new Thread(tituloThread){

                @Override
                public void run() {
                    ImportacaoSaoMarcos.this.habilitarBotoes(false);
                    ImportacaoSaoMarcos.this.importarDadosAdicionais();
                    ImportacaoSaoMarcos.this.habilitarBotoes(true);
                }
            }.start();
        }
        if (e.getSource() == this.buttonImportarCamposResultados) {
            this.habilitarBotoes(false);
            new Thread(tituloThread){

                @Override
                public void run() {
                    ImportacaoSaoMarcos.this.habilitarBotoes(false);
                    ImportacaoSaoMarcos.this.importarResultados();
                    ImportacaoSaoMarcos.this.habilitarBotoes(true);
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean listaPreenchida(int size) {
        return size > 0;
    }

    private boolean validaProgress() {
        return this.progress != null;
    }

    private boolean existeArquivo(FileInputStream fis) {
        return fis != null;
    }

    private boolean arquivoSelecionado(JFileChooser chooser) {
        return chooser.showOpenDialog(this) == 0;
    }
}

