/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.saomarcos.CamposRelacionamentoSaoMarcosUtil;
import jalis.laboratorio.util.parsers.saomarcos.ExameSaoMarcos;
import jalis.laboratorio.util.parsers.saomarcos.FiltroImportacaoSaoMarcos;
import jalis.laboratorio.util.parsers.saomarcos.SaoMarcosException;
import jalis.service.integracaolaboratorioexterno.ExameSaoMarcosService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.CertificadoException;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ImportacaoResultadoSaoMarcos
extends AbstractImportadorResultadoLabExterno {
    private String usuarioSaoMarcos = null;
    private String senhaSaoMarcos = null;
    private String enderecoWS = null;
    private int codigoLabExterno;
    private LaboratorioExterno labExterno;
    protected boolean conferirAutomatico = false;
    protected String codigoUsuarioConferenciaAutomatica = null;
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private FiltroImportacaoSaoMarcos filtro = null;

    public ImportacaoResultadoSaoMarcos(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importaca\u00e7\u00e3o de resultados do Lab. S\u00e3o Marcos (Webservice)", codigoLabExterno, Protocolo.SaoMarcos, new JPanel(new FlowLayout(2)));
        this.modeloRelatorio.clear();
        this.buttonImportar.setVisible(false);
        this.buttonImportarWS.setVisible(true);
        this.buttonImportarWS.setEnabled(true);
        this.getPanelAdicional().add(this.buttonImprimir);
        this.getPanelAdicional().add(this.buttonImportarWS);
        this.codigoLabExterno = codigoLabExterno;
        this.labExterno = LaboratorioExterno.getLabExterno(String.valueOf(codigoLabExterno));
        this.pegaDadosConferencia(codigoLabExterno);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonImportarWS) {
            this.setTextoInformacoes("");
            this.filtro = FiltroImportacaoSaoMarcos.novaInstancia(this.getTopLevelAncestor());
            this.filtro.setVisible(true);
            if (this.filtro.isOk()) {
                this.habilitarBotoes(false);
                this.setTextoInformacoes("Iniciando a importa\u00e7\u00e3o\n", false);
                new Thread(this).start();
                this.isWebService = true;
            }
        }
        if (o == this.buttonFechar) {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        }
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        }
    }

    public ImportacaoResultadoSaoMarcos(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo) {
        super(titulo, descricao, codigoLabExterno, protocolo);
    }

    @Override
    protected void importarResultado() {
    }

    @Override
    protected void importarResultadoWs() {
        try {
            List<String> listaRequisicao = null;
            String filial = "";
            this.modeloRelatorio.clear();
            if (this.filtro.isPeriodo()) {
                listaRequisicao = this.solicitarWebService(this.filtro.getDataInicial(), this.filtro.getDataFinal());
            }
            if (this.filtro.isRequisicao()) {
                ExameSaoMarcosService service = new ExameSaoMarcosService();
                Statement st = Conexao.getStatement();
                service.validarConexao(Variaveis.filialPadrao, this.labExterno, st, false);
                Conexao.fecharStatement(st);
                listaRequisicao = new ArrayList<String>();
                filial = this.filtro.getFilial();
                String requisicao = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                listaRequisicao.add(this.filtro.getRequisicao());
                filial = this.filtro.getFilial();
            }
            this.registraResultado(listaRequisicao, filial);
            this.setTextoInformacoes("Resultados importados com sucesso!", false);
            ParametrosLocais.setParametro("mostraDataInicial", this.filtro.getDataFinal());
            ParametrosLocais.salvaParametros();
            ParametrosLocais.carregaParametros();
        }
        catch (SaoMarcosException e) {
            this.setTextoInformacoes(e.getMessage(), false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), e.getMessage());
        }
        this.habilitarBotoes(false);
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        this.buttonImportar.setEnabled(habilitar);
        this.buttonFechar.setEnabled(habilitar);
        this.buttonImportarWS.setEnabled(habilitar);
        this.buttonImprimir.setEnabled(habilitar && this.modeloRelatorio.getRowCount() > 0);
    }

    private void registraResultado(List<String> listaRequisicao, String filial) throws CertificadoException, Exception {
        for (String requisicao : listaRequisicao) {
            try {
                this.processarPaiFilhos(requisicao, filial);
            }
            catch (SaoMarcosException e) {
                this.setTextoInformacoes(e.getMessage(), false);
            }
        }
    }

    private void processarPaiFilhos(String requisicao, String filial) throws CertificadoException, Exception {
        Integer[] multiguias = null;
        if (!Funcoes.isNumeric(requisicao)) {
            throw new SaoMarcosException("N\u00e3o foi poss\u00edvel importar: Requisi\u00e7\u00e3o n\u00e3o encontrada " + requisicao + " \n");
        }
        if (Funcoes.textoVazio(filial)) {
            filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
        }
        String codigoFilial = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial());
        boolean agruparMultiguias = this.agrupaMultiguia(filial, requisicao);
        requisicao = this.validaCodigoRequisicao(requisicao);
        String codigoTubo = codigoFilial + Funcoes.preencheZero(requisicao, ParametrosGerais.getDigitosTuboRequisicao());
        ExameSaoMarcosService service = new ExameSaoMarcosService();
        List<ExameSaoMarcos> listaExameSaoMarcos = service.getResultado(this.labExterno.configuracao, codigoTubo);
        this.possuiResultados(listaExameSaoMarcos, codigoTubo);
        for (Integer multiguia : multiguias = this.validaMultiguias(agruparMultiguias, codigoFilial, requisicao)) {
            String codigoMultiguia = codigoFilial + Funcoes.preencheZero(multiguia, ParametrosGerais.getDigitosTuboRequisicao());
            this.setTextoInformacoes("Solicitando resultado da Requisi\u00e7\u00e3o " + codigoMultiguia + "\n", false);
            for (ExameSaoMarcos exameSaoMarcos : listaExameSaoMarcos) {
                exameSaoMarcos.setCodigoRequisicao(multiguia.toString());
                exameSaoMarcos.setCodigoLaboratorioExterno(Integer.valueOf(this.labExterno.codigoLab));
                if ((exameSaoMarcos = service.localizaExameRelacionado(exameSaoMarcos)).getCodigoExameJalis() == null) continue;
                Registro reg = this.localizarExameRequisicao(service, exameSaoMarcos, exameSaoMarcos.getCodigoExameJalis(), exameSaoMarcos.getCodigoMaterialJalis());
                if (this.possuiRegistro(reg)) {
                    exameSaoMarcos.setCodigoExamePai("");
                    exameSaoMarcos.setCodigoMaterialPai("");
                    try {
                        this.registraResultado(reg, exameSaoMarcos, codigoTubo, codigoMultiguia);
                    }
                    catch (SaoMarcosException e) {
                        this.setTextoInformacoes(e.getMessage(), false);
                    }
                }
                ExameDesmembrado pai = this.getExamesDesmembrados(codigoFilial, exameSaoMarcos.getCodigoRequisicao(), String.valueOf(exameSaoMarcos.getCodigoLaboratorioExterno()), exameSaoMarcos.getCodigoExameJalis(), exameSaoMarcos.getCodigoMaterialJalis());
                try {
                    if (!this.possuiDesmembrados(pai)) continue;
                    String exa = pai.getCodigoExame();
                    String mco = String.valueOf(pai.getCodigomaterial());
                    exameSaoMarcos.setCodigoExamePai(exa);
                    exameSaoMarcos.setCodigoMaterialPai(mco);
                    reg = this.localizarExameRequisicao(service, exameSaoMarcos, exameSaoMarcos.getCodigoExamePai(), exameSaoMarcos.getCodigoMaterialPai());
                    this.registraResultado(reg, exameSaoMarcos, codigoTubo, codigoMultiguia);
                }
                catch (SaoMarcosException e) {
                    this.setTextoInformacoes(e.getMessage(), false);
                }
            }
        }
    }

    private boolean possuiRegistro(Registro reg) {
        return reg != null;
    }

    private boolean possuiDesmembrados(ExameDesmembrado pai) {
        return pai != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExameDesmembrado getExamesDesmembrados(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        Statement st;
        block4: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("       ,p.ele_xmllabexterno ");
                buf.append("   from examerequisicao a ");
                buf.append("   join examematcoletalabextdesm e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("   join examematcoletalabexterno p on e.fil_codigo = p.fil_codigo and e.exa_kodigo = p.exa_codigo and e.mco_codigo = p.mco_codigo and e.lae_codigo = p.lae_codigo ");
                buf.append("  where a.fil_codigo = ").append(filial);
                buf.append("    and a.req_codigo  = ").append(reqCodigo);
                buf.append("    and e.exa_kodigo = '").append(exaFilho).append("' ");
                buf.append("    and e.mco_kodigo = '").append(mcoFilho).append("'");
                buf.append("    and e.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block4;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"));
                ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    private void possuiResultados(List<ExameSaoMarcos> listaExameSaoMarcos, String codigoTubo) throws SaoMarcosException {
        if (listaExameSaoMarcos == null || listaExameSaoMarcos.isEmpty()) {
            throw new SaoMarcosException("Solicitando resultado da Requisi\u00e7\u00e3o " + codigoTubo + " - N\u00e3o foi poss\u00edvel importar: Requisi\u00e7\u00e3o n\u00e3o encontrada \n");
        }
    }

    private boolean agrupaMultiguia(String filial, String requisicao) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filial, requisicao);
    }

    private String validaCodigoRequisicao(String requisicao) {
        Integer tamanhoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        if (requisicao.length() == tamanhoTubo.intValue()) {
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
        }
        return requisicao;
    }

    private void registraResultado(Registro reg, ExameSaoMarcos exameSaoMarcos, String codigoTubo, String codigoMultiguia) throws CertificadoException, Exception {
        String resultado;
        if (reg.nulo("examepai")) {
            reg.setValor("examePai", reg.getString("exa_codigo"));
        }
        if (!this.exameRelacionado(reg)) {
            this.adicionarAoModeloRelatorio(exameSaoMarcos, AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO);
            throw new SaoMarcosException("N\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento \n");
        }
        this.validarSituacao(reg, exameSaoMarcos);
        this.setTextoInformacoes("Importando " + reg.getString("exa_codigo") + " da Requisi\u00e7\u00e3o " + codigoMultiguia + "\n", false);
        boolean salvoParcial = reg.getString("exr_situacao").equals("P");
        String elm_formato = this.getLayout(reg);
        Registro formato = new Registro();
        formato.setValor("formato", reg.getValor("formatoPadrao"));
        formato.setValor("met_codigo", reg.getValor("met_codigo"));
        String FORMATACAO = "formatacao";
        Registro formatacao = formato;
        StringBuilder resultadoAtual = new StringBuilder();
        Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
        Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
        Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
        historicos = this.possuiHistorico(historicos, reg.getString("fil_codigo"));
        String campoResultado = exameSaoMarcos.getAtributo() + "@Resultado";
        String campoConclusao = exameSaoMarcos.getAtributo() + "@Conclus\u00e3o";
        String campoValorReferencia = exameSaoMarcos.getAtributo() + "@Valor refer\u00eancia";
        String campoMetodo = exameSaoMarcos.getAtributo() + "@M\u00e9todo";
        String campoObservacao = exameSaoMarcos.getAtributo() + "@Observa\u00e7\u00e3o";
        if (!Funcoes.textoVazio(exameSaoMarcos.getCodigoExamePai())) {
            campoResultado = exameSaoMarcos.getAtributo() + "@" + exameSaoMarcos.getCodigoExameJalis() + "@Resultado#" + exameSaoMarcos.getCodigoMaterialJalis();
            campoConclusao = exameSaoMarcos.getAtributo() + "@" + exameSaoMarcos.getCodigoExameJalis() + "@Conclus\u00e3o#" + exameSaoMarcos.getCodigoMaterialJalis();
            campoValorReferencia = exameSaoMarcos.getAtributo() + "@" + exameSaoMarcos.getCodigoExameJalis() + "@Valor refer\u00eancia#" + exameSaoMarcos.getCodigoMaterialJalis();
            campoMetodo = exameSaoMarcos.getAtributo() + "@" + exameSaoMarcos.getCodigoExameJalis() + "@M\u00e9todo#" + exameSaoMarcos.getCodigoMaterialJalis();
            campoObservacao = exameSaoMarcos.getAtributo() + "@" + exameSaoMarcos.getCodigoExameJalis() + "@Observa\u00e7\u00e3o#" + exameSaoMarcos.getCodigoMaterialJalis();
        }
        dados.putAll(CamposRelacionamentoSaoMarcosUtil.getMapCampoValor(resultadoAtual, reg));
        dados.put(campoResultado, exameSaoMarcos.getResultado());
        dados.put(campoConclusao, exameSaoMarcos.getConclusao());
        dados.put(campoValorReferencia, exameSaoMarcos.getValorReferencia());
        dados.put(campoMetodo, exameSaoMarcos.getMetodo());
        dados.put(campoObservacao, exameSaoMarcos.getObservacaoResultado());
        dados.put("*@Data", exameSaoMarcos.getDataResultado());
        dados.put("*@Observa\u00e7\u00e3o", exameSaoMarcos.getObservacao());
        dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
        Map<String, Object> resposta = Resultado.getCamposResultado(reg.getString("exr_resposta"));
        Resultado res = new Resultado(formatacao.getString("formato"), dados);
        res.atualizarComponentes();
        res = new Resultado(null, formatacao.getString("formato"), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
        res.atualizarComponentes();
        boolean completo = true;
        if (reg.getBoolean("exa_salvaparcial")) {
            completo = res.resultadoCompleto(true);
        }
        boolean marcarConferido = false;
        if (this.conferirAutomatico(completo)) {
            int verificacao = res.verificarValidacao();
            boolean bl = marcarConferido = verificacao == 1;
        }
        if (!completo && reg.getBoolean("exa_salvaparcial")) {
            completo = res.resultadoCompleto(false);
        }
        String novaSituacao = completo ? "L" : "P";
        String string = resultado = completo ? res.getResultado() : res.getResultadoParcial();
        if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), exameSaoMarcos.getCodigoLis())) {
            this.inserirDadosRequisicao(Conexao.getStatement(), this.codigoLabExterno, exameSaoMarcos.getCodigoLis(), reg.getString("fil_codigo"), reg.getInt("req_codigo"));
        }
        boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
        boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
        this.salvarTabelaExameRequisicao(Conexao.getStatement(), this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
        this.adicionarAoModeloRelatorio(exameSaoMarcos, completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE);
        Conexao.arquivaSQL();
        this.setTextoInformacoes("Importando " + codigoMultiguia + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE)) + "\n", false);
    }

    private void validarSituacao(Registro reg, ExameSaoMarcos exameSaoMarcos) throws SaoMarcosException {
        String mensagem = reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Situa\u00e7\u00e3o do exame ";
        if (reg.getString("exr_situacao").equalsIgnoreCase("C")) {
            throw new SaoMarcosException(mensagem + AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO.descricao + "\n");
        }
        if (reg.getString("exr_situacao").equalsIgnoreCase("E")) {
            throw new SaoMarcosException(mensagem + AbstractImportadorResultadoLabExterno.Situacao.ENTREGUE.descricao + "\n");
        }
        if (reg.getString("exr_situacao").equalsIgnoreCase("I")) {
            throw new SaoMarcosException(mensagem + AbstractImportadorResultadoLabExterno.Situacao.IMPRESSO.descricao + "\n");
        }
        if (reg.getString("exr_situacao").equalsIgnoreCase("L")) {
            throw new SaoMarcosException(mensagem + AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao + "\n");
        }
    }

    private boolean conferirAutomatico(boolean completo) {
        return this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo;
    }

    private Map<String, Map<String, String>> possuiHistorico(Map<String, Map<String, String>> historicos, String filial) {
        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
            historicos = ExameUtil.getHistoricos(null, filial);
        }
        return historicos;
    }

    private String getLayout(Registro reg) {
        return ExameUtil.pegaLayoutIdade(reg.getString("fil_codigo"), Integer.parseInt(reg.getString("req_idade")), reg.getString("req_anomes"), reg.getString("codigo-layout"), reg.getString("exa_codigo"), Integer.parseInt(reg.getString("mco_codigo")), Integer.parseInt(reg.getString("met_codigo")), "elm_formato", reg);
    }

    private Integer[] validaMultiguias(boolean agruparMultiguias, String filial, String requisicao) throws SQLException {
        if (agruparMultiguias) {
            return RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
        }
        return new Integer[]{Integer.parseInt(requisicao)};
    }

    private boolean exameJaLancado(Registro reg) {
        String sit = reg.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    private Registro localizarExameRequisicao(ExameSaoMarcosService service, ExameSaoMarcos exameSaoMarcos, String codigoExame, String codigoMaterial) throws SQLException, SaoMarcosException {
        if (Funcoes.textoVazio(codigoExame)) {
            return null;
        }
        return service.localizaExame(exameSaoMarcos, codigoExame, codigoMaterial);
    }

    private List<String> solicitarWebService(String dataInicial, String dataFinal) throws SaoMarcosException, IOException {
        ExameSaoMarcosService service = new ExameSaoMarcosService();
        Statement st = Conexao.getStatement();
        service.validarConexao(Variaveis.filialPadrao, this.labExterno, st, false);
        Conexao.fecharStatement(st);
        String configuracaoOriginal = this.labExterno.configuracao;
        this.setTextoInformacoes("Solicitando a lista das requisi\u00e7\u00f5es que possuem Resultados prontos...\n", false);
        String retorno = service.getRequisicaoResultado(configuracaoOriginal, dataInicial, dataFinal);
        String requisicao = StringUtil.getValor(retorno, "respostas");
        if (Funcoes.textoVazio(requisicao)) {
            throw new SaoMarcosException("Ainda n\u00e3o h\u00e1 resultados de exames prontos para o Per\u00edodo informado!");
        }
        this.setTextoInformacoes("Lista de Requisi\u00e7\u00f5es recebida com sucesso!\n", false);
        return StringUtil.getListValores(requisicao, "atendimento");
    }

    private void adicionarAoModeloRelatorio(ExameSaoMarcos exameSaoMarcos, AbstractImportadorResultadoLabExterno.Situacao situacao) {
        Statement st = Conexao.getStatement();
        String exames = "";
        String exa = exameSaoMarcos.getCodigoExameJalis();
        String mco = exameSaoMarcos.getCodigoMaterialJalis();
        try {
            exames = BDUtil.getCodigoExames(exameSaoMarcos.getCodigoFilial(), exameSaoMarcos.getCodigoRequisicao(), st);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "(1264)");
        }
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, exameSaoMarcos.getCodigoFilial(), exameSaoMarcos.getCodigoRequisicao(), exa, Integer.parseInt(mco), situacao.descricao);
        ExameDesmembrado pai = this.getExamesDesmembrados(exameSaoMarcos.getCodigoFilial(), exameSaoMarcos.getCodigoRequisicao(), String.valueOf(this.codigoLabExterno), exa, mco);
        if (!(exames.contains(exameSaoMarcos.getCodigoExameJalis()) && pai == null || pai == null)) {
            exa = pai.getCodigoExame();
            mco = String.valueOf(pai.getCodigomaterial());
        }
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, exameSaoMarcos.getCodigoFilial(), exameSaoMarcos.getCodigoRequisicao(), exa, Integer.parseInt(mco), situacao.descricao);
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next() && rs.getInt("lae_codigo") == this.codigoLabExterno) {
                String xml = rs.getString("ele_xmllabexterno");
                reg.setValor("ele_xmllabexterno", xml);
                exa = StringUtil.getValor(xml, "codigo");
                mco = StringUtil.getValor(xml, "material");
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("select sma_xml from examessaomarcos where fil_codigo = ").append(fil);
                sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                sqlBuilder.append(" and sma_codexame = '").append(exa).append("' and sma_codmaterial = '").append(mco).append("' ");
                rs = st.executeQuery(sqlBuilder.toString());
                if (rs.next()) {
                    reg.setValor("sma_xml", rs.getString("sma_xml"));
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pegaDadosConferencia(int codigoLabExterno) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoSaoMarcos (56)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public String getUsuarioSaoMarcos() {
        return this.usuarioSaoMarcos;
    }

    public void setUsuarioSaoMarcos(String usuarioSaoMarcos) {
        this.usuarioSaoMarcos = usuarioSaoMarcos;
    }

    public String getSenhaSaoMarcos() {
        return this.senhaSaoMarcos;
    }

    public void setSenhaSaoMarcos(String senhaSaoMarcos) {
        this.senhaSaoMarcos = senhaSaoMarcos;
    }

    public String getEnderecoWS() {
        return this.enderecoWS;
    }

    public void setEnderecoWS(String enderecoWS) {
        this.enderecoWS = enderecoWS;
    }
}

