/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.saomarcos.SaoMarcosException;
import jalis.service.integracaolaboratorioexterno.ExameSaoMarcosService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FiltroImportacaoSaoMarcos
extends AbstractDialogoOKCancelar {
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkBoxPeriodo = ComponenteFactory.novoJCheckBox("Per\u00edodo:", 'P');
    private JCheckBox checkBoxRequisicao = ComponenteFactory.novoJCheckBox("Requisi\u00e7\u00e3o:", 'R');
    private JLabel labelFilial = new JLabel("C\u00f3d. Filial:");
    private TTextField textFilial = new TTextField(10, 1);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private JLabel labelRequisicao = new JLabel("C\u00f3d. Requisicao:");
    private TTextField textRequisicao = new TTextField(10, 1);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private boolean isOk = false;
    private String dataInicial = null;
    private String dataFinal = null;

    public static FiltroImportacaoSaoMarcos novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new FiltroImportacaoSaoMarcos((Dialog)pai, "Importa\u00e7\u00e3o via Webservice");
        }
        return new FiltroImportacaoSaoMarcos((Frame)pai, "Importa\u00e7\u00e3o via Webservice");
    }

    public FiltroImportacaoSaoMarcos(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public FiltroImportacaoSaoMarcos(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(270, 280));
        this.setResizable(false);
        this.setModal(true);
        this.buttonOK.setText("Importar");
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelInicial = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.insets = new Insets(0, 0, 0, 30);
        c1.fill = 2;
        this.checkBoxPeriodo.setPreferredSize(new Dimension(85, 15));
        panelInicial.add((Component)this.checkBoxPeriodo, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.labelDataInicial, c1);
        ++c1.gridy;
        c1.insets = new Insets(0, 0, 0, 0);
        this.textDataInicial.setPreferredSize(new Dimension(100, 20));
        panelInicial.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        panelInicial.add((Component)this.buttonDataInicial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelDataFinal, c1);
        ++c1.gridy;
        this.textDataFinal.setPreferredSize(new Dimension(100, 20));
        panelInicial.add((Component)this.textDataFinal, c1);
        ++c1.gridx;
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        panelInicial.add((Component)this.buttonDataFinal, c1);
        c1.gridx = 0;
        ++c1.gridy;
        c1.insets = new Insets(30, 0, 0, 0);
        this.checkBoxRequisicao.setPreferredSize(new Dimension(85, 15));
        panelInicial.add((Component)this.checkBoxRequisicao, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.labelFilial, c1);
        ++c1.gridy;
        c1.insets = new Insets(0, 0, 0, 0);
        this.textFilial.setPreferredSize(new Dimension(100, 20));
        panelInicial.add((Component)this.textFilial, c1);
        ++c1.gridx;
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        panelInicial.add((Component)this.buttonFilial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelRequisicao, c1);
        ++c1.gridy;
        this.textRequisicao.setPreferredSize(new Dimension(100, 20));
        panelInicial.add((Component)this.textRequisicao, c1);
        ++c1.gridx;
        this.buttonRequisicao.setPreferredSize(new Dimension(20, 20));
        panelInicial.add((Component)this.buttonRequisicao, c1);
        ++c1.gridy;
        c1.gridx = 0;
        JPanel aux = new JPanel(new BorderLayout());
        aux.add((Component)panelInicial, "North");
        panel.add((Component)aux, "West");
        if (!Funcoes.textoVazio(this.dataInicial)) {
            this.textDataInicial.setText(this.dataInicial);
        }
        if (!Funcoes.textoVazio(this.dataFinal)) {
            this.textDataFinal.setText(this.dataFinal);
        }
        this.mouseClick();
        this.montaListener();
        this.checkBoxPeriodo.setSelected(true);
        this.textDataInicial.setText(ParametrosLocais.getParametro("mostraDataInicial"));
        this.textDataFinal.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textFilial.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textDataInicial);
    }

    private void mouseClick() {
        this.checkBoxPeriodo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FiltroImportacaoSaoMarcos.this.checkBoxRequisicao.setSelected(false);
                    FiltroImportacaoSaoMarcos.this.ativarCampos();
                }
            }
        });
        this.checkBoxRequisicao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FiltroImportacaoSaoMarcos.this.checkBoxPeriodo.setSelected(false);
                    FiltroImportacaoSaoMarcos.this.ativarCampos();
                }
            }
        });
    }

    private void ativarCampos() {
        this.textDataInicial.setEnabled(this.checkBoxPeriodo.isSelected());
        this.textDataFinal.setEnabled(this.checkBoxPeriodo.isSelected());
        this.buttonDataFinal.setEnabled(this.checkBoxPeriodo.isSelected());
        this.buttonDataInicial.setEnabled(this.checkBoxPeriodo.isSelected());
        this.textFilial.setEnabled(this.checkBoxRequisicao.isSelected());
        this.textRequisicao.setEnabled(this.checkBoxRequisicao.isSelected());
        this.buttonFilial.setEnabled(this.checkBoxRequisicao.isSelected());
        this.buttonRequisicao.setEnabled(this.checkBoxRequisicao.isSelected());
    }

    private void montaListener() {
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FiltroImportacaoSaoMarcos.this.pressF2(e.getKeyCode())) {
                    FiltroImportacaoSaoMarcos.this.buscaFilial();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FiltroImportacaoSaoMarcos.this.pressF2(e.getKeyCode())) {
                    FiltroImportacaoSaoMarcos.this.buscaRequisicao();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FiltroImportacaoSaoMarcos.this.pressF2(e.getKeyCode())) {
                    FiltroImportacaoSaoMarcos.this.mostraDataInicial();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FiltroImportacaoSaoMarcos.this.pressF2(e.getKeyCode())) {
                    FiltroImportacaoSaoMarcos.this.mostraDataInicial();
                } else {
                    super.keyPressed(e);
                }
            }
        });
    }

    private boolean pressF2(int keyCode) {
        return keyCode == 113;
    }

    private void mostraDataInicial() {
        Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
    }

    private void mostraDataFinal() {
        Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            this.mostraDataInicial();
        } else if (e.getSource() == this.buttonDataFinal) {
            this.mostraDataFinal();
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonRequisicao) {
            this.buscaRequisicao();
        } else if (e.getSource() == this.buttonOK) {
            if (this.validaCampos()) {
                this.isOk = true;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.buttonCancelar) {
            this.isOk = false;
            this.setVisible(false);
        }
    }

    private boolean validaCampos() {
        if (this.checkBoxPeriodo.isSelected()) {
            return this.validaCamposPeriodo();
        }
        if (this.checkBoxRequisicao.isSelected()) {
            return this.validaCamposRequisicao();
        }
        Funcoes.mensagem(this, "Nenhum filtro selecionado.", 2);
        return false;
    }

    private boolean validaCamposRequisicao() {
        if (Funcoes.textoVazio(this.textFilial.getText())) {
            Funcoes.mensagem(this, "Filial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textRequisicao.getText())) {
            Funcoes.mensagem(this, "Requisicao deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        try {
            this.requisicaoInvalida();
        }
        catch (SaoMarcosException e) {
            Funcoes.mensagem(this, e.getMessage(), 2);
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean requisicaoInvalida() throws SQLException, SaoMarcosException {
        ExameSaoMarcosService service = new ExameSaoMarcosService();
        return !service.buscaRequisicao(this.textFilial.getText(), this.textRequisicao.getText());
    }

    private boolean validaCamposPeriodo() {
        if (Funcoes.textoVazio(this.textDataInicial.getText())) {
            Funcoes.mensagem(this, "Data inicial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataFinal.getText())) {
            Funcoes.mensagem(this, "Data final deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
        if (intervalo < 0) {
            Funcoes.mensagem(this, "A data final n\u00e3o pode ser menor que a data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        if (intervalo > 31) {
            Funcoes.mensagem(this, "O per\u00edodo informado, excede a quantidade m\u00e1xima de dias permitida pelo Laborat\u00f3rio S\u00e3o Marcos (31 dias).", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        return true;
    }

    private void buscaRequisicao() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            boolean retorno;
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), true, true, true);
            boolean bl = retorno = resultado != null;
            if (retorno) {
                this.textRequisicao.setText(resultado.get("req_codigo").toString());
            }
            ScreenUtil.requisitarFoco(this.textRequisicao);
        } else {
            Funcoes.mensagem(this, "Filial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
        }
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(Laboratorio.getInstancia(), false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    public boolean isPeriodo() {
        return this.checkBoxPeriodo.isSelected();
    }

    public boolean isRequisicao() {
        return this.checkBoxRequisicao.isSelected();
    }

    public boolean isOk() {
        return this.isOk;
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public String getFilial() {
        return this.textFilial.getText();
    }

    public String getRequisicao() {
        return this.textRequisicao.getText();
    }
}

