/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.laboratorio.util.parsers.alvaro.DadoAdicional;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ExameSaoMarcos {
    private String codigoFilial;
    private String codigoRequisicao;
    private String codigoLis;
    private String amostra;
    private String codigoExame;
    private String codigoExameJalis;
    private String codigoExamePai;
    private String codigoMaterialJalis;
    private String codigoMaterialPai;
    private String tuboId;
    private String dataResultado;
    private String atributo;
    private String linhaResultado;
    private String resultado;
    private String conclusao;
    private String valorReferencia;
    private String observacao;
    private String metodo;
    private String observacaoResultado;
    private Integer codigoLaboratorioExterno;
    private List<DadoAdicional> dadosAdicionais = new ArrayList<DadoAdicional>();

    public ExameSaoMarcos() {
    }

    public ExameSaoMarcos(String xml) {
        this.parseXml(xml);
    }

    private void parseXml(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            String dados = StringUtil.getValor(xml, "dados_adicionais");
            this.carregarXMLDadosAdicionais(dados);
        }
    }

    private void carregarXMLDadosAdicionais(String dados) {
        this.dadosAdicionais = new ArrayList<DadoAdicional>();
        for (String dadoXml : StringUtil.getValores(dados, "dado")) {
            if (Funcoes.textoVazio(dadoXml)) continue;
            String descricao = StringUtil.getValor(dadoXml, "descricao");
            DadoAdicional dado = new DadoAdicional();
            if (Funcoes.textoVazio(descricao)) {
                dado.setDescricao(dadoXml);
                continue;
            }
            if (descricao.contains(",")) {
                String[] desc;
                for (String d : desc = descricao.split(",")) {
                    dado = new DadoAdicional();
                    dado.setDescricao(d.trim());
                    dado.setUnidade(StringUtil.getValor(dadoXml, "unidade"));
                    this.dadosAdicionais.add(dado);
                }
                continue;
            }
            dado.setDescricao(descricao.trim());
            dado.setUnidade(StringUtil.getValor(dadoXml, "unidade"));
            this.dadosAdicionais.add(dado);
        }
    }

    public List<DadoAdicional> getDadosAdicionais() {
        return this.dadosAdicionais;
    }

    public void setDadosAdicionais(List<DadoAdicional> dadosAdicionais) {
        this.dadosAdicionais = dadosAdicionais;
    }

    public String getCodigoLis() {
        return this.codigoLis;
    }

    public void setCodigoLis(String codigoLis) {
        this.codigoLis = codigoLis;
    }

    public String getAmostra() {
        return this.amostra;
    }

    public void setAmostra(String amostra) {
        this.amostra = amostra;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getTuboId() {
        return this.tuboId;
    }

    public void setTuboId(String tuboId) {
        this.tuboId = tuboId;
    }

    public String getDataResultado() {
        return this.dataResultado;
    }

    public void setDataResultado(String dataResultado) {
        this.dataResultado = dataResultado;
    }

    public String getAtributo() {
        return this.atributo;
    }

    public void setAtributo(String atributo) {
        this.atributo = atributo;
    }

    public String getLinhaResultado() {
        return this.linhaResultado;
    }

    public void setLinhaResultado(String linhaResultado) {
        this.linhaResultado = linhaResultado;
    }

    public String getResultado() {
        return this.resultado;
    }

    public void setResultado(String resultado) {
        this.resultado = resultado;
    }

    public String getConclusao() {
        return this.conclusao;
    }

    public void setConclusao(String conclusao) {
        this.conclusao = conclusao;
    }

    public String getValorReferencia() {
        return this.valorReferencia;
    }

    public void setValorReferencia(String valorReferencia) {
        this.valorReferencia = valorReferencia;
    }

    public String getCodigoFilial() {
        return this.codigoFilial;
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public String getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public void setCodigoRequisicao(String codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getMetodo() {
        return this.metodo;
    }

    public void setMetodo(String metodo) {
        this.metodo = metodo;
    }

    public String getObservacaoResultado() {
        return this.observacaoResultado;
    }

    public void setObservacaoResultado(String observacaoResultado) {
        this.observacaoResultado = observacaoResultado;
    }

    public String getCodigoExameJalis() {
        return this.codigoExameJalis;
    }

    public void setCodigoExameJalis(String codigoExameJalis) {
        this.codigoExameJalis = codigoExameJalis;
    }

    public String getCodigoMaterialJalis() {
        return this.codigoMaterialJalis;
    }

    public void setCodigoMaterialJalis(String codigoMaterialJalis) {
        this.codigoMaterialJalis = codigoMaterialJalis;
    }

    public Integer getCodigoLaboratorioExterno() {
        return this.codigoLaboratorioExterno;
    }

    public void setCodigoLaboratorioExterno(Integer codigoLaboratorioExterno) {
        this.codigoLaboratorioExterno = codigoLaboratorioExterno;
    }

    public String getCodigoExamePai() {
        return this.codigoExamePai;
    }

    public void setCodigoExamePai(String codigoExamePai) {
        this.codigoExamePai = codigoExamePai;
    }

    public String getCodigoMaterialPai() {
        return this.codigoMaterialPai;
    }

    public void setCodigoMaterialPai(String codigoMaterialPai) {
        this.codigoMaterialPai = codigoMaterialPai;
    }
}

