/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.DialogoCamposImportacaoSelecionavel;
import jalis.laboratorio.util.parsers.saomarcos.CamposResultadosSaoMarcos;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;

public class DialogoCamposImportacaoSaoMarcos
extends DialogoCamposImportacaoSelecionavel {
    private static String titulo = "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. S\u00e3o Marcos";

    public static DialogoCamposImportacaoSaoMarcos novaInstancia(Object pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        if (pai instanceof Frame) {
            return new DialogoCamposImportacaoSaoMarcos((Frame)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        if (pai instanceof Dialog) {
            return new DialogoCamposImportacaoSaoMarcos((Dialog)pai, camposImportacao, listaExamesDesmLabExterno);
        }
        return null;
    }

    public DialogoCamposImportacaoSaoMarcos(Frame pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, titulo, camposImportacao, listaExamesDesmLabExterno);
    }

    public DialogoCamposImportacaoSaoMarcos(Dialog pai, Object camposImportacao, ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        super(pai, titulo, camposImportacao, listaExamesDesmLabExterno);
    }

    @Override
    public void iniciar(Object camposImportacao) {
        this.modelo = new ModeloGridTable(new String[]{"LinhaResultado", "Atributo", "Descri\u00e7\u00e3o", "Campos"});
        this.table = ComponenteFactory.novoJTable((TableModel)this.modelo, 0, 0, 0, 0);
        this.scroll = new JScrollPane(this.table);
        this.getPanelCentral().setLayout(new BorderLayout());
        if (this.listaValida(this.listaExamesDesmLabExterno)) {
            for (CamposImportacao campo : this.listaExamesDesmLabExterno) {
                this.comboDesm.addItem(campo.getCodigoExame());
                this.mapTabs.put(campo.getCodigoExame(), campo);
            }
            this.carregaCamposImportacao(((CamposImportacao)this.listaExamesDesmLabExterno.get(0)).getCamposImportacao());
            this.getComboDesm().setBorder(new TitledBorder("Desmembramento"));
            this.getPanelCentral().add((Component)this.comboDesm, "North");
        } else {
            this.carregaCamposImportacao(camposImportacao);
        }
        this.comboDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CamposImportacao campo = DialogoCamposImportacaoSaoMarcos.this.getMapTabs().get(DialogoCamposImportacaoSaoMarcos.this.getComboDesm().getSelectedItem());
                DialogoCamposImportacaoSaoMarcos.this.carregaCamposImportacao(campo.getCamposImportacao());
            }
        });
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.setSize(new Dimension(800, 500));
        ScreenUtil.centralizar(this);
    }

    private void carregaCamposImportacao(Object camposImportacao) {
        this.modelo.clear();
        List linhas = (List)camposImportacao;
        this.modelo.addLine(this.campoNenhumPadrao());
        this.modelo.addLine(this.campoObservacaoPadrao());
        this.modelo.addLine(this.campoDataResultadoPadrao());
        for (CamposResultadosSaoMarcos camposResultadosSaoMarcos : linhas) {
            this.modelo.addLine(this.inserirLinha(camposResultadosSaoMarcos, camposResultadosSaoMarcos.getResultado()));
            this.modelo.addLine(this.inserirLinha(camposResultadosSaoMarcos, camposResultadosSaoMarcos.getMetodo()));
            this.modelo.addLine(this.inserirLinha(camposResultadosSaoMarcos, camposResultadosSaoMarcos.getConclusao()));
            this.modelo.addLine(this.inserirLinha(camposResultadosSaoMarcos, camposResultadosSaoMarcos.getValorReferencia()));
            this.modelo.addLine(this.inserirLinha(camposResultadosSaoMarcos, camposResultadosSaoMarcos.getObservacao()));
        }
    }

    private Object[] campoDataResultadoPadrao() {
        CamposResultadosSaoMarcos campoResultado = new CamposResultadosSaoMarcos();
        campoResultado.setLinhaResultado("dataresultado");
        campoResultado.setNomeParametro("*");
        campoResultado.setDescricaoParametro("Data do Resultado");
        return this.inserirLinha(campoResultado, "Data");
    }

    private Object[] campoObservacaoPadrao() {
        CamposResultadosSaoMarcos campoResultado = new CamposResultadosSaoMarcos();
        campoResultado.setLinhaResultado("observacao");
        campoResultado.setNomeParametro("*");
        campoResultado.setDescricaoParametro("Observa\u00e7\u00e3o do Exame");
        return this.inserirLinha(campoResultado, "Observa\u00e7\u00e3o");
    }

    private Object[] campoNenhumPadrao() {
        CamposResultadosSaoMarcos campoResultado = new CamposResultadosSaoMarcos();
        campoResultado.setLinhaResultado("Nenhum");
        campoResultado.setNomeParametro("");
        campoResultado.setDescricaoParametro("");
        return this.inserirLinha(campoResultado, "");
    }

    private Object[] inserirLinha(CamposResultadosSaoMarcos camposResultadosSaoMarcos, String campo) {
        Object[] linha = new String[]{camposResultadosSaoMarcos.getLinhaResultado(), camposResultadosSaoMarcos.getNomeParametro(), camposResultadosSaoMarcos.getDescricaoParametro(), campo};
        return linha;
    }

    @Override
    public void setCampoSelecionado(String campoSelecionado) {
        String campos = "";
        if (this.campoSelecionadoValido(campoSelecionado)) {
            Scanner scanner = new Scanner(campoSelecionado).useDelimiter("\\@");
            campoSelecionado = scanner.next();
            String exameDesmSelecionado = "";
            if (scanner.hasNext()) {
                campos = exameDesmSelecionado = scanner.next();
                if (scanner.hasNext() && (campos = scanner.next()).contains("#")) {
                    campos = campos.substring(0, campos.indexOf("#"));
                }
            }
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        } else if (this.campoSelecionadoCaractere(campoSelecionado)) {
            String exameDesmSelecionado = campoSelecionado;
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        }
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!this.validarSelecaoTabela(this.table, i, campoSelecionado, campos)) continue;
            this.table.setRowSelectionInterval(i, i);
        }
    }

    @Override
    public String getCampoSelecionado() {
        String campoSelecionado = "";
        if (this.tabelaPreenchida(this.table.getSelectedRow())) {
            String exameDesmSelecionado = this.listaExamesDesmLabExterno != null && !this.listaExamesDesmLabExterno.isEmpty() ? "@" + this.getComboDesm().getSelectedItem() : "";
            String resultadoSelecionado = this.table.getValueAt(this.table.getSelectedRow(), 3).toString();
            campoSelecionado = this.table.getValueAt(this.table.getSelectedRow(), 1).toString();
            String string = campoSelecionado = !Funcoes.textoVazio(campoSelecionado) ? campoSelecionado + exameDesmSelecionado + "@" + resultadoSelecionado : "";
            if (this.listaValida(this.listaExamesDesmLabExterno)) {
                campoSelecionado = campoSelecionado + "#" + ((CamposImportacao)this.mapTabs.get(this.getComboDesm().getSelectedItem().toString())).getMaterialPaiDesm();
            }
        }
        return campoSelecionado;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(true);
    }

    @Override
    public boolean getOK() {
        return this.ok;
    }

    private boolean validarSelecaoTabela(JTable table, int i, String campoSelecionado, String campos) {
        return table.getValueAt(i, 1).toString().equalsIgnoreCase(campoSelecionado) && table.getValueAt(i, 3).toString().equalsIgnoreCase(campos);
    }

    private boolean campoSelecionadoValido(String campoSelecionado) {
        return this.campoSelecionadoCaractere(campoSelecionado) && campoSelecionado.contains("@");
    }

    private boolean campoSelecionadoCaractere(String campoSelecionado) {
        return !Funcoes.textoVazio(campoSelecionado);
    }

    private boolean listaValida(ArrayList<CamposImportacao> listaExamesDesmLabExterno) {
        return listaExamesDesmLabExterno != null && !listaExamesDesmLabExterno.isEmpty();
    }

    private boolean tabelaPreenchida(int index) {
        return index > -1;
    }
}

