/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.model.vo.cadastro.exame.ExameSaoMarcosVO;
import jalis.service.integracaolaboratorioexterno.ExameSaoMarcosService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorSaoMarcos
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigo";
    private static final String MATERIAL_EXAME = "materialExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String OBJ_EXAME_SAOMARCOS = "exameSaoMarcos";
    private ModeloResultSet modExa = new ModeloResultSet("Codigo", "codigo", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "materialExame");
    private ModeloResultSet modDadosAdicionais = new ModeloResultSet("Dado Adicional", "dadoAdicional", "Sel", "selecionado");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modDadosAdicionais, null, 0, 40);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0, 80, 50);
    private JTextField textLocalizar = new JTextField();
    private JTextField textMaterial = ComponenteFactory.novoTTextField(8, 3);
    private String xmlSelecionado = "";

    public ConfiguradorSaoMarcos(Frame pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorSaoMarcos(Dialog pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorSaoMarcos novaInstancia(Object pai, String codigoLabExterno, String titulo) {
        if (pai instanceof Frame) {
            return new ConfiguradorSaoMarcos((Frame)pai, codigoLabExterno, titulo);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorSaoMarcos((Dialog)pai, codigoLabExterno, titulo);
        }
        return null;
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameSaoMarcosVO.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameSaoMarcosVO exa = new ExameSaoMarcosVO();
            exa.setSmaCodExame(StringUtil.getValor(xml, COD_EXA));
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (!this.validaDadosExameSelecionado(reg, exa)) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.scrollDadosAdicionais.setPreferredSize(new Dimension(650, 100));
        this.modDadosAdicionais.setColunaEditavel("selecionado");
        TableColumn col = this.tableDadosAdicionais.getColumnModel().getColumn(1);
        col.setMinWidth(30);
        col.setMaxWidth(30);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), "Center");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorSaoMarcos.this.modExa.filtrar(ConfiguradorSaoMarcos.DESC_EXA, ConfiguradorSaoMarcos.this.textLocalizar.getText());
                if (ConfiguradorSaoMarcos.this.possuiExamesTabela(ConfiguradorSaoMarcos.this.modExa.getRowCount())) {
                    ConfiguradorSaoMarcos.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSaoMarcos.this.tabelaEmFoco() && ConfiguradorSaoMarcos.this.possuiExamesTabela(row = ConfiguradorSaoMarcos.this.tableExa.getSelectedRow())) {
                    ConfiguradorSaoMarcos.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorSaoMarcos.this.tableExa.scrollRectToVisible(ConfiguradorSaoMarcos.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorSaoMarcos.this.tabelaEmFoco() && ConfiguradorSaoMarcos.this.validaSelecaoTabela(row = ConfiguradorSaoMarcos.this.tableExa.getSelectedRow())) {
                    ConfiguradorSaoMarcos.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorSaoMarcos.this.tableExa.scrollRectToVisible(ConfiguradorSaoMarcos.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        ExameSaoMarcosService serviceExameSaoMarcos = new ExameSaoMarcosService();
        try {
            Map<String, ExameSaoMarcosVO> listaExames = serviceExameSaoMarcos.loadExamesSaoMarcos(Integer.valueOf(this.getCodigoLabExterno()), Variaveis.filialPadrao);
            for (String key : listaExames.keySet()) {
                ExameSaoMarcosVO examesSaoMarcos = listaExames.get(key);
                Registro reg = new Registro();
                reg.setValor(COD_EXA, examesSaoMarcos.getSmaCodExame());
                reg.setValor(DESC_EXA, examesSaoMarcos.getDescricaoExame());
                reg.setValor(MATERIAL_EXAME, examesSaoMarcos.getSmaCodMaterial());
                reg.setValor(OBJ_EXAME_SAOMARCOS, examesSaoMarcos);
                this.modExa.addRegistro(reg);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter a lista de exames.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (this.possuiRegistro(reg)) {
            ExameSaoMarcosVO exameSaoMarcos = (ExameSaoMarcosVO)reg.getValor(OBJ_EXAME_SAOMARCOS);
            this.atualizarDadosAdicionais(exameSaoMarcos);
        }
    }

    private void atualizarDadosAdicionais(ExameSaoMarcosVO exameSaoMarcos) {
        String[] dadosAdicionais;
        this.modDadosAdicionais.limpar();
        for (String valor : dadosAdicionais = StringUtil.getValores(exameSaoMarcos.getSmaxml(), "dado")) {
            Registro r = new Registro();
            r.setValor("dadoAdicional", StringUtil.getValor(valor, "descricao").trim());
            r.setValor("selecionado", Boolean.TRUE);
            this.modDadosAdicionais.addRegistro(r);
        }
    }

    @Override
    public boolean acaoOk() {
        ExameSaoMarcosVO exa = this.getExameSelecionado();
        if (!this.possuiRegistro(exa)) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        ExameSaoMarcosVO exa = this.getExameSelecionado();
        if (this.possuiRegistro(exa)) {
            if (!Funcoes.textoVazio(this.textMaterial.getText())) {
                exa.setSmaCodMaterial(this.textMaterial.getText().toUpperCase());
            }
            this.xmlSelecionado = exa.getSmaxml();
            return true;
        }
        return false;
    }

    private ExameSaoMarcosVO getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        return (ExameSaoMarcosVO)reg.getValor(OBJ_EXAME_SAOMARCOS);
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (ConfiguradorSaoMarcos.xmlPreenchido(xml)) {
            return StringUtil.getValor(xml, COD_EXA);
        }
        return "";
    }

    private static boolean xmlPreenchido(String xml) {
        return xml != null && xml.trim().length() > 0;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (ConfiguradorSaoMarcos.xmlPreenchido(xml)) {
            return StringUtil.getValor(xml, "descricao");
        }
        return "";
    }

    private boolean validaDadosExameSelecionado(Registro reg, ExameSaoMarcosVO exa) {
        return this.possuiRegistro(reg) && exa.getSmaCodExame().equals(reg.getValor(COD_EXA));
    }

    private boolean possuiExamesTabela(int index) {
        return index > 0;
    }

    private boolean possuiRegistro(Object reg) {
        return reg != null;
    }

    private boolean validaSelecaoTabela(int row) {
        return row < this.tableExa.getRowCount() - 1;
    }

    private boolean tabelaEmFoco() {
        return this.tableExa.hasFocus();
    }
}

