/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.laboratorio.util.impressao.exame.externo.saoMarcos.ConexaoSaoMarcos;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.saomarcos.ButtonConfigLayoutSaoMarcos;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.TipoImpressao;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloSaoMarcos
extends AbstractConfiguradorProtocolo {
    protected JTextField textChave = new TTextField(100, 1);
    protected JTextField textSenha = new TTextField(16, 3);
    protected JTextField textDataValidade = new TTextField(8, 4);
    protected JTextField textEndWebService = new TTextField(100, 3);
    protected JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    public static final String TAG_MODELO_GRAFICO = "modeloGrafico";
    public static final String TAG_MODELO_TERMICO = "modeloTermico";
    public static final String TERMICA = "T";
    public static final String GRAFICA = "G";
    public static final String TIPO_IMPRESSAO = "tipoImpressao";
    private String data;
    private ButtonConfigLayoutSaoMarcos buttonConfigurarLayout = new ButtonConfigLayoutSaoMarcos(this, "Configurar layout", TipoImpressao.GRAFICA, TipoImpressao.TERMICA);

    public ConfiguradorProtocoloSaoMarcos(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloSaoMarcos(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        ConfiguradorProtocoloSaoMarcos configuradorProtocolo = null;
        if (pai instanceof Frame) {
            configuradorProtocolo = new ConfiguradorProtocoloSaoMarcos((Frame)pai, "Laborat\u00f3rio S\u00e3o Marcos", codigoLaboratorio);
        } else if (pai instanceof Dialog) {
            configuradorProtocolo = new ConfiguradorProtocoloSaoMarcos((Dialog)pai, "Laborat\u00f3rio S\u00e3o Marcos", codigoLaboratorio);
        }
        return configuradorProtocolo;
    }

    @Override
    public String getXML() {
        String xmlEtiqueta = this.buttonConfigurarLayout.getXmlConfiguracao();
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever("chave", this.textChave.getText());
        xml.escrever("validadeChave", this.textDataValidade.getText());
        xml.escrever("codigo", this.textCodigo.getText());
        xml.escrever("lote", this.textLote.getText());
        xml.escrever("senha", this.textSenha.getText());
        xml.escrever("enderecoWebService", this.textEndWebService.getText());
        xml.escrever("enviarLoteWebService", this.enviarLoteUsandoWebService());
        xml.escrever("envioAutomatico", this.enviarAutomaticoRequisicao());
        xml.escrever(TIPO_IMPRESSAO, this.buttonConfigurarLayout.getTipoImpressaoSelecionado().getCodigo());
        xml.escrever("modelo", xmlEtiqueta);
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.getTag("saomarcos", xml.getXML()));
        return buf.toString();
    }

    private String enviarAutomaticoRequisicao() {
        return this.checkEnvioAutomatico.isSelected() ? "true" : "false";
    }

    private String enviarLoteUsandoWebService() {
        return this.checkEnviaLoteUsandoWebService.isSelected() ? "true" : "false";
    }

    private String getDataValidade() {
        if (!Funcoes.textoVazio(this.data) && !this.isTokeValido()) {
            return this.getNewDate();
        }
        return this.data;
    }

    private boolean isTokeValido() {
        return Funcoes.comparaData(this.data, this.getNewDate()) >= 0;
    }

    public String getNewDate() {
        return Funcoes.formataData("dd/MM/yyyy", new Date());
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (this.existeXml(xml)) {
            xml = StringUtil.getValor(xml, "saomarcos");
            this.data = StringUtil.getValor(xml, "validadeChave");
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
            this.textCodigo.setText(StringUtil.getValor(xml, "codigo"));
            this.textChave.setText(StringUtil.getValor(xml, "chave"));
            this.textDataValidade.setText(StringUtil.getValor(xml, "validadeChave"));
            this.textSenha.setText(StringUtil.getValor(xml, "senha"));
            this.textEndWebService.setText(StringUtil.getValor(xml, "enderecoWebService"));
            this.checkEnvioAutomatico.setSelected(this.extrairEnvioAutomaticoRequisicao(xml));
            TipoImpressao tipoImpressao = this.getTipoImpressao(xml);
            this.buttonConfigurarLayout.setTipoImpressaoSelecionado(tipoImpressao);
            this.buttonConfigurarLayout.setXmlConfiguracao(StringUtil.getValor(xml, "modelo"));
        }
    }

    private TipoImpressao getTipoImpressao(String xml) {
        String tipoImpressao = StringUtil.getValor(xml, TIPO_IMPRESSAO);
        if (tipoImpressao.equalsIgnoreCase(TERMICA)) {
            return TipoImpressao.TERMICA;
        }
        return TipoImpressao.GRAFICA;
    }

    protected void iniciar() {
        this.setPreferredSize(new Dimension(350, 280));
        this.setSize(new Dimension(340, 270));
        this.getPanelCentral().setPreferredSize(new Dimension(300, 300));
        this.getPanelCentral().setSize(new Dimension(300, 300));
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(0, 0, 1, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        JLabel lblChave = ComponenteFactory.novoJLabel("Chave:", new Dimension(85, 20));
        lblChave.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblChave, cons);
        ++cons.gridy;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 20));
        lblLote.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblLote, cons);
        ++cons.gridy;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 20));
        lblCodigo.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblCodigo, cons);
        ++cons.gridy;
        JLabel lblSenha = ComponenteFactory.novoJLabel("Senha:", new Dimension(85, 20));
        lblSenha.setMinimumSize(new Dimension(85, 20));
        this.getPanelCentral().add((Component)lblSenha, cons);
        cons.gridx = 0;
        ++cons.gridy;
        JLabel lblService = ComponenteFactory.novoJLabel("Web Services:", new Dimension(100, 20));
        lblService.setMinimumSize(new Dimension(100, 20));
        this.getPanelCentral().add((Component)lblService, cons);
        cons.gridy = 0;
        ++cons.gridx;
        cons.gridwidth = 3;
        this.textChave = new TTextField(100, 3);
        this.textChave.setPreferredSize(new Dimension(150, 20));
        this.textChave.setMinimumSize(new Dimension(150, 20));
        this.textChave.setEnabled(false);
        this.getPanelCentral().add((Component)this.textChave, cons);
        ++cons.gridy;
        this.textLote.setPreferredSize(new Dimension(200, 20));
        this.textLote.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        this.textCodigo = new TTextField(6, 3);
        this.textCodigo.setPreferredSize(new Dimension(200, 20));
        this.textCodigo.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        this.textSenha.setHorizontalAlignment(4);
        ++cons.gridy;
        this.textSenha.setPreferredSize(new Dimension(200, 20));
        this.textSenha.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textSenha, cons);
        ++cons.gridy;
        this.textEndWebService.setPreferredSize(new Dimension(200, 20));
        this.textEndWebService.setMinimumSize(new Dimension(200, 20));
        this.textEndWebService.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textEndWebService, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 4;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        ++cons.gridy;
        cons.gridx = 3;
        cons.gridwidth = 1;
        cons.fill = 0;
        cons.anchor = 13;
        this.buttonConfigurarLayout.setPreferredSize(new Dimension(152, 25));
        this.buttonConfigurarLayout.setMinimumSize(new Dimension(152, 25));
        this.buttonConfigurarLayout.setHorizontalAlignment(0);
        this.buttonConfigurarLayout.addActionListener(this);
        this.buttonConfigurarLayout.setMnemonic('L');
        this.getPanelCentral().add((Component)this.buttonConfigurarLayout, cons);
        this.checkEnvioAutomatico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloSaoMarcos.this.checkEnvioAutomatico.isSelected()) {
                    ConfiguradorProtocoloSaoMarcos.this.checkEnviaLoteUsandoWebService.setSelected(true);
                }
            }
        });
        this.checkEnviaLoteUsandoWebService.setSelected(true);
        this.checkEnviaLoteUsandoWebService.setEnabled(false);
        this.textChave.setHorizontalAlignment(4);
        this.pack();
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textChave);
    }

    @Override
    public boolean acaoOk() {
        if (this.checkEnviaLoteUsandoWebService.isSelected()) {
            if (Funcoes.textoVazio(this.textSenha.getText())) {
                Funcoes.mensagem(this, "Informe o campo senha.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
            if (Funcoes.textoVazio(this.textEndWebService.getText())) {
                Funcoes.mensagem(this, "Informe o campo web services.", 2);
                ScreenUtil.requisitarFoco(this.textEndWebService);
                return false;
            }
        }
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textChave) || !this.isTokeValido()) {
            String token = this.getChave();
            if (!Funcoes.textoVazio(token)) {
                this.textChave.setText(token);
            } else {
                return false;
            }
        }
        return true;
    }

    private String getChave() {
        ConexaoSaoMarcos conexao = new ConexaoSaoMarcos();
        String retorno = conexao.getToken(this.getXML());
        if (conexao.retornoValido(retorno)) {
            return retorno;
        }
        return "";
    }

    private boolean ignoraChaves(String caracter) {
        return !caracter.equals("{") && !caracter.equals("}");
    }

    private boolean extrairEnviarViaWebService(String xml) {
        boolean valor = false;
        if (this.possuiTag(xml, "enviarLoteWebService")) {
            valor = StringUtil.getBoolean(xml, "enviarLoteWebService");
        }
        return valor;
    }

    private boolean extrairEnvioAutomaticoRequisicao(String xml) {
        boolean valor = false;
        if (this.possuiTag(xml, "envioAutomatico")) {
            valor = StringUtil.getBoolean(xml, "envioAutomatico");
        }
        return valor;
    }

    private boolean possuiTag(String xml, String tag) {
        return StringUtil.getValor(xml, tag).trim().length() > 0;
    }

    private boolean existeXml(String xml) {
        return xml != null;
    }
}

