/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.saomarcos.CampoImportacaoSaoMarcos;
import jalis.service.integracaolaboratorioexterno.ExameSaoMarcosService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class CamposRelacionamentoSaoMarcosUtil {
    public static Map<String, Object> getMapCampoValor(StringBuilder resultadoAtual, Registro reg) {
        return CamposRelacionamentoSaoMarcosUtil.atualizaXmlResultadoAtual(reg, resultadoAtual);
    }

    private static Map<String, Object> atualizaXmlResultadoAtual(Registro reg, StringBuilder resultadoAtual) {
        String resultados = reg.getString("exr_resultado");
        String[] componentes = StringUtil.getValores(resultados, "componente");
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        for (String componente : componentes) {
            String atributos = StringUtil.getValor(componente, "atributos");
            String campoImportacao = StringUtil.getValor(atributos, "campoImportacao");
            String labExterno = StringUtil.getValor(campoImportacao, "protocolo");
            if (Funcoes.textoVazio(labExterno)) continue;
            String campo = StringUtil.getValor(campoImportacao, "campo");
            String resultado = StringUtil.getValor(componente, "valorResultado");
            mapa.put(campo, resultado);
        }
        return mapa;
    }

    public static CamposImportacao carregarCamposAutomaticamente(String codigoLabExterno, String codigoExameLabApoio, String xmlExameLabApoio, String codigoExamePai, Integer materialPai) throws SQLException {
        CampoImportacaoSaoMarcos campoImportacao = null;
        ExameSaoMarcosService serviceExameSaoMarcos = new ExameSaoMarcosService();
        String tmp = "";
        if (CamposRelacionamentoSaoMarcosUtil.possuiLabExternoConfigurado(codigoLabExterno, codigoExameLabApoio) && !Funcoes.textoVazio(tmp = serviceExameSaoMarcos.getXml(codigoLabExterno, codigoExameLabApoio, Variaveis.filialPadrao))) {
            campoImportacao = new CampoImportacaoSaoMarcos(tmp, tmp, codigoLabExterno, codigoExameLabApoio, codigoExamePai, materialPai);
        }
        return campoImportacao;
    }

    private static boolean possuiLabExternoConfigurado(String codigoLabExterno, String codigoExameLabApoio) {
        return codigoLabExterno != null && codigoExameLabApoio != null;
    }

    public static CamposImportacao carregarCampos(String codigoLabExterno, String codExameLabExterno, String xmlExameLabExterno, String codigoExamePai, Integer codigoMaterialPai) throws SQLException {
        return CamposRelacionamentoSaoMarcosUtil.carregarCamposAutomaticamente(codigoLabExterno, codExameLabExterno, xmlExameLabExterno, codigoExamePai, codigoMaterialPai);
    }
}

