/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.saomarcos.CamposResultadosSaoMarcos;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CampoImportacaoSaoMarcos
implements CamposImportacao {
    private List<CamposResultadosSaoMarcos> linhas = new ArrayList<CamposResultadosSaoMarcos>();
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CampoImportacaoSaoMarcos(String xml, String xmlExameLabApoio, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        this.codigoExamePai = codigoExamePai;
        this.codigoMaterialPai = codigoMaterialPai;
        this.codigoExame = codigoExameLabApoio;
        this.linhas.addAll(this.getCamposResultados(xmlExameLabApoio));
    }

    private List<CamposResultadosSaoMarcos> getCamposResultados(String xmlExameLabApoio) {
        String codigoExame = StringUtil.getValor(xmlExameLabApoio, "codigo");
        String descricaoExame = StringUtil.getValor(xmlExameLabApoio, "descricao");
        String observacaoExame = StringUtil.getValor(xmlExameLabApoio, "observacao");
        String dataResultado = StringUtil.getValor(xmlExameLabApoio, "dataresultado");
        String resultados = StringUtil.getValor(xmlExameLabApoio, "resultados");
        ArrayList<CamposResultadosSaoMarcos> listaResultados = new ArrayList<CamposResultadosSaoMarcos>();
        for (String campos : StringUtil.getValores(xmlExameLabApoio, "campo")) {
            String parametro = StringUtil.getValor(campos, "atributo");
            String descricaoParametro = StringUtil.getValor(campos, "nome-parametro");
            String metodo = StringUtil.getValor(campos, "metodo");
            String conclusao = StringUtil.getValor(campos, "conclusao");
            String valorReferencia = StringUtil.getValor(campos, "vlr_referencia");
            String observacao = StringUtil.getValor(campos, "observacao");
            String resultado = StringUtil.getValor(campos, "resultado");
            String linhaResultado = StringUtil.getValor(campos, "linharesultado");
            CamposResultadosSaoMarcos camposResultados = new CamposResultadosSaoMarcos();
            camposResultados.setCodigoExame(codigoExame);
            camposResultados.setLinhaResultado(linhaResultado);
            camposResultados.setNomeParametro(parametro);
            camposResultados.setDescricaoParametro(descricaoParametro);
            camposResultados.setMetodo(metodo);
            camposResultados.setResultado(resultado);
            camposResultados.setConclusao(conclusao);
            camposResultados.setValorReferencia(valorReferencia);
            camposResultados.setObservacao(observacao);
            camposResultados.setObservacaoExame(observacaoExame);
            camposResultados.setDataResultado(dataResultado);
            listaResultados.add(camposResultados);
        }
        return listaResultados;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public String toString() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }
}

