/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.saomarcos;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.parsers.saomarcos.ConfiguradorProtocoloSaoMarcos;
import jalis.relatorio.Editor;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.impressao.TipoImpressao;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ButtonConfigLayoutSaoMarcos
extends JButton {
    private TipoImpressao[] tiposImpressao = null;
    private TipoImpressao tipoImpressaoSelecionado = TipoImpressao.GRAFICA;
    private JPopupMenu menu = new JPopupMenu();
    private JMenu menuTipo = new JMenu("Tipo de impress\u00e3o");
    private JCheckBoxMenuItem itemTipoGrafica = new JCheckBoxMenuItem(TipoImpressao.GRAFICA.getDescricao(), TipoImpressao.GRAFICA.getImagem());
    private JCheckBoxMenuItem itemTipoDireta = new JCheckBoxMenuItem(TipoImpressao.DIRETA.getDescricao(), TipoImpressao.DIRETA.getImagem());
    private JCheckBoxMenuItem itemTipoTermica = new JCheckBoxMenuItem(TipoImpressao.TERMICA.getDescricao(), TipoImpressao.TERMICA.getImagem());
    private JMenuItem itemNovoAlterar = new JMenuItem("Novo/Alterar");
    private ConfiguradorProtocoloSaoMarcos configuradorProtocoloSaoMarcos;
    private String xmlConfiguracao = "";
    private String xmlConfiguracaoModeloGraficoTemp = "";
    private String xmlConfiguracaoModeloTermicoTemp = "";

    public ButtonConfigLayoutSaoMarcos(ConfiguradorProtocoloSaoMarcos configProtocoloSaoMarcos, String descricao, TipoImpressao ... impressao) {
        super(descricao);
        this.configuradorProtocoloSaoMarcos = configProtocoloSaoMarcos;
        int altura = this.getHeight();
        this.setPreferredSize(new Dimension(170, 25));
        this.setMinimumSize(new Dimension(170, 25));
        this.setMaximumSize(new Dimension(170, 25));
        this.tiposImpressao = impressao;
        this.setHorizontalTextPosition(4);
        this.setTipoImpressaoSelecionado(TipoImpressao.GRAFICA, false);
        this.setHorizontalAlignment(2);
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TipoImpressao.GRAFICA) > -1) {
            this.menuTipo.add(this.itemTipoGrafica);
        }
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TipoImpressao.DIRETA) > -1) {
            this.menuTipo.add(this.itemTipoDireta);
        }
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TipoImpressao.TERMICA) > -1) {
            this.menuTipo.add(this.itemTipoTermica);
        }
        if (this.menuTipo.getPopupMenu().getComponentCount() > 0) {
            this.menu.add(this.menuTipo);
        }
        this.menu.add(this.itemNovoAlterar);
        this.itemNovoAlterar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfigLayoutSaoMarcos.this.xmlConfiguracao = ButtonConfigLayoutSaoMarcos.this.configurarModelo(ButtonConfigLayoutSaoMarcos.this);
                ButtonConfigLayoutSaoMarcos.this.setXmlConfiguracao(ButtonConfigLayoutSaoMarcos.this.xmlConfiguracao);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfigLayoutSaoMarcos.this.menu.show(ButtonConfigLayoutSaoMarcos.this, 0, ButtonConfigLayoutSaoMarcos.this.getHeight());
            }
        });
        this.itemTipoGrafica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfigLayoutSaoMarcos.this.setTipoImpressaoSelecionado(TipoImpressao.GRAFICA, true);
            }
        });
        this.itemTipoDireta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfigLayoutSaoMarcos.this.setTipoImpressaoSelecionado(TipoImpressao.DIRETA, true);
            }
        });
        this.itemTipoTermica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfigLayoutSaoMarcos.this.setTipoImpressaoSelecionado(TipoImpressao.TERMICA, true);
            }
        });
    }

    private String configurarModelo(ButtonConfigLayoutSaoMarcos buttonConfiguracao) {
        TipoImpressao tipoImpressao = buttonConfiguracao.getTipoImpressaoSelecionado();
        if (tipoImpressao == null) {
            return "";
        }
        StringBuilder xml = new StringBuilder();
        xml.append(buttonConfiguracao.getXmlConfiguracao());
        String configurando = "";
        if (tipoImpressao.equals((Object)TipoImpressao.GRAFICA)) {
            Editor editor = new Editor(Laboratorio.getInstancia(), "Configurando etiqueta HP Direct", true);
            editor.setCamposDoBanco(Impressao.CAMPOS_ETIQUETA_SM);
            this.xmlConfiguracaoModeloGraficoTemp = StringUtil.getValor(this.xmlConfiguracao, "modeloGrafico");
            if (!Funcoes.textoVazio(this.xmlConfiguracaoModeloGraficoTemp)) {
                editor.setAtributos(this.xmlConfiguracaoModeloGraficoTemp);
            }
            editor.setVisible(true);
            configurando = editor.ok() ? editor.getAtributos() : this.xmlConfiguracaoModeloGraficoTemp;
            if (this.contemTag(xml, "modeloGrafico")) {
                xml.append("<").append("modeloGrafico").append(">");
                xml.append("</").append("modeloGrafico").append(">");
            }
            StringUtil.setValor(xml, "modeloGrafico", configurando);
        } else if (tipoImpressao.equals((Object)TipoImpressao.TERMICA)) {
            EditorTermica editorTermica = new EditorTermica(Laboratorio.getInstancia(), "Configurando etiqueta HP Direct", true);
            this.xmlConfiguracaoModeloTermicoTemp = StringUtil.getValor(this.xmlConfiguracao, "modeloTermico");
            editorTermica.setDocumento(this.xmlConfiguracaoModeloTermicoTemp);
            editorTermica.setCamposBanco(Impressao.CAMPOS_ETIQUETA_SM);
            editorTermica.setVisible(true);
            configurando = editorTermica.ok() ? editorTermica.getDocumento() : this.xmlConfiguracaoModeloTermicoTemp;
            if (this.contemTag(xml, "modeloTermico")) {
                xml.append("<").append("modeloTermico").append(">").append("</").append("modeloTermico").append(">");
            }
            StringUtil.setValor(xml, "modeloTermico", configurando);
        }
        return xml.toString();
    }

    private boolean contemTag(StringBuilder xml, String tag) {
        return xml.indexOf("<" + tag + ">") == -1;
    }

    public void setTipoImpressaoSelecionado(TipoImpressao tipo, boolean perguntarAlteracao) {
        if (perguntarAlteracao && this.tipoImpressaoSelecionado != tipo) {
            int resp = Funcoes.mensagem(this.getTopLevelAncestor(), "Alterar o tipo de impress\u00e3o remover\u00e1 as configura\u00e7\u00f5es atuais.\nDeseja alterar?", 4);
            if (resp == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.xmlConfiguracao);
                StringUtil.setValor(builder, "modeloTermico", "");
                StringUtil.setValor(builder, "modeloGrafico", "");
                this.xmlConfiguracao = builder.toString();
            } else {
                if (tipo == TipoImpressao.GRAFICA) {
                    this.itemTipoGrafica.setSelected(false);
                } else if (tipo == TipoImpressao.DIRETA) {
                    this.itemTipoDireta.setSelected(false);
                } else if (tipo == TipoImpressao.TERMICA) {
                    this.itemTipoTermica.setSelected(false);
                } else {
                    this.itemTipoGrafica.setSelected(true);
                    this.setIcon(TipoImpressao.GRAFICA.getImagem());
                }
                return;
            }
        }
        this.tipoImpressaoSelecionado = tipo;
        if (this.tipoImpressaoSelecionado.getImagem() != null) {
            this.setIcon(this.tipoImpressaoSelecionado.getImagem());
        }
        this.itemTipoGrafica.setSelected(false);
        this.itemTipoDireta.setSelected(false);
        this.itemTipoTermica.setSelected(false);
        if (tipo == TipoImpressao.GRAFICA) {
            this.itemTipoGrafica.setSelected(true);
        } else if (tipo == TipoImpressao.DIRETA) {
            this.itemTipoDireta.setSelected(true);
        } else if (tipo == TipoImpressao.TERMICA) {
            this.itemTipoTermica.setSelected(true);
        } else {
            this.itemTipoGrafica.setSelected(true);
            this.setIcon(TipoImpressao.GRAFICA.getImagem());
        }
        this.montaHint();
    }

    public TipoImpressao getTipoImpressaoSelecionado() {
        return this.tipoImpressaoSelecionado;
    }

    public void setTipoImpressaoSelecionado(TipoImpressao tipoImpressaoSelecionado) {
        this.tipoImpressaoSelecionado = tipoImpressaoSelecionado;
        this.tipoImpressaoSelecionado = tipoImpressaoSelecionado;
        if (tipoImpressaoSelecionado != null && tipoImpressaoSelecionado.getImagem() != null) {
            this.setIcon(tipoImpressaoSelecionado.getImagem());
        }
        this.itemTipoGrafica.setSelected(false);
        this.itemTipoDireta.setSelected(false);
        this.itemTipoTermica.setSelected(false);
        if (this.tipoImpressaoSelecionado == TipoImpressao.GRAFICA) {
            this.itemTipoGrafica.setSelected(true);
        } else if (this.tipoImpressaoSelecionado == TipoImpressao.DIRETA) {
            this.itemTipoDireta.setSelected(true);
        } else if (this.tipoImpressaoSelecionado == TipoImpressao.TERMICA) {
            this.itemTipoTermica.setSelected(true);
        } else {
            this.itemTipoGrafica.setSelected(true);
            this.setIcon(TipoImpressao.GRAFICA.getImagem());
        }
        this.montaHint();
    }

    public void setXmlConfiguracao(String xml) {
        this.xmlConfiguracao = xml;
        this.montaHint();
    }

    public String getXmlConfiguracao() {
        return this.xmlConfiguracao;
    }

    public String getModeloGrafico() {
        StringBuffer retorno = new StringBuffer();
        retorno.append(StringUtil.getValor(this.xmlConfiguracao, "modeloGrafico"));
        return retorno.toString();
    }

    public String getModeloTermico() {
        StringBuffer retorno = new StringBuffer();
        retorno.append(StringUtil.getValor(this.xmlConfiguracao, "modeloTermico"));
        return retorno.toString();
    }

    private void montaHint() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html>Tipo de impress\u00e3o: <b>").append(this.tipoImpressaoSelecionado != null ? this.tipoImpressaoSelecionado.getDescricao() : "").append("</b>");
        if (Funcoes.textoVazio(this.xmlConfiguracao)) {
            buf.append("<br>").append("Sem modelo definido");
        }
        buf.append("</html>");
        this.setToolTipText(buf.toString());
    }

    public void limpar() {
        this.setTipoImpressaoSelecionado(TipoImpressao.GRAFICA, false);
        this.setXmlConfiguracao("");
    }
}

