/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.rede.ws.CamposRedeWS;
import jalis.laboratorio.util.parsers.rede.ws.ExameRedeWS;
import jalis.laboratorio.util.parsers.rede.ws.LinhaResultadoRedeWS;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.Registro;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoRedeWS {
    private static int RECIPIENTE = 0;
    private static int CODIGO_EXAME = 1;
    private static int PROCEDIMENTO = 2;
    private static int MATERIAL = 3;
    private static int STATUS = 4;
    private static int VERSAO = 5;
    private static int DATA = 6;
    private static int HORA = 7;
    private static int PADRAO = 8;
    private static int MASCARA = 9;
    private static int PARAM_APELIDO = 10;
    private static int PARAM_DESCRICAO = 11;
    private static int PARAM_APELIDO_EXPOR = 12;
    private static int PROC_APELIDO = 13;
    private static int PROC_DESCRICAO = 14;
    private static int PROC_METODO = 15;
    private static int PROC_UNIDADE = 16;
    public static final String TAG_EXAME_JALIS = "exa_codigo";
    public static final String TAG_MATERIAL_JALIS = "mco_codigo";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_EXAME_CODIGO = "codigo";
    public static final String TAG_EXAME_DESCRICAO = "descricao";
    public static final String TAG_EXAME_DESC_MATERIAL = "desc_material";
    public static final String TAG_EXAME_RECIPIENTE = "recipiente";
    public static final String TAG_EXAME_VERSAO = "versao";
    public static final String TAG_EXAME_DATA = "data";
    public static final String TAG_RESULTADO_DATA = "data";
    public static final String TAG_RESULTADO_DESC_DATA = "desc_data";
    public static final String TAG_RESULTADO_HORA = "hora";
    public static final String TAG_RESULTADO_DESC_HORA = "desc_hora";
    public static final String TAG_RESULTADO_RESPONSAVEL = "responsavel";
    public static final String TAG_RESULTADO_DESC_RESPONSAVEL = "desc_responsavel";
    public static final String TAG_RESULTADO_APELIDO = "apelido";
    public static final String TAG_RESULTADO_DESC_APELIDO = "desc_apelido";
    public static final String TAG_RESULTADO_CAMPOS = "campos";
    public static final String TAG_RESULTADO_CAMPO = "campo";
    public static final String TAG_RESULTADO_CAMPO_CODIGO = "codigo";
    public static final String TAG_RESULTADO_CAMPO_DESCRICAO = "descricao";

    public static ArrayList<ExameRedeWS> importarDadosRedeWS(File fileExamesRedeWS, int codigoLabExterno, JProgressBar progress, StringBuilder buiMensagem) {
        ArrayList<ExameRedeWS> exames = new ArrayList<ExameRedeWS>();
        ArrayList<ExameRedeWS> atualizaExamesDePara = new ArrayList<ExameRedeWS>();
        try {
            Map<String, ExameRedeWS> examesAntigosRelac = ParserImportacaoRedeWS.examesMap(ParserImportacaoRedeWS.getExamesRelacionados(codigoLabExterno));
            List<ExameRedeWS> dadosExameRedeWS = ParserImportacaoRedeWS.loadExamesRedeWS(fileExamesRedeWS, codigoLabExterno);
            if (dadosExameRedeWS.size() > 0) {
                Statement st = Conexao.getStatement();
                ArrayList<ExameRedeWS> examesAtualizados = new ArrayList<ExameRedeWS>();
                if (progress != null) {
                    progress.setMaximum(dadosExameRedeWS.size() * 2);
                    progress.setValue(0);
                }
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 13, new Object[0]);
                for (ExameRedeWS exame : dadosExameRedeWS) {
                    if (exame.getCodigo().isEmpty() || exame.getDescricao().isEmpty() || exame.getDescricaoMaterial().isEmpty() || Objects.isNull(exame.getLaboratorioExterno()) || exame.getXml().isEmpty() || Objects.isNull(exame.getVersao()) || Objects.isNull(exame.getData())) {
                        buiMensagem.append("\n");
                        buiMensagem.append("\nO exame " + exame.getCodigo() + " n\u00e3o possui todas as informa\u00e7\u00f5es para a importa\u00e7\u00e3o no Jalis.");
                        continue;
                    }
                    examesAtualizados.add(exame);
                }
                ParserImportacaoRedeWS.inserirExamesRedeWS(dadosExameRedeWS, st, codigoLabExterno, progress);
                HashSet<ExameRedeWS> examesNovosRel = new HashSet<ExameRedeWS>(dadosExameRedeWS);
                for (ExameRedeWS e1 : examesNovosRel) {
                    for (ExameRedeWS e2 : examesAntigosRelac.values()) {
                        if (!e1.getCodigo().equals(e2.getCodigo())) continue;
                        atualizaExamesDePara.add(e1);
                    }
                }
                if (progress != null) {
                    progress.setMaximum(examesNovosRel.size() * 2);
                    progress.setValue(0);
                }
                for (ExameRedeWS ex : atualizaExamesDePara) {
                    ExameRedeWS exAntigo = examesAntigosRelac.get(ex.getCodigo());
                    ex.setExameJalis(exAntigo.getExameJalis());
                    ex.setMaterialJalis(exAntigo.getMaterialJalis());
                    if (!(!Funcoes.textoVazio(ex.getCodigoMaterial()) && Funcoes.isNumeric(ex.getCodigoMaterial()) || Funcoes.textoVazio(exAntigo.getCodigoMaterial()))) {
                        ex.setCodigoMaterial(exAntigo.getCodigoMaterial());
                    }
                    if (Funcoes.textoVazio(ex.getDescricaoMaterial()) && !Funcoes.textoVazio(exAntigo.getDescricaoMaterial())) {
                        ex.setDescricaoMaterial(exAntigo.getDescricaoMaterial());
                    }
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), ex.getXml().replace("'", ""));
                }
                Conexao.arquivaSQL();
                return examesAtualizados;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoRedeWS: 43");
        }
        return exames;
    }

    private static void inserirExamesRedeWS(List<ExameRedeWS> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SalvaDadosException, SQLException {
        for (ExameRedeWS ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ep.getCodigo()) || Funcoes.textoVazio(ep.getCodigoMaterial())) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 13, ep.getCodigo(), ep.getCodigoMaterial(), ep.getDescricao(), StringUtil.textoDB(ep.getDescricaoMaterial() != null ? ep.getDescricaoMaterial() : ""), ep.getXml().replace("'", ""));
        }
    }

    private static List<ExameRedeWS> loadExamesRedeWS(File file, int codigoLabExterno) throws Exception {
        String[] linhas;
        ArrayList<ExameRedeWS> examesList = new ArrayList<ExameRedeWS>();
        String dados = null;
        if (file.getAbsolutePath().contains(".csv")) {
            dados = StringUtil.lerArquivoTexto(file);
        }
        if ((linhas = dados.split("\n")).length > 0) {
            String[] cabec = linhas[0].replaceAll("[\"]", "").split(";");
            if (ParserImportacaoRedeWS.validaTamanhoLinha(cabec, 17)) {
                if (!(cabec[0].equalsIgnoreCase("Recipientes") || cabec[1].equalsIgnoreCase("Mnenomico") || cabec[2].equalsIgnoreCase("Procedimento") || cabec[3].equalsIgnoreCase("Material") || cabec[4].equalsIgnoreCase("Status") || cabec[5].equalsIgnoreCase("Versao") || cabec[6].equalsIgnoreCase("Data") || cabec[7].equalsIgnoreCase("Hora") || cabec[8].equalsIgnoreCase("Padrao") || cabec[9].equalsIgnoreCase("Prazo") || cabec[10].equalsIgnoreCase("M\u00e1scara Descri\u00e7\u00e3o") || cabec[11].equalsIgnoreCase("Par\u00e2metro - Apelido") || cabec[12].equalsIgnoreCase("Par\u00e2metro - Descri\u00e7\u00e3o") || cabec[13].equalsIgnoreCase("Par\u00e2metro - Apelido exportacao") || cabec[14].equalsIgnoreCase("Processo - Apelido") || cabec[15].equalsIgnoreCase("Processo - Descri\u00e7\u00e3o") || cabec[16].equalsIgnoreCase("Processo - M\u00e9todo") || cabec[17].equalsIgnoreCase("Processo - Unidade de medida"))) {
                    return examesList;
                }
            } else {
                return examesList;
            }
        }
        String[] cabecalho = linhas[0].split(";");
        ExameRedeWS exameRedeWS = new ExameRedeWS();
        LinhaResultadoRedeWS resultado = new LinhaResultadoRedeWS();
        for (int i = 1; i < linhas.length; ++i) {
            String[] linha = linhas[i].split(";");
            if (!ParserImportacaoRedeWS.validaTamanhoLinha(linha, 17)) continue;
            int index = examesList.size();
            Optional<ExameRedeWS> achado = examesList.stream().filter(a -> linha[CODIGO_EXAME] != "" && a.getCodigo().equals(linha[CODIGO_EXAME])).findAny();
            if (!achado.isPresent()) {
                exameRedeWS = new ExameRedeWS();
                resultado = new LinhaResultadoRedeWS();
                exameRedeWS.setCodigo(linha[CODIGO_EXAME]);
                exameRedeWS.setDescricao(linha[PROCEDIMENTO]);
                exameRedeWS.setDescricaoMaterial(linha[MATERIAL]);
                exameRedeWS.setCodigoMaterial("0");
                exameRedeWS.setLaboratorioExterno(codigoLabExterno);
                exameRedeWS.setRecipiente(linha[RECIPIENTE]);
                exameRedeWS.setVersao(Integer.valueOf(linha[VERSAO]));
                exameRedeWS.setData(linha[DATA]);
                resultado.setData(linha[DATA]);
                resultado.setHora(linha[HORA]);
                exameRedeWS.getLinhasResultado().add(resultado);
            }
            CamposRedeWS campo = new CamposRedeWS();
            campo.setApelido(linha[PARAM_APELIDO_EXPOR]);
            campo.setDescricaoApelido(linha[PROC_APELIDO]);
            resultado.getCampos().add(campo);
            if (!achado.isPresent()) {
                exameRedeWS.preencheXML();
            } else {
                exameRedeWS.preencheCampoResultado();
            }
            if (achado.isPresent()) continue;
            examesList.add(index, exameRedeWS);
        }
        return examesList;
    }

    public static Registro getExame(String xml, String exameJalis, String materialJalis) {
        Registro exame = new Registro();
        if (!Funcoes.textoVazio(exameJalis) && !Funcoes.textoVazio(materialJalis)) {
            exame.setValor(TAG_EXAME_JALIS, exameJalis);
            exame.setValor(TAG_MATERIAL_JALIS, materialJalis);
        }
        String xmlExame = StringUtil.getValor(xml, TAG_EXAME);
        exame.setValor("codigo", StringUtil.getValor(xmlExame, "codigo"));
        exame.setValor("descricao", StringUtil.getValor(xmlExame, "descricao"));
        exame.setValor(TAG_EXAME_DESC_MATERIAL, StringUtil.getValor(xmlExame, TAG_EXAME_DESC_MATERIAL));
        exame.setValor(TAG_EXAME_RECIPIENTE, StringUtil.getValor(xmlExame, TAG_EXAME_RECIPIENTE));
        exame.setValor(TAG_EXAME_VERSAO, StringUtil.getValor(xmlExame, TAG_EXAME_VERSAO));
        exame.setValor("data", StringUtil.getValor(xmlExame, "data"));
        exame.setValor("data", StringUtil.getValor(xmlExame, "data"));
        exame.setValor(TAG_RESULTADO_DESC_DATA, StringUtil.getValor(xmlExame, TAG_RESULTADO_DESC_DATA));
        exame.setValor(TAG_RESULTADO_HORA, StringUtil.getValor(xmlExame, TAG_RESULTADO_HORA));
        exame.setValor(TAG_RESULTADO_DESC_HORA, StringUtil.getValor(xmlExame, TAG_RESULTADO_DESC_HORA));
        exame.setValor(TAG_RESULTADO_RESPONSAVEL, StringUtil.getValor(xmlExame, TAG_RESULTADO_RESPONSAVEL));
        exame.setValor(TAG_RESULTADO_DESC_RESPONSAVEL, StringUtil.getValor(xmlExame, TAG_RESULTADO_DESC_RESPONSAVEL));
        exame.setValor(TAG_RESULTADO_APELIDO, StringUtil.getValor(xmlExame, TAG_RESULTADO_APELIDO));
        exame.setValor(TAG_RESULTADO_DESC_APELIDO, StringUtil.getValor(xmlExame, TAG_RESULTADO_DESC_APELIDO));
        List<String> campos = StringUtil.getListValores(xmlExame, TAG_RESULTADO_CAMPO);
        ArrayList<Registro> camp = new ArrayList<Registro>();
        for (String campo : campos) {
            Registro r = new Registro();
            r.setValor("codigo", StringUtil.getValor(campo, "codigo"));
            r.setValor("descricao", StringUtil.getValor(campo, "descricao"));
            camp.add(r);
        }
        exame.setValor(TAG_RESULTADO_CAMPOS, camp);
        return exame;
    }

    private static Map<String, ExameRedeWS> examesMap(Collection<ExameRedeWS> exames) {
        HashMap<String, ExameRedeWS> examesMap = new HashMap<String, ExameRedeWS>();
        for (ExameRedeWS ex : exames) {
            examesMap.put(ex.getCodigo(), ex);
        }
        return examesMap;
    }

    private static Set<ExameRedeWS> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameRedeWS.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameRedeWS>();
    }

    private static boolean validaTamanhoLinha(String[] linha, int i) {
        return linha.length >= i;
    }
}

