/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.rede.ws.dto.RespostaRedeWSExame;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.model.vo.triagem.LoteExternoVO;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImportacaoResultadoRedeWSDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requisicaoValida(String codFilial, String codRequisicao) {
        StringBuilder sql = new StringBuilder(" select req_codigo from requisicao ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and req_excluida is not null and req_excluida = false ");
        Statement st = ConexaoTemporaria.getStatement();
        boolean valida = false;
        try {
            ResultSet resultado = st.executeQuery(sql.toString());
            if (resultado.next()) {
                valida = true;
            }
        }
        catch (SQLException e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return valida;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loteValido(String codLote, String codLabExterno) {
        StringBuilder sql = new StringBuilder(" select lex_codigo from loteexterno ");
        sql.append(" where lex_codigo = ").append(codLote);
        sql.append(" and lae_codigo = ").append(codLabExterno);
        sql.append(" and lex_dataestorno is null ");
        Statement st = ConexaoTemporaria.getStatement();
        boolean valido = false;
        try {
            ResultSet resultado = st.executeQuery(sql.toString());
            if (resultado.next()) {
                valido = true;
            }
        }
        catch (SQLException e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return valido;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoteExternoRequisicaoVO> pesquisarRequisicoesPorLote(String codigoLote, int codigoLabExterno) {
        StringBuilder sql = new StringBuilder(" select fil_codigo, lex_codigo, req_codigo ");
        sql.append(" from loteexternorequisicao ");
        sql.append(" where lex_codigo = ").append(codigoLote);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        Statement st = ConexaoTemporaria.getStatement();
        ArrayList<LoteExternoRequisicaoVO> requisicoesPorLote = new ArrayList<LoteExternoRequisicaoVO>();
        try {
            ResultSet resultado = st.executeQuery(sql.toString());
            while (resultado.next()) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(resultado.getInt("fil_codigo"));
                LoteExternoVO loteExterno = new LoteExternoVO();
                loteExterno.setCodigo(resultado.getInt("lex_codigo"));
                RequisicaoVO requisicao = new RequisicaoVO();
                requisicao.setCodigo(resultado.getInt("req_codigo"));
                LoteExternoRequisicaoVO vo = new LoteExternoRequisicaoVO();
                vo.setFilialVO(filial);
                vo.setLoteExternoVO(loteExterno);
                vo.setRequisicaoVO(requisicao);
                requisicoesPorLote.add(vo);
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return requisicoesPorLote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro localizarExameRequisicao(String codFilial, String codRequisicao, RespostaRedeWSExame exameRede) {
        StringBuilder sql = new StringBuilder(" select ");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, ");
        sql.append("  b.exa_codigo,b.exr_resposta, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, ");
        sql.append("  a.req_idade, a.req_anomes, b.exr_datamaterial, ");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, null as exameFilho, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, ");
        sql.append("  a.req_guia, b.exr_codautorizacao, b.exr_solicitadotiss ");
        sql.append("from requisicao a ");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo ");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo ");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo ");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo ");
        sql.append("where ");
        sql.append("  a.fil_codigo = ").append(codFilial).append(" and ");
        sql.append("  a.req_codigo = ").append(codRequisicao).append(" and ");
        sql.append("  a.req_excluida = false and b.exr_excluido = false ");
        sql.append(" and b.exa_codigo = '").append(exameRede.getExaCodigo()).append("'");
        sql.append(" and b.mco_codigo = ").append(exameRede.getMcoCodigo());
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet res = ConexaoTemporaria.executeQuery(st, sql.toString());
            Registro reg = null;
            if (res.next()) {
                reg = new Registro(res);
                reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(codFilial, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(codFilial, reg.getString("codigo-layout")));
                Registro formatacao = new Registro();
                formatacao.setValor("formato", reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor("formatacao", formatacao);
                exameRede.setExaCodigo(res.getString("exa_codigo"));
                exameRede.setMcoCodigo(res.getString("mco_codigo"));
                Registro registro = reg;
                return registro;
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscarDadosExameAssociado(String codFilial, String codRequisicao, RespostaRedeWSExame exameRede) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.exa_codigo as examepai, ");
        sql.append(" e.exa_kodigo as examefilho, ");
        sql.append(" a.mco_codigo, ");
        sql.append(" p.ele_xmllabexterno ");
        sql.append(" \t\tFROM examerequisicao a ");
        sql.append(" \t\t\tJOIN examematcoletalabextdesm e ON a.fil_codigo = e.fil_codigo ");
        sql.append(" \t\t\t\tAND a.exa_codigo = e.exa_codigo ");
        sql.append(" \t\t\t\tAND a.mco_codigo = e.mco_codigo ");
        sql.append(" \t\t\tJOIN examematcoletalabexterno p ON e.fil_codigo = p.fil_codigo ");
        sql.append(" \t\t\t\tAND e.exa_kodigo = p.exa_codigo ");
        sql.append(" \t\t\t\tAND e.mco_codigo = p.mco_codigo ");
        sql.append(" \t\t\t\tAND e.lae_codigo = p.lae_codigo ");
        sql.append(" WHERE a.fil_codigo = ").append(codFilial);
        sql.append(" \t\tAND a.req_codigo = ").append(codRequisicao);
        sql.append("    AND upper(p.ele_xmllabexterno) ilike '%<").append("codigo").append(">").append(exameRede.getCodigoApoio().toUpperCase()).append("</").append("codigo").append(">%'");
        sql.append(" \t\tAND p.ele_xmllabexterno is not null and p.ele_xmllabexterno <> '' ");
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet resultSet = ConexaoTemporaria.executeQuery(st, sql);
            if (resultSet.next()) {
                exameRede.setExaCodigo(resultSet.getString("examefilho"));
                exameRede.setMcoCodigo(resultSet.getString("mco_codigo"));
                exameRede.setXmlLabExterno(resultSet.getString("ele_xmllabexterno"));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExameDesmembrado> pesquisarExamesDesmembrados(String codFilial, String codRequisicao, String codLabExterno, String exameFilho, String mcoFilho) {
        ArrayList<ExameDesmembrado> exameDesmembrado = new ArrayList<ExameDesmembrado>();
        Statement st = ConexaoTemporaria.getStatement();
        try {
            if (st != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("       ,p.ele_xmllabexterno ");
                buf.append("   from examerequisicao a ");
                buf.append("   join examematcoletalabextdesm e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("   join examematcoletalabexterno p on e.fil_codigo = p.fil_codigo and e.exa_kodigo = p.exa_codigo and e.mco_kodigo = p.mco_codigo and e.lae_codigo = p.lae_codigo ");
                buf.append("  where a.fil_codigo = ").append(codFilial);
                buf.append("    and a.req_codigo  = ").append(codRequisicao);
                buf.append("    and e.exa_kodigo = '").append(exameFilho).append("' ");
                buf.append("    and e.mco_kodigo = ").append(mcoFilho);
                buf.append("    and e.lae_codigo = ").append(codLabExterno);
                ResultSet res = ConexaoTemporaria.executeQuery(st, buf.toString());
                while (res.next()) {
                    ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"));
                    ex.addFilho(new Exame(exameFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                    exameDesmembrado.add(ex);
                }
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return exameDesmembrado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exameRelacionado(Registro reg, int codigoLabExterno) {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = ConexaoTemporaria.getStatement();
            try {
                ResultSet rs = st.executeQuery(sql.toString());
                if (rs.next() && rs.getInt("lae_codigo") == codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo");
                    mco = StringUtil.getValor(xml, "desc_material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select red_xml from examesrede where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(codigoLabExterno);
                    sqlBuilder.append(" and red_codexame = '").append(exa).append("' and red_descricaomaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("red_xml", rs.getString("red_xml"));
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception e) {
                this.anularSQL();
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro pesquisarDadosConferenciaAutomatica(int codigoLabExterno) {
        Statement st = ConexaoTemporaria.getStatement();
        StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and lae_codigo = ").append(codigoLabExterno);
        Registro reg = new Registro();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                reg.setValor("conferirAutomatico", rs.getBoolean("lae_conferirautomatico"));
                String codUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
                reg.setValor("codigoUsuarioConferenciaAutomatica", codUsuarioConferenciaAutomatica);
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return reg;
    }

    private void anularSQL() {
        try {
            ConexaoTemporaria.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscaPermissaoDeEnvioEmail(String filial) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, "select fil_enviaremail from filiais_postocoleta where fil_codigo = " + filial);
            if (rs.next()) {
                retorno = rs.getBoolean("fil_enviaremail");
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscaPermissaoDeEnvioPush(String filial) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, "select fil_enviarpushapp from filiais_postocoleta where fil_codigo = " + filial);
            if (rs.next()) {
                retorno = rs.getBoolean("fil_enviarpushapp");
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscaPermissaoDeEnvioWhatsapp(String filial) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, "select fil_enviarwhatsapp from filiais_postocoleta where fil_codigo = " + filial);
            if (rs.next()) {
                retorno = rs.getBoolean("fil_enviarwhatsapp");
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buscaPermissaoDeEnvioSms(String filial) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, "select fil_enviarsms from filiais_postocoleta where fil_codigo = " + filial);
            if (rs.next()) {
                retorno = rs.getBoolean("fil_enviarsms");
            }
        }
        catch (Exception e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return retorno;
    }
}

