/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import br.com.shift.www.WSApoioSoapProxy;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.redews.RedeWSCampos;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.rede.ws.ImportacaoResultadoRedeWSDao;
import jalis.laboratorio.util.parsers.rede.ws.InformaPeriodo;
import jalis.laboratorio.util.parsers.rede.ws.ParserImportacaoRedeWS;
import jalis.laboratorio.util.parsers.rede.ws.dto.RespostaRedeWSExame;
import jalis.laboratorio.util.parsers.rede.ws.dto.RespostaRedeWSResultado;
import jalis.laboratorio.util.parsers.rede.ws.dto.RespostaRedeWSResultadoLab;
import jalis.model.vo.triagem.LoteExternoRequisicaoVO;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.StringHolder;

public class ImportacaoResultadoRedeWS
extends AbstractImportadorResultadoLabExterno {
    public static final String FORMATO = "formato";
    public static final String FORMATO_TEXTO = "formatotexto";
    public static final String CODIGO_LAYOUT = "codigo-layout";
    public static final String CABECALHO = "cabecalho";
    public static final String FORMATACAO = "formatacao";
    public static final String CONFERIR_AUTOMATICO = "conferirAutomatico";
    public static final String COD_USUARIO_CONFERENCIA_AUTOMATICA = "codigoUsuarioConferenciaAutomatica";
    private StringHolder pRetornoCliente;
    private StringHolder pDescricaoErro;
    private String idLaboratorio;
    private String senha;
    private List<String> listaFilial = new ArrayList<String>();
    private List<String> listaRequisicao = new ArrayList<String>();
    private HashMap<String, String> requisicoesNotificar = new HashMap();
    private final ImportacaoResultadoRedeWSDao dao;
    private ModeloGridTable modeloRelatorio;
    private JButton buttonImprimir;
    private LaboratorioExterno lab;

    public ImportacaoResultadoRedeWS(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Rede (Webservice)", codigoLabExterno, Protocolo.RedeWS, new JPanel(new FlowLayout(2)));
        this.buttonImportarWS.setEnabled(true);
        this.buttonImportarWS.setVisible(true);
        this.buttonImportar.setVisible(false);
        this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
        this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
        this.getPanelAdicional().add(this.buttonImprimir);
        this.dao = new ImportacaoResultadoRedeWSDao();
        this.lab = LaboratorioExterno.getLabExterno(String.valueOf(codigoLabExterno));
    }

    @Override
    protected void importarResultadoWs() {
        this.idLaboratorio = StringUtil.getValor(this.lab.configuracao, "idLaboratorio");
        this.senha = StringUtil.getValor(this.lab.configuracao, "senha");
        if (this.isWebService) {
            InformaPeriodo informa = InformaPeriodo.novaInstancia(this.getTopLevelAncestor(), this.codigoLabExterno);
            informa.setVisible(true);
            if (informa.isOk()) {
                this.importarResultados(informa);
            }
        }
    }

    private void importarResultados(InformaPeriodo informa) {
        this.setTextoInformacoes("Iniciando a importa\u00e7\u00e3o...", false);
        String dataInicial = "";
        String dataFinal = "";
        String horaInicial = "";
        String horaFinal = "";
        String codPedido = "";
        this.listaFilial = new ArrayList<String>();
        this.listaRequisicao = new ArrayList<String>();
        if (informa.filtroPeriodoSelecionado()) {
            dataInicial = Funcoes.formataData("yyyy-MM-dd", informa.getDataInicial());
            dataFinal = Funcoes.formataData("yyyy-MM-dd", informa.getDataFinal());
            horaInicial = !Funcoes.textoVazio(informa.getHoraInicial()) ? informa.getHoraInicial() : "00:00";
            String string = horaFinal = !Funcoes.textoVazio(informa.getHoraFinal()) ? informa.getHoraFinal() : "23:59";
            if (this.retornoValido(dataInicial, dataFinal, horaInicial, horaFinal, codPedido)) {
                this.setTextoInformacoes("\nSolicitando os resultados do Per\u00edodo informado...", false);
                this.processaResultados();
            }
        }
        if (informa.filtroRequisicaoSelecionado() && this.retornoValido(dataInicial, dataFinal, horaInicial, horaFinal, codPedido = Funcoes.preencheZero(informa.getFiltroFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(informa.getFiltroRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()))) {
            this.processaResultados();
        }
        if (informa.filtroLoteSelecionado()) {
            List<LoteExternoRequisicaoVO> requisicoesLote = this.dao.pesquisarRequisicoesPorLote(informa.getFiltroLote(), this.codigoLabExterno);
            for (LoteExternoRequisicaoVO req : requisicoesLote) {
                codPedido = Funcoes.preencheZero(informa.getFiltroFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req.getRequisicaoVO().getCodigo(), ParametrosGerais.getDigitosTuboRequisicao());
                if (!this.retornoValido(dataInicial, dataFinal, horaInicial, horaFinal, codPedido)) continue;
                this.processaResultados();
            }
        }
        if (!this.listaFilial.isEmpty() || !this.listaRequisicao.isEmpty()) {
            this.geraLogSmsEmail();
        }
        this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada!", false);
    }

    private void geraLogSmsEmail() {
        Registro confAutomatica = this.dao.pesquisarDadosConferenciaAutomatica(this.codigoLabExterno);
        boolean conferirAutomatico = confAutomatica.getBoolean(CONFERIR_AUTOMATICO);
        String codigoUsuarioConferenciaAutomatica = confAutomatica.getString(COD_USUARIO_CONFERENCIA_AUTOMATICA);
        for (int i = 0; i < this.listaRequisicao.size(); ++i) {
            try {
                boolean enviaLogSMS = this.dao.buscaPermissaoDeEnvioSms(this.listaFilial.get(i));
                boolean enviaLogEmail = this.dao.buscaPermissaoDeEnvioEmail(this.listaFilial.get(i));
                boolean enviaLogPush = this.dao.buscaPermissaoDeEnvioPush(this.listaFilial.get(i));
                boolean enviaLogWhatsapp = this.dao.buscaPermissaoDeEnvioWhatsapp(this.listaFilial.get(i));
                if (enviaLogSMS && conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(this.listaFilial.get(i), this.listaRequisicao.get(i), Conexao.getStatement())) {
                    SMSUtil.criaLogSmsComDadosRequisicao(this.listaFilial.get(i), this.listaRequisicao.get(i), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
                if (enviaLogEmail && conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(this.listaFilial.get(i), this.listaRequisicao.get(i), Conexao.getStatement())) {
                    EmailUtil.criaLogEmail(this.listaFilial.get(i), this.listaRequisicao.get(i), null, EmailUtil.TipoEmail.RESULTADO, true, Conexao.getStatement());
                }
                if (enviaLogPush && conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(this.listaFilial.get(i), this.listaRequisicao.get(i), Conexao.getStatement())) {
                    PushUtil.criaLogPushComDadosRequisicao(this.listaFilial.get(i), this.listaRequisicao.get(i), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                }
                if (!enviaLogWhatsapp || !conferirAutomatico || Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(this.listaFilial.get(i), this.listaRequisicao.get(i), Conexao.getStatement())) continue;
                WhatsAppUtil.criaLogWhatsappComDadosRequisicao(this.listaFilial.get(i), this.listaRequisicao.get(i), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean retornoValido(String dataInicial, String dataFinal, String horaInicial, String horaFinal, String codigoPedido) {
        this.pRetornoCliente = new StringHolder();
        this.pDescricaoErro = new StringHolder();
        WSApoioSoapProxy proxy = new WSApoioSoapProxy();
        try {
            proxy.exportaResultados(this.idLaboratorio, this.senha, dataInicial, dataFinal, horaInicial, horaFinal, codigoPedido, "", new BooleanHolder(), this.pRetornoCliente, this.pDescricaoErro);
        }
        catch (Exception e) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel obter a comunica\u00e7\u00e3o com Webservice Lab. Rede. (Verifique sua conex\u00e3o com a internet)", false);
            return false;
        }
        if (!Funcoes.textoVazio(this.pDescricaoErro.value)) {
            this.setTextoInformacoes("\nMensagem do Lab. Rede: ".concat(this.pDescricaoErro.value), false);
            return false;
        }
        if (Funcoes.textoVazio(this.pRetornoCliente.value)) {
            this.setTextoInformacoes("\nAinda n\u00e3o h\u00e1 resultados de exames prontos para o Per\u00edodo informado!", false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaResultados() {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            this.processarRetorno(st, st2);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRedeWS: 286");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
    }

    private void processarRetorno(Statement st, Statement st2) throws Exception {
        List<RespostaRedeWSResultadoLab> resultadosRede = this.converterResultadosLabParaResultadosRede();
        for (RespostaRedeWSResultadoLab resultadoRede : resultadosRede) {
            this.setTextoInformacoes(String.format("\nSolicitando resultados da Requisi\u00e7\u00e3o %s", resultadoRede.getOrdemServico()), false);
            int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
            if (resultadoRede.getOrdemServico().length() < qtdeDigitos || resultadoRede.getOrdemServico().length() > qtdeDigitos) {
                this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada: " + resultadoRede.getOrdemServico(), false);
                continue;
            }
            String codigoForaPadrao = resultadoRede.getOrdemServico().substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String codFilial = StringUtil.removeZerosEsquerda(resultadoRede.getOrdemServico().substring(0, ParametrosGerais.getDigitosTuboFilial()));
            String codRequisicao = StringUtil.removeZerosEsquerda(codigoForaPadrao);
            for (RespostaRedeWSExame exameRede : resultadoRede.getExames()) {
                LinkedList<Registro> listaRegistros = this.processarPaiFilhos(resultadoRede, exameRede);
                for (Registro registroExame : listaRegistros) {
                    Date horaColeta;
                    boolean salvoParcial;
                    Registro formatacao;
                    if (registroExame == null) continue;
                    if (this.exameLancado(registroExame)) {
                        this.setTextoInformacoes(this.construirMensagemPadraoComStatus(AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao), false);
                        this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO);
                        continue;
                    }
                    if (!this.exameColetado(registroExame) && registroExame != null && !registroExame.getString("exr_situacao").equals("P")) {
                        this.setTextoInformacoes(this.construirMensagemPadraoComStatus(String.format("Material %s n\u00e3o localizado na Requisi\u00e7\u00e3o", registroExame.getString("mco_codigo"))), false);
                        this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL);
                        continue;
                    }
                    if (!this.dao.exameRelacionado(registroExame, this.codigoLabExterno)) {
                        this.setTextoInformacoes(this.construirMensagemPadraoComStatus("Exame sem relacionamento"), false);
                        this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO);
                        continue;
                    }
                    if (registroExame.getValor("examePai") != null) {
                        registroExame.setValor("exa_codigo", registroExame.getString("examePai"));
                    }
                    Registro registro = formatacao = (salvoParcial = registroExame.getString("exr_situacao").equals("P")) ? (Registro)registroExame.getValor(FORMATACAO) : this.localizarFormatacao(registroExame);
                    if (formatacao == null || Funcoes.textoVazio(formatacao.getString(FORMATO))) {
                        this.setTextoInformacoes(this.construirMensagemPadraoComStatus("Laudo n\u00e3o encontrado"), false);
                        continue;
                    }
                    this.setTextoInformacoes(this.construirMensagemPadraoImportacao(registroExame.getString("exa_codigo"), registroExame.getString("req_codigo")), false);
                    Registro exameSalvo = ParserImportacaoRedeWS.getExame(registroExame.getString("ele_xmllabexterno"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"));
                    Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), registroExame.getString("fil_codigo"), false, false);
                    dados.put("codigo", exameSalvo.getString("codigo"));
                    dados.put("descricao", exameSalvo.getString("descricao"));
                    String resultadoAtual = "";
                    for (RespostaRedeWSResultado resultado : exameRede.getResultados()) {
                        String exaJalis = registroExame.getString("examePai");
                        if (Funcoes.textoVazio(exaJalis)) {
                            resultadoAtual = this.gerarResultadoAtual(exameRede, registroExame, resultado, dados, false, resultadoAtual);
                            continue;
                        }
                        for (RespostaRedeWSExame respExame : resultadoRede.getExames()) {
                            for (RespostaRedeWSResultado respResultado : respExame.getResultados()) {
                                resultadoAtual = this.gerarResultadoAtual(respExame, registroExame, respResultado, dados, true, resultadoAtual);
                            }
                        }
                    }
                    Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("pac_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), registroExame.getString("met_codigo"));
                    dados.putAll(RecepcaoUtil.preencheHashDados(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo")));
                    Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(registroExame.getString("exa_codigo"), registroExame.getString("fil_codigo"));
                    if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                        historicos = ExameUtil.getHistoricos(null, registroExame.getString("fil_codigo"));
                    }
                    Map<String, Object> resposta = Resultado.getCamposResultado(registroExame.getString("exr_resposta"));
                    Resultado res = new Resultado(null, formatacao.getString(FORMATO), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual);
                    res.atualizarComponentes();
                    if (!res.verificarCondicao()) {
                        this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
                        this.setTextoInformacoes(this.construirMensagemPadraoComStatus("O resultado n\u00e3o ser\u00e1 CONFERIDO por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame!"), false);
                        continue;
                    }
                    boolean completo = true;
                    if (registroExame.getBoolean("exa_salvaparcial")) {
                        completo = res.resultadoCompleto(true);
                    }
                    String novaSituacao = completo ? "L" : "P";
                    String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                    Util.gravaAlteracaoExameRequisicao(st, registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"));
                    boolean marcarConferido = false;
                    Registro confAutomatica = this.dao.pesquisarDadosConferenciaAutomatica(this.codigoLabExterno);
                    boolean conferirAutomatico = confAutomatica.getBoolean(CONFERIR_AUTOMATICO);
                    String codigoUsuarioConferenciaAutomatica = confAutomatica.getString(COD_USUARIO_CONFERENCIA_AUTOMATICA);
                    if (conferirAutomatico && codigoUsuarioConferenciaAutomatica != null && completo) {
                        int verificacao = res.verificarValidacao();
                        boolean bl = marcarConferido = verificacao == 1;
                        if (!marcarConferido && verificacao != 2) {
                            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA);
                            this.setTextoInformacoes(this.construirMensagemPadraoComStatus("O resultado n\u00e3o ser\u00e1 CONFERIDO por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame!"), false);
                        }
                    }
                    if (!this.existeRequisicaoLabExterno(registroExame.getInt("fil_codigo"), this.codigoLabExterno, registroExame.getInt("req_codigo"), resultadoRede.getOrdemServicoApoio())) {
                        this.inserirDadosRequisicao(st, this.codigoLabExterno, resultadoRede.getOrdemServicoApoio(), registroExame.getString("fil_codigo"), registroExame.getInt("req_codigo"));
                    }
                    boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                    boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                    this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), registroExame, registroExame, marcarConferido, codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                    if (this.exportarBaseWeb(registroExame.getString("fil_codigo"))) {
                        Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), resultado, false);
                        this.exportarParaWeb(st, this.getCodigoBaseWeb(registroExame.getString("fil_codigo")), novaSituacao, registroExame, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                        if (ExportaWeb.isGerarPdfResultado(st2, registroExame.getString("fil_codigo"))) {
                            ExportaWeb.enviarResultadoPDF(st2, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), this.getCodigoBaseWeb(registroExame.getString("fil_codigo")));
                        }
                    }
                    this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE);
                    Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                    Date date = horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registroExame.getDate("exr_datamaterial") : new Date();
                    if (completo) {
                        this.atualizarTabelaExamesControle(st, registroExame, res.getResultadoAnterior(dataColeta, horaColeta));
                    }
                    ExportaWeb.atualizaPaginaOrdemExameWeb(st, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), Variaveis.codigoBaseWeb);
                    this.editarRequisicaoExportaFiliais(registroExame);
                    DBUtil.setExameSituacaoInterfaceamento(st, registroExame.getString("fil_codigo"), registroExame.getString("req_codigo"), registroExame.getString("exa_codigo"), registroExame.getString("mco_codigo"), 8);
                    String exameImportado = registroExame.getString("exa_codigo");
                    if (!Funcoes.textoVazio(registroExame.getString("exameFilho"))) {
                        String codExame = StringUtil.getValor(registroExame.getString("ele_xmllabexterno"), "cd_db");
                        exameImportado = exameImportado + "(" + codExame + ")";
                    }
                    this.setTextoInformacoes(this.construirMensagemPadraoComStatus(completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO.descricao : AbstractImportadorResultadoLabExterno.Situacao.LANCADO.descricao) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE.descricao), false);
                    this.requisicoesNotificar.put(Funcoes.getChaveFilReq(registroExame.getString("fil_codigo"), registroExame.getString("req_codigo")), registroExame.getString("req_codigo"));
                }
            }
        }
    }

    private String construirMensagemPadraoComStatus(String mensagemStatus) {
        return String.format(" - %s", mensagemStatus);
    }

    private String construirMensagemPadraoImportacao(String codExame, String codRequisicao) {
        return String.format("\nImportando %s da Requisi\u00e7\u00e3o %s", codExame, codRequisicao);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAtitude 784");
        }
    }

    private String gerarResultadoAtual(RespostaRedeWSExame exameRede, Registro registroExame, RespostaRedeWSResultado resultado, Map<String, Object> dados, boolean isDesmembrado, String resultadoAtual) {
        String valorResultado = resultado.getValor();
        String apelido = resultado.getApelido();
        dados.put(resultado.getApelido(), valorResultado);
        String dataLiberacao = isDesmembrado ? this.padronizarCampoDesmembrado(RedeWSCampos.LIBERACAO_DATA.getTag(), exameRede) : RedeWSCampos.LIBERACAO_DATA.getTag();
        dados.put(dataLiberacao, exameRede.getLiberacaoData());
        String horaLiberacao = isDesmembrado ? this.padronizarCampoDesmembrado(RedeWSCampos.LIBERACAO_HORA.getTag(), exameRede) : RedeWSCampos.LIBERACAO_HORA.getTag();
        dados.put(horaLiberacao, exameRede.getLiberacaoHora());
        String responsavelLiberacao = isDesmembrado ? this.padronizarCampoDesmembrado(RedeWSCampos.LIBERACAO_NOME_RESPONSAVEL.getTag(), exameRede) : RedeWSCampos.LIBERACAO_NOME_RESPONSAVEL.getTag();
        dados.put(responsavelLiberacao, exameRede.getLiberacaoNomeResponsavel());
        String metodologia = this.padronizarCampo(RedeWSCampos.RESULTADO_METODOLOGIA.getTag(), apelido);
        metodologia = isDesmembrado ? this.padronizarCampoDesmembrado(metodologia, exameRede) : metodologia;
        dados.put(metodologia, resultado.getMetodologia());
        String unidadeMedida = this.padronizarCampo(RedeWSCampos.RESULTADO_UNIDADE_MEDIDA.getTag(), apelido);
        unidadeMedida = isDesmembrado ? this.padronizarCampoDesmembrado(unidadeMedida, exameRede) : unidadeMedida;
        dados.put(unidadeMedida, resultado.getUnidadeMedida());
        String valorReferencia = this.padronizarCampo(RedeWSCampos.RESULTADO_VALOR_REFERENCIA.getTag(), apelido);
        valorReferencia = isDesmembrado ? this.padronizarCampoDesmembrado(valorReferencia, exameRede) : valorReferencia;
        dados.put(valorReferencia, resultado.getValorReferencia());
        if (!Funcoes.textoVazio(resultado.getCulturaPositiva())) {
            String culturaPositiva = this.padronizarCampo(RedeWSCampos.RESULTADO_CULTURA_POSITIVA.getTag(), apelido);
            culturaPositiva = isDesmembrado ? this.padronizarCampoDesmembrado(culturaPositiva, exameRede) : culturaPositiva;
            dados.put(culturaPositiva, resultado.getCulturaPositiva());
        }
        if (!Funcoes.textoVazio(resultado.getTsaRealizado())) {
            String tsaRealizado = this.padronizarCampo(RedeWSCampos.RESULTADO_TSA_REALIZADO.getTag(), apelido);
            tsaRealizado = isDesmembrado ? this.padronizarCampoDesmembrado(tsaRealizado, exameRede) : tsaRealizado;
            dados.put(tsaRealizado, resultado.getTsaRealizado());
        }
        if (!Funcoes.textoVazio(resultado.getNotaLaudo())) {
            String notaLaudo = this.padronizarCampo(RedeWSCampos.RESULTADO_NOTA_LAUDO.getTag(), apelido);
            notaLaudo = isDesmembrado ? this.padronizarCampoDesmembrado(notaLaudo, exameRede) : notaLaudo;
            dados.put(notaLaudo, resultado.getNotaLaudo());
        }
        resultadoAtual = this.getXmlResultadoAtual(exameRede, resultadoAtual, valorResultado, isDesmembrado);
        this.adicionaValorExameDesmemmbrado(dados, resultado, exameRede, isDesmembrado);
        return resultadoAtual;
    }

    private void adicionaValorExameDesmemmbrado(Map<String, Object> dados, RespostaRedeWSResultado resultado, RespostaRedeWSExame exameRede, boolean isDesmembrado) {
        if (isDesmembrado) {
            String chaveResultado = this.padronizarCampoDesmembrado(resultado.getApelido(), exameRede);
            dados.put(chaveResultado, resultado.getValor());
        }
    }

    private String padronizarCampo(String campo, String apelido) {
        return String.format("%s_%s", campo, apelido);
    }

    private String padronizarCampoDesmembrado(String campo, RespostaRedeWSExame exameRede) {
        return campo.concat("@").concat(exameRede.getExaCodigo()).concat("#").concat(exameRede.getMcoCodigo());
    }

    private String getXmlResultadoAtual(RespostaRedeWSExame exameRede, String resultadoAtual, String linhaResultado, boolean isDesmembrado) {
        String tag = exameRede.getExaCodigo();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linhaResultado;
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao")) || reg.getString("exr_situacao").equals("P");
    }

    private List<RespostaRedeWSResultadoLab> converterResultadosLabParaResultadosRede() {
        ArrayList<RespostaRedeWSResultadoLab> resultadosLabRede = new ArrayList<RespostaRedeWSResultadoLab>();
        List<String> resultadosLabRetorno = StringUtil.getListValores(this.pRetornoCliente.value, RedeWSCampos.RESULTADO_LAB.getTag());
        for (String resultado : resultadosLabRetorno) {
            RespostaRedeWSResultadoLab resultadoLabRede = new RespostaRedeWSResultadoLab();
            resultadoLabRede.setOrdemServico(StringUtil.getValor(resultado, RedeWSCampos.ORDEM_SERVICO.getTag()));
            resultadoLabRede.setOrdemServicoApoio(StringUtil.getValor(resultado, RedeWSCampos.ORDEM_SERVICO_APOIO.getTag()));
            resultadoLabRede.setExames(this.converterExamesRetornoParaExamesRede(resultado));
            resultadosLabRede.add(resultadoLabRede);
        }
        return resultadosLabRede;
    }

    private List<RespostaRedeWSExame> converterExamesRetornoParaExamesRede(String resultadoRede) {
        ArrayList<RespostaRedeWSExame> exames = new ArrayList<RespostaRedeWSExame>();
        List<String> examesRetorno = StringUtil.getListValores(resultadoRede, RedeWSCampos.EXAME.getTag());
        for (String exameResultado : examesRetorno) {
            RespostaRedeWSExame exameRede = new RespostaRedeWSExame();
            exameRede.setCodigoApoio(StringUtil.getValor(exameResultado, RedeWSCampos.EXA_CODIGO_APOIO.getTag()));
            exameRede.setCodigoLISOrigem(StringUtil.getValor(exameResultado, RedeWSCampos.EXA_CODIGO_LIS_ORIGEM.getTag()));
            exameRede.setDescMaterial(StringUtil.getValor(exameResultado, RedeWSCampos.EXA_DESC_MATERIAL.getTag()));
            exameRede.setDescricao(StringUtil.getValor(exameResultado, RedeWSCampos.EXA_DESCRICAO.getTag()));
            exameRede.setResultados(this.converterResultadosExameParaResultadosRede(exameResultado));
            String liberacao = StringUtil.getValor(exameResultado, RedeWSCampos.LIBERACAO.getTag());
            exameRede.setLiberacaoData(StringUtil.getValor(liberacao, RedeWSCampos.LIBERACAO_DATA.getTag()));
            exameRede.setLiberacaoHora(StringUtil.getValor(liberacao, RedeWSCampos.LIBERACAO_HORA.getTag()));
            exameRede.setLiberacaoNomeResponsavel(StringUtil.getValor(liberacao, RedeWSCampos.LIBERACAO_NOME_RESPONSAVEL.getTag()));
            exames.add(exameRede);
        }
        return exames;
    }

    private List<RespostaRedeWSResultado> converterResultadosExameParaResultadosRede(String exameResultado) {
        ArrayList<RespostaRedeWSResultado> resultados = new ArrayList<RespostaRedeWSResultado>();
        List<String> resultadosExamesRetorno = StringUtil.getListValores(exameResultado, RedeWSCampos.RESULTADO.getTag());
        for (String resultado : resultadosExamesRetorno) {
            RespostaRedeWSResultado resultadoRede = new RespostaRedeWSResultado();
            resultadoRede.setApelido(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_APELIDO.getTag()));
            resultadoRede.setCulturaPositiva(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_CULTURA_POSITIVA.getTag()));
            resultadoRede.setMetodologia(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_METODOLOGIA.getTag()));
            resultadoRede.setNotaLaudo(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_NOTA_LAUDO.getTag()));
            resultadoRede.setTsaRealizado(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_TSA_REALIZADO.getTag()));
            resultadoRede.setUnidadeMedida(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_UNIDADE_MEDIDA.getTag()));
            resultadoRede.setValor(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_VALOR.getTag()));
            resultadoRede.setValorReferencia(StringUtil.getValor(resultado, RedeWSCampos.RESULTADO_VALOR_REFERENCIA.getTag()));
            resultados.add(resultadoRede);
        }
        return resultados;
    }

    private LinkedList<Registro> processarPaiFilhos(RespostaRedeWSResultadoLab resultadoRede, RespostaRedeWSExame exameRede) throws Exception {
        Integer[] integerArray;
        boolean agruparMultiguias;
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        String codFilial = StringUtil.removeZerosEsquerda(resultadoRede.getOrdemServico().substring(0, ParametrosGerais.getDigitosTuboFilial()));
        String codigoForaPadrao = resultadoRede.getOrdemServico().substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String codRequisicao = StringUtil.removeZerosEsquerda(codigoForaPadrao);
        boolean enviaLogSMS = this.dao.buscaPermissaoDeEnvioSms(codFilial);
        boolean enviaLogEmail = this.dao.buscaPermissaoDeEnvioEmail(codFilial);
        Registro confAutomatica = this.dao.pesquisarDadosConferenciaAutomatica(this.codigoLabExterno);
        boolean conferirAutomatico = confAutomatica.getBoolean(CONFERIR_AUTOMATICO);
        Integer[] multiguias = null;
        boolean bl = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.lab.agruparMultiguias;
        if (agruparMultiguias) {
            integerArray = RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true);
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = Integer.parseInt(codRequisicao);
        }
        multiguias = integerArray;
        String codigoUsuarioConferenciaAutomatica = confAutomatica.getString(COD_USUARIO_CONFERENCIA_AUTOMATICA);
        for (Integer multiguia : multiguias) {
            Registro exameSeparado = this.dao.localizarExameRequisicao(codFilial, multiguia.toString(), exameRede);
            if (exameSeparado != null) {
                retorno.add(exameSeparado);
                this.listaFilial.add(codFilial);
                this.listaRequisicao.add(codRequisicao);
            }
            if (!this.dao.buscarDadosExameAssociado(codFilial, multiguia.toString(), exameRede)) continue;
            List<ExameDesmembrado> listaExamesPai = this.dao.pesquisarExamesDesmembrados(codFilial, multiguia.toString(), String.valueOf(this.codigoLabExterno), exameRede.getExaCodigo(), exameRede.getMcoCodigo());
            for (ExameDesmembrado pai : listaExamesPai) {
                String codigoJalisTemp = exameRede.getExaCodigo();
                exameRede.setExaCodigo(pai.getCodigoExame());
                exameRede.setMcoCodigo(String.valueOf(pai.getCodigomaterial()));
                Registro reg = this.dao.localizarExameRequisicao(codFilial, codRequisicao, exameRede);
                if (reg == null) continue;
                reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                reg.setValor("examePai", pai.getCodigoExame());
                reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                exameRede.setExaCodigo(codigoJalisTemp);
                retorno.add(reg);
                this.listaFilial.add(codFilial);
                this.listaRequisicao.add(codRequisicao);
            }
        }
        if (retorno.isEmpty()) {
            this.setTextoInformacoes("Requisi\u00e7\u00e3o n\u00e3o encontrada", false);
            this.adicionarAoModeloRelatorio(codFilial, codRequisicao, exameRede, AbstractImportadorResultadoLabExterno.Situacao.NAO_LOCALIZADO);
        }
        return retorno;
    }

    private void adicionarAoModeloRelatorio(String codFilial, String codRequisicao, RespostaRedeWSExame exameRede, AbstractImportadorResultadoLabExterno.Situacao situacao) {
        String exa = exameRede.getExaCodigo();
        String mco = exameRede.getMcoCodigo();
        if (!Funcoes.textoVazio(exa) && !Funcoes.textoVazio(mco)) {
            String exames = "";
            Statement st = Conexao.getStatement();
            try {
                ExameDesmembrado pai;
                exames = BDUtil.getCodigoExames(codFilial, codRequisicao, st);
                if (!Funcoes.textoVazio(exames) && !exames.contains(exa) && (pai = this.getExamesDesmembrados(codFilial, codRequisicao, String.valueOf(this.codigoLabExterno), exa, mco)) != null) {
                    exa = pai.getCodigoExame();
                    mco = String.valueOf(pai.getCodigomaterial());
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRedeWS (1264)");
            }
        }
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, codFilial, codRequisicao, exa, Integer.parseInt(mco), situacao.descricao);
    }

    @Override
    protected void importarResultado() {
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }
}

