/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.rede.ws.ExameRedeWS;
import jalis.laboratorio.util.parsers.rede.ws.ParserImportacaoRedeWS;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public class ImportacaoRedeWS
extends AbstractImportadorLabExterno {
    private static final String titulo = "Importa\u00e7\u00e3o de Exames";
    private static final String descricao = "Importa\u00e7\u00e3o de exames do Lab. RedeWS";
    private static final String tituloThread = "Thread de Importa\u00e7\u00e3o de Campos de Resultados";

    public ImportacaoRedeWS(int codigoLabExterno) {
        super(titulo, titulo, codigoLabExterno, Protocolo.RedeWS);
        this.getButtonImportar().setText("Importar Exames");
    }

    public ImportacaoRedeWS(String titulo, String descricao, int codigoLabExterno, Protocolo protocolo) {
        super(titulo, titulo, codigoLabExterno, protocolo);
        this.getButtonImportar().setText("Importar Exames");
    }

    @Override
    protected boolean importarArquivo() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo CSV do Lab. RedeWS (*.csv)", "csv"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                bui.append("Importando dados adicionais...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setVisible(true);
                if (!file.getAbsolutePath().contains(".csv")) {
                    bui.append("\nFormato do arquivo incompat\u00edvel com a Integra\u00e7\u00e3o do Lab. Rede via WebService.");
                } else {
                    ArrayList<ExameRedeWS> examesAtualizados = ParserImportacaoRedeWS.importarDadosRedeWS(file, this.codigoLabExterno, this.progress, bui);
                    bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                    this.setTextoInformacoes(bui.toString());
                    Thread.sleep(50L);
                    if (examesAtualizados != null && examesAtualizados.size() > 0) {
                        bui.append("\n\nOs seguintes exames abaixo foram atualizados: \n\n");
                        bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                        bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                        bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                        for (ExameRedeWS e : examesAtualizados) {
                            bui.append("\n\t|").append(StringUtil.formatarColuna(e.getDescricao(), 50, 'c'));
                            bui.append("|").append(StringUtil.formatarColuna(e.getDescricaoMaterial(), 50, 'c')).append("|");
                        }
                        bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                        this.setTextoInformacoes(bui.toString());
                    } else {
                        this.setTextoInformacoes("\nO arquivo n\u00e3o cont\u00eam os dados necess\u00e1rios para importar os dados adicionais, verifica se o arquivo n\u00e3o est\u00e1 vazio!");
                        bui.append("\nVerifique como foi gerado o arquivo com os dados adicionais ou por quem forneceu o arquivo com os dados adicionais.");
                        this.setTextoInformacoes(bui.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoAlvaro: 114");
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
        return false;
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }
}

