/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.rede.ws.CamposRedeWS;
import jalis.laboratorio.util.parsers.rede.ws.LinhaResultadoRedeWS;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExameRedeWS {
    private String codigo;
    private String descricao;
    private String descricaoMaterial;
    private String codigoMaterial;
    private int laboratorioExterno;
    private String exameJalis;
    private String materialJalis;
    private String xml;
    private String recipiente;
    private int versao;
    private String data;
    private ArrayList<LinhaResultadoRedeWS> linhasResultado = new ArrayList();

    public ExameRedeWS() {
    }

    public ExameRedeWS(String xml) {
        this.parseXml(xml);
    }

    public ExameRedeWS(String codigo, String descricao, String descricaoMaterial, String recipiente, int versao, String data) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.descricaoMaterial = descricaoMaterial;
        this.recipiente = recipiente;
        this.versao = versao;
        this.data = data;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getCodigoMaterial() {
        return this.codigoMaterial;
    }

    public ArrayList<LinhaResultadoRedeWS> getLinhasResultado() {
        return this.linhasResultado;
    }

    public void setCodigoMaterial(String codigoMaterial) {
        this.codigoMaterial = codigoMaterial;
    }

    public int getLaboratorioExterno() {
        return this.laboratorioExterno;
    }

    public void setLaboratorioExterno(int laboratorioExterno) {
        this.laboratorioExterno = laboratorioExterno;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public void setDescricaoMaterial(String descricaoMaterial) {
        this.descricaoMaterial = descricaoMaterial;
    }

    public String getRecipiente() {
        return this.recipiente;
    }

    public void setRecipiente(String recipiente) {
        this.recipiente = recipiente;
    }

    public int getVersao() {
        return this.versao;
    }

    public void setVersao(int versao) {
        this.versao = versao;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorRede = StringUtil.getValor(xml, "redews");
        return valorRede != null && valorRede.trim().length() > 0 && (valorExame = StringUtil.getValor(valorRede, "exame")) != null && valorExame.trim().length() > 0;
    }

    public static Set<ExameRedeWS> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameRedeWS> list = new HashSet<ExameRedeWS>();
        if (res.first()) {
            do {
                list.add(new ExameRedeWS(res));
            } while (res.next());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ExameRedeWS> getExames(int filial, int codigoLabExterno) {
        LinkedHashSet<ExameRedeWS> exames = new LinkedHashSet<ExameRedeWS>();
        String sql = "select red_xml from examesrede where fil_codigo = ? and lae_codigo = ? order by red_codexame";
        PreparedStatement prst = Conexao.getPreparedStatement(sql);
        try {
            prst.setInt(1, filial);
            prst.setInt(2, codigoLabExterno);
            try (ResultSet rs = null;){
                rs = prst.executeQuery();
                while (rs.next()) {
                    exames.add(new ExameRedeWS(rs.getString("red_xml")));
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameRede");
        }
        finally {
            try {
                prst.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exames;
    }

    public ExameRedeWS(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.codigo = res.getString("exa_codigo");
        this.codigoMaterial = res.getString("mco_codigo");
        this.laboratorioExterno = res.getInt("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    public String preencheXML() {
        StringBuilder bui = new StringBuilder("<redews>");
        bui.append("<exame>");
        bui.append(StringUtil.getTag("codigo", this.codigo));
        bui.append(StringUtil.getTag("descricao", this.descricao));
        bui.append(StringUtil.getTag("desc_material", this.descricaoMaterial));
        bui.append(StringUtil.getTag("recipiente", this.recipiente));
        bui.append(StringUtil.getTag("versao", String.valueOf(this.versao)));
        bui.append(StringUtil.getTag("data", this.data != null ? this.data.toString() : ""));
        for (LinhaResultadoRedeWS linhaResultadoRedeWS : this.linhasResultado) {
            bui.append("<resultado>");
            bui.append(StringUtil.getTag("data", "data"));
            bui.append(StringUtil.getTag("desc_data", "Data da libera\u00e7\u00e3o do exame"));
            bui.append(StringUtil.getTag("hora", "hora"));
            bui.append(StringUtil.getTag("desc_hora", "Hora da libera\u00e7\u00e3o do exame"));
            bui.append(StringUtil.getTag("responsavel", "nomeResponsavel"));
            bui.append(StringUtil.getTag("desc_responsavel", "Respons\u00e1vel pela libera\u00e7\u00e3o do exame"));
            for (CamposRedeWS campo : linhaResultadoRedeWS.getCampos()) {
                if (campo.getApelido().isEmpty()) continue;
                bui.append("<campos>");
                bui.append(StringUtil.getTag("apelido", campo.getApelido()));
                bui.append(StringUtil.getTag("desc_apelido", campo.getDescricaoApelido()));
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "unidadeMedida"));
                bui.append(StringUtil.getTag("descricao", "Unidade de medida " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "valorReferencia"));
                bui.append(StringUtil.getTag("descricao", "Valor de refer\u00eancia " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "metodologia"));
                bui.append(StringUtil.getTag("descricao", "Metodologia " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "culturaPositiva"));
                bui.append(StringUtil.getTag("descricao", "Cultura positiva " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "tsaRealizado"));
                bui.append(StringUtil.getTag("descricao", "TSA realizado " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "notaLaudo"));
                bui.append(StringUtil.getTag("descricao", "Nota laudo " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("</campos>");
            }
            bui.append("</resultado>");
        }
        bui.append("</exame>");
        bui.append("</redews>").toString();
        this.xml = bui.toString();
        return this.xml;
    }

    public String preencheCampoResultado() {
        StringBuilder bui = new StringBuilder();
        String campos = "";
        this.xml = ExameRedeWS.removeTag(this.xml, "resultado");
        for (LinhaResultadoRedeWS linhaResultadoRedeWS : this.linhasResultado) {
            bui.append(StringUtil.getTag("data", "data"));
            bui.append(StringUtil.getTag("desc_data", "Data da libera\u00e7\u00e3o do exame"));
            bui.append(StringUtil.getTag("hora", "hora"));
            bui.append(StringUtil.getTag("desc_hora", "Hora da libera\u00e7\u00e3o do exame"));
            bui.append(StringUtil.getTag("responsavel", "nomeResponsavel"));
            bui.append(StringUtil.getTag("desc_responsavel", "Respons\u00e1vel pela libera\u00e7\u00e3o do exame"));
            for (CamposRedeWS campo : linhaResultadoRedeWS.getCampos()) {
                if (campo.getApelido().isEmpty()) continue;
                bui.append("<campos>");
                bui.append(StringUtil.getTag("apelido", campo.getApelido()));
                bui.append(StringUtil.getTag("desc_apelido", campo.getDescricaoApelido()));
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "unidadeMedida"));
                bui.append(StringUtil.getTag("descricao", "Unidade de medida " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "valorReferencia"));
                bui.append(StringUtil.getTag("descricao", "Valor de refer\u00eancia " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "metodologia"));
                bui.append(StringUtil.getTag("descricao", "Metodologia " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "culturaPositiva"));
                bui.append(StringUtil.getTag("descricao", "Cultura positiva " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "tsaRealizado"));
                bui.append(StringUtil.getTag("descricao", "TSA realizado " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("<campo>");
                bui.append(StringUtil.getTag("codigo", "notaLaudo"));
                bui.append(StringUtil.getTag("descricao", "Nota laudo " + campo.getDescricaoApelido()));
                bui.append("</campo>");
                bui.append("</campos>");
            }
        }
        this.xml = campos = ExameRedeWS.addValorTag(this.xml, "resultado", bui.toString());
        return this.xml;
    }

    public static String removeTag(String xml, String tag) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, "");
        return sb.toString();
    }

    public static String addValorTag(String xml, String tag, String valor) {
        StringBuilder sb = new StringBuilder(xml);
        StringUtil.setValor(sb, tag, valor);
        return sb.toString();
    }

    private void parseXml(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, "exame");
            this.codigo = StringUtil.getValor(exame, "codigo");
            this.descricao = StringUtil.getValor(exame, "descricao");
            this.descricaoMaterial = StringUtil.getValor(exame, "desc_material");
            this.recipiente = StringUtil.getValor(exame, "recipiente");
            this.versao = StringUtil.getValor(exame, "versao").isEmpty() ? 0 : Integer.valueOf(StringUtil.getValor(exame, "versao"));
            this.data = StringUtil.getValor(exame, "data");
            String[] linhasResultado = StringUtil.getValores(xml, "resultado");
            this.carregarXMLLinhasResultado(linhasResultado);
            this.preencheXML();
        }
    }

    private void carregarXMLLinhasResultado(String[] xml) {
        this.linhasResultado = new ArrayList();
        for (String linha : xml) {
            LinhaResultadoRedeWS l = new LinhaResultadoRedeWS();
            l.setData(StringUtil.getValor(linha, "data"));
            l.setDescricaoData(StringUtil.getValor(linha, "desc_data"));
            l.setDescricaoHora(StringUtil.getValor(linha, "desc_hora"));
            l.setHora(StringUtil.getValor(linha, "hora"));
            l.setResponsavel(StringUtil.getValor(linha, "responsavel"));
            l.setDescricaoResponsavel(StringUtil.getValor(linha, "desc_responsavel"));
            String[] linhasCampos = StringUtil.getValores(linha, "campos");
            this.carregarXMLLinhasCampos(linhasCampos, l);
            this.linhasResultado.add(l);
        }
    }

    private void carregarXMLLinhasCampos(String[] xml, LinhaResultadoRedeWS resultado) {
        ArrayList<CamposRedeWS> campos = new ArrayList<CamposRedeWS>();
        for (String linha : xml) {
            CamposRedeWS l = new CamposRedeWS();
            l.setApelido(StringUtil.getValor(linha, "apelido"));
            l.setDescricaoApelido(StringUtil.getValor(linha, "desc_apelido"));
            campos.add(l);
        }
        resultado.setLinhasCampos(campos);
    }
}

