/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.rede.ExameRede;
import jalis.laboratorio.util.parsers.rede.ws.ExameRedeWS;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorRedeWS
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String OBJ_EXAME_REDE = "objExameRede";
    private static final String RECIPIENTE = "recipiente";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "descricaoMaterial");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0, 120);
    private JTextField textLocalizar = new JTextField();
    private String xmlSelecionado = "";
    private JLabel codigoRecipiente = new JLabel("");
    private JLabel labelCodigoRecipiente = new JLabel("C\u00f3d. Recipiente: ");

    public ConfiguradorRedeWS(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio RedeWS", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorRedeWS(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio RedeWS", codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorRedeWS novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorRedeWS((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorRedeWS((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.getPanelCentral().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.labelCodigoRecipiente, "West");
        panel.add(this.codigoRecipiente);
        this.getPanelCentral().add(panel);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameRede exa = new ExameRede(xml);
            return exa.getCodigo();
        }
        return "";
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            ExameRedeWS exa = new ExameRedeWS(xml);
            return exa.getDescricao();
        }
        return "";
    }

    private void carregarExames() {
        for (ExameRedeWS exame : ExameRedeWS.getExames(Integer.valueOf(Variaveis.filialPadrao), Integer.valueOf(this.getCodigoLabExterno()))) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigo());
            reg.setValor(DESC_EXA, exame.getDescricao());
            reg.setValor(DESC_MAT, exame.getDescricaoMaterial());
            reg.setValor(OBJ_EXAME_REDE, exame);
            reg.setValor(RECIPIENTE, exame.getRecipiente());
            this.modExa.addRegistro(reg);
        }
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorRedeWS.this.tableExa.hasFocus() && (row = ConfiguradorRedeWS.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorRedeWS.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorRedeWS.this.tableExa.scrollRectToVisible(ConfiguradorRedeWS.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorRedeWS.this.tableExa.hasFocus() && (row = ConfiguradorRedeWS.this.tableExa.getSelectedRow()) < ConfiguradorRedeWS.this.tableExa.getRowCount() - 1) {
                    ConfiguradorRedeWS.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorRedeWS.this.tableExa.scrollRectToVisible(ConfiguradorRedeWS.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorRedeWS.this.modExa.filtrar(ConfiguradorRedeWS.DESC_EXA, ConfiguradorRedeWS.this.textLocalizar.getText());
                if (ConfiguradorRedeWS.this.modExa.getRowCount() > 0) {
                    ConfiguradorRedeWS.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.codigoRecipiente.setText((String)reg.getValor(RECIPIENTE));
        }
        ExameRedeWS exa = this.getExameSelecionado();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public boolean acaoOk() {
        ExameRedeWS exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    @Override
    public void setXML(String xml) {
        if (ExameRedeWS.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameRedeWS exa = new ExameRedeWS(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !this.isEqualsExames(exa, (ExameRedeWS)reg.getValor(OBJ_EXAME_REDE))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private boolean isEqualsExames(ExameRedeWS exame1, ExameRedeWS exame2) {
        return exame1.getCodigo().equals(exame2.getCodigo()) && exame1.getDescricaoMaterial().equals(exame2.getDescricaoMaterial()) && exame1.getVersao() == exame2.getVersao() && exame1.getRecipiente().equals(exame2.getRecipiente());
    }

    private boolean atualizarXMLSelecionado() {
        ExameRedeWS exa = this.getExameSelecionado();
        if (exa != null) {
            exa.preencheXML();
            this.xmlSelecionado = exa.getXml();
            return true;
        }
        return false;
    }

    private ExameRedeWS getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameRedeWS)reg.getValor(OBJ_EXAME_REDE);
        }
        return null;
    }
}

