/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede.ws;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloRedeWS
extends AbstractConfiguradorProtocolo {
    private TTextField textCodigo = ComponenteFactory.novoTTextField(30, 3, this);
    protected TTextField textSenha = ComponenteFactory.novoTTextField(30, 3, this);
    protected JTextField textEndWebService = new TTextField(100, 3);
    protected JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    protected JButton buttonConfigurarCabecalhoEtiqueta = ComponenteFactory.novoJButton("Configurar impress\u00e3o de etiquetas", this);
    public static final String TAG_ID_LABORATORIO = "idLaboratorio";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_ENVIAR_UTILIZANDO_WEBSERVICE = "enviarLoteWebservice";
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    public static final String TAG_CONFIGURADOR_CABECALHO_ETIQUETA = "configuradorCabecalho";
    public static final String TAG_ENVIAR_LOTE_PELA_REQUISICAO = "envioAutomatico";
    private String xmlCabecalhoEtiqueta = "";

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloRedeWS((Frame)pai, "Laborat\u00f3rio Rede", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloRedeWS((Dialog)pai, "Laborat\u00f3rio Rede", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloRedeWS(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloRedeWS(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        Dimension dimensionLabels = new Dimension(77, 20);
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", dimensionLabels);
        lblLote.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textLote.setPreferredSize(new Dimension(200, 20));
        this.textLote.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("ID Laborat\u00f3rio:", dimensionLabels);
        lblCodigo.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textCodigo.setPreferredSize(new Dimension(200, 20));
        this.textCodigo.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridwidth = 1;
        JLabel lblChave = ComponenteFactory.novoJLabel("Senha:", dimensionLabels);
        lblChave.setMinimumSize(dimensionLabels);
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textSenha.setPreferredSize(new Dimension(150, 20));
        this.textSenha.setMinimumSize(new Dimension(150, 20));
        this.getPanelCentral().add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        cons.gridwidth = 1;
        JLabel lblService = ComponenteFactory.novoJLabel("Web Services:", dimensionLabels);
        this.getPanelCentral().add((Component)lblService, cons);
        cons.gridx = 1;
        cons.gridwidth = 2;
        this.textEndWebService.setPreferredSize(new Dimension(200, 20));
        this.textEndWebService.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textEndWebService, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        cons.insets.left = 1;
        cons.insets.right = 1;
        cons.gridx = 0;
        cons.gridy = 11;
        cons.weightx = 0.5;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.buttonConfigurarCabecalhoEtiqueta, cons);
        this.checkEnviaLoteUsandoWebService.setSelected(true);
        this.checkEnviaLoteUsandoWebService.setEnabled(false);
        this.repaint();
        this.revalidate();
        this.pack();
        this.setSize(new Dimension(340, 330));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
        this.checkEnviaLoteUsandoWebService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloRedeWS.this.checkEnviaLoteUsandoWebService.isSelected()) {
                    ConfiguradorProtocoloRedeWS.this.buttonConfigurarCabecalhoEtiqueta.setEnabled(true);
                } else {
                    ConfiguradorProtocoloRedeWS.this.buttonConfigurarCabecalhoEtiqueta.setEnabled(false);
                    ConfiguradorProtocoloRedeWS.this.checkEnvioAutomatico.setSelected(false);
                }
            }
        });
        this.checkEnvioAutomatico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloRedeWS.this.checkEnvioAutomatico.isSelected()) {
                    ConfiguradorProtocoloRedeWS.this.checkEnviaLoteUsandoWebService.setSelected(true);
                    ConfiguradorProtocoloRedeWS.this.buttonConfigurarCabecalhoEtiqueta.setEnabled(true);
                }
            }
        });
        this.buttonConfigurarCabecalhoEtiqueta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTermica termica = EditorTermica.novaInstancia(Laboratorio.getInstancia(), "Configurando ", true, true);
                if (!Funcoes.textoVazio(ConfiguradorProtocoloRedeWS.this.xmlCabecalhoEtiqueta)) {
                    termica.setDocumento(ConfiguradorProtocoloRedeWS.this.xmlCabecalhoEtiqueta);
                }
                termica.setVisible(true);
                if (!Funcoes.textoVazio(termica.getDocumento())) {
                    ConfiguradorProtocoloRedeWS.this.xmlCabecalhoEtiqueta = termica.getDocumento();
                }
            }
        });
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<redews>");
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        bui.append(StringUtil.getTag(TAG_ID_LABORATORIO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag(TAG_SENHA, this.textSenha.getText()));
        bui.append(StringUtil.getTag(TAG_ENDERECO_WEBSERVICE, this.textEndWebService.getText()));
        bui.append(StringUtil.getTag(TAG_ENVIAR_UTILIZANDO_WEBSERVICE, this.checkEnviaLoteUsandoWebService.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_LOTE_PELA_REQUISICAO, this.checkEnvioAutomatico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_CONFIGURADOR_CABECALHO_ETIQUETA, this.xmlCabecalhoEtiqueta));
        return bui.append("</redews>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "redews");
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
            this.textCodigo.setText(StringUtil.getValor(xml, TAG_ID_LABORATORIO));
            this.textSenha.setText(StringUtil.getValor(xml, TAG_SENHA));
            this.textEndWebService.setText(StringUtil.getValor(xml, TAG_ENDERECO_WEBSERVICE));
            this.checkEnviaLoteUsandoWebService.setSelected(true);
            this.checkEnvioAutomatico.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_LOTE_PELA_REQUISICAO).trim().length() > 0 ? StringUtil.getBoolean(xml, TAG_ENVIAR_LOTE_PELA_REQUISICAO) : false);
            this.xmlCabecalhoEtiqueta = StringUtil.getValor(xml, TAG_CONFIGURADOR_CABECALHO_ETIQUETA);
        }
    }

    public void setXmlConfiguracao(String xml) {
        this.xmlCabecalhoEtiqueta = xml;
    }

    @Override
    public boolean acaoOk() {
        if (this.checkEnviaLoteUsandoWebService.isSelected()) {
            if (Funcoes.textoVazio(this.textCodigo.getText())) {
                Funcoes.mensagem(this, "Informe o ID Laborat\u00f3rio para realizar a integra\u00e7\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.textCodigo);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenha.getText())) {
                Funcoes.mensagem(this, "\tInforme a Senha do Laborat\u00f3rio.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
            if (Funcoes.textoVazio(this.textEndWebService.getText())) {
                Funcoes.mensagem(this, "\tInforme o Link da Integra\u00e7\u00e3o.", 2);
                ScreenUtil.requisitarFoco(this.textEndWebService);
                return false;
            }
        }
        return true;
    }
}

