/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ParserUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.rede.ConfiguracaoProtocoloRede;
import jalis.laboratorio.util.parsers.rede.Exame;
import jalis.laboratorio.util.parsers.rede.ExameResultado;
import jalis.laboratorio.util.parsers.rede.Paciente;
import jalis.laboratorio.util.parsers.rede.PacienteResultado;
import jalis.laboratorio.util.parsers.rede.Requisicao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;

public class ImportacaoResultadoRede
extends AbstractImportadorResultadoLabExterno {
    private ModeloGridTable modeloRelatorio;
    private JButton buttonImprimir;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoRede(int codigoLabExterno) {
        Statement st;
        block4: {
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Rede (Titan) a partir de arquivo TXT", codigoLabExterno, Protocolo.Rede);
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRede (118)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        try {
            ConfiguracaoProtocoloRede config = this.getConfigRede();
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo TXT do Lab. S. Rede (*.txt)", "txt"));
            if (chooser.showOpenDialog(this) == 0) {
                String nomeArquivo = chooser.getSelectedFile().getName();
                if (nomeArquivo.substring(0, 3).toUpperCase().equals(config.getEmpresa().toUpperCase()) && nomeArquivo.toLowerCase().indexOf(".txt") == nomeArquivo.length() - 4 && ParserUtil.getNumeroLinhas(chooser.getSelectedFile()) > 0) {
                    this.setTextoInformacoes("Importa\u00e7\u00e3o iniciada...");
                    this.importarResultados(config, Integer.valueOf(Variaveis.filialPadrao), this.getPacientesResultado(chooser.getSelectedFile()));
                } else {
                    this.setTextoInformacoes("Arquivo inv\u00e1lido, tente novamente.");
                }
            }
            this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRede");
        }
        this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada.", false);
        this.progress.setVisible(false);
    }

    private ConfiguracaoProtocoloRede getConfigRede() throws Exception {
        String sql = "select lae_configuracao from labexterno where fil_codigo = ? and lae_codigo = ?";
        PreparedStatement prst = Conexao.getConnection().prepareStatement(sql);
        prst.setInt(1, Integer.valueOf(Variaveis.filialPadrao));
        prst.setInt(2, this.codigoLabExterno);
        ResultSet rs = prst.executeQuery();
        rs.next();
        ConfiguracaoProtocoloRede config = new ConfiguracaoProtocoloRede(rs.getString("lae_configuracao"));
        prst.close();
        return config;
    }

    private void importarResultados(ConfiguracaoProtocoloRede config, int codigoFilial, List<PacienteResultado> pacientesResultado) throws Exception {
        this.progress.setValue(0);
        this.progress.setMaximum(pacientesResultado.size());
        this.progress.setVisible(true);
        if (pacientesResultado.isEmpty()) {
            this.setTextoInformacoes("\nNenhum resultado para importar", false);
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        for (PacienteResultado pacResultado : pacientesResultado) {
            this.progress.setValue(this.progress.getValue() + 1);
            Requisicao requisicao = this.getRequisicao(codigoFilial, this.codigoLabExterno, pacResultado);
            if (requisicao == null) {
                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Nenhuma requisi\u00e7\u00e3o para o c\u00f3digo do paciente: ".concat(String.valueOf(pacResultado.getIdPaciente())), false);
                continue;
            }
            if (!this.validaPaciente(requisicao)) {
                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Req.: " + requisicao.getCodigo() + "| Pac.:" + requisicao.getIdCliente() + "  " + Situacao.NAO_LOCALIZADO.descricao, false);
                continue;
            }
            for (Exame exame : requisicao.getExames()) {
                if (exame.isLancado()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, exame.isSalvaParcial() ? Situacao.NAO_LOCALIZADO : Situacao.JA_LANCADO);
                    continue;
                }
                if (!Funcoes.textoVazio(exame.getSituacao())) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.SEM_MATERIAL);
                    continue;
                }
                ExameResultado exameResultado = pacResultado.getExame(exame.getCodigo());
                if (exameResultado == null) continue;
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString(), requisicao.getCodigoFilial().toString(), false, false);
                dados.putAll(exameResultado.getResultados());
                boolean salvoParcial = exame.getSituacao().equals("P");
                if (!salvoParcial) {
                    this.preencheFormatacao(requisicao, exame);
                }
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(String.valueOf(requisicao.getCodigoFilial()), String.valueOf(requisicao.getCodigo()), String.valueOf(requisicao.getPaciente().getCodigo()), exame.getCodigo(), String.valueOf(exame.getCodigoMaterial()), String.valueOf(exame.getCodigoMetodo()));
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(exame.getCodigo(), String.valueOf(requisicao.getCodigoFilial()));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, String.valueOf(requisicao.getCodigoFilial()));
                }
                Resultado resultado = new Resultado(exame.getFormato(), dados, resAnterior, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"));
                resultado.atualizarComponentes();
                if (!resultado.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + requisicao.getCodigo() + "|" + exame.getCodigo() + " - " + Situacao.CONDICAO_INSATISFEITA.descricao, false);
                    continue;
                }
                boolean completo = true;
                if (exame.isSalvaParcial()) {
                    completo = resultado.resultadoCompleto(true);
                }
                String novaSituacao = completo ? "L" : "P";
                String resultadoValor = completo ? resultado.getResultado() : resultado.getResultadoParcial();
                Util.gravaAlteracaoExameRequisicao(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString());
                boolean marcarConferido = false;
                if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null) {
                    int verificacao = resultado.verificarValidacao();
                    boolean bl = marcarConferido = verificacao == 1;
                    if (!marcarConferido && verificacao != 2) {
                        this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.VALIDACAO_INSATISFEITA);
                        this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + requisicao.getCodigo().toString() + "|" + exame.getCodigo() + (!Funcoes.textoVazio(resultado.getMensagemValidacao()) ? " - " + resultado.getMensagemValidacao() : ""), false);
                    } else {
                        novaSituacao = "C";
                    }
                }
                boolean validacaoCompulsoria = resultado.verificarValidacaoCompulsoria() == 1;
                this.salvarExameRequisicao(requisicao, exame, resultadoValor, novaSituacao, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria);
                this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.LANCADO);
                if (completo) {
                    Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? exame.getDataMaterial() : new Date();
                    this.atualizarTabelaExamesControle(st, requisicao, exame, resultado.getResultadoAnterior(dataColeta, dataColeta));
                }
                ExportaWeb.atualizaPaginaOrdemExameWeb(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), Variaveis.codigoBaseWeb);
                this.editarRequisicaoExportaFiliais(requisicao, exame);
                DBUtil.setExameSituacaoInterfaceamento(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString(), 8);
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st2)) {
                    SMSUtil.criaLogSmsComDadosRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), ExportaSMS.TipoSMS.RESULTADO, st, st2);
                }
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st2)) {
                    EmailUtil.criaLogEmail(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                }
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st2)) {
                    PushUtil.criaLogPushComDadosRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), TipoPush.RESULTADO, st, st2);
                }
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !WhatsAppUtil.isBloquearWhatsappExamePronto(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st2)) {
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), TipoWhatsapp.RESULTADO, st, st2);
                }
                this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(requisicao.getCodigoFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(requisicao.getCodigo(), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + exame.getCodigo() + " - " + (Object)((Object)(marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO)), false);
                Conexao.arquivaSQL();
                if (!this.isFilialExportaWeb(requisicao.getCodigoFilial())) continue;
                String reqImagemWeb = IntegracaoUtil.formataCodigoRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st);
                Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), exame.getCodigo(), exame.getCodigoMaterial().toString(), resultadoValor, false);
                this.exportarParaWeb(st, ExportaWeb.getCodigoBaseWeb(st, requisicao.getCodigoFilial().toString()), novaSituacao, requisicao, exame, mapa, resultadoValor);
                if (ExportaWeb.isGerarPdfResultado(st, requisicao.getCodigoFilial().toString())) {
                    ExportaWeb.enviarResultadoPDF(st, requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), ExportaWeb.getCodigoBaseWeb(st, requisicao.getCodigoFilial().toString()));
                }
                Conexao.arquivaSQL();
            }
        }
    }

    private List<PacienteResultado> getPacientesResultado(File arquivo) {
        ArrayList<PacienteResultado> pacientes = new ArrayList<PacienteResultado>();
        if (!arquivo.exists()) {
            return null;
        }
        try {
            String line;
            PacienteResultado novoPaciente = null;
            ExameResultado novoExame = null;
            StringBuilder comentario = new StringBuilder("");
            String idPaciente = "";
            String codigoExame = "";
            boolean novoPac = false;
            BufferedReader csvTabela = new BufferedReader(new FileReader(arquivo));
            StringBuilder tabela = new StringBuilder();
            while ((line = csvTabela.readLine()) != null) {
                tabela.append(line).append("\n");
            }
            csvTabela.close();
            List<List<String>> dados = ParserUtil.parserCsv(tabela.toString(), "|", "");
            for (List<String> list : dados) {
                if (!list.get(0).equals("3") || Funcoes.textoVazio(list.get(2))) continue;
                if (!idPaciente.equalsIgnoreCase(list.get(1))) {
                    idPaciente = list.get(1);
                    novoPaciente = new PacienteResultado(new BigInteger(list.get(1)));
                    pacientes.add(novoPaciente);
                    novoPac = true;
                }
                if (!codigoExame.equals(this.getExame(list.get(2))) || novoPac) {
                    novoPac = false;
                    codigoExame = this.getExame(list.get(2));
                    if (!comentario.toString().equals("")) {
                        novoExame.setValorResultado("comentario", comentario.toString());
                    }
                    comentario.setLength(0);
                    novoExame = new ExameResultado(codigoExame);
                    novoExame.setDataCadastro(Funcoes.stringToDate("dd/MM/yyyy", list.get(12)));
                    novoPaciente.addExame(novoExame);
                }
                if (list.size() >= 4) {
                    novoExame.setNumeroRecipiente(list.get(3));
                }
                if (list.size() >= 5) {
                    novoExame.setComplementoExame(list.get(4));
                }
                if (list.size() >= 18) {
                    novoExame.setNumeroRecipientesTitan(list.get(17));
                }
                if (list.size() >= 12) {
                    novoExame.setNumeroVisitasPaciente(!list.get(11).equals("") ? Integer.parseInt(list.get(11)) : 0);
                }
                if (list.size() >= 14) {
                    novoExame.setStatusResultado(list.get(13));
                }
                if (list.size() >= 19) {
                    novoExame.setQuantidadeAntibiogramas(!list.get(18).equals("") ? Integer.parseInt(list.get(18)) : 0);
                }
                if (!list.get(8).equals("")) {
                    novoExame.setValorResultados("resultado", list.get(8).replace('.', ','));
                }
                if (!list.get(5).equals("")) {
                    StringBuilder resultado = new StringBuilder();
                    if (novoExame.getResultados().containsKey(list.get(5))) {
                        resultado.append(String.valueOf(novoExame.getResultados().get(list.get(5))).trim()).append("\n");
                    }
                    resultado.append(list.get(8).replace('.', ','));
                    novoExame.setValorResultados(list.get(5), resultado.toString());
                }
                if (!list.get(10).equals("")) {
                    comentario.append(list.get(10)).append(" ");
                }
                if (list.size() < 17 || list.get(16).equals("")) continue;
                novoExame.setValorResultados("metodo", list.get(16));
                novoExame.setValorResultados("MET_" + list.get(5), list.get(16));
            }
            if (novoPaciente != null && dados.size() > 1) {
                novoExame.setValorResultado("comentario", comentario.toString());
                novoPaciente.addExame(novoExame);
                pacientes.add(novoPaciente);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRede");
        }
        return pacientes;
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private Requisicao getRequisicao(int codigoFilial, int codigoLabExterno, PacienteResultado pac) throws SQLException {
        Requisicao requisicao = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select c.pac_codigo, c.pac_nome, c.pac_idade, c.pac_anomes ");
        sql.append("from paciente c ");
        sql.append("where c.fil_codigo = ? and c.pac_codigo = ? ");
        PreparedStatement prst = Conexao.getPreparedStatement(sql.toString());
        prst.setInt(1, codigoFilial);
        prst.setLong(2, new Long(pac.getIdPaciente().toString()));
        ResultSet rs = prst.executeQuery();
        if (rs.next()) {
            Paciente paciente = new Paciente(rs.getInt("pac_codigo"));
            paciente.setNome(rs.getString("pac_nome"));
            paciente.setIdade(rs.getInt("pac_idade"));
            paciente.setTipoIdade(rs.getString("pac_anomes"));
            Set<String> codigosExames = pac.getCodigosExames();
            ArrayList<String> etq = new ArrayList<String>();
            Map<String, ExameResultado> exames = pac.getExames();
            for (String codExame : codigosExames) {
                etq.add("'".concat(exames.get(codExame).getNumeroRecipientesTitan()).concat("'"));
            }
            sql.setLength(0);
            sql.append("select a.exa_codigo, a.mco_codigo, a.exr_situacao, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
            sql.append("g.met_codigo, a.exr_datamaterial,");
            sql.append("b.exa_salvaparcial, g.ele_xmllabexterno, a.exr_codetiquetaoffline, ");
            sql.append("d.fil_codigo, d.req_codigo, d.con_codigo, d.des_codigo, b.exa_salvaparcial");
            sql.append(" from examerequisicao a ");
            sql.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            sql.append(" left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
            sql.append(" left join requisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo ");
            sql.append(" left join paciente e on d.pac_codigo = e.pac_codigo and d.fil_codigo = e.fil_codigo ");
            sql.append(" left join loteexternorequisicao f on d.fil_codigo = f.fil_codigo and d.req_codigo = f.fil_codigo ");
            sql.append(" left join examematcoletalabexterno g on c.fil_codigo = g.fil_codigo and c.exa_codigo = g.exa_codigo and c.mco_codigo = g.mco_codigo ");
            sql.append(" where a.fil_codigo = ? and g.lae_codigo = ? and e.pac_codigo = ? and a.exr_excluido = false and g.ele_xmllabexterno <> '' and g.ele_xmllabexterno is not null ");
            sql.append("and a.exr_codetiquetaoffline in ").append(etq.toString().replace('[', '(').replace(']', ')'));
            PreparedStatement prst2 = Conexao.getPreparedStatement(sql.toString());
            prst2.setInt(1, codigoFilial);
            prst2.setInt(2, codigoLabExterno);
            prst2.setLong(3, new Long(pac.getIdPaciente().toString()));
            ResultSet rs2 = prst2.executeQuery();
            while (rs2.next()) {
                if (requisicao == null || requisicao.getCodigo().intValue() != rs2.getInt("req_codigo")) {
                    requisicao = new Requisicao(rs2.getInt("fil_codigo"), rs2.getInt("req_codigo"), paciente);
                    requisicao.setIdCliente(pac.getIdPaciente());
                    requisicao.setCodigoConvenio(rs2.getInt("con_codigo"));
                    requisicao.setCodigoDestino(rs2.getString("des_codigo"));
                }
                Exame exame = new Exame(rs2.getString("exa_codigo"));
                String xmlExame = rs2.getString("ele_xmllabexterno");
                exame.setCodigoMaterial(rs2.getInt("mco_codigo"));
                exame.setCodigoMetodo(rs2.getInt("met_codigo"));
                exame.setSituacao(rs2.getString("exr_situacao"));
                exame.setFormato(rs2.getString("exr_resultado"));
                exame.setDataMaterial(rs2.getDate("exr_datamaterial"));
                exame.setSalvarParcial(rs2.getBoolean("exa_salvaparcial"));
                String codigoLayout = ExameUtil.getCodigoLayout(requisicao.getCodigoFilial().toString(), requisicao.getCodigoConvenio().toString(), requisicao.getCodigoDestino());
                exame.setCodigoLayout(Integer.valueOf(codigoLayout));
                requisicao.getExames().add(exame);
            }
            prst2.close();
        }
        prst.close();
        return requisicao;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarAoModeloRelatorio(Requisicao requisicao, Exame exame, Situacao situacao) {
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, String.valueOf(requisicao.getCodigoFilial()), String.valueOf(requisicao.getCodigo()), exame.getCodigo(), exame.getCodigoMaterial(), situacao.descricao);
    }

    private void exportarParaWeb(Statement st, String codigoBaseWeb, String situacao, Requisicao requisicao, Exame exame, Map mapa, String resultadoOriginal) throws Exception {
        if (mapa != null && !Funcoes.textoVazio(codigoBaseWeb)) {
            boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, requisicao.getCodigoFilial().toString());
            ArrayList<String> chave = new ArrayList<String>();
            chave.add("codigoRequisicao");
            chave.add(IntegracaoUtil.formataCodigoRequisicao(requisicao.getCodigoFilial().toString(), requisicao.getCodigo().toString(), st));
            chave.add("codigoBase");
            chave.add(codigoBaseWeb);
            chave.add("codigoExameRequisicao");
            chave.add(exame.getCodigo());
            chave.add("materialExameRequisicao");
            chave.add(exame.getCodigoMaterial().toString());
            ArrayList<String> temp = new ArrayList<String>(chave);
            String laudo = mapa.get("laudo") != null ? StringUtil.textoDB((String)mapa.get("laudo")) : "";
            String exportaTexto = mapa.get("laudo") != null ? exame.getFormatoTexto() : "";
            temp.add("dataEnvioExameRequisicao");
            temp.add("current_timestamp");
            temp.add("situacaoExameRequisicao");
            temp.add(situacao);
            if (!resultadoPdf) {
                temp.add("resultadoExameRequisicao");
                temp.add(laudo);
                temp.add("resultadoTextoExameRequisicao");
                temp.add(ResultadosUtil.geraResultadoTextoParaWeb(resultadoOriginal, exportaTexto));
            }
            DBUtil.insereExportaWeb(requisicao.getCodigoFilial().toString(), st, "requisicaoexame", "A", true, temp.toArray(new String[temp.size()]));
            Map imagens = (Map)mapa.get("imagens");
            if (imagens != null && !imagens.isEmpty()) {
                DBUtil.insereExportaWeb(requisicao.getCodigoFilial().toString(), st, "requisicaoexameimagem", "D", chave.toArray(new String[chave.size()]));
                temp.clear();
                for (Integer indice : imagens.keySet()) {
                    temp.addAll(chave);
                    temp.add("codigoImagemExame");
                    temp.add(indice.toString());
                    temp.add("imagemExame");
                    temp.add((String)imagens.get(indice));
                    DBUtil.insereExportaWeb(requisicao.getCodigoFilial().toString(), st, "requisicaoexameimagem", "I", false, temp.toArray(new String[temp.size()]));
                    temp.clear();
                }
            }
        }
    }

    private boolean isFilialExportaWeb(int codigoFilial) {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, String.valueOf(codigoFilial));
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoREDE: 261");
        }
        return false;
    }

    private boolean carregouVO(FilialVO filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private boolean pertenceAoIntervalo(ResultSet res, Paciente paciente) throws SQLException {
        int idadePac = paciente.getIdade() * this.diasTipo(paciente.getTipoIdade());
        int ini = res.getInt("ela_idadeini") * this.diasTipo(res.getString("ela_idadeinitipo"));
        int fim = res.getInt("ela_idadefim") * this.diasTipo(res.getString("ela_idadefimtipo"));
        return ini <= idadePac && idadePac <= fim;
    }

    private void preencheFormatacao(Requisicao requisicao, Exame exame) {
        Statement st = Conexao.getStatement();
        if (st != null && exame.getCodigoLayout() != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  c.met_codigo, \n");
                bui.append("  b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.lae_codigo = ").append(this.codigoLabExterno);
                bui.append("where \n");
                bui.append("  a.fil_codigo = ").append(requisicao.getCodigoFilial()).append(" and \n");
                bui.append("  a.exa_codigo = '").append(exame.getCodigo()).append("' and \n");
                bui.append("  a.mco_codigo = ").append(exame.getCodigoMaterial()).append(" and \n");
                bui.append("  c.lae_codigo = ").append(this.codigoLabExterno);
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("ela_padrao");
                    boolean interValido = exame.getCodigoLayout().intValue() == rs.getInt("lay_codigo") && this.pertenceAoIntervalo(rs, requisicao.getPaciente());
                    boolean bl = idadeZero = exame.getCodigoLayout().intValue() == rs.getInt("lay_codigo") && rs.getInt("ela_idadeini") == 0 && rs.getInt("ela_idadefim") == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !interValido) continue;
                    linha = rs.getRow();
                    if (!interValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    bui.setLength(0);
                    bui.append("select \n");
                    bui.append("  a.elm_formato, a.elm_exportartexto, b.met_codigo \n");
                    bui.append("from examelayoutmetodo a \n");
                    bui.append("left join metodologia b \n");
                    bui.append("  on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo \n");
                    bui.append("where \n");
                    bui.append("  a.fil_codigo = ").append(requisicao.getCodigoFilial()).append(" and \n");
                    bui.append("  a.exa_codigo = '").append(exame.getCodigo()).append("' and \n");
                    bui.append("  a.mco_codigo = ").append(exame.getCodigoMaterial()).append(" and \n");
                    bui.append("  a.lay_codigo = ").append(rs.getString("lay_codigo")).append(" and \n");
                    bui.append("  a.ela_idadeini = ").append(rs.getString("ela_idadeini")).append(" and \n");
                    bui.append("  a.ela_idadefim = ").append(rs.getString("ela_idadefim")).append(" and \n");
                    bui.append("  a.ela_idadeinitipo = '").append(rs.getString("ela_idadeinitipo")).append("' and \n");
                    bui.append("  a.ela_idadefimtipo = '").append(rs.getString("ela_idadefimtipo")).append("' and \n");
                    bui.append("  b.met_codigo = ").append(rs.getString("met_codigo"));
                    rs = Conexao.executeQuery(st, bui.toString());
                    if (rs.next()) {
                        exame.setFormatoTexto(rs.getString("elm_exportartexto"));
                        exame.setFormato(rs.getString("elm_formato"));
                        exame.setCodigoMetodo(rs.getInt("met_codigo"));
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRede");
            }
        }
    }

    private void editarRequisicaoExportaFiliais(Requisicao requisicao, Exame exame) {
        try {
            ExportaFiliais.gravaRequisicao(requisicao.getCodigoFilial(), requisicao.getCodigo().intValue(), exame.getCodigo(), exame.getCodigoMaterial(), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoRede");
        }
    }

    private void atualizarTabelaExamesControle(Statement st, Requisicao requisicao, Exame exame, String resAnterior) throws SQLException {
        Registro reg = new Registro();
        reg.setValor("fil_codigo", requisicao.getCodigoFilial().toString());
        reg.setValor("pac_codigo", requisicao.getPaciente().getCodigo().toString());
        reg.setValor("exa_codigo", exame.getCodigo());
        reg.setValor("mco_codigo", exame.getCodigoMaterial());
        reg.setValor("req_codigo", requisicao.getCodigo().toString());
        reg.setValor("exc_resultado", resAnterior);
        reg.setValor("exr_datamaterial", exame.getDataMaterial());
        reg.setValor("met_codigo", exame.getCodigoMetodo());
        super.atualizarTabelaExamesControle(st, reg, resAnterior);
    }

    private void salvarExameRequisicao(Requisicao requisicao, Exame exame, String resultado, String situacao, boolean conferir, String usuarioConferencia, boolean validacaoCompulsoria) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("update examerequisicao set");
        bui.append(" exr_resultado = '").append(StringUtil.textoDB(resultado)).append("'");
        bui.append(", exr_compulsorio = ").append(validacaoCompulsoria);
        bui.append(", exr_situacao = '").append(situacao).append("'");
        bui.append(", exr_datadigita = current_timestamp, usr_coddigitador = '").append(Variaveis.login).append("'");
        bui.append(", met_codigo = ").append(exame.getCodigoMetodo());
        if (conferir) {
            bui.append(",  exr_dataassina = current_timestamp, \n");
            if (usuarioConferencia != null && !Funcoes.textoVazio(usuarioConferencia)) {
                bui.append("  usr_codassina = '").append(StringUtil.textoDB(usuarioConferencia)).append("', \n");
            }
        }
        bui.append(" where fil_codigo = ").append(requisicao.getCodigoFilial());
        bui.append(" and req_codigo = ").append(requisicao.getCodigo());
        bui.append(" and exa_codigo = '").append(exame.getCodigo()).append("'");
        bui.append(" and mco_codigo = ").append(exame.getCodigoMaterial());
        DBUtil.gravaLogSituacaoExameRequisicao(st, String.valueOf(requisicao.getCodigoFilial()), String.valueOf(requisicao.getCodigo()), exame.getCodigo(), String.valueOf(exame.getCodigoMaterial()), situacao, false);
        Conexao.executeUpdate(String.valueOf(requisicao.getCodigoFilial()), st, bui.toString());
        st.close();
    }

    private boolean validaPaciente(Requisicao requisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("select pac_codigo from paciente ");
        bui.append("where fil_codigo = ").append(requisicao.getCodigoFilial());
        bui.append("and pac_codigo = ").append(requisicao.getIdCliente());
        ResultSet res = Conexao.executeQuery(st, bui.toString());
        return res.next();
    }

    private String getMaterial(String mnemonicoExame) {
        return mnemonicoExame.substring(mnemonicoExame.trim().length() - 2, mnemonicoExame.length());
    }

    private String getExame(String mnemonicoExame) {
        if (mnemonicoExame.trim().length() > 2) {
            return this.substring(mnemonicoExame, mnemonicoExame.trim().length() - 2);
        }
        return "";
    }

    private String substring(String str, int endIndex) {
        return str.substring(0, str.length() > endIndex ? endIndex : str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirRelatorio() {
        Statement st;
        block5: {
            if (this.modeloRelatorio.getRowCount() <= 0) {
                return;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioSituacaoLote.getModuloAcesso());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block5;
                final JDialog dialogo = new JDialog(Laboratorio.getInstancia());
                dialogo.setSize(new Dimension(750, 600));
                dialogo.getContentPane().setLayout(new BorderLayout());
                dialogo.setModal(true);
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        dialogo.dispose();
                    }
                });
                gerador.executar(rs.getString("rel_xml"), this.modeloRelatorio);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ImportacaoResultadoRede");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        SEM_MATERIAL("Sem material");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

