/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.ParserUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.rede.CampoRede;
import jalis.laboratorio.util.parsers.rede.ExameRede;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;

public class ImportacaoRede
extends AbstractImportadorLabExterno {
    private static final int TAG_MNEMONICO = 0;
    private static final int TAG_EXAME_DESCRICAO = 1;
    private static final int TAG_QUANTIDADE = 2;
    private static final int TAG_APELIDO = 3;
    private static final int TAG_NOME_DO_CAMPO = 4;
    private File arquivo;

    public ImportacaoRede(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Rede", codigoLabExterno, Protocolo.Rede);
        this.getButtonImportar().setText("Importar Exames");
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
    }

    @Override
    public void anexarTextoInformacoes(String texto) {
        super.anexarTextoInformacoes(texto);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            StringBuilder bui = new StringBuilder();
            this.setTextoInformacoes("Buscando dados... aguarde.");
            Thread.sleep(50L);
            this.progress.setValue(0);
            this.progress.setVisible(true);
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo CSV do Lab. S. Rede (*.csv)", "csv"));
            if (chooser.showOpenDialog(this) == 0) {
                this.arquivo = chooser.getSelectedFile();
                Set<ExameRede> exames = this.importarExamesRede();
                Thread.sleep(50L);
                if (exames.size() > 0) {
                    bui.append("\n\nOs seguintes exames foram atualizados: \n\n");
                    bui.append("+--------+-----------------------------------------------------------------------------+\n");
                    bui.append("| CODIGO |                                  EXAME                                      |\n");
                    bui.append("+--------+-----------------------------------------------------------------------------+");
                    for (ExameRede exameRede : exames) {
                        bui.append("\n|").append(StringUtil.formatarColuna(exameRede.getCodigo(), 8, 'e'));
                        bui.append("|").append(StringUtil.formatarColuna(exameRede.getDescricao(), 77, 'c')).append("|");
                    }
                    bui.append("\n+--------+-----------------------------------------------------------------------------+");
                    this.anexarTextoInformacoes(bui.toString());
                    this.anexarTextoInformacoes("\nImporta\u00e7\u00e3o conclu\u00edda");
                    retorno = true;
                }
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel importar arquivo - Lab. Rede - " + e.getMessage(), e.getStackTrace());
        }
        this.progress.setVisible(false);
        return retorno;
    }

    private HashSet<ExameRede> importaArquivoRede() throws Exception {
        String line;
        HashSet<ExameRede> examesRede = new HashSet<ExameRede>();
        BufferedReader csvTabela = new BufferedReader(new FileReader(this.arquivo));
        StringBuilder tabela = new StringBuilder();
        while ((line = csvTabela.readLine()) != null) {
            tabela.append(line).append("\n");
        }
        csvTabela.close();
        List<List<String>> dados = ParserUtil.parserCsv(tabela.toString(), ";", "");
        String exame = "";
        ExameRede exameRede = null;
        for (List<String> list : dados) {
            if (list.get(0).toUpperCase().equals("MNEMONICO")) continue;
            if (Funcoes.textoVazio(list.get(0))) {
                exameRede.setCampo(new CampoRede(list.get(3), list.get(4).trim()));
                exameRede.setCampo(new CampoRede("MET_" + list.get(3), "M\u00e9todo utilizado " + list.get(4).trim()));
                continue;
            }
            if (!list.get(0).equalsIgnoreCase(exame) && exameRede != null) {
                examesRede.add(exameRede);
                exame = list.get(0);
            }
            exameRede = new ExameRede(list.get(0), list.get(1));
            exameRede.setCampo(new CampoRede(list.get(3), list.get(4).trim()));
            exameRede.setCampo(new CampoRede("MET_" + list.get(3), "M\u00e9todo utilizado " + list.get(4).trim()));
        }
        if (exameRede != null) {
            examesRede.add(exameRede);
        }
        return examesRede;
    }

    private Set<ExameRede> importarExamesRede() throws Exception {
        HashSet<ExameRede> examesNovos = this.importaArquivoRede();
        HashSet<ExameRede> examesExcluidos = new HashSet<ExameRede>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                Map<String, ExameRede> examesAntigosRelac = ImportacaoRede.examesMap(ImportacaoRede.getExamesRelacionados(this.codigoLabExterno));
                Set<ExameRede> examesAntigos = this.loadExamesRede(st);
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, this.codigoLabExterno, 6, new Object[0]);
                if (this.progress != null) {
                    this.progress.setMaximum(examesNovos.size());
                    this.progress.setValue(0);
                }
                this.inserirExamesRede(examesNovos, st, this.codigoLabExterno, this.progress);
                HashSet<ExameRede> examesNovosRel = new HashSet<ExameRede>(examesNovos);
                examesNovosRel.retainAll(examesAntigosRelac.values());
                if (this.progress != null) {
                    this.progress.setMaximum(examesNovosRel.size());
                    this.progress.setValue(0);
                }
                for (ExameRede ex : examesNovosRel) {
                    if (this.progress != null) {
                        this.progress.setValue(this.progress.getValue() + 1);
                    }
                    ExameRede exAntigo = examesAntigosRelac.get(ex.getCodigo());
                    ex.setExameJalis(exAntigo.getExameJalis());
                    ex.setMaterialJalis(exAntigo.getMaterialJalis());
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, this.codigoLabExterno, ex.getExameJalis(), ex.getMaterialJalis(), StringUtil.textoDB(ex.getXML()));
                }
                examesExcluidos.addAll(examesAntigos);
                examesExcluidos.removeAll(examesNovos);
                HashSet<ExameRede> examesExcluidosRel = new HashSet<ExameRede>(examesAntigosRelac.values());
                examesExcluidosRel.removeAll(examesNovos);
                for (ExameRede ex : examesExcluidosRel) {
                    IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, this.codigoLabExterno, ex.getExameJalis(), ex.getMaterialJalis(), null);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return examesNovos;
    }

    private Set<ExameRede> loadExamesRede(Statement st) throws SQLException {
        HashSet<ExameRede> exames = new HashSet<ExameRede>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo, lae_codigo, red_codexame, red_codmaterial, red_descricaoexame, red_descricaomaterial, red_xml ");
        sql.append("   from examesrede ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameRede e = new ExameRede(rs.getString("red_xml"));
            e.setCodigo(rs.getString("red_codexame"));
            e.setDescricao(rs.getString("red_descricaoexame"));
            e.setCodigoMaterial(rs.getInt("red_codmaterial"));
            e.setDescricaoMaterial(rs.getString("red_descricaomaterial"));
            exames.add(e);
        }
        return exames;
    }

    private static Set<ExameRede> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, c.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.lae_codigo = c.lae_codigo ");
                bui.append("where \n");
                bui.append(" c.ele_xmllabexterno <> '' and c.ele_xmllabexterno is not null and \n");
                bui.append(" b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append(" b.lae_codigo = ").append(codigoLabExterno);
                ResultSet rs = Conexao.executeQuery(st, SQL + bui.toString());
                Funcoes.validarNaoNull(rs, "res");
                HashSet<ExameRede> list = new HashSet<ExameRede>();
                if (rs.first()) {
                    do {
                        ExameRede e = new ExameRede(rs.getString("ele_xmllabexterno"));
                        e.setExameJalis(rs.getString("exa_codigo"));
                        e.setMaterialJalis(rs.getInt("mco_codigo"));
                        list.add(e);
                    } while (rs.next());
                }
                return list;
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameRede>();
    }

    private static Map<String, ExameRede> examesMap(Collection<ExameRede> exames) {
        HashMap<String, ExameRede> examesMap = new HashMap<String, ExameRede>();
        for (ExameRede ex : exames) {
            examesMap.put(ex.getCodigo(), ex);
        }
        return examesMap;
    }

    private void inserirExamesRede(Set<ExameRede> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        for (ExameRede ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ep.getCodigo())) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 6, ep.getCodigo(), ep.getCodigoMaterial(), StringUtil.textoDB(ep.getDescricao()), StringUtil.textoDB(ep.getDescricaoMaterial()), StringUtil.textoDB(ep.getXML()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }
}

