/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.rede.CampoRede;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ExameRede {
    public static final String TAG_REDE = "rede";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_DESCRICAO = "descricao";
    public static final String TAG_CAMPOS = "campos";
    public static final String TAG_CAMPO = "campo";
    private String codigo;
    private String descricao;
    private Integer codigoMaterial;
    private String descricaoMaterial;
    private String exameJalis;
    private Integer materialJalis;
    private List<CampoRede> campos = new ArrayList<CampoRede>();

    public ExameRede(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
        this.codigoMaterial = 0;
        this.descricaoMaterial = "";
    }

    public ExameRede(String xml) {
        this.setXML(xml);
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Integer getCodigoMaterial() {
        return this.codigoMaterial;
    }

    public void setCodigoMaterial(Integer codigoMaterial) {
        this.codigoMaterial = codigoMaterial;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public void setDescricaoMaterial(String descricaoMaterial) {
        this.descricaoMaterial = descricaoMaterial;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public Integer getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(Integer materialJalis) {
        this.materialJalis = materialJalis;
    }

    public List<CampoRede> getCampos() {
        return this.campos;
    }

    public void setCampos(List<CampoRede> campos) {
        this.campos = campos;
    }

    public void setCampo(CampoRede campo) {
        this.campos.add(campo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ExameRede> getExames(int filial, int codigoLabExterno) {
        LinkedHashSet<ExameRede> exames = new LinkedHashSet<ExameRede>();
        String sql = "select red_xml from examesrede where fil_codigo = ? and lae_codigo = ? order by red_codexame";
        PreparedStatement prst = Conexao.getPreparedStatement(sql);
        try {
            prst.setInt(1, filial);
            prst.setInt(2, codigoLabExterno);
            try (ResultSet rs = null;){
                rs = prst.executeQuery();
                while (rs.next()) {
                    exames.add(new ExameRede(rs.getString("red_xml")));
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameRede");
        }
        finally {
            try {
                prst.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exames;
    }

    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_REDE);
            xml.abrir(TAG_EXAME);
            xml.escrever(TAG_CODIGO, this.getCodigo());
            xml.escrever(TAG_DESCRICAO, this.getDescricao());
            xml.abrir(TAG_CAMPOS);
            for (CampoRede campo : this.campos) {
                campo.escreveXml(xml);
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_REDE);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameRede");
        }
        return xml.getXML();
    }

    private void setXML(String xml) {
        String exame = StringUtil.getValor(xml, TAG_EXAME);
        this.codigo = StringUtil.getValor(exame, TAG_CODIGO);
        this.descricao = StringUtil.getValor(exame, TAG_DESCRICAO);
        for (String xmlCampo : StringUtil.getValores(StringUtil.getValor(xml, TAG_CAMPOS), TAG_CAMPO, true)) {
            this.campos.add(new CampoRede(xmlCampo));
        }
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorRede = StringUtil.getValor(xml, TAG_REDE);
        return valorRede != null && valorRede.trim().length() > 0 && (valorExame = StringUtil.getValor(valorRede, TAG_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExameRede) {
            ExameRede outroExame = (ExameRede)obj;
            return outroExame.getCodigo().equalsIgnoreCase(this.codigo);
        }
        return false;
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }
}

