/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.rede.ExameRede;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorRede
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String OBJ_EXAME_REDE = "objExameRede";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0);
    private JTextField textLocalizar = new JTextField();
    private String xmlSelecionado = "";

    public ConfiguradorRede(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Rede", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorRede(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Rede", codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorRede novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorRede((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorRede((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameRede exa = new ExameRede(xml);
            return exa.getDescricao();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameRede exa = new ExameRede(xml);
            return exa.getCodigo() + "|1";
        }
        return "";
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorRede.this.modExa.filtrar(ConfiguradorRede.DESC_EXA, ConfiguradorRede.this.textLocalizar.getText());
                if (ConfiguradorRede.this.modExa.getRowCount() > 0) {
                    ConfiguradorRede.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorRede.this.tableExa.hasFocus() && (row = ConfiguradorRede.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorRede.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorRede.this.tableExa.scrollRectToVisible(ConfiguradorRede.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorRede.this.tableExa.hasFocus() && (row = ConfiguradorRede.this.tableExa.getSelectedRow()) < ConfiguradorRede.this.tableExa.getRowCount() - 1) {
                    ConfiguradorRede.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorRede.this.tableExa.scrollRectToVisible(ConfiguradorRede.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (ExameRede exame : ExameRede.getExames(Integer.valueOf(Variaveis.filialPadrao), Integer.valueOf(this.getCodigoLabExterno()))) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigo());
            reg.setValor(DESC_EXA, exame.getDescricao());
            reg.setValor(OBJ_EXAME_REDE, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public boolean acaoOk() {
        ExameRede exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    @Override
    public void setXML(String xml) {
        if (ExameRede.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameRede exa = new ExameRede(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.equals(reg.getValor(OBJ_EXAME_REDE))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private boolean atualizarXMLSelecionado() {
        ExameRede exa = this.getExameSelecionado();
        if (exa != null) {
            this.xmlSelecionado = exa.getXML();
            return true;
        }
        return false;
    }

    private ExameRede getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameRede)reg.getValor(OBJ_EXAME_REDE);
        }
        return null;
    }
}

