/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloRede
extends AbstractConfiguradorProtocolo {
    public static final String MODELO_ETIQUETA = "modeloEtiqueta";
    public static final String LABORATORIO = "laboratorio";
    public static final String LOTE = "lote";
    public static final String EMPRESA = "empresa";
    public static final String UTILIZA_FAIXA = "utilizaFaixa";
    public static final String FAIXA_INICIAL = "faixaInicial";
    public static final String FAIXA_FINAL = "faixaFinal";
    public static final String ULTIMA_FAIXA = "ultimaFaixa";
    protected JTextField textEmpresa = new TTextField(3, 3);
    protected JTextField textLaboratorio = new TTextField(3, 3);
    protected JCheckBox checkUtilizaFaixa = new JCheckBox();
    protected JTextField textFaixaInicial = new TTextField(12, 1);
    protected JTextField textFaixaFinal = new TTextField(12, 1);
    protected JTextField textUltimaFaixa = new TTextField(12, 1);
    protected JButton buttonLayout = new JButton("Configurar layout");
    String modeloEtq = "";

    @Override
    public int getNumeroLote() {
        if (Funcoes.textoVazio(this.textLote)) {
            return 0;
        }
        return Integer.parseInt(this.textLote.getText());
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloRede((Frame)pai, "Laborat\u00f3rio Rede", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloRede((Dialog)pai, "Laborat\u00f3rio Rede", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloRede(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloRede(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<rede>");
        bui.append(StringUtil.getTag(LABORATORIO, this.textLaboratorio.getText()));
        bui.append(StringUtil.getTag(LOTE, this.textLote.getText()));
        bui.append(StringUtil.getTag(EMPRESA, this.textEmpresa.getText()));
        bui.append(StringUtil.getTag(UTILIZA_FAIXA, this.checkUtilizaFaixa.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(FAIXA_INICIAL, this.textFaixaInicial.getText()));
        bui.append(StringUtil.getTag(FAIXA_FINAL, this.textFaixaFinal.getText()));
        bui.append(StringUtil.getTag(ULTIMA_FAIXA, this.textUltimaFaixa.getText()));
        bui.append(StringUtil.getTag(MODELO_ETIQUETA, this.modeloEtq));
        return bui.append("</rede>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "rede");
            this.textLaboratorio.setText(StringUtil.getValor(xml, LABORATORIO));
            this.textLote.setText(StringUtil.getValor(xml, LOTE));
            this.textEmpresa.setText(StringUtil.getValor(xml, EMPRESA));
            this.checkUtilizaFaixa.setSelected(StringUtil.getValor(xml, UTILIZA_FAIXA).equals("true"));
            this.textFaixaInicial.setText(StringUtil.getValor(xml, FAIXA_INICIAL));
            this.textFaixaFinal.setText(StringUtil.getValor(xml, FAIXA_FINAL));
            this.textUltimaFaixa.setText(StringUtil.getValor(xml, ULTIMA_FAIXA));
            this.modeloEtq = StringUtil.getValor(xml, MODELO_ETIQUETA);
        }
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        Dimension d = new Dimension(40, 20);
        JLabel labelLaboratorio = ComponenteFactory.novoJLabel("Laborat\u00f3rio:", d);
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", d);
        JLabel labelEmpresa = ComponenteFactory.novoJLabel("Empresa:", d);
        JLabel labelUtilizaFaixa = ComponenteFactory.novoJLabel("Sequ\u00eancia de envio:", d);
        JLabel labelFaixa = ComponenteFactory.novoJLabel("Faixa:", d);
        JLabel labelUltimaFaixa = ComponenteFactory.novoJLabel("\u00daltimo c\u00f3digo enviado:", d);
        labelLaboratorio.setMaximumSize(d);
        labelLaboratorio.setMinimumSize(d);
        labelLote.setMaximumSize(d);
        labelLote.setMinimumSize(d);
        labelEmpresa.setMaximumSize(d);
        labelEmpresa.setMinimumSize(d);
        labelUtilizaFaixa.setMaximumSize(d);
        labelUtilizaFaixa.setMinimumSize(d);
        labelFaixa.setMaximumSize(d);
        labelFaixa.setMinimumSize(d);
        labelUltimaFaixa.setMaximumSize(d);
        labelUltimaFaixa.setMinimumSize(d);
        this.buttonLayout.setMinimumSize(d);
        this.buttonLayout.setMaximumSize(d);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 1.0;
        this.getPanelCentral().add((Component)labelEmpresa, cons);
        ++cons.gridx;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.textEmpresa, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        this.getPanelCentral().add((Component)labelLaboratorio, cons);
        ++cons.gridx;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.textLaboratorio, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridx;
        cons.gridwidth = 3;
        this.textLote.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        this.getPanelCentral().add((Component)labelUtilizaFaixa, cons);
        ++cons.gridx;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkUtilizaFaixa, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        this.getPanelCentral().add((Component)labelFaixa, cons);
        ++cons.gridx;
        cons.weightx = 2.0;
        this.textFaixaInicial.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textFaixaInicial, cons);
        ++cons.gridx;
        cons.weightx = 0.0;
        this.getPanelCentral().add((Component)new JLabel("a"), cons);
        ++cons.gridx;
        cons.weightx = 2.0;
        this.textFaixaFinal.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textFaixaFinal, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        this.getPanelCentral().add((Component)labelUltimaFaixa, cons);
        ++cons.gridx;
        cons.gridwidth = 3;
        this.textUltimaFaixa.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textUltimaFaixa, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        this.getPanelCentral().add((Component)this.buttonLayout, cons);
        this.setSize(new Dimension(510, 280));
        this.setLocationRelativeTo(this.getParent());
        ScreenUtil.requisitarFoco(this.textEmpresa);
        this.buttonLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTermica termica = new EditorTermica(Laboratorio.getInstancia(), "Configurando ", true);
                termica.setCamposBanco(new String[]{"requisicao", "nomePaciente", "material", "examesRede", "codEtiquetaRede"});
                termica.setDocumento(ConfiguradorProtocoloRede.this.modeloEtq);
                termica.setVisible(true);
                if (termica.ok()) {
                    ConfiguradorProtocoloRede.this.modeloEtq = termica.getDocumento();
                }
            }
        });
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textEmpresa) || Funcoes.textoVazio(this.textLaboratorio) || Funcoes.textoVazio(this.textLote)) {
            return false;
        }
        if (this.checkUtilizaFaixa.isSelected() && (Funcoes.textoVazio(this.textFaixaInicial) || Funcoes.textoVazio(this.textFaixaInicial) || Integer.parseInt(this.textFaixaInicial.getText()) >= Integer.parseInt(this.textFaixaFinal.getText()))) {
            Funcoes.mensagem(this, "Valor da faixa n\u00e3o preenchida ou inicial maior que a final!", 1);
            return false;
        }
        if (this.checkUtilizaFaixa.isSelected() && (Funcoes.textoVazio(this.textUltimaFaixa) || Integer.parseInt(this.textUltimaFaixa.getText()) > Integer.parseInt(this.textFaixaFinal.getText()) || Integer.parseInt(this.textUltimaFaixa.getText()) < Integer.parseInt(this.textFaixaInicial.getText()))) {
            Funcoes.mensagem(this, "\u00daltima faixa n\u00e3o preenchida ou fora do intervalo!", 1);
            return false;
        }
        return true;
    }
}

