/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.rede;

import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class CampoRede {
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_RESULTADO = "resultado";
    public static final String TAG_COMETARIO = "comentario";
    public static final String TAG_METODO = "metodo";
    private String codigo;
    private String comentario;

    public String getComentario() {
        return this.comentario;
    }

    public CampoRede(String codigo, String comentario) {
        this.codigo = codigo;
        this.comentario = comentario;
    }

    public CampoRede(String xml) {
        this.setXml(xml);
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void escreveXml(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(TAG_CAMPO);
        xml.escrever(TAG_CODIGO, this.codigo);
        xml.escrever(TAG_COMETARIO, this.comentario);
        xml.fechar(TAG_CAMPO);
    }

    private void setXml(String xml) {
        String xmlCampo = StringUtil.getValor(xml, TAG_CAMPO);
        this.codigo = StringUtil.getValor(xmlCampo, TAG_CODIGO);
        this.comentario = StringUtil.getValor(xmlCampo, TAG_COMETARIO);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CampoRede) {
            CampoRede outroCampo = (CampoRede)obj;
            return this.codigo.equalsIgnoreCase(outroCampo.getCodigo());
        }
        return false;
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }
}

