/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.reacao.CampoReacao;
import jalis.laboratorio.util.parsers.reacao.DadoAdicional;
import jalis.laboratorio.util.parsers.reacao.ExameReacao;
import jalis.laboratorio.util.parsers.reacao.ImportacaoReacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JProgressBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoReacao {
    public static Set<ExameReacao> importarExamesReacao(File xml, int codigoLabExterno, JProgressBar progress, ImportacaoReacao telaImportacao) {
        HashSet<ExameReacao> examesNovos = new HashSet<ExameReacao>();
        boolean arquivoResultado = false;
        String textoXml = "";
        try {
            textoXml = StringUtil.lerArquivoTexto(xml);
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel ler o arquivo", e1.getStackTrace());
        }
        if (!Funcoes.textoVazio(StringUtil.getValor(textoXml, "exames"))) {
            String[] exames = StringUtil.getValores(textoXml, "exame");
            for (int i = 0; i < exames.length; ++i) {
                ExameReacao exaReacao = new ExameReacao();
                exaReacao.setCodigoExame(StringUtil.getValor(exames[i], "codigo_exame"));
                exaReacao.setNomeExame(StringUtil.getValor(exames[i], "nome_exame"));
                exaReacao.setCodigoMaterialPadrao(StringUtil.getValor(exames[i], "codigo_material_padrao"));
                exaReacao.setNomeMaterialPadrao(StringUtil.getValor(exames[i], "nome_material_padrao"));
                examesNovos.add(exaReacao);
            }
        }
        HashSet<ExameReacao> examesExcluidos = new HashSet<ExameReacao>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                Map<String, ExameReacao> examesAntigosRelac = ParserImportacaoReacao.examesMap(ParserImportacaoReacao.getExamesRelacionados(codigoLabExterno));
                Set<ExameReacao> examesAntigos = ParserImportacaoReacao.loadExamesReacao(st);
                if (arquivoResultado) {
                    String erros;
                    for (ExameReacao ex : examesNovos) {
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 5, ex.getCodigoExame(), ex.getCodigoMaterialPadrao());
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    if ((erros = ParserImportacaoReacao.inserirExamesReacao(examesNovos, st, codigoLabExterno, progress)) != null) {
                        telaImportacao.anexarTextoInformacoes(erros);
                    }
                    HashSet<ExameReacao> examesNovosRel = new HashSet<ExameReacao>(examesNovos);
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (ExameReacao ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        ExameReacao exAntigo = examesAntigosRelac.get(ex.getCodigoExame());
                        ex.setExameJalis(exAntigo.getExameJalis());
                        ex.setMaterialJalis(exAntigo.getMaterialJalis());
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), StringUtil.textoDB(ex.getXml()));
                    }
                } else {
                    String erros;
                    IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 5, new Object[0]);
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    if ((erros = ParserImportacaoReacao.inserirExamesReacao(examesNovos, st, codigoLabExterno, progress)) != null) {
                        telaImportacao.anexarTextoInformacoes(erros);
                    }
                    HashSet<ExameReacao> examesNovosRel = new HashSet<ExameReacao>(examesNovos);
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (ExameReacao ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        ExameReacao exAntigo = examesAntigosRelac.get(ex.getCodigoExame());
                        ex.setExameJalis(exAntigo.getExameJalis());
                        ex.setMaterialJalis(exAntigo.getMaterialJalis());
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), StringUtil.textoDB(ex.getXml()));
                    }
                    examesExcluidos.addAll(examesAntigos);
                    examesExcluidos.removeAll(examesNovos);
                    HashSet<ExameReacao> examesExcluidosRel = new HashSet<ExameReacao>(examesAntigosRelac.values());
                    examesExcluidosRel.removeAll(examesNovos);
                    for (ExameReacao ex : examesExcluidosRel) {
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), null);
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return examesExcluidos;
    }

    private static Map<String, ExameReacao> examesMap(Collection<ExameReacao> exames) {
        HashMap<String, ExameReacao> examesMap = new HashMap<String, ExameReacao>();
        for (ExameReacao ex : exames) {
            examesMap.put(ex.getCodigoExame(), ex);
        }
        return examesMap;
    }

    private static Hashtable<String, String> getMateriais(List<Element> elements) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (Element e : elements) {
            hash.put(e.getAttribute("codigo_exame"), e.getAttribute("nome_exame"));
        }
        return hash;
    }

    private static HashSet<ExameReacao> getExames(List<Element> elements) {
        HashSet<ExameReacao> exames = new HashSet<ExameReacao>();
        for (Element e : elements) {
            ExameReacao exa = new ExameReacao(e);
            exames.add(exa);
        }
        return exames;
    }

    private static Set<ExameReacao> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, c.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.lae_codigo = c.lae_codigo ");
                bui.append("where \n");
                bui.append(" c.ele_xmllabexterno <> '' and c.ele_xmllabexterno is not null and \n");
                bui.append(" b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append(" b.lae_codigo = ").append(codigoLabExterno);
                return ExameReacao.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameReacao>();
    }

    private static String inserirExamesReacao(Set<ExameReacao> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        String erros = "";
        for (ExameReacao ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ep.getCodigoExame())) continue;
            if (ep.getCodigoMaterialPadrao() == null || Funcoes.textoVazio(ep.getCodigoMaterialPadrao())) {
                erros = erros + "Faltando material para o exame \"" + ep.getCodigoExame() + "\".\n";
                continue;
            }
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 5, ep.getCodigoExame(), ep.getCodigoMaterialPadrao(), StringUtil.textoDB(ep.getNomeExame()), StringUtil.textoDB(ep.getNomeMaterialPadrao()), StringUtil.textoDB(ep.getXml()));
        }
        if (!Funcoes.textoVazio(erros)) {
            return erros;
        }
        return null;
    }

    public static ArrayList<ExameReacao> importarDadosAdicionais(File fileDadosAdicionais, int codigoLabExterno, JProgressBar progress) {
        try {
            List<DadoAdicional> dadosAdicionais = ParserImportacaoReacao.loadDadosAdicionais(fileDadosAdicionais);
            Statement st = Conexao.getStatement();
            if (dadosAdicionais.size() > 0) {
                ArrayList<ExameReacao> examesAtualizados = new ArrayList<ExameReacao>();
                StringBuilder bui = new StringBuilder();
                Set<ExameReacao> examesReacao = null;
                for (int i = 0; i < dadosAdicionais.size(); ++i) {
                    DadoAdicional dados = dadosAdicionais.get(i);
                    examesReacao = ParserImportacaoReacao.loadExamesReacao(st, dados.getCodigoExame(), dados.getMaterialColeta(), dados);
                    for (ExameReacao exa : examesReacao) {
                        examesAtualizados.add(exa);
                    }
                }
                if (progress != null) {
                    progress.setMaximum(examesAtualizados.size());
                    progress.setValue(0);
                }
                for (ExameReacao ea : examesAtualizados) {
                    StringBuilder xml = new StringBuilder(ea.getXml());
                    StringUtil.setValor(xml, "<requisitos>", ea.getDadosAdicionais().getRequisitos());
                    bui.setLength(0);
                    bui.append(" select exa_codigo, mco_codigo from  examematcoletalabexterno");
                    bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao).append(" \n");
                    bui.append("    and lae_codigo = '").append(codigoLabExterno).append("' \n");
                    bui.append("    and ele_xmllabexterno ilike '%<codigo_exame>").append(ea.getCodigoExame()).append("</codigo_exame>%'");
                    bui.append("    and ele_xmllabexterno ilike '%<codigo_material_padrao>").append(ea.getCodigoMaterialPadrao()).append("</codigo_material_padrao>%'");
                    ResultSet rs = Conexao.executeQuery(st, bui.toString());
                    if (rs.next()) {
                        ea.setExameJalis(rs.getString("exa_codigo"));
                        ea.setMaterialJalis(rs.getString("mco_codigo"));
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ea.getExameJalis(), Integer.parseInt(ea.getMaterialJalis()), xml.toString());
                    }
                    IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 5, ea.getCodigoExame(), ea.getCodigoMaterialPadrao(), null, null, xml);
                    progress.setValue(progress.getValue() + 1);
                }
                Conexao.arquivaSQL();
                return examesAtualizados;
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoReacao: 303");
            return null;
        }
        return null;
    }

    private static List<DadoAdicional> loadDadosAdicionais(File file) throws Exception {
        String[] linhas;
        ArrayList<DadoAdicional> dadosAdicionais = new ArrayList<DadoAdicional>();
        String dados = StringUtil.lerArquivoTexto(file);
        for (String s : linhas = dados.split("\n")) {
            String[] linha = s.split(";");
            if (linha.length != 4) continue;
            String codigo = StringUtil.removeCaractere(linha[0], '\"');
            DadoAdicional dado = new DadoAdicional();
            dado.setRequisitos(StringUtil.removeCaractere(linha[2], '\"'));
            dado.setMaterialColeta(StringUtil.removeCaractere(linha[3], '\"'));
            dado.setCodigoExame(StringUtil.removeCaractere(linha[0], '\"'));
            dadosAdicionais.add(dado);
        }
        return dadosAdicionais;
    }

    private static Set<ExameReacao> loadExamesReacao(Statement st) throws SQLException {
        HashSet<ExameReacao> exames = new HashSet<ExameReacao>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo, lae_codigo, rea_codexame, rea_codmaterial, rea_descricaoexame, rea_descricaomaterial, rea_xml ");
        sql.append("   from examesReacao ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameReacao e = new ExameReacao(rs.getString("rea_xml"));
            e.setCodigoExame(rs.getString("rea_codexame"));
            e.setNomeExame(rs.getString("rea_descricaoexame"));
            e.setCodigoMaterialPadrao(rs.getString("rea_codmaterial"));
            e.setNomeMaterialPadrao(rs.getString("rea_descricaomaterial"));
            exames.add(e);
        }
        return exames;
    }

    private static Set<ExameReacao> loadExamesReacao(Statement st, String codigoExame, String material, DadoAdicional dadosAdicionais) throws SQLException {
        HashSet<ExameReacao> exames = new HashSet<ExameReacao>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo, lae_codigo, rea_codexame, rea_codmaterial, rea_descricaoexame, rea_descricaomaterial, rea_xml ");
        sql.append("   from examesReacao ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append("    and rea_codexame = '").append(codigoExame).append("' ");
        sql.append("    and rea_descricaomaterial = '").append(material).append("' ");
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameReacao e = new ExameReacao(rs.getString("rea_xml"));
            e.setCodigoExame(rs.getString("rea_codexame"));
            e.setNomeExame(rs.getString("rea_descricaoexame"));
            e.setCodigoMaterialPadrao(rs.getString("rea_codmaterial"));
            e.setNomeMaterialPadrao(rs.getString("rea_descricaomaterial"));
            e.setDadosAdicionais(dadosAdicionais);
            exames.add(e);
        }
        return exames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ExameReacao> importarCamposDeResultado(File fileDados, int codigoLabExterno, JProgressBar progress) throws SalvaDadosException {
        ArrayList<ExameReacao> arrayList;
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        try {
            List<ExameReacao> examesReacao = ParserImportacaoReacao.loadCamposDeResultado(fileDados);
            ArrayList<ExameReacao> examesAtualizado = new ArrayList<ExameReacao>();
            for (ExameReacao exameReacao : examesReacao) {
                ExameReacao exameReacaoAntigo;
                if (Funcoes.textoVazio(exameReacao.getCodigoMaterialPadrao())) continue;
                bui.setLength(0);
                bui.append("select rea_xml from examesreacao  ");
                bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao).append(" \n");
                bui.append("    and lae_codigo = ").append(codigoLabExterno);
                bui.append("    and rea_codexame = '").append(exameReacao.getCodigoExame()).append("' \n");
                bui.append("    and rea_codmaterial = ").append(exameReacao.getCodigoMaterialPadrao()).append(" \n");
                ResultSet rs = Conexao.executeQuery(st, bui);
                if (!rs.next() || (exameReacaoAntigo = new ExameReacao(rs.getString("rea_xml"))).getCampos().containsAll(exameReacao.getCampos())) continue;
                exameReacao.setNomeMaterialPadrao(exameReacaoAntigo.getNomeMaterialPadrao());
                exameReacao.setDadosAdicionais(exameReacaoAntigo.getDadosAdicionais());
                IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 5, exameReacao.getCodigoExame(), exameReacao.getCodigoMaterialPadrao(), null, null, StringUtil.textoDB(exameReacao.getXml()));
                examesAtualizado.add(exameReacao);
            }
            Conexao.arquivaSQL();
            arrayList = examesAtualizado;
        }
        catch (SQLException e) {
            ArrayList<ExameReacao> arrayList2;
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoReacao");
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return arrayList2;
        }
        Conexao.fecharStatement(st);
        return arrayList;
    }

    public static TreeMap<String, List<ExameReacao>> loadDadosExame(File file, String codPosto) {
        TreeMap<String, List<ExameReacao>> requisicoesReacao = new TreeMap<String, List<ExameReacao>>();
        Document doc = ParserImportacaoReacao.analisarXML(file);
        if (doc == null) {
            return requisicoesReacao;
        }
        Element raiz = doc.getDocumentElement();
        for (Element e : XMLUtil.getElementosFilhos(raiz)) {
            if (!e.getNodeName().equalsIgnoreCase("exame") || !e.getAttribute("CD_POSTO").equalsIgnoreCase(codPosto)) continue;
            if (requisicoesReacao.containsKey(e.getAttribute("CD_REQUISICAO"))) {
                requisicoesReacao.get(e.getAttribute("CD_REQUISICAO")).add(ParserImportacaoReacao.parseExameCadastro(e));
                continue;
            }
            ArrayList<ExameReacao> resultadosExames = new ArrayList<ExameReacao>();
            resultadosExames.add(ParserImportacaoReacao.parseExameCadastro(e));
            requisicoesReacao.put(e.getAttribute("CD_REQUISICAO"), resultadosExames);
        }
        return requisicoesReacao;
    }

    private static Document analisarXML(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private static List<ExameReacao> loadCamposDeResultado(File file) {
        ArrayList<ExameReacao> examesReacao = new ArrayList<ExameReacao>();
        Document doc = ParserImportacaoReacao.analisarXML(file);
        if (doc == null) {
            return examesReacao;
        }
        Element raiz = doc.getDocumentElement();
        for (Element e : XMLUtil.getElementosFilhos(raiz)) {
            ExameReacao exameReacao = null;
            if (e.getNodeName().equalsIgnoreCase("exame")) {
                exameReacao = new ExameReacao();
                for (Element exame : XMLUtil.getElementosFilhos(e)) {
                    if (exame.getNodeName().equals("codigo_exame")) {
                        exameReacao.setCodigoExame(exame.getTextContent());
                        continue;
                    }
                    if (exame.getNodeName().equals("nome_exame")) {
                        exameReacao.setNomeExame(exame.getTextContent());
                        continue;
                    }
                    if (exame.getNodeName().equals("codigo_material_padrao")) {
                        exameReacao.setCodigoMaterialPadrao(exame.getTextContent());
                        continue;
                    }
                    if (!exame.getNodeName().equals("layout_resultado")) continue;
                    exameReacao.setCampos(ParserImportacaoReacao.parseLayoutResultado(exame, exameReacao));
                }
            }
            if (exameReacao == null) continue;
            examesReacao.add(exameReacao);
        }
        return examesReacao;
    }

    private static ArrayList<CampoReacao> parseLayoutResultado(Element exame, ExameReacao exameReacao) {
        ArrayList<CampoReacao> camposReacao = new ArrayList<CampoReacao>();
        String codigoLayout = "";
        for (Element ele : XMLUtil.getElementosFilhos(exame)) {
            if (ele.getNodeName().equals("codigo_grupo_layout")) {
                codigoLayout = ele.getTextContent();
                continue;
            }
            if (!ele.getNodeName().equals("campos")) continue;
            for (Element campos : XMLUtil.getElementosFilhos(ele)) {
                if (!campos.getNodeName().equals("campo")) continue;
                StringBuilder comentarioNum = new StringBuilder();
                StringBuilder comentarioText = new StringBuilder();
                String codigo = "";
                String codigoNum = "";
                String codigoText = "";
                for (Element campo : XMLUtil.getElementosFilhos(campos)) {
                    if (campo.getNodeName().equals("id_campo")) {
                        codigo = campo.getTextContent();
                        codigoNum = campo.getTextContent().concat("_N");
                        codigoText = campo.getTextContent().concat("_T");
                        continue;
                    }
                    if (!campo.getNodeName().equals("de_campo")) continue;
                    comentarioNum.append(StringUtil.removerAcentos(campo.getTextContent()));
                    comentarioText.append(StringUtil.removerAcentos(campo.getTextContent()));
                }
                comentarioNum.append(" Resultado num\u00e9rico ").append(" Lay. Cod: ").append(codigoLayout);
                comentarioText.append(" Resultado texto ").append(" Lay. Cod: ").append(codigoLayout);
                camposReacao.add(new CampoReacao(codigoNum, comentarioNum.toString()));
                camposReacao.add(new CampoReacao(codigoText, comentarioText.toString()));
                camposReacao.add(new CampoReacao(codigo.concat("_UNIDADE"), "Unidade de Medida"));
            }
        }
        return camposReacao;
    }

    private static ExameReacao parseExameCadastro(Element e) {
        ExameReacao exameReacao = new ExameReacao();
        exameReacao.setCodigoExame(e.getAttribute("CD_EXAME"));
        exameReacao.setUsuario(e.getAttribute("ID_USUARIO"));
        for (Element el : XMLUtil.getElementosFilhos(e)) {
            if (el.getNodeName().toUpperCase().equals("RESULTADO")) {
                if (!Funcoes.textoVazio(el.getAttribute("VL_RESULTADO_NUMERICO"))) {
                    exameReacao.setCampo(new CampoReacao(el.getAttribute("ID_CAMPO").concat("_N"), el.getAttribute("DE_CAMPO").concat(" - resultado n\u00famero"), el.getAttribute("VL_RESULTADO_NUMERICO")));
                }
                if (!Funcoes.textoVazio(el.getAttribute("VL_RESULTADO_CARACTER"))) {
                    exameReacao.setCampo(new CampoReacao(el.getAttribute("ID_CAMPO").concat("_T"), el.getAttribute("DE_CAMPO").concat(" - resultado caracter"), el.getAttribute("VL_RESULTADO_CARACTER")));
                }
                if (Funcoes.textoVazio(el.getAttribute("ID_UNIDADE"))) continue;
                exameReacao.setCampo(new CampoReacao(el.getAttribute("ID_CAMPO").concat("_UNIDADE"), "Unidade de Medida", el.getAttribute("ID_UNIDADE")));
                continue;
            }
            if (el.getNodeName().toUpperCase().equals("VALOR_REFERENCIA")) {
                exameReacao.setCampo(new CampoReacao("VALOR_REFERENCIA".concat(el.getAttribute("ID")), "Valor de refer\u00eancia ".concat(el.getAttribute("ID")), el.getAttribute("VALOR_REFERENCIA")));
                continue;
            }
            if (!el.getNodeName().toUpperCase().equals("VALOR_REFERENCIA_BLOCO")) continue;
            exameReacao.setCampo(new CampoReacao("VALOR_REFERENCIA_BLOCO".concat(el.getAttribute("ID")), "Valor de refer\u00eancia bloco".concat(el.getAttribute("ID")), el.getAttribute("VALOR_REFERENCIA_BLOCO")));
        }
        return exameReacao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] validaArquivo(String arquivoResultados, int codigoLabExterno) {
        Statement st;
        String codPosto;
        block6: {
            String[] stringArray;
            codPosto = "";
            if (!arquivoResultados.substring(0, 1).equals("R")) {
                return new String[]{"Arquivo de resultado sem o prefixo 'R' provavelmente n\u00e3o \u00e9 um arquivo de resultados!"};
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("Select lae_configuracao from labexterno ");
            buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                String codLabReacao = "";
                if (rs.next()) {
                    codLabReacao = Funcoes.preencheZero(StringUtil.getValor(rs.getString("lae_configuracao"), "laboratorio"), 3);
                    codPosto = Funcoes.preencheZero(StringUtil.getValor(rs.getString("lae_configuracao"), "posto"), 3);
                }
                if (arquivoResultados.substring(1, 4).equals(codLabReacao)) break block6;
                stringArray = new String[]{"Arquivo de resultado n\u00e3o pertence ao laborat\u00f3rio que est\u00e1 tentando importar!"};
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ParserImportacaoReacao");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return stringArray;
        }
        Conexao.fecharStatement(st);
        return new String[]{"", codPosto};
    }
}

