/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.reacao.CampoReacao;
import jalis.laboratorio.util.parsers.reacao.ExameReacao;
import jalis.laboratorio.util.parsers.reacao.ParserImportacaoReacao;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.w3c.dom.Document;

public class ImportacaoResultadoReacao
extends AbstractImportadorResultadoLabExterno {
    private static final String FORMATO = "formato";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final String VERSAO_EXAME = "versaoExameLabExterno";
    private ModeloGridTable modeloRelatorio;
    private JButton buttonImprimir;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoReacao(int codigoLabExterno) {
        Statement st;
        block4: {
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Rea\u00e7\u00e3o", codigoLabExterno, Protocolo.Reacao, new JPanel(new FlowLayout(2)));
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            this.getPanelAdicional().add(this.buttonImprimir);
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoReacao (105)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void importarResultado() {
        block33: {
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Rea\u00e7\u00e3o (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) != 0) break block33;
            String[] retorno = ParserImportacaoReacao.validaArquivo(chooser.getSelectedFile().getName(), this.codigoLabExterno);
            if (!Funcoes.textoVazio(retorno[0])) {
                this.setTextoInformacoes(retorno[0]);
                return;
            }
            if (retorno.length < 2) {
                this.setTextoInformacoes("\nC\u00f3digo do posto n\u00e3o configurado!");
                return;
            }
            Document doc = null;
            try {
                doc = XMLUtil.analisarXML(chooser.getSelectedFile());
            }
            catch (Exception e1) {
                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo.\n" + e1.getMessage());
                return;
            }
            if (doc == null) {
                this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + chooser.getSelectedFile().getPath());
                return;
            }
            TreeMap<String, List<ExameReacao>> resultadosExames = ParserImportacaoReacao.loadDadosExame(new File(chooser.getSelectedFile().getPath()), retorno[1]);
            if (resultadosExames == null || resultadosExames.size() == 0) {
                this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                return;
            }
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            if (st == null) {
                return;
            }
            try {
                Registro reg;
                String requisicao;
                String filial;
                this.progress.setValue(0);
                this.progress.setMaximum(resultadosExames.size());
                this.progress.setVisible(true);
                Set<String> requisicoes = resultadosExames.keySet();
                for (String filialRequisicao : requisicoes) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    filial = Funcoes.getFilialRequisicao(filialRequisicao)[0];
                    requisicao = Funcoes.getFilialRequisicao(filialRequisicao)[1];
                    for (ExameReacao exResultado : resultadosExames.get(filialRequisicao)) {
                        Registro formatacao;
                        reg = this.localizaExameRequisicao(requisicao, exResultado, st, filial);
                        if (reg == null) continue;
                        if (this.exameLancado(reg)) {
                            this.adicionarAoModeloRelatorio(requisicao, filial, exResultado, Situacao.JA_LANCADO);
                            continue;
                        }
                        if (!this.exameColetado(reg)) {
                            this.adicionarAoModeloRelatorio(requisicao, filial, exResultado, Situacao.SEM_MATERIAL);
                            continue;
                        }
                        if (!this.exameRelacionado(reg)) {
                            this.adicionarAoModeloRelatorio(requisicao, filial, exResultado, Situacao.SEM_RELACIONAMENTO);
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
                            continue;
                        }
                        boolean salvoParcial = reg.getString("exr_situacao").equals("P");
                        Registro registro = formatacao = salvoParcial ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                        if (formatacao == null) {
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
                            continue;
                        }
                        String fil_codigo = filialRequisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String req_codigo = filialRequisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                        ExameReacao exReacaoSalvo = new ExameReacao(reg.getString("ele_xmllabexterno"));
                        Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                        for (CampoReacao campo : exResultado.getCampos()) {
                            dados.put(campo.getCodigo(), campo.getResultado());
                        }
                        Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(fil_codigo, req_codigo, reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                        dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                        Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                        if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                            historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                        }
                        Resultado res = new Resultado(formatacao.getString(FORMATO), dados, resAnterior, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"));
                        res.atualizarComponentes();
                        if (!res.verificarCondicao()) {
                            this.adicionarAoModeloRelatorio(requisicao, filial, exResultado, Situacao.CONDICAO_INSATISFEITA);
                            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                            continue;
                        }
                        boolean completo = true;
                        if (reg.getBoolean("exa_salvaparcial")) {
                            completo = res.resultadoCompleto(true);
                        }
                        String novaSituacao = completo ? "L" : "P";
                        String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                        Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                        boolean marcarConferido = false;
                        if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null) {
                            int verificacao = res.verificarValidacao();
                            boolean bl = marcarConferido = verificacao == 1;
                            if (!marcarConferido && verificacao != 2) {
                                this.adicionarAoModeloRelatorio(requisicao, filial, exResultado, Situacao.VALIDACAO_INSATISFEITA);
                                this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                            }
                        }
                        boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                        boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                        this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                        if (this.exportarBaseWeb(filial)) {
                            Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st, filial, req_codigo, reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                            this.exportarParaWeb(st, this.getCodigoBaseWeb(filial), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                            if (ExportaWeb.isGerarPdfResultado(st, filial)) {
                                ExportaWeb.enviarResultadoPDF(st, filial, req_codigo, this.getCodigoBaseWeb(fil_codigo));
                            }
                        }
                        this.adicionarAoModeloRelatorio(requisicao, filial, exResultado, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE);
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                        ExportaWeb.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), Variaveis.codigoBaseWeb);
                        ExportaFiliais.gravaRequisicao(reg.getInt("fil_codigo"), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
                        this.atualizarSituacaoExameInterfaceamento(st, reg);
                        this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)), false);
                    }
                }
                for (String filialRequisicao : requisicoes) {
                    filial = Funcoes.getFilialRequisicao(filialRequisicao)[0];
                    requisicao = Funcoes.getFilialRequisicao(filialRequisicao)[1];
                    for (ExameReacao exResultado : resultadosExames.get(filialRequisicao)) {
                        reg = this.localizaExameRequisicao(requisicao, exResultado, st, filial);
                        if (reg == null) continue;
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, st, st2);
                        }
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                        }
                        if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) {
                            PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RESULTADO, st, st2);
                        }
                        if (!this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), st2)) continue;
                        WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RESULTADO, st, st2);
                    }
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 69");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
            this.progress.setVisible(false);
        }
    }

    private Registro localizaExameRequisicao(String requisicao, ExameReacao exame, Statement st, String filial) throws Exception {
        if (!this.validaExameRelacionamento(exame, st, filial, requisicao)) {
            if (exame.getExameJalis() == null || exame.getMaterialJalis() == null) {
                this.setTextoInformacoes(String.format("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame rea\u00e7\u00e3o %s na requisi\u00e7\u00e3o do Jalis. C\u00f3digo: %s ", exame.getCodigoExame(), requisicao), false);
                return null;
            }
            this.adicionarAoModeloRelatorio(requisicao, filial, exame, Situacao.SEM_COD_EXM_LAB);
            return null;
        }
        String exa = exame.getExameJalis();
        String mco = exame.getMaterialJalis();
        if (Funcoes.textoVazio(requisicao)) {
            this.adicionarAoModeloRelatorio(requisicao, filial, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis.", false);
            return null;
        }
        if (Funcoes.textoVazio(exa) || Funcoes.textoVazio(mco)) {
            this.adicionarAoModeloRelatorio(requisicao, filial, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis. C\u00f3digo: " + requisicao, false);
            return null;
        }
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, f.met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, f.ele_xmllabexterno, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
        sql.append("  a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join examematcoletalabexterno f on e.fil_codigo = f.fil_codigo and e.exa_codigo = f.exa_codigo and e.mco_codigo = f.mco_codigo and f.lae_codigo = ").append(this.codigoLabExterno);
        sql.append(" where \n");
        sql.append("  a.fil_codigo = ").append(filial).append(" and \n");
        sql.append("  a.req_codigo = ").append(requisicao).append(" and \n");
        sql.append("  b.exa_codigo = '").append(exa).append("' and \n");
        sql.append("  b.mco_codigo = ").append(mco);
        sql.append("  and a.req_excluida = false and b.exr_excluido = false ");
        sql.append("  and f.ele_xmllabexterno <> '' and f.ele_xmllabexterno is not null ");
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(filial, reg.getString(CODIGO_LAYOUT)));
            Registro formatacao = new Registro();
            formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor(FORMATACAO, formatacao);
            return reg;
        }
        this.adicionarAoModeloRelatorio(requisicao, filial, exame, Situacao.NAO_LOCALIZADO);
        return null;
    }

    private boolean validaExameRelacionamento(ExameReacao exame, Statement st, String fil_codigo, String codRequisicao) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select d.mco_codigo , d.exa_codigo ");
        sql.append("from examesreacao a ");
        sql.append("left join loteexternorequisicao b on a.fil_codigo =  b.fil_codigo and a.lae_codigo = b.lae_codigo ");
        sql.append("left join loteexternoexamerequisicao c on b.fil_codigo = c.fil_codigo and b.fil_kodigo = c.fil_kodigo and b.req_codigo = c.req_codigo and b.lex_codigo = c.lex_codigo ");
        sql.append("left join examematcoletalabexterno e on c.fil_codigo = e.fil_codigo and c.exa_codigo = e.exa_codigo and c.mco_codigo = e.mco_codigo and c.lae_codigo = e.lae_codigo ");
        sql.append("left join examematcoleta d on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and c.mco_codigo = d.mco_codigo ");
        sql.append("where c.fil_kodigo = ").append(fil_codigo);
        sql.append("  and a.rea_codexame = '").append(exame.getCodigoExame()).append("'");
        sql.append("  and b.req_codigo = ").append(codRequisicao);
        sql.append("  and a.lae_codigo = ").append(this.codigoLabExterno);
        sql.append("  and e.ele_xmllabexterno is not null and e.ele_xmllabexterno <> '' ");
        sql.append("and e.ele_xmllabexterno ilike '%<codigo_exame>").append(exame.getCodigoExame()).append("</codigo_exame>%' ");
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        boolean retorno = rs.next();
        if (retorno) {
            exame.setExameJalis(rs.getString("exa_codigo"));
            exame.setMaterialJalis(rs.getString("mco_codigo"));
            retorno = !rs.next();
        }
        return retorno;
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco).append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno  <> '' and ele_xmllabexterno  is not null ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo_exame");
                    mco = StringUtil.getValor(xml, "codigo_material_padrao");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select rea_xml from examesreacao where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and rea_codexame = '").append(exa).append("' and rea_codmaterial = ").append(mco);
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("rea_xml", rs.getString("rea_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void adicionarAoModeloRelatorio(String requisicao, String filial, ExameReacao exame, Situacao situacao) throws Exception {
        if (exame.getExameJalis() == null) {
            throw new Exception("N\u00e3o foi localizada associa\u00e7\u00e3o para o exame \"" + exame.getCodigoExame() + "\" do lab. rea\u00e7\u00e3o.");
        }
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, requisicao, exame.getExameJalis(), Integer.parseInt(exame.getMaterialJalis()), situacao.descricao);
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_COD_EXM_LAB("XML sem campo CodExmLab"),
        SEM_MATERIAL("Sem material");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

