/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.reacao.ExameReacao;
import jalis.laboratorio.util.parsers.reacao.ParserImportacaoReacao;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;

public class ImportacaoReacao
extends AbstractImportadorLabExterno {
    private JButton buttonImportarDadosAdicionais = ComponenteFactory.novoJButton("Importar Dados Adicionais", 'D', this);
    private JButton buttonImportarCamposdeResultado = ComponenteFactory.novoJButton("Importar Campos de Resultado", 'R', this);

    public ImportacaoReacao(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Rea\u00e7\u00e3o a partir de arquivo XML", codigoLabExterno, Protocolo.Reacao);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarDadosAdicionais, 1);
        this.getPanelBotoes().add((Component)this.buttonImportarCamposdeResultado, 2);
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
        this.buttonImportarDadosAdicionais.setEnabled(habilitar);
        this.buttonImportarCamposdeResultado.setEnabled(habilitar);
    }

    @Override
    public void anexarTextoInformacoes(String texto) {
        super.anexarTextoInformacoes(texto);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Rea\u00e7\u00e3o (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                this.setTextoInformacoes("");
                this.anexarTextoInformacoes("Importando exames...\n");
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Set<ExameReacao> excluidos = ParserImportacaoReacao.importarExamesReacao(file, this.codigoLabExterno, this.progress, this);
                this.anexarTextoInformacoes("\nImporta\u00e7\u00e3o conclu\u00edda");
                Thread.sleep(50L);
                if (excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("+--------------------------------------------------+------------------------------+\n");
                    bui.append("|                     EXAME                        |           MATERIAL           |\n");
                    bui.append("+--------------------------------------------------+------------------------------+");
                    for (ExameReacao e : excluidos) {
                        bui.append("\n|").append(StringUtil.formatarColuna(e.getNomeExame(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getNomeMaterialPadrao(), 30, 'c')).append("|");
                    }
                    bui.append("\n+--------------------------------------------------+------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. Rea\u00e7\u00e3o - " + e.getMessage(), e.getStackTrace());
        }
        this.progress.setVisible(false);
        return retorno;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportarDadosAdicionais) {
            this.habilitarBotoes(false);
            new Thread("Thread de Importa\u00e7\u00e3o de Dados Adicionais"){

                @Override
                public void run() {
                    ImportacaoReacao.this.importarDadosAdicionais();
                }
            }.start();
        } else if (e.getSource() == this.buttonImportarCamposdeResultado) {
            this.habilitarBotoes(false);
            new Thread("Thread de Importa\u00e7\u00e3o de Campos de Resultados"){

                @Override
                public void run() {
                    ImportacaoReacao.this.importarCamposdeResultado();
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    private void importarCamposdeResultado() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Rea\u00e7\u00e3o (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                bui.append("Importando dados adicionais...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setVisible(true);
                ArrayList<ExameReacao> examesAtualizados = ParserImportacaoReacao.importarCamposDeResultado(file, this.codigoLabExterno, this.progress);
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (examesAtualizados != null && examesAtualizados.size() > 0) {
                    bui.append("\n\nOs exames abaixo foram atualizados: \n\n");
                    bui.append("+--------------------------------------------------+------------------------------+\n");
                    bui.append("|                     EXAME                        |           MATERIAL           |\n");
                    bui.append("+--------------------------------------------------+------------------------------+");
                    for (ExameReacao e : examesAtualizados) {
                        bui.append("\n|").append(StringUtil.formatarColuna(e.getNomeExame(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getNomeMaterialPadrao(), 30, 'c')).append("|");
                    }
                    bui.append("\n+--------------------------------------------------+------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                } else {
                    bui.append("\nNenhum exame necess\u00e1rio para atualizar!");
                    this.setTextoInformacoes(bui.toString());
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar dados adicionais - Lab. Rea\u00e7\u00e3o - " + e.getMessage(), e.getStackTrace());
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }

    private void importarDadosAdicionais() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo CSV do Lab. Rea\u00e7\u00e3o (*.csv)", "csv"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                bui.append("Importando dados adicionais...");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                this.progress.setVisible(true);
                ArrayList<ExameReacao> examesAtualizados = ParserImportacaoReacao.importarDadosAdicionais(file, this.codigoLabExterno, this.progress);
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (examesAtualizados != null && examesAtualizados.size() > 0) {
                    bui.append("\n\nOs exames abaixo foram atualizados: \n\n");
                    bui.append("+--------------------------------------------------+------------------------------+\n");
                    bui.append("|                     EXAME                        |           MATERIAL           |\n");
                    bui.append("+--------------------------------------------------+------------------------------+");
                    for (ExameReacao e : examesAtualizados) {
                        bui.append("\n|").append(StringUtil.formatarColuna(e.getNomeExame(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getNomeMaterialPadrao(), 30, 'c')).append("|");
                    }
                    bui.append("\n+--------------------------------------------------+------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                } else {
                    bui.append("\nNenhum exame necess\u00e1rio para atualizar!");
                    this.setTextoInformacoes(bui.toString());
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar dados adicionais - Lab. Rea\u00e7\u00e3o - " + e.getMessage(), e.getStackTrace());
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }
}

