/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.reacao.CampoReacao;
import jalis.laboratorio.util.parsers.reacao.DadoAdicional;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class ExameReacao {
    private String codigoExame;
    private String nomeExame;
    private String codigoMaterialPadrao;
    private String nomeMaterialPadrao;
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;
    private String xmlJalis;
    private String usuario;
    private Integer codigoMetodo;
    private DadoAdicional dadosAdicionais = new DadoAdicional();
    private List<CampoReacao> campos = new ArrayList<CampoReacao>();
    public static final String CODIGO_EXAME = "codigo_exame";
    public static final String NOME_EXAME = "nome_exame";
    public static final String CODIGO_MATERIAL_PADRAO = "codigo_material_padrao";
    public static final String NOME_MATERIAL_PADRAO = "nome_material_padrao";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_EXAMES = "exames";
    public static final String TAG_ADICIONAIS = "adicionais";
    public static final String REQUISITOS = "requisitos";
    public static final String MATERIAL_COLETA = "material_coleta";
    public static final String TAG_CAMPOS = "campos";
    public static final String TAG_LAYOUT_RESULTADO = "layout_resultado";
    public static final String TAG_CODIGO_GRP_LAYOUT = "codigo_grupo_layout";
    public static final String TAG_DESCRICAO_GRUPO_LAYOUT = "descricao_grupo_layout";
    public static final String TAG_NU_LAYOUT = "nu_layout";

    public ExameReacao() {
    }

    public ExameReacao(String xml) {
        this.parseXml(xml);
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getXmlJalis() {
        return this.xmlJalis;
    }

    public void setXmlJalis(String xmlJalis) {
        this.xmlJalis = xmlJalis;
    }

    public String toString() {
        return this.nomeExame;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getNomeExame() {
        return this.nomeExame;
    }

    public void setNomeExame(String nomeExame) {
        this.nomeExame = nomeExame;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setCodigoMetodo(Integer codigoMetodo) {
        this.codigoMetodo = codigoMetodo;
    }

    public String getCodigoMaterialPadrao() {
        return this.codigoMaterialPadrao;
    }

    public void setCodigoMaterialPadrao(String codigoMaterialPadrao) {
        this.codigoMaterialPadrao = codigoMaterialPadrao;
    }

    public String getNomeMaterialPadrao() {
        return this.nomeMaterialPadrao;
    }

    public void setNomeMaterialPadrao(String nomeMaterialPadrao) {
        this.nomeMaterialPadrao = nomeMaterialPadrao;
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public void addDadoAdicional(DadoAdicional dadoAdicional) {
        this.dadosAdicionais = dadoAdicional;
    }

    public DadoAdicional getDadosAdicionais() {
        return this.dadosAdicionais;
    }

    public void setDadosAdicionais(DadoAdicional dadosAdicionais) {
        this.dadosAdicionais = dadosAdicionais;
    }

    public List<CampoReacao> getCampos() {
        return this.campos;
    }

    public void setCampos(List<CampoReacao> campos) {
        this.campos = campos;
    }

    public void setCampo(CampoReacao campo) {
        this.campos.add(campo);
    }

    private void setXML(String xml) {
        String exame = StringUtil.getValor(xml, TAG_EXAME);
        for (String xmlCampo : StringUtil.getValores(StringUtil.getValor(xml, TAG_CAMPOS), "campo", true)) {
            this.campos.add(new CampoReacao(StringUtil.getValor(xmlCampo, "codigo"), StringUtil.getValor(xmlCampo, "comentario")));
        }
    }

    public static Set<ExameReacao> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameReacao> list = new HashSet<ExameReacao>();
        if (res.first()) {
            do {
                list.add(new ExameReacao(res));
            } while (res.next());
        }
        return list;
    }

    public ExameReacao(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.laboratorioExternoJalis = res.getString("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    private void carregarXMLDadosAdicionais(String xml) {
        this.dadosAdicionais = new DadoAdicional();
        for (String dadoXml : StringUtil.getValores(xml, TAG_ADICIONAIS)) {
            if (Funcoes.textoVazio(dadoXml)) continue;
            String requisitos = StringUtil.getValor(dadoXml, REQUISITOS);
            String materialColeta = StringUtil.getValor(dadoXml, MATERIAL_COLETA);
            this.dadosAdicionais.setRequisitos(requisitos);
            this.dadosAdicionais.setMaterialColeta(materialColeta);
        }
    }

    public ExameReacao(Element element) {
        this();
        this.setCodigoExame(element.getAttribute(CODIGO_EXAME));
        this.setNomeExame(element.getAttribute(NOME_EXAME));
        this.setCodigoMaterialPadrao(element.getAttribute(CODIGO_MATERIAL_PADRAO));
        this.setNomeMaterialPadrao(element.getAttribute(NOME_MATERIAL_PADRAO));
        if (element.hasChildNodes()) {
            List<Element> childs = XMLUtil.getElementosFilhos(element);
            for (Element c : childs) {
                this.parseDadosAdicionais(c);
            }
        }
    }

    private void parseDadosAdicionais(Element element) {
        List<Element> filhosElement = XMLUtil.getElementosFilhos(element);
        this.dadosAdicionais = new DadoAdicional();
        for (Element e : filhosElement) {
            this.dadosAdicionais.setMaterialColeta(e.getAttribute(MATERIAL_COLETA));
            this.dadosAdicionais.setRequisitos(e.getAttribute(REQUISITOS));
        }
    }

    private void parseXml(String xml) {
        if (xml != null) {
            String exame = StringUtil.getValor(xml, TAG_EXAME);
            this.codigoExame = StringUtil.getValor(exame, CODIGO_EXAME);
            this.nomeExame = StringUtil.getValor(exame, NOME_EXAME);
            this.codigoMaterialPadrao = StringUtil.getValor(exame, CODIGO_MATERIAL_PADRAO);
            this.nomeMaterialPadrao = StringUtil.getValor(exame, NOME_MATERIAL_PADRAO);
            String dadosAux = StringUtil.getValor(xml, "dados_adicionais");
            this.dadosAdicionais.setRequisitos(StringUtil.getValor(dadosAux, REQUISITOS));
            this.dadosAdicionais.setMaterialColeta(StringUtil.getValor(dadosAux, MATERIAL_COLETA));
            for (String xmlCampo : StringUtil.getValores(StringUtil.getValor(xml, TAG_CAMPOS), "campo", true)) {
                this.campos.add(new CampoReacao(StringUtil.getValor(xmlCampo, "codigo"), StringUtil.getValor(xmlCampo, "comentario")));
            }
        }
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_EXAMES);
            xml.abrir(TAG_EXAME);
            xml.escrever(CODIGO_EXAME, this.getCodigoExame());
            xml.escrever(NOME_EXAME, this.getNomeExame());
            xml.escrever(CODIGO_MATERIAL_PADRAO, this.getCodigoMaterialPadrao());
            xml.escrever(NOME_MATERIAL_PADRAO, this.getNomeMaterialPadrao());
            if (this.dadosAdicionais != null && (this.dadosAdicionais.getRequisitos() != null || this.dadosAdicionais.getMaterialColeta() != null)) {
                xml.abrir("dados_adicionais");
                xml.escrever(REQUISITOS, this.dadosAdicionais.getRequisitos());
                xml.escrever(MATERIAL_COLETA, this.dadosAdicionais.getMaterialColeta());
                xml.fechar("dados_adicionais");
            }
            xml.abrir(TAG_CAMPOS);
            for (CampoReacao campo : this.campos) {
                campo.escreveXml(xml);
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_EXAMES);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return xml.getXML();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorReacao = StringUtil.getValor(xml, TAG_EXAMES);
        return valorReacao != null && valorReacao.trim().length() > 0 && (valorExame = StringUtil.getValor(valorReacao, TAG_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public static List<ExameReacao> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameReacao> exames = new ArrayList<ExameReacao>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select * \n");
                bui.append("   from examesreacao \n");
                bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("        lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("  order by rea_descricaoexame ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameReacao exa = new ExameReacao();
                    exa.setCodigoExame(res.getString("rea_codexame"));
                    exa.setCodigoMaterialPadrao(res.getString("rea_codmaterial"));
                    exa.setNomeMaterialPadrao(res.getString("rea_descricaomaterial"));
                    exa.setNomeExame(res.getString("rea_descricaoexame"));
                    exa.parseXml(res.getString("rea_xml"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return exames;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExameReacao)) {
            return false;
        }
        ExameReacao e = (ExameReacao)o;
        return e.codigoExame.equalsIgnoreCase(this.codigoExame);
    }

    public int hashCode() {
        return this.codigoExame.hashCode();
    }
}

