/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.reacao.ExameReacao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorReacao
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String OBJ_EXAME_REACAO = "objExameReacao";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 70, 0, 130);
    private JTextField textLocalizar = new JTextField();
    private ModeloResultSet modDadosAdicionais = new ModeloResultSet("Requisitos", "requisitos", "Material Coleta", "material_coleta");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modDadosAdicionais, null, 0, 0);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    private String xmlSelecionado = "";

    @Override
    public boolean exigeTempoDiurese() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("TEMPO DIURESE");
    }

    @Override
    public boolean exigeVolumeDiurese() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("VOLUME");
    }

    @Override
    public boolean exigePeso() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("PESO");
    }

    @Override
    public boolean exigeAltura() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("ALTURA");
    }

    @Override
    public boolean exigeJejum() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("JEJUM");
    }

    @Override
    public boolean exigeMedicamento() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("MEDICAMENTO");
    }

    @Override
    public boolean exigeDUM() {
        if (this.xmlSelecionado == null || Funcoes.textoVazio(this.xmlSelecionado)) {
            return false;
        }
        return this.xmlSelecionado.toUpperCase().contains("DUM");
    }

    public ConfiguradorReacao(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Rea\u00e7\u00e3o", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorReacao(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Laborat\u00f3rio Rea\u00e7\u00e3o", codigoLabExterno);
        this.iniciar();
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameReacao.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameReacao exa = new ExameReacao(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.equals(reg.getValor(OBJ_EXAME_REACAO))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            ExameReacao exa = new ExameReacao(xml);
            return exa.getNomeExame();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameReacao exa = new ExameReacao(xml);
            return exa.getCodigoMaterialPadrao() + "|" + exa.getCodigoExame() + "|1";
        }
        return "";
    }

    public static ConfiguradorReacao novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorReacao((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorReacao((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.scrollDadosAdicionais.setPreferredSize(new Dimension(650, 50));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), "Center");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorReacao.this.modExa.filtrar(ConfiguradorReacao.DESC_EXA, ConfiguradorReacao.this.textLocalizar.getText());
                if (ConfiguradorReacao.this.modExa.getRowCount() > 0) {
                    ConfiguradorReacao.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorReacao.this.tableExa.hasFocus() && (row = ConfiguradorReacao.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorReacao.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorReacao.this.tableExa.scrollRectToVisible(ConfiguradorReacao.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorReacao.this.tableExa.hasFocus() && (row = ConfiguradorReacao.this.tableExa.getSelectedRow()) < ConfiguradorReacao.this.tableExa.getRowCount() - 1) {
                    ConfiguradorReacao.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorReacao.this.tableExa.scrollRectToVisible(ConfiguradorReacao.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (ExameReacao exame : ExameReacao.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigoExame());
            reg.setValor(DESC_EXA, exame.getNomeExame());
            reg.setValor(MATERIAL, exame.getNomeMaterialPadrao());
            reg.setValor(OBJ_EXAME_REACAO, exame);
            this.modExa.addRegistro(reg);
        }
        this.getExameSelecionado();
    }

    @Override
    public boolean acaoOk() {
        ExameReacao exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        this.xmlSelecionado = exa.getXml();
        return true;
    }

    private ExameReacao getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameReacao)reg.getValor(OBJ_EXAME_REACAO);
        }
        return null;
    }

    private void atualizarDadosAdicionais(ExameReacao exame) {
        this.modDadosAdicionais.limpar();
        if (!(exame.getDadosAdicionais() == null || Funcoes.textoVazio(exame.getDadosAdicionais().getMaterialColeta()) && Funcoes.textoVazio(exame.getDadosAdicionais().getRequisitos()))) {
            StringTokenizer tokenizer = new StringTokenizer(exame.getDadosAdicionais().getRequisitos(), "+");
            while (tokenizer.hasMoreTokens()) {
                Registro r = new Registro();
                r.setValor("requisitos", tokenizer.nextToken().trim());
                r.setValor("material_coleta", exame.getDadosAdicionais().getMaterialColeta());
                this.modDadosAdicionais.addRegistro(r);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.atualizarDadosAdicionais((ExameReacao)reg.getValor(OBJ_EXAME_REACAO));
        }
    }
}

