/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloReacao
extends AbstractConfiguradorProtocolo {
    protected JTextField textLaboratorio = new TTextField(3, 3);
    protected JTextField textLote = new TTextField(5, 3);
    protected JTextField textPosto = new TTextField(3, 3);
    protected JCheckBox checkBoxIdPac = new JCheckBox();

    @Override
    public int getNumeroLote() {
        if (Funcoes.textoVazio(this.textLote)) {
            return 0;
        }
        return Integer.parseInt(this.textLote.getText());
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloReacao((Frame)pai, "Laborat\u00f3rio Rea\u00e7\u00e3o", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloReacao((Dialog)pai, "Laborat\u00f3rio Rea\u00e7\u00e3o", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloReacao(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloReacao(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<reacao>");
        bui.append(StringUtil.getTag("laboratorio", this.textLaboratorio.getText()));
        bui.append(StringUtil.getTag("convenio", this.textCodigo.getText()));
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        bui.append(StringUtil.getTag("posto", this.textPosto.getText()));
        bui.append(StringUtil.getTag("ignorarDigitosPaciente", String.valueOf(this.checkBoxIdPac.isSelected())));
        return bui.append("</reacao>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "reacao");
            this.textLaboratorio.setText(StringUtil.getValor(xml, "laboratorio"));
            this.textCodigo.setText(StringUtil.getValor(xml, "convenio"));
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
            this.textPosto.setText(StringUtil.getValor(xml, "posto"));
            this.checkBoxIdPac.setSelected(Boolean.parseBoolean(StringUtil.getValor(xml, "ignorarDigitosPaciente")));
        }
    }

    private void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        Dimension d = new Dimension(120, 20);
        JLabel labelLaboratorio = ComponenteFactory.novoJLabel("Laborat\u00f3rio:", d);
        JLabel labelConvenio = ComponenteFactory.novoJLabel("Conv\u00eanio:", d);
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", d);
        JLabel labelPosto = ComponenteFactory.novoJLabel("Posto Coleta:", d);
        JLabel labelQtdePac = ComponenteFactory.novoJLabel("Ignorar qtde digitos do paciente:", d);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.anchor = 17;
        this.getPanelCentral().add((Component)labelLaboratorio, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelConvenio, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelPosto, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelQtdePac, cons);
        ++cons.gridx;
        cons.gridy = 0;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.textLaboratorio.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textLaboratorio, cons);
        ++cons.gridy;
        this.textCodigo.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        ++cons.gridy;
        this.textLote.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        this.textPosto.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textPosto, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkBoxIdPac, cons);
        this.setSize(new Dimension(280, 190));
        this.setLocationRelativeTo(null);
        ScreenUtil.requisitarFoco(this.textLaboratorio);
    }

    @Override
    public boolean acaoOk() {
        return !Funcoes.textoVazio(this.textLaboratorio) && !Funcoes.textoVazio(this.textCodigo) && !Funcoes.textoVazio(this.textLote) && !Funcoes.textoVazio(this.textPosto);
    }
}

