/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.reacao;

import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class CampoReacao {
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_CODIGO = "codigo";
    public static final String TAG_ID_CAMPO = "id_campo";
    public static final String TAG_DE_CAMPO = "de_campo";
    public static final String TAG_COMETARIO = "comentario";
    private String codigo;
    private String comentario;
    private String resultado;

    public String getResultado() {
        return this.resultado;
    }

    public void setResultado(String valorResultado) {
        this.resultado = valorResultado;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public CampoReacao(String codigo, String comentario) {
        this.codigo = codigo;
        this.comentario = comentario;
    }

    public CampoReacao(String codigo, String comentario, String valoResultado) {
        this.codigo = codigo;
        this.comentario = comentario;
        this.resultado = valoResultado;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getComentario() {
        return this.comentario;
    }

    public void setComentario(String comentario) {
        this.comentario = comentario;
    }

    public void escreveXml(XMLStringBuilder xml) throws XMLStringBuilderException {
        xml.abrir(TAG_CAMPO);
        xml.escrever(TAG_CODIGO, this.codigo);
        xml.escrever(TAG_COMETARIO, this.comentario);
        xml.fechar(TAG_CAMPO);
    }

    private void setXml(String xml) {
        String xmlCampo = StringUtil.getValor(xml, TAG_CAMPO);
        this.codigo = StringUtil.getValor(xmlCampo, TAG_CODIGO);
        this.comentario = StringUtil.getValor(xmlCampo, TAG_COMETARIO);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CampoReacao) {
            CampoReacao outroCampo = (CampoReacao)obj;
            return this.codigo.equalsIgnoreCase(outroCampo.getCodigo());
        }
        return false;
    }

    public int hashCode() {
        return this.codigo.hashCode();
    }
}

