/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini.resultado;

import jalis.laboratorio.util.parsers.pardini.resultado.Elemento;

class ParserElemento {
    private final String caminho;
    private String nome;
    private String idNome;
    private String idValor;
    private int pos;

    ParserElemento(String caminho) {
        this.caminho = caminho;
        this.pos = -1;
    }

    Elemento proximoElemento() {
        this.nome = null;
        this.idNome = null;
        this.idValor = null;
        this.analisar();
        return new Elemento(this.nome, this.idNome, this.idValor);
    }

    private void analisar() {
        int posIni = this.proximo();
        if (this.pos > posIni) {
            this.nome = this.caminho.substring(posIni, this.pos);
            if (this.isChar(':')) {
                posIni = this.proximo();
                this.idNome = this.caminho.substring(posIni, this.pos);
            }
            if (this.isChar('=')) {
                posIni = this.proximo();
                this.idValor = this.caminho.substring(posIni, this.pos);
            }
        }
    }

    private int proximo() {
        int posIni = ++this.pos;
        while (!this.delimitador()) {
            ++this.pos;
        }
        return posIni;
    }

    private boolean delimitador() {
        return this.pos >= this.caminho.length() || this.caminho.charAt(this.pos) == '|' || this.caminho.charAt(this.pos) == ':' || this.caminho.charAt(this.pos) == '=';
    }

    private boolean isChar(char ch) {
        return this.pos < this.caminho.length() && this.caminho.charAt(this.pos) == ch;
    }
}

