/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini.resultado;

import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElementoHPardiniImpl
implements ElementoHPardini {
    private ElementoHPardini pai;
    private String nome;
    private String valor;
    private String atributoID;
    private Map<String, String> atrs;
    private List<ElementoHPardini> filhos;

    public ElementoHPardiniImpl(ElementoHPardini pai, String nome, String valor) {
        this.pai = pai;
        Funcoes.validarNaoNull(nome, "nome");
        this.nome = nome;
        this.valor = valor;
        this.atrs = new HashMap<String, String>();
        this.filhos = new ArrayList<ElementoHPardini>();
        this.atributoID = null;
    }

    public ElementoHPardiniImpl(ElementoHPardini pai, String nome) {
        this(pai, nome, null);
    }

    @Override
    public ElementoHPardini getPai() {
        return this.pai;
    }

    public void setNome(String nome) {
        Funcoes.validarNaoNull(nome, "nome");
        this.nome = nome;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public void setAtributo(String atr, String valor) {
        Funcoes.validarNaoNull(atr, "atr");
        Funcoes.validarNaoNull(valor, "valor");
        this.atrs.put(atr, valor);
    }

    public void setAtributoID(String atr, String valor) {
        Funcoes.validarNaoNull(atr, "valor");
        Funcoes.validarNaoNull(valor, "valor");
        this.atributoID = atr;
        this.atrs.put(this.atributoID, valor);
    }

    public void addFilho(ElementoHPardini filho) {
        Funcoes.validarNaoNull(filho, "filho");
        this.filhos.add(filho);
    }

    @Override
    public boolean contemAtributo(String atributo) {
        return this.atrs.containsKey(atributo);
    }

    @Override
    public boolean contemAtributoID() {
        return this.atributoID != null && this.atrs.containsKey(this.atributoID);
    }

    @Override
    public boolean contemAtributos() {
        return !this.atrs.isEmpty();
    }

    @Override
    public boolean contemFilho(String nome) {
        for (ElementoHPardini filho : this.filhos) {
            if (!filho.getNome().equals(nome)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contemFilhos() {
        return !this.filhos.isEmpty();
    }

    @Override
    public Set<String> getAtributos() {
        return new HashSet<String>(this.atrs.keySet());
    }

    @Override
    public Map<String, String> getMapaAtributos() {
        return new HashMap<String, String>(this.atrs);
    }

    @Override
    public ElementoHPardini getFilho(String nome) {
        for (ElementoHPardini filho : this.filhos) {
            if (!filho.getNome().equals(nome)) continue;
            return filho;
        }
        return null;
    }

    @Override
    public List<ElementoHPardini> getFilhos() {
        return new ArrayList<ElementoHPardini>(this.filhos);
    }

    @Override
    public List<ElementoHPardini> getFilhos(String nome) {
        ArrayList<ElementoHPardini> temp = new ArrayList<ElementoHPardini>();
        for (ElementoHPardini filho : this.filhos) {
            if (!filho.getNome().equals(nome)) continue;
            temp.add(filho);
        }
        if (temp.size() == 0) {
            for (ElementoHPardini filho : this.filhos) {
                for (ElementoHPardini neto : filho.getFilhos()) {
                    if (!neto.getNome().equals(nome)) continue;
                    temp.add(neto);
                }
            }
        }
        return temp;
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    @Override
    public String getNomeAtributoID() {
        return this.atributoID;
    }

    @Override
    public String getValor() {
        return this.valor;
    }

    @Override
    public String getValorAtributo(String atributo) {
        return this.atrs.get(atributo);
    }

    @Override
    public String getValorAtributoID() {
        return this.atrs.get(this.atributoID);
    }
}

