/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.util.Funcoes;
import java.util.List;

public class CamposImportacaoHPardini
implements CamposImportacao {
    private ElementoHPardini superExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;
    private String versao;

    CamposImportacaoHPardini(ElementoHPardini superExame, String codigoExamePai, Integer codigoMaterialPai, String versao) {
        Funcoes.validarNaoNull(superExame, "superExame");
        if (!superExame.getNome().equals("SuperExame")) {
            throw new InternalError("O par\u00e2metro superExame deve ser o elemento SuperExame do XML do H. Pardini");
        }
        this.superExame = superExame;
        this.codigoExamePai = codigoExamePai;
        this.codigoMaterialPai = codigoMaterialPai;
        this.versao = versao;
    }

    @Override
    public String getVersao() {
        if (!Funcoes.textoVazio(this.versao)) {
            return this.versao;
        }
        if (this.superExame.contemFilho("CodigoFormato")) {
            return this.superExame.getFilho("CodigoFormato").getValor();
        }
        StringBuilder buf = new StringBuilder();
        if (this.superExame.contemFilho("Formatos")) {
            List<ElementoHPardini> elementos = this.superExame.getFilhos("Formato");
            for (int i = 0; i < elementos.size(); ++i) {
                if (!elementos.get(i).contemFilho("CodigoFormato")) continue;
                buf.append(elementos.get(i).getFilho("CodigoFormato").getValor());
                if (i >= elementos.size() - 1) continue;
                buf.append(",");
            }
            return buf.toString();
        }
        return "0";
    }

    @Override
    public String getCodigoExameLabExterno() {
        if (this.superExame.contemFilho("CodExmApoio")) {
            String str = this.superExame.getFilho("CodExmApoio").getValor();
            return str.substring(str.indexOf(124) + 1, str.lastIndexOf(124));
        }
        return "";
    }

    @Override
    public Object getCamposImportacao() {
        return this.superExame;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public String toString() {
        return this.getVersao();
    }
}

