/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini.rastreabilidade;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.loteexterno.LoteExternoRequisicaoRastreioBean;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class TelaRastreabilidadeAmostra
extends AbstractDialogoOKCancelar {
    private JPanel panelRastro = new JPanel();
    private JTextPane lista = new JTextPane();
    private JScrollPane scroll = new JScrollPane(this.lista);

    public static TelaRastreabilidadeAmostra novaInstancia(Object pai, String titulo) {
        if (pai instanceof Dialog) {
            return new TelaRastreabilidadeAmostra((Dialog)pai, titulo);
        }
        return new TelaRastreabilidadeAmostra((Frame)pai, titulo);
    }

    public TelaRastreabilidadeAmostra(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public TelaRastreabilidadeAmostra(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.getBotaoCancelar().setVisible(false);
        this.setSize(new Dimension(300, 200));
        this.setLocationRelativeTo(Laboratorio.getInstancia());
        this.getPanelCentral().setLayout(new BorderLayout());
        this.lista.setContentType("text/html");
        this.getPanelCentral().add((Component)this.scroll, "Center");
    }

    public void setRastreabilidade(List<LoteExternoRequisicaoRastreioBean> listaRastro) {
        this.lista.setText("");
        if (this.possuiRastreio(listaRastro)) {
            StringBuilder buf = new StringBuilder("<html>");
            for (LoteExternoRequisicaoRastreioBean rastreio : listaRastro) {
                buf.append("<b>Pedido:</b> ").append(rastreio.getCodigoTubo()).append("<br>");
                buf.append("<html><b>Origem:</b> ").append(rastreio.getOrigemPedido()).append("<br>");
                buf.append("<html><b>Status:</b> ").append(rastreio.getDescricaoStatus()).append("<br>");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    String data = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", sdf.parse(rastreio.getDataHoraStatus()));
                    buf.append("<html><b>Data/Hora Status:</b> ").append(data).append("<br>");
                    buf.append("<hr/>");
                }
                catch (ParseException e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "setRastreabilidade ");
                }
            }
            buf.append("</html>");
            this.lista.setText(buf.toString());
        }
        ScreenUtil.requisitarFoco(this.scroll);
    }

    private boolean possuiRastreio(List<LoteExternoRequisicaoRastreioBean> listaRastro) {
        return listaRastro.size() > 0;
    }
}

