/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SolicitarData
extends AbstractDialogoOKCancelar {
    private TTextField textData = new TTextField(10, 4);
    private JButton buttonData = ComponenteFactory.novoJButton(this, true);

    public static SolicitarData getInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new SolicitarData((Dialog)pai, "Pesquisa");
        }
        return new SolicitarData((Frame)pai, "Pesquisa");
    }

    public SolicitarData(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public SolicitarData(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.textData, this.buttonData, this.getPanelCentral(), true);
        } else {
            super.actionPerformed(e);
        }
    }

    private void montaTela(Component pai) {
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        p.add((Component)new JLabel("Data de pesquisa"), c);
        Insets in = c.insets;
        this.textData.setPreferredSize(new Dimension(100, 20));
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets.right = 0;
        p.add((Component)this.textData, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets.right = in.right;
        c.insets.left = 0;
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        p.add((Component)this.buttonData, c);
        this.setSize(180, 120);
        this.setLocationRelativeTo(pai);
        ScreenUtil.requisitarFoco(this.textData);
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    SolicitarData.this.buttonData.doClick();
                }
            }
        });
    }

    @Override
    protected boolean acaoOk() {
        if (Funcoes.textoVazio(this.textData.getText()) || !Funcoes.verificaData(this.textData.getText())) {
            Funcoes.mensagem(this, "Data de pesquisa incorreta", 1);
            return false;
        }
        return true;
    }

    public String getDataPesquisa() {
        return this.textData.getText();
    }
}

