/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.pardini.ExameConfiguradoJSON;
import jalis.laboratorio.util.parsers.pardini.ExameSelecionado;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class SelecionarParaIntegrar
extends JDialog
implements ActionListener {
    private static final int COLUNA_SELECAO = 0;
    private static final int COLUNA_EXAME = 1;
    private static final int COLUNA_MATERIAL = 2;
    private static final int COLUNA_DESCRICAO = 3;
    private static final int COLUNA_RELACIONADO = 4;
    private static final int COLUNA_BLOQUEADO = 5;
    private static final int COLUNA_CODIGO_MATERIAL = 6;
    private static final int COLUNA_DESCRICAO_MATERIAL = 7;
    private static final int COLUNA_CODEXM = 8;
    private static final int COLUNA_DESCMAT = 9;
    private static final int COLUNA_DESCEXM = 10;
    private static final int COLUNA_CODMAT = 11;
    private static final int TAMANHO = 12;
    private JPanel panelPrincipal = new JPanel(new BorderLayout());
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es");
    private JButton buttonExportar = ComponenteFactory.novoJButton("Exportar", 'E', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem itemSelecionarTodos = ComponenteFactory.novoJMenuItem("Selecionar todos", this);
    private JMenuItem itemDesmarcarTodos = ComponenteFactory.novoJMenuItem("Desmarcar todos", this);
    private TTextField textLocalizar = new TTextField(100);
    private JCheckBox checkEnviarConfigurados = new JCheckBox("Enviar exames j\u00e1 configurados");
    private boolean isOk = false;
    private String codigoLabExterno = null;
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"Sel.", "Exame", "Mat.", "Descri\u00e7\u00e3o", "Relacionado"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    };
    private JTable tableExames = new JTable(this.modeloExames);

    public static SelecionarParaIntegrar novaInstancia(String codigoLabExterno, Window pai) {
        if (pai instanceof Dialog) {
            return new SelecionarParaIntegrar((Dialog)pai, codigoLabExterno);
        }
        return new SelecionarParaIntegrar((Frame)pai, codigoLabExterno);
    }

    private SelecionarParaIntegrar(Frame pai, String codigoLabExterno) {
        super(pai, "Selecione os exames para integrar");
        this.codigoLabExterno = codigoLabExterno;
        this.montaTela();
        this.carregaExames();
        this.modeloExames.ordenarColuna(1);
    }

    private SelecionarParaIntegrar(Dialog pai, String codigoLabExterno) {
        super(pai, "Selecione os exames para integrar");
        this.codigoLabExterno = codigoLabExterno;
        this.montaTela();
        this.carregaExames();
        this.modeloExames.ordenarColuna(1);
    }

    private void carregaExames() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.lae_codigo, a.fil_codigo, a.exa_codigo, a.mco_codigo, h.exa_descricao, ");
            buf.append("  a.ele_bloqueado, a.ele_padrao, a.ele_xmllabexterno, i.mco_abreviatura, i.mco_descricao, ");
            buf.append("pegarvalortag(a.ele_xmllabexterno, 'codigo-exame') as codexm, ");
            buf.append("pegarvalortag(a.ele_xmllabexterno, 'codigo-material') as codmat, ");
            buf.append("pegarvalortag(a.ele_xmllabexterno, 'material-selecionado') as descmat, ");
            buf.append("pegarvalortag(a.ele_xmllabexterno, 'descricao-exame') as descexm");
            buf.append(" from examematcoletalabexterno a ");
            buf.append(" left join exames h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo ");
            buf.append(" left join materialcoleta i on a.fil_codigo = i.fil_codigo and a.mco_codigo = i.mco_codigo ");
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.lae_codigo = ").append(this.codigoLabExterno);
            buf.append(" union ");
            buf.append(" select a.lae_codigo, a.fil_codigo, a.exa_codigo, a.mco_codigo, h.exa_descricao, ");
            buf.append("  false, false, '', i.mco_abreviatura, i.mco_descricao, '', '', '', '' ");
            buf.append(" from examematcoleta a ");
            buf.append(" left join exames h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo ");
            buf.append(" left join materialcoleta i on a.fil_codigo = i.fil_codigo and a.mco_codigo = i.mco_codigo ");
            buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" order by exa_codigo, mco_codigo ");
            Statement st = Conexao.getStatement();
            ResultSet rsExames = Conexao.executeQuery(st, buf.toString());
            if (rsExames != null) {
                while (rsExames.next()) {
                    String descricaoExameLabExterno = "";
                    if (!Funcoes.textoVazio(rsExames.getString("ele_xmllabexterno"))) {
                        descricaoExameLabExterno = this.validaCampoDescricaoLabExterno(rsExames.getString("ele_xmllabexterno"));
                    }
                    Object[] exame = this.adicionaObjeto(Boolean.FALSE, rsExames.getString("exa_codigo"), rsExames.getString("mco_abreviatura"), rsExames.getString("exa_descricao"), descricaoExameLabExterno, rsExames.getBoolean("ele_bloqueado"), rsExames.getBoolean("ele_padrao"), rsExames.getString("mco_codigo"), rsExames.getString("mco_descricao"), rsExames.getString("codexm"), rsExames.getString("descmat"), rsExames.getString("descexm"), rsExames.getString("codmat"));
                    this.modeloExames.addLine(exame);
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private String validaCampoDescricaoLabExterno(String xml) {
        String descricaoExameLabExterno = StringUtil.getValor(xml, "descricaoExame");
        if (this.validaNome(xml, descricaoExameLabExterno, "descricao-exame")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "descricao-exame");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "ds_exame")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "ds_exame");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "nome")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "nome");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "descricao")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "descricao");
        } else if (this.validaNome(xml, descricaoExameLabExterno, "codigoExame")) {
            descricaoExameLabExterno = StringUtil.getValor(xml, "codigoExame");
        }
        return descricaoExameLabExterno;
    }

    private boolean validaNome(String xml, String descricaoExameLabExterno, String tag) {
        return Funcoes.textoVazio(descricaoExameLabExterno) && !Funcoes.textoVazio(StringUtil.getValor(xml, tag));
    }

    private Object[] adicionaObjeto(Boolean selecionado, String codExame, String abrMaterial, String descExame, String descExameRelacionado, Boolean bloqueado, Boolean padrao, String codMaterial, String descricaoMaterial, String codexm, String descmat, String descexm, String codmat) throws SQLException {
        Object[] exame = new Object[]{selecionado, codExame, abrMaterial, descExame, descExameRelacionado, bloqueado, codMaterial, descricaoMaterial, codexm, descmat, descexm, codmat};
        return exame;
    }

    private void montaTela() {
        this.setSize(900, 450);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().add(this.panelPrincipal);
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.panelPrincipal.setBorder(ScreenUtil.criarBordaVazia());
        this.modeloExames.setColumnSize(new int[]{25, 60, 40, 0, 0}, this.tableExames);
        this.tableExames.repaint();
        this.menuOpcoes.add(this.itemSelecionarTodos);
        this.menuOpcoes.add(this.itemDesmarcarTodos);
        JPanel panelLista = new JPanel(new GridBagLayout());
        this.panelPrincipal.add((Component)panelLista, "Center");
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.panelPrincipal.add((Component)panelBotoes, "South");
        this.montaPanelExames(panelLista);
        this.buttonOpcoes.setMnemonic('O');
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonOpcoes, this.checkEnviarConfigurados), "West");
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonExportar, this.buttonCancelar), "East");
        Funcoes.montaEnter((JComponent)this.getContentPane());
        this.montaListeners();
        ScreenUtil.centralizar(this);
    }

    private void montaListeners() {
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        ScreenUtil.requisitarFoco(this.textLocalizar);
        this.buttonOpcoes.addActionListener(this);
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int colunaOrdenacao = SelecionarParaIntegrar.this.modeloExames.getColunaOrdenacao();
                int row = -1;
                row = colunaOrdenacao == 1 ? SelecionarParaIntegrar.this.modeloExames.localizarParcial(SelecionarParaIntegrar.this.modeloExames.getColunaOrdenacao(), SelecionarParaIntegrar.this.textLocalizar.getText()) : SelecionarParaIntegrar.this.modeloExames.localizarContendo(SelecionarParaIntegrar.this.modeloExames.getColunaOrdenacao(), SelecionarParaIntegrar.this.textLocalizar.getText());
                if (row >= 0) {
                    SelecionarParaIntegrar.this.tableExames.getSelectionModel().setSelectionInterval(row, row);
                    Rectangle rect = SelecionarParaIntegrar.this.tableExames.getCellRect(row, 0, true);
                    SelecionarParaIntegrar.this.tableExames.scrollRectToVisible(rect);
                } else {
                    SelecionarParaIntegrar.this.tableExames.getSelectionModel().clearSelection();
                }
            }
        });
    }

    public boolean isOk() {
        return this.isOk;
    }

    public List<ExameSelecionado> getSelecionados() {
        ArrayList<ExameSelecionado> exames = new ArrayList<ExameSelecionado>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            Object o = this.modeloExames.getValueAt(i, 0);
            if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) continue;
            String exame = this.modeloExames.getValueAt(i, 1).toString();
            String mat = this.modeloExames.getValueAt(i, 6).toString();
            if (Funcoes.textoVazio(exame) || !Funcoes.isNumeric(mat)) continue;
            exames.add(new ExameSelecionado(exame, Integer.parseInt(mat)));
        }
        return exames;
    }

    public List<ExameConfiguradoJSON> getExamesConfigurados() {
        ArrayList<ExameConfiguradoJSON> exames = new ArrayList<ExameConfiguradoJSON>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            Object o = this.modeloExames.getValueAt(i, 4);
            if (!(o instanceof String) || Funcoes.textoVazio((String)o)) continue;
            String exame = this.modeloExames.getValueAt(i, 1).toString();
            String mat = this.modeloExames.getValueAt(i, 6).toString();
            if (Funcoes.textoVazio(exame) || !Funcoes.isNumeric(mat)) continue;
            ExameConfiguradoJSON configurado = new ExameConfiguradoJSON();
            configurado.setCodExmLab(exame + "|" + mat);
            configurado.setDescExmLab(this.modeloExames.getValueAt(i, 3).toString());
            configurado.setDescMatLab(this.modeloExames.getValueAt(i, 7).toString());
            configurado.setCodExm(this.pegaValorColunaModelo(i, 8));
            configurado.setCodMat(this.pegaValorColunaModelo(i, 11));
            configurado.setDescExm(this.pegaValorColunaModelo(i, 10));
            configurado.setDescMat(this.pegaValorColunaModelo(i, 9));
            exames.add(configurado);
        }
        return exames;
    }

    private String pegaValorColunaModelo(int linha, int coluna) {
        Object o = this.modeloExames.getValueAt(linha, coluna);
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private void montaPanelExames(JPanel panelLista) {
        panelLista.setBorder(new TitledBorder("Exames"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 1, 0, 0);
        JScrollPane scrollExames = new JScrollPane(this.tableExames);
        panelLista.add((Component)scrollExames, c);
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 17;
        c.weighty = 0.0;
        c.fill = 2;
        JPanel panelPesquisar = new JPanel(new GridBagLayout());
        panelPesquisar.setBorder(new TitledBorder(""));
        panelLista.add((Component)panelPesquisar, c);
        this.montaPanelLocalizar(panelPesquisar);
    }

    private void montaPanelLocalizar(JPanel panelPesquisar) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 0, 1);
        this.labelLocalizar.setDisplayedMnemonic('L');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        panelPesquisar.add((Component)this.labelLocalizar, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.textLocalizar.setMinimumSize(new Dimension(20, 20));
        panelPesquisar.add((Component)this.textLocalizar, c);
    }

    private void limparCampos() {
        this.textLocalizar.setText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.itemDesmarcarTodos) {
            this.desmarcarTodos();
        } else if (e.getSource() == this.itemSelecionarTodos) {
            this.marcarTodos();
        } else if (e.getSource() == this.buttonOpcoes) {
            Dimension dim = this.menuOpcoes.getPreferredSize();
            this.menuOpcoes.show(this.buttonOpcoes.getParent(), this.buttonOpcoes.getX(), this.buttonOpcoes.getY() - dim.height - 1);
        } else if (e.getSource() == this.buttonExportar) {
            if (!this.temExameSelecionado()) {
                Funcoes.mensagem(this, "Nenhum exame foi selecionado para ser exportado", 2);
            } else {
                this.fechar(true);
            }
        } else if (e.getSource() == this.buttonCancelar) {
            this.fechar(false);
        }
    }

    private boolean temExameSelecionado() {
        boolean retorno = false;
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            Object o = this.modeloExames.getValueAt(i, 0);
            boolean bl = retorno = o instanceof Boolean && (Boolean)o != false;
            if (retorno) break;
        }
        return retorno;
    }

    public boolean enviarConfigurados() {
        return this.checkEnviarConfigurados.isSelected();
    }

    private void fechar(boolean ok) {
        this.isOk = ok;
        this.setVisible(false);
    }

    private void desmarcarTodos() {
        this.mudarSelecionados(false);
    }

    private void marcarTodos() {
        this.mudarSelecionados(true);
    }

    private void mudarSelecionados(boolean novaSelecao) {
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            this.modeloExames.setValueAt(novaSelecao, i, 0);
        }
    }

    public HashSet<String> getListaCodigosExamesSelecionados() {
        HashSet<String> listaRetorno = new HashSet<String>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            listaRetorno.add(this.modeloExames.getValueAt(i, 1).toString());
        }
        return listaRetorno;
    }

    private HashSet<ExameMatColetaVO> getListaExamesMateriaisSelecionados() {
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        HashSet<ExameMatColetaVO> listaRetorno = new HashSet<ExameMatColetaVO>();
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!((Boolean)this.modeloExames.getValueAt(i, 0)).booleanValue()) continue;
            listaRetorno.add(this.getExameMatColetaVO(i));
        }
        return listaRetorno;
    }

    private ExameMatColetaVO getExameMatColetaVO(int row) {
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        ExameVO exameVO = new ExameVO();
        exameVO.setFilial(filialVO);
        exameVO.setCodigo(this.modeloExames.getValueAt(row, 1).toString());
        MaterialColetaVO materialVO = new MaterialColetaVO();
        materialVO.setFilial(filialVO);
        ExameMatColetaVO exameMaterialVO = new ExameMatColetaVO();
        exameMaterialVO.setFilial(filialVO);
        exameMaterialVO.setExame(exameVO);
        exameMaterialVO.setMaterial(materialVO);
        return exameMaterialVO;
    }
}

