/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.pardini.MatRealHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JProgressBar;

public class ParserImportacaoHPardini {
    private static String xmlConfiguracao = null;

    public static String[] getDataHoraGeracao(String xmlTabela) {
        String[] vlrs = new String[]{"", ""};
        if (xmlTabela != null) {
            String tabela = StringUtil.getValor(xmlTabela, "TABELA");
            vlrs[0] = StringUtil.getValor(tabela.equals("") ? xmlTabela : tabela, "DATAGERACAO");
            vlrs[1] = StringUtil.getValor(tabela.equals("") ? xmlTabela : tabela, "HORAGERACAO");
        }
        return vlrs;
    }

    public static Set<ExameHPardini> importarExamesHPardini(String xmlTabela, int codigoLabExterno) throws SQLException, NumberFormatException, SalvaDadosException {
        return ParserImportacaoHPardini.importarExamesHPardini(xmlTabela, codigoLabExterno, null, Variaveis.filialPadrao, false);
    }

    public static Set<ExameHPardini> importarExamesHPardini(String xmlTabela, int codigoLabExterno, JProgressBar progress, String filialPadrao, boolean importacaoUnica) throws SQLException, NumberFormatException, SalvaDadosException {
        Set<ExameHPardini> exaNovos = ParserImportacaoHPardini.getExames(xmlTabela);
        Set<ExameHPardini> exaVelhos = ParserImportacaoHPardini.getExamesRelacionados(codigoLabExterno, filialPadrao);
        HashSet<ExameHPardini> aux = new HashSet<ExameHPardini>(exaVelhos);
        HashSet<ExameHPardini> aux2 = new HashSet<ExameHPardini>(exaNovos);
        Statement st = Conexao.getStatement();
        ParserImportacaoHPardini.adicionaSuperExame(aux2, codigoLabExterno);
        ParserImportacaoHPardini.adicionaSuperExame(aux, codigoLabExterno);
        if (st != null && !exaNovos.isEmpty() && progress != null) {
            progress.setMaximum(exaNovos.size());
            progress.setValue(0);
        }
        StringBuilder bui = new StringBuilder();
        if (importacaoUnica) {
            Iterator<ExameHPardini> eNovo;
            Iterator<ExameHPardini> iterator = eNovo = exaNovos.iterator().hasNext() ? exaNovos.iterator().next() : null;
            if (null != eNovo) {
                exaVelhos = exaVelhos.stream().filter(e -> e.getMnemonicoExame().equals(eNovo.getMnemonicoExame()) && e.getMnemonicoMaterial().equals(eNovo.getMnemonicoMaterial())).collect(Collectors.toSet());
            }
        }
        for (ExameHPardini exa : exaVelhos) {
            exa.setSuperExame(ExameHPardini.getDadosSuperExame(codigoLabExterno, exa));
            IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, filialPadrao, codigoLabExterno, exa.codExaJalis, Integer.parseInt(exa.codMatJalis), "");
        }
        if (!importacaoUnica) {
            IntegracaoLabExternoUtil.deletaExame(st, filialPadrao, codigoLabExterno, 0, new Object[0]);
        } else {
            for (ExameHPardini ee : exaNovos) {
                IntegracaoLabExternoUtil.deletaExameUnicoPardini(st, filialPadrao, codigoLabExterno, ee.getMnemonicoExame(), ee.getMnemonicoMaterial());
            }
        }
        Map<String, ExameHPardini> listaExames = ParserImportacaoHPardini.exameMap(exaNovos);
        ParserImportacaoHPardini.atualizaDetalhesExamesVelhos(aux, listaExames);
        ParserImportacaoHPardini.inserirExamesHPardini(filialPadrao, aux, st, codigoLabExterno, progress);
        for (ExameHPardini ep : aux) {
            bui.setLength(0);
            StringBuilder xml = new StringBuilder(ep.getXMLEHP(ep.getXMLDetalhes(), ep.getSuperExame()));
            ExameHPardini examePardini = listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial());
            if (examePardini != null) {
                IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, filialPadrao, codigoLabExterno, ep.codExaJalis, Integer.parseInt(ep.codMatJalis), StringUtil.textoDB(ep.getXMLExame()));
                ParserImportacaoHPardini.atualizaMaterialAlterado(filialPadrao, st, listaExames, ep, xml);
                continue;
            }
            IntegracaoLabExternoUtil.deletaExameUnicoPardini(st, filialPadrao, codigoLabExterno, ep.getMnemonicoExame(), ep.getMnemonicoMaterial());
        }
        aux2.removeIf(exaNovo -> aux.stream().anyMatch(exaVelho -> exaVelho.getMnemonicoExame().equals(exaNovo.getMnemonicoExame()) && exaVelho.getMnemonicoMaterial().equals(exaNovo.getMnemonicoMaterial())));
        ParserImportacaoHPardini.inserirExamesHPardini(filialPadrao, aux2, st, codigoLabExterno, progress);
        Conexao.arquivaSQL();
        if (importacaoUnica) {
            exaVelhos.clear();
        } else {
            exaVelhos.removeAll(exaNovos);
        }
        return exaVelhos;
    }

    private static void atualizaDetalhesExamesVelhos(Set<ExameHPardini> examesVelhos, Map<String, ExameHPardini> listaExames) {
        if (!examesVelhos.isEmpty()) {
            for (ExameHPardini exaVelho : examesVelhos) {
                for (Map.Entry<String, ExameHPardini> exameHPLista : listaExames.entrySet()) {
                    if (!exameHPLista.getValue().getMnemonicoExame().equals(exaVelho.getMnemonicoExame()) || !exameHPLista.getValue().getMnemonicoMaterial().equals(exaVelho.getMnemonicoMaterial())) continue;
                    exaVelho.setXMLDetalhes(exameHPLista.getValue().getXMLDetalhes());
                }
            }
        }
    }

    private static void adicionaSuperExame(Set<ExameHPardini> examesHPardini, int codigoLabExterno) throws SQLException {
        if (!examesHPardini.isEmpty()) {
            for (ExameHPardini exaHPardini : examesHPardini) {
                exaHPardini.setSuperExame(ExameHPardini.getDadosSuperExame(codigoLabExterno, exaHPardini));
            }
        }
    }

    private static void atualizaMaterialAlterado(String filial, Statement st, Map<String, ExameHPardini> listaExames, ExameHPardini ep, StringBuilder xml) throws SQLException, SalvaDadosException {
        String conservanteSelecionado = ep.getConservanteSelecionado();
        int qtdeConservantes = 0;
        List<MatRealHPardini> matExameHP = listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais();
        if (!matExameHP.isEmpty()) {
            qtdeConservantes = matExameHP.get(0).getConservantes().size();
        }
        if (listaExames.containsKey(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()) && !xml.toString().equals(listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getXMLExame()) && !ep.getMateriaisReais().isEmpty()) {
            xml.setLength(0);
            xml.append(listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getXMLExame());
            if (ParserImportacaoHPardini.contemTag(xml, "utilizar-mat-requisicao")) {
                StringUtil.setValor(xml, "utilizar-mat-requisicao", String.valueOf(ep.utilizarMatRequisicao()));
            }
            StringUtil.setValor(xml, "material-selecionado", listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().get(0).getDescricaoMatReal());
            if (qtdeConservantes > 1) {
                for (int i = 0; i < qtdeConservantes; ++i) {
                    if (!listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().get(0).getConservantes().get(i).equalsIgnoreCase(conservanteSelecionado)) continue;
                    StringUtil.setValor(xml, "conservante-selecionado", listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getMateriaisReais().get(0).getConservantes().get(i));
                }
            }
            IntegracaoLabExternoUtil.updateExame(st, filial, Integer.parseInt(ep.codLabExterno), 0, ep.getMnemonicoExame(), ep.getMnemonicoMaterial(), null, listaExames.get(ep.getMnemonicoExame() + ep.getMnemonicoMaterial()).getXMLEHP(ep.getXMLDetalhes(), ep.getSuperExame()));
        }
    }

    private static boolean contemTag(StringBuilder xml, String tag) {
        return xml.toString().contains(tag);
    }

    private static Map<String, ExameHPardini> exameMap(Set<ExameHPardini> exaNovos) {
        HashMap<String, ExameHPardini> listaExames = new HashMap<String, ExameHPardini>();
        for (ExameHPardini e : exaNovos) {
            listaExames.put(e.getMnemonicoExame() + e.getMnemonicoMaterial(), e);
        }
        return listaExames;
    }

    public static List<ElementoHPardini> importarCamposResultadoHPardini(ElementoHPardini resultados, int codigoLabExterno, JProgressBar progress, String xmlConfiguracao) {
        ArrayList<ElementoHPardini> rejeitados = new ArrayList<ElementoHPardini>();
        Funcoes.validarNaoNull(resultados, "resultados");
        List<ElementoHPardini> superExames = resultados.getFilhos("SuperExame");
        if (progress != null) {
            progress.setMaximum(superExames.size());
        }
        ArrayList<String> chaves = new ArrayList<String>();
        try {
            for (ElementoHPardini superExame : superExames) {
                if (progress != null) {
                    progress.setValue(progress.getValue() + 1);
                }
                ParserImportacaoHPardini.salvarSuperExame(superExame, codigoLabExterno, rejeitados, xmlConfiguracao, chaves);
            }
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoHPardini: 168");
        }
        catch (SalvaDadosException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoHPardini");
        }
        return rejeitados;
    }

    protected static void salvarSuperExame(ElementoHPardini superExame, int codigoLabExterno, List<ElementoHPardini> rejeitados, String xmlConfiString, List<String> chaves) throws SQLException, SalvaDadosException {
        String unidadeProdutivaAtual;
        Statement st = Conexao.getStatement();
        boolean isIgnorarUnidadeProdutiva = StringUtil.getBoolean(xmlConfiString, "ignorarUnidadeProdutiva");
        String unidadeProdutiva = StringUtil.getValor(xmlConfiString, "unidadeProdutiva");
        String string = unidadeProdutivaAtual = superExame.getFilho("UnidadeProdutiva") != null ? superExame.getFilho("UnidadeProdutiva").getValor() : null;
        if (Funcoes.textoVazio(unidadeProdutiva)) {
            unidadeProdutiva = unidadeProdutivaAtual;
        }
        if (!(Funcoes.textoVazio(unidadeProdutiva) || isIgnorarUnidadeProdutiva || unidadeProdutiva.equalsIgnoreCase(unidadeProdutivaAtual))) {
            return;
        }
        if (st != null && superExame.contemFilho("CodExmApoio")) {
            String codExmApoio = superExame.getFilho("CodExmApoio").getValor();
            if (codExmApoio.indexOf(124) < 0) {
                return;
            }
            String mat = codExmApoio.substring(0, codExmApoio.indexOf(124));
            String exa = codExmApoio.substring(codExmApoio.indexOf(124) + 1, codExmApoio.lastIndexOf(124));
            String codFormato = superExame.getFilho("CodigoFormato").getValor();
            String chave = exa + codFormato + mat;
            if (chaves.contains(chave)) {
                return;
            }
            chaves.add(chave);
            StringBuilder sql = new StringBuilder("select ehp_xml \n");
            sql.append("from examespardini \n");
            sql.append("where \n  fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append("   and lae_codigo = ").append(codigoLabExterno);
            sql.append("   and ehp_codexame = '").append(exa);
            sql.append("'  and ehp_codmaterial = '").append(mat).append("'");
            ResultSet res = Conexao.executeQuery(st, sql);
            if (!res.next()) {
                rejeitados.add(superExame);
            } else {
                String xmlArquivo = ParserImportacaoHPardini.montarXMLCamposResultados(res.getString("ehp_xml"), superExame);
                String xmlBanco = res.getString("ehp_xml");
                StringBuilder xmlAux = new StringBuilder();
                String[] listFormatos = StringUtil.getValores(xmlBanco, "Formato");
                if (listFormatos.length <= 0) {
                    listFormatos = StringUtil.getValores(xmlBanco, "SuperExame");
                    String aux = null;
                    if (listFormatos.length <= 0) {
                        xmlAux.append(xmlBanco);
                        xmlAux.append(xmlArquivo);
                    } else {
                        aux = listFormatos[0];
                        aux = StringUtil.removerTagCompletaXML(aux, "MaterialNome", true);
                        aux = StringUtil.removerTagCompletaXML(aux, "ExameNome", true);
                        listFormatos[0] = aux = StringUtil.removerTagCompletaXML(aux, "CodExmApoio", true);
                    }
                }
                boolean formatoAdicionado = false;
                for (String s : listFormatos) {
                    String xmlFormato = StringUtil.getValor(s, "CodigoFormato");
                    String formato = StringUtil.getTag("CodigoFormato", xmlFormato);
                    if (xmlArquivo.indexOf(formato) > -1) continue;
                    if (!formatoAdicionado) {
                        xmlAux.append(xmlArquivo.substring(0, xmlArquivo.indexOf("</SuperExame>")));
                        String xml = xmlAux.substring(0, xmlAux.indexOf("</Formatos>"));
                        xmlAux.setLength(0);
                        xmlAux.append(xml);
                    }
                    xmlAux.append(StringUtil.getTag("Formato", s));
                    if (formatoAdicionado) continue;
                    formatoAdicionado = true;
                }
                if (formatoAdicionado) {
                    xmlAux.append("</Formatos>");
                    xmlAux.append("</SuperExame>");
                    xmlArquivo = xmlAux.toString();
                }
                IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 0, exa, mat, null, xmlArquivo);
            }
        } else {
            rejeitados.add(superExame);
        }
    }

    private static String montarXMLCamposResultados(String ehpXML, ElementoHPardini superExame) {
        StringBuilder bui = ParserImportacaoHPardini.montaCabecalho(ehpXML);
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            ParserImportacaoHPardini.carregarXMLBuilder(xml, superExame, false);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\nExame: " + superExame.getFilho("CodExmApoio").getValor(), e.getStackTrace(), "ParserImportacaoHPardini: 220");
        }
        bui.append(StringUtil.textoDB(xml.getXML()));
        return bui.toString();
    }

    private static StringBuilder montaCabecalho(String xml) {
        int beginIndex = xml.indexOf("<detalhes>");
        int endIndex = xml.indexOf("</detalhes>") + "</detalhes>".length();
        StringBuilder bui = new StringBuilder(StringUtil.textoDB(xml.substring(beginIndex, endIndex)));
        bui.append('\n');
        return bui;
    }

    protected static void carregarXMLBuilder(XMLStringBuilder xml, ElementoHPardini ele, boolean buscandoVersoes) throws XMLStringBuilderException, SQLException {
        if (!ele.contemFilhos()) {
            if (ele.getNome().equals("CodigoFormato")) {
                xml.abrir("Formato");
            }
            if ((ele.getNome().equals("MaterialNome") || ele.getNome().equals("ExameNome") || ele.getNome().equals("CodExmApoio")) && buscandoVersoes) {
                return;
            }
            String valor = ele.getValor();
            if (ele.getNome().equalsIgnoreCase("descricao") || ele.getNome().equalsIgnoreCase("nota") || ele.getNome().equalsIgnoreCase("observacao") || ele.getNome().equalsIgnoreCase("comentariodopatologista") || ele.getNome().equalsIgnoreCase("metodo") || ele.getNome().equalsIgnoreCase("examenome") || ele.getNome().equalsIgnoreCase("valor") || ele.getNome().equalsIgnoreCase("valorreferencia") || ele.getNome().equalsIgnoreCase("valorreferenciablocotexto") || ele.getNome().equalsIgnoreCase("interpretacao")) {
                valor = "<![CDATA[" + valor + "]]>";
            }
            if (ele.getNome().toLowerCase().contains("categoria") && ele.getPai().getPai().getPai().getNome().equalsIgnoreCase("valordereferencia")) {
                valor = "<![CDATA[" + valor + "]]>";
            }
            xml.escrever(ele.getNome(), valor, ele.getMapaAtributos());
            if (ele.getNome().equals("CodExmApoio") && !buscandoVersoes) {
                xml.abrir("Formatos");
            }
        } else {
            if (!ele.getNome().equals("SuperExame") || !buscandoVersoes) {
                xml.abrir(ele.getNome(), ele.getMapaAtributos());
            }
            for (ElementoHPardini filho : ele.getFilhos()) {
                ParserImportacaoHPardini.carregarXMLBuilder(xml, filho, buscandoVersoes);
            }
            if (ele.getNome().equals("SuperExame") && !buscandoVersoes) {
                for (ElementoHPardini filho : ele.getPai().getFilhos()) {
                    if (filho.getNome().equals("Protocolo") || filho.getFilho("CodExmApoio") == null || !filho.getFilho("CodExmApoio").getValor().equals(ele.getFilho("CodExmApoio").getValor()) || filho.getFilho("CodigoFormato").getValor().equals(ele.getFilho("CodigoFormato").getValor())) continue;
                    xml.fechar("Formato");
                    ParserImportacaoHPardini.carregarXMLBuilder(xml, filho, true);
                }
                xml.fechar("Formato");
                xml.fechar("Formatos");
                buscandoVersoes = false;
            }
            if (!ele.getNome().equals("SuperExame") || !buscandoVersoes) {
                xml.fechar(ele.getNome());
            }
        }
    }

    private static void inserirExamesHPardini(String filial, Set<ExameHPardini> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SQLException, SalvaDadosException {
        for (ExameHPardini ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            IntegracaoLabExternoUtil.insertExame(st, filial, codigoLabExterno, 0, ep.getMnemonicoExame(), ep.getMnemonicoMaterial(), ep.getDescricaoExame(), ep.getXMLEHP(ep.getXMLDetalhes(), ep.getSuperExame()));
        }
    }

    private static Set<ExameHPardini> getExames(String xmlTabela) {
        HashSet<ExameHPardini> exames = new HashSet<ExameHPardini>();
        String tabela = StringUtil.getValor(xmlTabela, "TABELA");
        if (!tabela.equals("")) {
            for (String exame : StringUtil.getValores(xmlTabela, "EXAME")) {
                String origemAdmissivel = StringUtil.getValor(exame, "ORIGEMADMISSIVEL");
                String matReal = StringUtil.getValor(exame, "MATREAL");
                if (Funcoes.textoVazio(matReal) || origemAdmissivel != null && !origemAdmissivel.equalsIgnoreCase("TODOS")) continue;
                ExameHPardini exameHPardini = new ExameHPardini(exame, false);
                exames.add(exameHPardini);
            }
        }
        return exames;
    }

    private static Set<ExameHPardini> getExamesRelacionados(int codigoLabExterno, String filialPadrao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        if (st != null) {
            bui.append("select \n");
            bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
            bui.append("from examematcoletalabexterno a \n");
            bui.append("left join labexterno b \n");
            bui.append("  on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
            bui.append("where \n");
            bui.append("  b.fil_codigo = ").append(filialPadrao).append(" and \n");
            bui.append("  b.lae_codigo = ").append(codigoLabExterno);
            bui.append("  and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
            return ExameHPardini.getExames(Conexao.executeQuery(st, bui.toString()));
        }
        return new HashSet<ExameHPardini>();
    }
}

