/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class MatRealHPardini {
    private String descMatReal;
    private List<String> conservantes;

    MatRealHPardini(String xmlMatreal, boolean tagJalis) {
        Funcoes.validarNaoNull(xmlMatreal, "xmlMatreal");
        this.descMatReal = StringUtil.getValor(xmlMatreal, tagJalis ? "desc-mat-real" : "DESCMATREAL");
        this.conservantes = new ArrayList<String>();
        for (String conservante : StringUtil.getValores(xmlMatreal, tagJalis ? "conservante" : "CONSERVANTE")) {
            this.conservantes.add(conservante);
        }
    }

    MatRealHPardini(String matReal, String descMatReal, List<String> conservantes) {
        this.descMatReal = descMatReal;
        this.conservantes = conservantes;
    }

    static List<MatRealHPardini> getMateriaisReais(String xmlDetalhes) {
        ArrayList<MatRealHPardini> list = new ArrayList<MatRealHPardini>();
        block0: for (String mat : StringUtil.getValores(StringUtil.getValor(xmlDetalhes, "detalhes"), "mat-real")) {
            MatRealHPardini matHPardini = new MatRealHPardini(mat, true);
            if (MatRealHPardini.listaVazia(list)) {
                list.add(new MatRealHPardini(mat, true));
            }
            for (MatRealHPardini matRealHPardini : list) {
                if (!MatRealHPardini.validaMaterialDuplicado(matRealHPardini.getDescricaoMatReal(), matHPardini.getDescricaoMatReal())) continue;
                list.add(new MatRealHPardini(mat, true));
                continue block0;
            }
        }
        return list;
    }

    private static boolean listaVazia(ArrayList<MatRealHPardini> list) {
        return list.isEmpty();
    }

    public static boolean validaMaterialDuplicado(String descricaoMatHPReal, String descricaoMatReal) {
        return !descricaoMatHPReal.equals(descricaoMatReal);
    }

    public String getDescricaoMatReal() {
        return this.descMatReal;
    }

    public List<String> getConservantes() {
        return this.conservantes;
    }
}

