/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class JanelaHistoricoLotes
extends JDialog
implements ActionListener {
    private final int COLUNA_LOTE = 0;
    private final int COLUNA_DATA_ENVIO = 1;
    private final int COLUNA_PREVISAO_RETORNO = 2;
    private final int COLUNA_DATA_RETORNO = 3;
    private final int COLUNA_QTDE_ENVIADA = 4;
    private JPanel panelLogs = new JPanel(new GridBagLayout());
    private JPanel panelExcecao = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JButton buttonFechar = new JButton("Fechar");
    private ModeloGridTable modeloLogs = new ModeloGridTable(new String[]{"Lote", "Data envio", "Previs\u00e3o retorno", "Data retorno", "Qtde Exames"});
    private JTable tableLogs = new JTable(this.modeloLogs);
    private JScrollPane scrollLogs = new JScrollPane(this.tableLogs);

    public JanelaHistoricoLotes(Frame pai, int filial, int labExterno) {
        super(pai);
        this.setTitle("Hist\u00f3rico de solicita\u00e7\u00e3o de DE/PARA");
        this.setModal(true);
        this.montaTela();
        this.carregaDados(filial, labExterno);
    }

    private void carregaDados(int filial, int labExterno) {
        this.modeloLogs.clear();
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo, lae_codigo, let_lote, let_datahoraenvio, let_dataprevisaoretorno, let_datahoraretornou, let_qtdeexamesenviados ");
        buf.append("from labexternolotepardini ");
        buf.append(" where ");
        buf.append(" fil_codigo = ").append(filial);
        buf.append(" and lae_codigo = ").append(labExterno);
        buf.append(" order by let_datahoraenvio, let_lote");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                this.modeloLogs.addLine(new Object[]{rs.getString("let_lote"), Funcoes.formataData("dd/MM/yyyy kk:mm", rs.getTimestamp("let_datahoraenvio")), rs.getString("let_dataprevisaoretorno"), null != rs.getString("let_datahoraretornou") ? Funcoes.formataData("dd/MM/yyyy kk:mm", rs.getTimestamp("let_datahoraretornou")) : "", rs.getString("let_qtdeexamesenviados")});
            }
            rs.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e2o foi poss\u00edvel carregar o hist\u00f3rico dos lotes.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void montaPanelLogs() {
        this.panelLogs.setBorder(new TitledBorder("Lotes"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.panelLogs.add((Component)this.scrollLogs, c);
        this.modeloLogs.setColumnSize(new int[]{40, 70, 70, 0}, this.tableLogs);
    }

    private void montaTela() {
        JPanel panelCentral = (JPanel)this.getContentPane();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelLogs, c);
        ++c.gridy;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelBotoes, c);
        this.montaPanelLogs();
        this.montaPanelBotoes();
        Funcoes.montaEnter((JComponent)this.panelLogs);
        this.setSize(700, 500);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void montaPanelBotoes() {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        this.panelBotoes.add((Component)panelEsquerda, "West");
        this.panelBotoes.add((Component)panelDireita, "East");
        panelDireita.add(this.buttonFechar);
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        }
    }
}

