/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.laboratorio.util.parsers.pardini.ExameRetornoSuspenso;
import jalis.laboratorio.util.parsers.pardini.RetornoHistoricoExameSuspensoJSON;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class JanelaHistoricoExamesSuspensos
extends JDialog
implements ActionListener {
    private final int COLUNA_LOTE = 0;
    private final int COLUNA_DATA_ENVIO = 1;
    private final int COLUNA_PREVISAO_RETORNO = 2;
    private final int COLUNA_DATA_RETORNO = 3;
    private final int COLUNA_QTDE_ENVIADA = 4;
    private JPanel panelLogs = new JPanel(new GridBagLayout());
    private JPanel panelExcecao = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JButton buttonFechar = new JButton("Fechar");
    private ModeloGridTable modeloLogs = new ModeloGridTable(new String[]{"Exame", "Material", "C\u00f3digo", "Motivo", "Detalhes"});
    private JTable tableLogs = new JTable(this.modeloLogs);
    private JScrollPane scrollLogs = new JScrollPane(this.tableLogs);

    public JanelaHistoricoExamesSuspensos(Frame pai, RetornoHistoricoExameSuspensoJSON historico) {
        super(pai);
        this.construir(historico);
    }

    public JanelaHistoricoExamesSuspensos(Dialog pai, RetornoHistoricoExameSuspensoJSON historico) {
        super(pai);
        this.construir(historico);
    }

    private void construir(RetornoHistoricoExameSuspensoJSON historico) {
        this.setTitle("Hist\u00f3rico de exames suspensos");
        this.setModal(true);
        this.montaTela();
        this.carregaDados(historico);
    }

    private void carregaDados(RetornoHistoricoExameSuspensoJSON historico) {
        this.modeloLogs.clear();
        if (null != historico && null != historico.getSuspensos()) {
            for (ExameRetornoSuspenso suspenso : historico.getSuspensos()) {
                this.modeloLogs.addLine(new Object[]{suspenso.getDescExmLab(), suspenso.getDescMatLab(), suspenso.getCodExmLab(), suspenso.getMotivoSuspensao(), suspenso.getDetalhesMotivoSuspensao()});
            }
        }
    }

    private void montaPanelLogs() {
        this.panelLogs.setBorder(new TitledBorder("Exames"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        this.panelLogs.add((Component)this.scrollLogs, c);
        this.modeloLogs.setColumnSize(new int[]{250, 90, 80, 60, 0}, this.tableLogs);
    }

    private void montaTela() {
        JPanel panelCentral = (JPanel)this.getContentPane();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.4;
        panelCentral.add((Component)this.panelLogs, c);
        ++c.gridy;
        c.weighty = 0.0;
        panelCentral.add((Component)this.panelBotoes, c);
        this.montaPanelLogs();
        this.montaPanelBotoes();
        Funcoes.montaEnter((JComponent)this.panelLogs);
        this.setSize(880, 500);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
    }

    private void montaPanelBotoes() {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        this.panelBotoes.add((Component)panelEsquerda, "West");
        this.panelBotoes.add((Component)panelDireita, "East");
        panelDireita.add(this.buttonFechar);
        this.buttonFechar.setMnemonic('F');
        this.buttonFechar.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        }
    }
}

