/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractIntegracaoProtocolo;
import jalis.laboratorio.util.parsers.IntegracaoProtocoloException;
import jalis.laboratorio.util.parsers.NomeModeloWeb;
import jalis.laboratorio.util.parsers.RetornoImportacaoCadastroModelos;
import jalis.laboratorio.util.parsers.RetornoIntegracaoDePara;
import jalis.laboratorio.util.parsers.pardini.ChaveValorJSON;
import jalis.laboratorio.util.parsers.pardini.ExameConfiguradoJSON;
import jalis.laboratorio.util.parsers.pardini.ExameJSON;
import jalis.laboratorio.util.parsers.pardini.ExameRetornoDePara;
import jalis.laboratorio.util.parsers.pardini.ExameRetornoSuspenso;
import jalis.laboratorio.util.parsers.pardini.ExameSelecionado;
import jalis.laboratorio.util.parsers.pardini.IdentificacaoJSON;
import jalis.laboratorio.util.parsers.pardini.JanelaHistoricoExamesSuspensos;
import jalis.laboratorio.util.parsers.pardini.ObjetoExamesConfiguradosJSON;
import jalis.laboratorio.util.parsers.pardini.ObjetoJSON;
import jalis.laboratorio.util.parsers.pardini.RespostaExameModelo;
import jalis.laboratorio.util.parsers.pardini.RespostaExameTabelaV2;
import jalis.laboratorio.util.parsers.pardini.RespostaModelos;
import jalis.laboratorio.util.parsers.pardini.RespostaModelosAtualizados;
import jalis.laboratorio.util.parsers.pardini.RespostaRetornoDePara;
import jalis.laboratorio.util.parsers.pardini.RespostaRetornoEnvio;
import jalis.laboratorio.util.parsers.pardini.RespostaRetornoTermoAceite;
import jalis.laboratorio.util.parsers.pardini.RespostaTabelaV2;
import jalis.laboratorio.util.parsers.pardini.RespostaTabelaV2Atualizados;
import jalis.laboratorio.util.parsers.pardini.RetornoHistoricoExameSuspensoJSON;
import jalis.laboratorio.util.parsers.pardini.RetornoStatusLoteJSON;
import jalis.laboratorio.util.parsers.pardini.SelecionarLoteEnviado;
import jalis.laboratorio.util.parsers.pardini.SelecionarParaIntegrar;
import jalis.model.bean.cadastro.exame.ExameLayoutMetodoBean;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoBean;
import jalis.model.bean.cadastro.exame.LabExternoLogIntegracaoBean;
import jalis.model.bean.cadastro.exame.LabExternoLotePardiniBean;
import jalis.model.bean.cadastro.exame.LabExternoVersaoTermoBean;
import jalis.model.vo.cadastro.LayoutVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.ExameLayoutVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.LabExternoLotePardiniVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.LabExternoVersaoTermoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.service.cadastro.exame.ExameLayoutMetodoService;
import jalis.service.cadastro.exame.ExameLayoutService;
import jalis.service.cadastro.exame.ExameMatColetaLabExternoService;
import jalis.service.cadastro.exame.ExameMatColetaService;
import jalis.service.cadastro.exame.LabExternoLotePardiniService;
import jalis.service.cadastro.exame.LabExternoVersaoTermoService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class IntegracaoDeParaHPardini
extends AbstractIntegracaoProtocolo {
    private static final String APPLICATION_JSON = "application/json";
    private static final String URL_PING_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/ping";
    private static final String URL_POSTDE_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara";
    private static final String URL_GETDE_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara";
    private static final String URL_AUTENTICACAO_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/autenticacao/laboratorio-conveniado";
    private static final String URL_TERMO_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/termo-de-aceite";
    private static final String URL_STATUS_LOTE_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/consultas/status/lote";
    private static final String URL_EXAMES_SUSPENSO_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/consultas/historico/exames/exames-suspensos";
    private static final String URL_MODELO_EXAMES_ATUALIZADOS_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/recursos/modelos/atualizados";
    private static final String URL_MODELO_EXAMES_TODOS_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/recursos/modelos/pagina";
    private static final String URL_CADASTRO_EXAMES_ATUALIZADOS_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/recursos/tabelalhpv2/atualizados";
    private static final String URL_CADASTRO_EXAMES_TODOS_HOMOLOGACAO = "https://lab2lab.grupopardini.com.br/symphony-homol/v2/depara/recursos/tabelalhpv2/pagina";
    private static final String URL_PING = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/ping";
    private static final String URL_POSTDE = "https://lab2lab.grupopardini.com.br/symphony/v2/depara";
    private static final String URL_GETDE = "https://lab2lab.grupopardini.com.br/symphony/v2/depara";
    private static final String URL_AUTENTICACAO = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/autenticacao/laboratorio-conveniado";
    private static final String URL_TERMO = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/termo-de-aceite";
    private static final String URL_STATUS_LOTE = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/consultas/status/lote";
    private static final String URL_EXAMES_SUSPENSO = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/consultas/historico/exames/exames-suspensos";
    private static final String URL_MODELO_EXAMES_ATUALIZADOS = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/recursos/modelos/atualizados";
    private static final String URL_MODELO_EXAMES_TODOS = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/recursos/modelos/pagina";
    private static final String URL_CADASTRO_EXAMES_ATUALIZADOS = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/recursos/tabelalhpv2/atualizados";
    private static final String URL_CADASTRO_EXAMES_TODOS = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/recursos/tabelalhpv2/pagina";
    private static final String URL_PRE_CONFIGURADOS = "https://lab2lab.grupopardini.com.br/symphony/v2/depara/manutencao/exames/pre-configurados";
    private static final String BUSCAR_MODELOS = "https://hp.thread.com.br/modelos.php";
    private static final String CRIAR_MODELO = "https://hp.thread.com.br/novo-modelo.php";
    private static final String ENVIAR_FORMATO = "https://hp.thread.com.br/enviar.php";
    private static final String LISTAR_EXAMES = "https://hp.thread.com.br/exames.php";
    private static final String PEGA_FORMATO = "https://hp.thread.com.br/formatos-jalis.php";
    private static final String TEM_VERSAO = "https://hp.thread.com.br/tem-versao.php";
    public static final String USER_AGENT = "java HTTP1.1/1.2.0";
    private boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    @Override
    protected String getPalavraChave() {
        return "C0nect0rforP4rd1n1Thread";
    }

    @Override
    protected String getDiretorioIntegracaoExportar() {
        return "";
    }

    @Override
    protected String getDiretorioIntegracaoImportar() {
        return "";
    }

    private boolean temExamesParaEnviar(List<ExameSelecionado> exames) {
        return exames != null && !exames.isEmpty();
    }

    private boolean temExamesConfiguradosParaEnviar(List<ExameConfiguradoJSON> exames) {
        return exames != null && !exames.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetornoIntegracaoDePara enviarDados(int filial, int labexterno, String xmlCodigoLC) {
        String senhaJalis;
        RetornoIntegracaoDePara retorno = new RetornoIntegracaoDePara();
        if (!this.pingar()) {
            retorno.setSucesso(false);
            retorno.setMensagens(new String[]{"<html>N\u00e3o foi poss\u00edvel conectar com o servidor do laborat\u00f3rio de apoio, verifique sua internet ou se possui algum bloqueio para o endere\u00e7o <b>lab2lab.grupopardini.com.br</b> e tente novamente.</html>"});
            return retorno;
        }
        SelecionarParaIntegrar sel = SelecionarParaIntegrar.novaInstancia(String.valueOf(labexterno), Laboratorio.getInstancia());
        sel.setVisible(true);
        List<ExameSelecionado> examesParaEnviar = null;
        List<ExameConfiguradoJSON> examesConfigurados = null;
        if (sel.isOk()) {
            examesParaEnviar = sel.getSelecionados();
            if (sel.enviarConfigurados()) {
                examesConfigurados = sel.getExamesConfigurados();
            }
        } else {
            return null;
        }
        if (!this.temExamesParaEnviar(examesParaEnviar) || sel.enviarConfigurados() && !this.temExamesConfiguradosParaEnviar(examesConfigurados)) {
            retorno.setSucesso(false);
            retorno.setMensagens(new String[]{"N\u00e3o h\u00e1 exames para enviar para o laborat\u00f3rio de apoio"});
            return retorno;
        }
        String codigoLCJalis = StringUtil.getValor(xmlCodigoLC, "codigoProtocolo");
        String token = this.loginComToken(codigoLCJalis, senhaJalis = StringUtil.getValor(xmlCodigoLC, "senhaWeb"));
        if (Funcoes.textoVazio(token)) {
            retorno.setSucesso(false);
            retorno.setMensagens(new String[]{"N\u00e3o foi poss\u00edvel autenticar no servidor do laborat\u00f3rio de apoio, verifique o c\u00f3digo e senha informado na configura\u00e7\u00e3o e tente novamente"});
            return retorno;
        }
        SplashMensagem mensagem = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        mensagem.mostrar("Aguarde...");
        LabExternoLogIntegracaoBean log = null;
        String responseString = "";
        try {
            CloseableHttpResponse response;
            LabExternoVersaoTermoVO lvt = this.getTermoDeAceite(filial, labexterno);
            ArrayList<Registro> registros = this.getListaExamesPardini(filial, labexterno, examesParaEnviar);
            ObjetoJSON ojson = new ObjetoJSON();
            ArrayList<ExameJSON> exames = new ArrayList<ExameJSON>();
            if (!registros.isEmpty()) {
                ojson.setIdentificacao(this.montarIdentificacao(registros.get(0)));
                ojson.setTermoDeAceite(new Base64().encodeAsString(lvt.getTermo().getBytes()));
                for (Registro reg : registros) {
                    ExameJSON tmp = this.montarExame(reg);
                    if (tmp == null) continue;
                    exames.add(tmp);
                }
                if (!exames.isEmpty()) {
                    ojson.setExames(exames.toArray(new ExameJSON[exames.size()]));
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
            String json = mapper.writeValueAsString((Object)ojson);
            log = this.gerarLog(filial, labexterno, "E", json);
            String jsonConfigurados = "";
            if (null != examesConfigurados && !examesConfigurados.isEmpty() && !registros.isEmpty()) {
                ObjetoExamesConfiguradosJSON ojsonconfigurados = new ObjetoExamesConfiguradosJSON();
                ojsonconfigurados.setIdentificacao(this.montarIdentificacao(registros.get(0)));
                ojsonconfigurados.setExames(examesConfigurados.toArray(new ExameConfiguradoJSON[examesConfigurados.size()]));
                ojsonconfigurados.setTermoDeAceite(new Base64().encodeAsString(lvt.getTermo().getBytes()));
                jsonConfigurados = mapper.writeValueAsString((Object)ojsonconfigurados);
                log = this.gerarLog(filial, labexterno, "C", jsonConfigurados);
            }
            if ((response = this.enviarListaDePara(token, json)) == null) {
                retorno.setSucesso(false);
                retorno.setMensagens(new String[]{"Ocorreu uma falha no servidor do laborat\u00f3rio e n\u00e3o foi poss\u00edvel exportar os exames"});
                log.setRetorno("Falha no servidor do laborat\u00f3rio e n\u00e3o foi poss\u00edvel exportar os exames");
                log.setSucesso(false);
            } else {
                ArrayList<String> mensagens;
                ArrayList cv;
                HttpEntity entity;
                HttpEntity entity2;
                if (this.statusOK(response)) {
                    entity2 = response.getEntity();
                    responseString = EntityUtils.toString((HttpEntity)entity2);
                    retorno.setSucesso(true);
                    retorno.setMensagens(this.tratarRetornoEnvio(filial, labexterno, responseString, true));
                    log.setSucesso(true);
                    log.setRetorno(responseString);
                } else {
                    retorno.setSucesso(false);
                    log.setSucesso(false);
                    int status = response.getStatusLine().getStatusCode();
                    if (status == 401) {
                        retorno.setMensagens(new String[]{"N\u00e3o foi poss\u00edvel autenticar o laborat\u00f3rio ao enviar os dados, verifique o usu\u00e1rio e senha e tente novamente"});
                        log.setRetorno("Falha de autentica\u00e7\u00e3o");
                    } else {
                        entity = response.getEntity();
                        responseString = EntityUtils.toString((HttpEntity)entity);
                        cv = (ArrayList)mapper.readValue(responseString, (TypeReference)new TypeReference<List<ChaveValorJSON>>(){});
                        if (null == cv) {
                            retorno.setMensagens(new String[]{"N\u00e3o foi poss\u00edvel comunicar com o servidor do laborat\u00f3rio de apoio - status " + status});
                            log.setRetorno("Falha de envio - status " + status);
                        } else {
                            mensagens = new ArrayList<String>();
                            for (ChaveValorJSON c : cv) {
                                mensagens.add(c.getValor());
                            }
                            retorno.setMensagens(mensagens.toArray(new String[mensagens.size()]));
                            log.setRetorno("Mensagem recebida do servidor do laborat\u00f3rio de apoio");
                        }
                    }
                }
                if (!Funcoes.textoVazio(jsonConfigurados)) {
                    String[] tmp;
                    response = this.enviarListaDeParaConfigurados(token, jsonConfigurados);
                    if (this.statusOK(response)) {
                        entity2 = response.getEntity();
                        responseString = EntityUtils.toString((HttpEntity)entity2);
                        tmp = retorno.getMensagens();
                        retorno.setMensagens(ArraysUtil.concatenar(tmp, ArraysUtil.concatenar(new String[]{"\nEnvio de exames configurados: \n"}, this.tratarRetornoEnvio(filial, labexterno, responseString, false))));
                        log.setSucesso(true);
                        log.setRetorno(responseString);
                    } else if (null != response) {
                        int status = response.getStatusLine().getStatusCode();
                        if (status == 401) {
                            tmp = retorno.getMensagens();
                            retorno.setMensagens(ArraysUtil.concatenar(tmp, new String[]{"\nEnvio de exames configurados: \nN\u00e3o foi poss\u00edvel autenticar o laborat\u00f3rio ao enviar os dados de exames configurados, verifique o usu\u00e1rio e senha e tente novamente"}));
                            log.setRetorno("Falha de autentica\u00e7\u00e3o");
                        } else {
                            entity = response.getEntity();
                            responseString = EntityUtils.toString((HttpEntity)entity);
                            cv = (ArrayList)mapper.readValue(responseString, (TypeReference)new TypeReference<List<ChaveValorJSON>>(){});
                            if (null == cv) {
                                String[] tmp2 = retorno.getMensagens();
                                retorno.setMensagens(ArraysUtil.concatenar(tmp2, new String[]{"\nEnvio de exames configurados: \nN\u00e3o foi poss\u00edvel comunicar com o servidor do laborat\u00f3rio de apoio para enviar os exames configurados - status " + status}));
                                log.setRetorno("Falha de envio de exames configurados - status " + status);
                            } else {
                                mensagens = new ArrayList();
                                for (ChaveValorJSON c : cv) {
                                    mensagens.add(c.getValor());
                                }
                                String[] tmp3 = retorno.getMensagens();
                                retorno.setMensagens(ArraysUtil.concatenar(tmp3, ArraysUtil.concatenar(new String[]{"\nEnvio de exames configurados: \n"}, mensagens.toArray(new String[mensagens.size()]))));
                                log.setRetorno("Mensagem recebida do servidor do laborat\u00f3rio de apoio");
                            }
                        }
                    } else {
                        retorno.setSucesso(false);
                        String[] tmp4 = retorno.getMensagens();
                        retorno.setMensagens(ArraysUtil.concatenar(tmp4, ArraysUtil.concatenar(new String[]{"\nEnvio de exames configurados: \n"}, this.tratarRetornoEnvio(filial, labexterno, responseString, false))));
                        log.setSucesso(false);
                        log.setRetorno(responseString);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "IntegracaoDeParaHPardini (75)");
            if (log != null) {
                log.setSucesso(false);
                log.setRetorno(e.getMessage() + "\n" + responseString);
            }
        }
        finally {
            mensagem.apagar();
        }
        this.gravarLog(log);
        return retorno;
    }

    private SSLConnectionSocketFactory construirSSL() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder builder = new SSLContextBuilder();
        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
        return new SSLConnectionSocketFactory(builder.build());
    }

    private String[] tratarRetornoEnvio(int filial, int labExterno, String json, boolean apresentarLote) throws IOException {
        ArrayList<String> retorno = new ArrayList<String>();
        if (Funcoes.textoVazio(json)) {
            retorno.add("N\u00e3o foi identificado a mensagem de retorno do servidor");
            return retorno.toArray(new String[retorno.size()]);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        RespostaRetornoEnvio retornoJson = (RespostaRetornoEnvio)mapper.readValue(json, RespostaRetornoEnvio.class);
        if (this.retornoComSucesso(retornoJson)) {
            if (!this.inserirLoteRetornoPrevisao(filial, labExterno, String.valueOf(retornoJson.getLote()), retornoJson.getPrevisaoRetorno(), retornoJson.getAceitos())) {
                retorno.add("N\u00e3o foi poss\u00edvel armazenar a identifica\u00e7\u00e3o do lote " + retornoJson.getLote());
            }
            String dataRetorno = Funcoes.formataData("dd/MM/yyyy kk:mm:ss", retornoJson.getPrevisaoRetorno());
            retorno.add(retornoJson.getAceitos() + " exame(s) aceito(s) pelo laborat\u00f3rio" + (apresentarLote ? ", lote n\u00famero " + retornoJson.getLote() + " com previs\u00e3o de retorno em " + dataRetorno : ""));
        } else if (retornoJson == null) {
            retorno.add("N\u00e3o foi poss\u00edvel obter a resposta do servidor ao enviar a listagem de exames");
        }
        return retorno.toArray(new String[retorno.size()]);
    }

    private boolean retornoComSucesso(RespostaRetornoEnvio r) {
        return r != null && r.getAceitos() > 0;
    }

    private boolean inserirLoteRetornoPrevisao(int filial, int labExterno, String lote, Date previsaoRetorno, int examesRecebidos) {
        boolean retorno = false;
        LabExternoLotePardiniService service = new LabExternoLotePardiniService();
        try {
            LabExternoLotePardiniVO vo = service.getLote(String.valueOf(filial), String.valueOf(labExterno), lote);
            if (vo == null) {
                LabExternoLotePardiniBean bean = new LabExternoLotePardiniBean();
                FilialVO f = new FilialVO();
                f.setCodigo(filial);
                LabExternoVO l = new LabExternoVO();
                l.setFilial(f);
                l.setCodigo(labExterno);
                bean.setFilial(f);
                bean.setLabExterno(l);
                bean.setLote(lote);
                bean.setDataHoraEnvio(Funcoes.getDataHoraServidor());
                bean.setPrevisaoRetorno(Funcoes.formataData("dd/MM/yyyy kk:mm:ss", previsaoRetorno));
                bean.setQuantidadeExamesEnviados(examesRecebidos);
                service.insert(bean, null, Variaveis.filialPadrao, "");
            }
            Conexao.arquivaSQL();
            retorno = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Ocorreu uma falha ao registrar os dados do lote enviado", e.getStackTrace());
        }
        return retorno;
    }

    private boolean solicitarTermoDeAceite(int filial, int labExterno, String token) {
        LabExternoLogIntegracaoBean log;
        boolean retorno;
        block8: {
            retorno = false;
            log = null;
            try {
                log = this.gerarLog(filial, labExterno, "T", "solicitar termo de aceite");
                CloseableHttpResponse response = this.enviarSolicitacaoTermo(token);
                if (response != null && this.statusOK(response)) {
                    HttpEntity entity = response.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity);
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                    RespostaRetornoTermoAceite retornoJson = (RespostaRetornoTermoAceite)mapper.readValue(responseString, RespostaRetornoTermoAceite.class);
                    if (retornoJson != null) {
                        log.setDataHoraFim(Funcoes.getDataHoraServidor());
                        log.setSucesso(true);
                        log.setRetorno(responseString);
                        if (!this.termoJaAdicionado(filial, labExterno, retornoJson.getVersaoTermo())) {
                            LabExternoVersaoTermoService service = new LabExternoVersaoTermoService();
                            service.insert(this.versaoTermoJsonToBean(filial, labExterno, retornoJson), null, Variaveis.filialPadrao, ParametrosGerais.getCopiaLabExterno());
                            retorno = true;
                        }
                    } else {
                        log.setDataHoraFim(Funcoes.getDataHoraServidor());
                        log.setSucesso(false);
                        log.setRetorno("Falha ao processar o retorno do termo de aceite - " + responseString);
                    }
                } else {
                    log.setDataHoraFim(Funcoes.getDataHoraServidor());
                    log.setSucesso(false);
                    log.setRetorno("Falha ao obter o retorno do servidor pardini - " + (response != null ? "statuscode " + response.getStatusLine().getStatusCode() : "response: null"));
                }
            }
            catch (Exception e) {
                if (log != null) {
                    log.setDataHoraFim(Funcoes.getDataHoraServidor());
                    log.setSucesso(false);
                    log.setRetorno("Falha ao obter o retorno do servidor pardini " + e.getMessage());
                }
                if (!this.debug) break block8;
                e.printStackTrace();
            }
        }
        this.gravarLog(log);
        return retorno;
    }

    public LabExternoVersaoTermoBean versaoTermoJsonToBean(int filial, int labExterno, RespostaRetornoTermoAceite json) {
        String tmp = json.getTermoDeAceite();
        String termoConvertido = new String(new Base64().decode(tmp.getBytes()), StandardCharsets.UTF_8);
        LabExternoVersaoTermoBean bean = new LabExternoVersaoTermoBean();
        FilialVO f = new FilialVO();
        f.setCodigo(filial);
        LabExternoVO l = new LabExternoVO();
        l.setCodigo(labExterno);
        l.setFilial(f);
        bean.setFilial(f);
        bean.setLabExterno(l);
        bean.setDataHoraAtualizacao(Funcoes.getDataHoraServidor());
        bean.setVersao(json.getVersaoTermo());
        bean.setTermo(termoConvertido);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetornoIntegracaoDePara importarDados(int filial, int labExterno, String xmlCodigoLC, String xmlMetodo) throws IntegracaoProtocoloException {
        SplashMensagem mensagem = SplashMensagem.getInstancia(Laboratorio.getInstancia());
        mensagem.mostrar("Aguarde...");
        RetornoIntegracaoDePara retorno = new RetornoIntegracaoDePara();
        ArrayList<String> mensagensRetorno = new ArrayList<String>();
        ArrayList<ExameMatColetaVO> examesRetorno = new ArrayList<ExameMatColetaVO>();
        boolean sucesso = false;
        String metodoConfigurado = StringUtil.getValor(xmlMetodo, "metodo");
        LabExternoLogIntegracaoBean log = null;
        try {
            SelecionarLoteEnviado sel;
            String codigoLCJalis = StringUtil.getValor(xmlCodigoLC, "codigoProtocolo");
            String senhaJalis = StringUtil.getValor(xmlCodigoLC, "senhaWeb");
            mensagensRetorno.add("Solicitando token de acesso");
            String token = this.loginComToken(codigoLCJalis, senhaJalis);
            if (Funcoes.textoVazio(token)) {
                retorno.setSucesso(false);
                retorno.setMensagens(new String[]{"N\u00e3o foi poss\u00edvel autenticar no servidor do laborat\u00f3rio de apoio, verifique o c\u00f3digo e senha informado na configura\u00e7\u00e3o e tente novamente"});
                RetornoIntegracaoDePara retornoIntegracaoDePara = retorno;
                return retornoIntegracaoDePara;
            }
            mensagensRetorno.add("Solicitando termo de aceite ao servidor");
            if (this.solicitarTermoDeAceite(filial, labExterno, token)) {
                mensagensRetorno.add("Novo termo de aceite adicionado ao laborat\u00f3rio");
            }
            mensagensRetorno.add("Solicitando lotes ao servidor");
            LabExternoLotePardiniService serviceLotes = new LabExternoLotePardiniService();
            ArrayList<LabExternoLotePardiniVO> lotes = serviceLotes.getTodosVO(String.valueOf(filial), String.valueOf(labExterno));
            String lote = "";
            if (lotes != null) {
                if (lotes.size() == 1) {
                    lote = lotes.get(0).getLote();
                } else {
                    sel = new SelecionarLoteEnviado();
                    sel.setLotes(lotes);
                    sel.setVisible(true);
                    if (sel.getOK()) {
                        lote = sel.getLoteSelecionado().getLote();
                    }
                }
            }
            if (Funcoes.textoVazio(lote)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum lote selecionado para importa\u00e7\u00e3o", 2);
                sel = null;
                return sel;
            }
            String status = this.verificarRetornoStatusLote(token, lote);
            boolean continuar = Funcoes.textoVazio(status);
            log = this.gerarLog(filial, labExterno, "R", "Solicitando lote " + lote + "\n" + status);
            if (!continuar) {
                Funcoes.mensagem(Laboratorio.getInstancia(), status, 2);
                RetornoIntegracaoDePara retornoIntegracaoDePara = null;
                return retornoIntegracaoDePara;
            }
            CloseableHttpResponse response = this.enviarSolicitacaoDePara(token, lote);
            if (response != null) {
                mensagensRetorno.add("Validando dados recebidos");
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity);
                log.setRetorno(responseString);
                log.setSucesso(!this.mensagemComErro(responseString));
                log.setDataHoraFim(Funcoes.getDataHoraServidor());
                ObjectMapper mapper = new ObjectMapper();
                mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
                if (!log.getSucesso().booleanValue()) {
                    ArrayList cv = (ArrayList)mapper.readValue(responseString, (TypeReference)new TypeReference<List<ChaveValorJSON>>(){});
                    for (ChaveValorJSON ch : cv) {
                        mensagensRetorno.add(ch.getValor());
                    }
                } else {
                    ExameMatColetaLabExternoService service = new ExameMatColetaLabExternoService();
                    if (this.jsonImportarDeParaValido(responseString)) {
                        RespostaRetornoDePara retornoJson = (RespostaRetornoDePara)mapper.readValue(responseString, RespostaRetornoDePara.class);
                        if (retornoJson != null) {
                            if (this.validarLC(retornoJson.getCodigoLc(), codigoLCJalis)) {
                                for (ExameRetornoDePara exame : retornoJson.getDePara()) {
                                    if (!exame.isSemPredicao() && exame.temDeParaJalisConfigurado()) {
                                        boolean existeAlgumConfigurado = service.verificaExamePossuiAlgumaConfiguracaoLabExterno(String.valueOf(filial), exame.getCodigoExameJalis(), exame.getCodigoMaterialJalis());
                                        boolean existeConfiguradoParaPardini = service.verificaHaAssociacaoExameMaterialLabExterno(String.valueOf(filial), exame.getCodigoExameJalis(), exame.getCodigoMaterialJalis(), String.valueOf(labExterno));
                                        if (!existeConfiguradoParaPardini) {
                                            examesRetorno.add(this.montarVOdeRetorno(filial, exame.getCodigoExameJalis(), Integer.parseInt(exame.getCodigoMaterialJalis())));
                                            this.inserirExameMaterialLabExterno(exame.getCodigoExameJalis(), Integer.parseInt(exame.getCodigoMaterialJalis()), exame.getXML(), 0, 0.0, !existeAlgumConfigurado, Integer.parseInt(metodoConfigurado), String.valueOf(labExterno));
                                            Set<ExameLayoutVO> modelos = this.buscaModelosDoExame(String.valueOf(filial), exame.getCodigoExameJalis(), exame.getCodigoMaterialJalis());
                                            for (ExameLayoutVO modelo : modelos) {
                                                if (this.temMetodoNoModeloDoExame(modelo.getFilial().getCodigo().toString(), modelo.getExame().getCodigo(), modelo.getMatColeta().getCodigo().toString(), modelo.getLayout().getCodigo().toString(), modelo.getIdadeIni().toString(), modelo.getIdadeIniTipo(), modelo.getIdadeFim().toString(), modelo.getIdadeFimTipo(), metodoConfigurado)) continue;
                                                ExameLayoutMetodoBean bean = this.montarBean(modelo.getFilial().getCodigo().toString(), modelo.getExame().getCodigo(), modelo.getMatColeta().getCodigo().toString(), modelo.getLayout().getCodigo().toString(), modelo.getIdadeIni().toString(), modelo.getIdadeIniTipo(), modelo.getIdadeFim().toString(), modelo.getIdadeFimTipo(), metodoConfigurado);
                                                ExameLayoutMetodoService serviceMetodo = new ExameLayoutMetodoService();
                                                serviceMetodo.insert(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
                                            }
                                            mensagensRetorno.add(this.criarMensagemLog("Adicionado exame " + exame.getDescExm() + " (" + exame.getDescMat() + "), c\u00f3digo no sistema: " + exame.getCodExmLab()));
                                            continue;
                                        }
                                        mensagensRetorno.add("Exame " + exame.getDescExm() + " j\u00e1 configurado");
                                        continue;
                                    }
                                    mensagensRetorno.add(this.criarMensagemLog("Exame " + exame.getDescExm() + " n\u00e3o configurado pelo laborat\u00f3rio"));
                                }
                                if (null != retornoJson.getSuspensos() && retornoJson.getSuspensos().length > 0) {
                                    for (ExameRetornoSuspenso suspenso : retornoJson.getSuspensos()) {
                                        this.atualizarExameMaterialLabExternoSuspenso(suspenso.getCodigoExameJalis(), Integer.parseInt(suspenso.getCodigoMaterialJalis()), String.valueOf(labExterno));
                                        mensagensRetorno.add(this.criarMensagemLog("Exame " + suspenso.getCodExmLab() + " (" + suspenso.getDescExmLab() + ", material " + suspenso.getDescMatLab() + "), suspenso pelo laborat\u00f3rio de apoio, motivo: " + suspenso.getDetalhesMotivoSuspensao()));
                                    }
                                }
                                if (retornoJson.getDePara() != null && retornoJson.getDePara().length > 0) {
                                    LabExternoLotePardiniService s = new LabExternoLotePardiniService();
                                    s.atualizarDataRecebimentoLote(String.valueOf(filial), String.valueOf(labExterno), lote, Funcoes.getDataHoraServidor());
                                }
                                sucesso = true;
                            } else {
                                log.setDataHoraFim(Funcoes.getDataHoraServidor());
                                log.setSucesso(false);
                                log.setRetorno("C\u00f3digo de LC incorreto, verifique a configura\u00e7\u00e3o do laborat\u00f3rio externo (recebido: " + retornoJson.getCodigoLc() + ")");
                                mensagensRetorno.add(log.getRetorno());
                            }
                        } else {
                            log.setDataHoraFim(Funcoes.getDataHoraServidor());
                            log.setSucesso(false);
                            log.setRetorno("Formato de retorno n\u00e3o esperado do servidor");
                            mensagensRetorno.add(log.getRetorno());
                        }
                    } else {
                        log.setDataHoraFim(Funcoes.getDataHoraServidor());
                        log.setSucesso(false);
                        log.setRetorno("Resposta n\u00e3o esperada do servidor\nMensagem apresentada: " + responseString);
                        mensagensRetorno.add(log.getRetorno());
                    }
                }
            } else {
                log.setDataHoraFim(Funcoes.getDataHoraServidor());
                log.setSucesso(false);
                log.setRetorno("N\u00e3o houve resposta do servidor");
                mensagensRetorno.add(log.getRetorno());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (null != log) {
                log.setDataHoraFim(Funcoes.getDataHoraServidor());
                log.setSucesso(false);
                log.setRetorno(e.getMessage());
            }
        }
        finally {
            mensagem.apagar();
        }
        this.gravarLog(log);
        RetornoIntegracaoDePara r = new RetornoIntegracaoDePara();
        r.setSucesso(sucesso);
        r.setMensagens(mensagensRetorno.toArray(new String[mensagensRetorno.size()]));
        r.setImportados(examesRetorno.toArray(new ExameMatColetaVO[examesRetorno.size()]));
        return r;
    }

    private boolean mensagemComErro(String json) {
        return json.toUpperCase().indexOf("existem erros".toUpperCase()) > -1 || json.toUpperCase().indexOf("\"chave\":\"Erro\"".toUpperCase()) > -1;
    }

    private LabExternoLogIntegracaoBean gerarLog(int filial, int labExterno, String operacao, String envio) {
        LabExternoLogIntegracaoBean bean = new LabExternoLogIntegracaoBean();
        FilialVO f = new FilialVO();
        f.setCodigo(filial);
        LabExternoVO l = new LabExternoVO();
        l.setFilial(f);
        l.setCodigo(labExterno);
        UsuarioVO u = new UsuarioVO();
        u.setCodigo(Variaveis.login);
        bean.setFilial(f);
        bean.setLabExterno(l);
        bean.setUsuario(u);
        bean.setDataHoraInicio(Funcoes.getDataHoraServidor());
        bean.setTipoOperacao(operacao);
        bean.setEnvio(envio);
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gravarLog(LabExternoLogIntegracaoBean log) {
        Statement st = ConexaoTemporaria.getStatement();
        try {
            String sql = "insert into labexternologintegracao(fil_codigo, lae_codigo, lil_datahorainicio, lil_datahorafim, lil_sucesso, lil_tipooperacao, lil_envio, lil_retorno, usr_codigo) values (" + log.getFilial().getCodigo() + ", " + log.getLabExterno().getCodigo() + ", " + StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", log.getDataHoraInicio())) + ", " + StringUtil.textoDBEscape(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", log.getDataHoraFim() == null ? Funcoes.getDataHoraServidor() : log.getDataHoraFim())) + ", " + log.getSucesso() + ", " + StringUtil.textoDBEscape(log.getTipoOperacao()) + ", '" + StringUtil.textoDB(log.getEnvio()) + "', '" + StringUtil.textoDB(log.getRetorno()) + "', " + StringUtil.textoDBEscape(log.getUsuario().getCodigo()) + ")";
            st.executeUpdate(sql);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e1) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar o log de comunica\u00e7\u00e3o.\n" + e1.getMessage(), 1);
            try {
                ConexaoTemporaria.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
    }

    private boolean validarLC(String recebido, String origem) {
        return !Funcoes.textoVazio(recebido) && !Funcoes.textoVazio(origem) && recebido.equalsIgnoreCase(origem);
    }

    private String criarMensagemLog(String mensagem) {
        return mensagem;
    }

    private ExameLayoutMetodoBean montarBean(String filial, String exame, String material, String modelo, String idadeInicial, String tipoIdadeInicial, String idadeFinal, String tipoIdadeFinal, String metodo) {
        ExameLayoutMetodoBean bean = new ExameLayoutMetodoBean();
        FilialVO f = new FilialVO();
        f.setCodigo(Integer.parseInt(filial));
        MetodologiaVO m = new MetodologiaVO();
        m.setFilial(f);
        m.setCodigo(Integer.parseInt(metodo));
        ExameVO e = new ExameVO();
        e.setFilial(f);
        e.setCodigo(exame);
        MaterialColetaVO mat = new MaterialColetaVO();
        mat.setFilial(f);
        mat.setCodigo(Integer.parseInt(material));
        LayoutVO l = new LayoutVO();
        l.setFilial(f);
        l.setCodigo(Integer.parseInt(modelo));
        bean.setFilial(f);
        bean.setLayout(l);
        bean.setExame(e);
        bean.setMatColeta(mat);
        bean.setMetodologia(m);
        bean.setIdadeInicial(Integer.parseInt(idadeInicial));
        bean.setIdadeInicioTipo(tipoIdadeInicial);
        bean.setIdadeFim(Integer.parseInt(idadeFinal));
        bean.setIdadeFimTipo(tipoIdadeFinal);
        bean.setDadosBrutos("");
        bean.setExportarTexto("");
        bean.setFormato("");
        bean.setNormal("");
        bean.setMapa("");
        return bean;
    }

    private ExameMatColetaVO montarVOdeRetorno(int filial, String codigoExame, int codigoMaterial) throws Exception {
        ExameMatColetaService service = new ExameMatColetaService();
        return (ExameMatColetaVO)service.getVO(String.valueOf(filial), codigoExame, String.valueOf(codigoMaterial));
    }

    private boolean temMetodoNoModeloDoExame(String filial, String exame, String material, String modelo, String idadeInicial, String tipoIdadeInicial, String idadeFinal, String tipoIdadeFinal, String metodo) throws Exception {
        ExameLayoutMetodoService service = new ExameLayoutMetodoService();
        Set tmp = service.loadVO(" where fil_codigo = " + filial + " and exa_codigo = " + StringUtil.textoDBEscape(exame) + " and mco_codigo = " + material + " and lay_codigo = " + modelo + " and ela_idadeini = " + idadeInicial + " and ela_idadeinitipo = " + StringUtil.textoDBEscape(tipoIdadeInicial) + " and ela_idadefim = " + idadeFinal + " and ela_idadefimtipo = " + StringUtil.textoDBEscape(tipoIdadeFinal) + " and met_codigo = " + metodo);
        return tmp != null && tmp.size() > 0;
    }

    private Set<ExameLayoutVO> buscaModelosDoExame(String filial, String exame, String material) throws Exception {
        ExameLayoutService service = new ExameLayoutService();
        return service.loadVO(" where fil_codigo = " + filial + " and exa_codigo = " + StringUtil.textoDBEscape(exame) + " and mco_codigo = " + material);
    }

    private void atualizarExameMaterialLabExternoSuspenso(String codigoExame, int codigoMaterial, String codigoLabExterno) throws Exception {
        ExameMatColetaLabExternoBean bean = new ExameMatColetaLabExternoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(new Integer(Variaveis.filialPadrao));
        LabExternoVO labexterno = new LabExternoVO();
        labexterno.setCodigo(Integer.parseInt(codigoLabExterno));
        labexterno.setFilial(filial);
        ExameVO exame = new ExameVO();
        exame.setFilial(filial);
        exame.setCodigo(codigoExame);
        MaterialColetaVO material = new MaterialColetaVO();
        material.setFilial(filial);
        material.setCodigo(codigoMaterial);
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setLaboratorioExterno(labexterno);
        bean.setMatColeta(material);
        bean.setBloqueado(true);
        new ExameMatColetaLabExternoService().update(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
    }

    private void inserirExameMaterialLabExterno(String codigoExame, int codigoMaterial, String xml, int prazoLabExt, Double valorExame, Boolean padrao, Integer metodoPadrao, String codigoLabExterno) throws Exception {
        ExameMatColetaLabExternoBean bean = new ExameMatColetaLabExternoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(new Integer(Variaveis.filialPadrao));
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setCodigo(metodoPadrao);
        metodo.setFilial(filial);
        LabExternoVO labexterno = new LabExternoVO();
        labexterno.setCodigo(Integer.parseInt(codigoLabExterno));
        labexterno.setFilial(filial);
        ExameVO exame = new ExameVO();
        exame.setFilial(filial);
        exame.setCodigo(codigoExame);
        MaterialColetaVO material = new MaterialColetaVO();
        material.setFilial(filial);
        material.setCodigo(codigoMaterial);
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setDiasprazo(prazoLabExt);
        bean.setLaboratorioExterno(labexterno);
        bean.setMatColeta(material);
        bean.setMetodologia(metodo);
        bean.setPadrao(padrao);
        bean.setValorExame(valorExame);
        bean.setXmlLabExterno(xml);
        bean.setBloqueado(true);
        new ExameMatColetaLabExternoService().insert(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
    }

    private void inserirMetodoModelo(int codigoLayout, int codigoMetodo, String codigoExame, int codigoMaterial, int idadeInicial, int idadeFinal, String tipoIdadeInicial, String tipoIdadeFinal) throws Exception {
        ExameLayoutMetodoBean bean = new ExameLayoutMetodoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(new Integer(Variaveis.filialPadrao));
        filial.setDescricao("");
        MaterialColetaVO material = new MaterialColetaVO();
        material.setCodigo(codigoMaterial);
        material.setFilial(filial);
        ExameVO exame = new ExameVO();
        exame.setCodigo(codigoExame);
        exame.setFilial(filial);
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setCodigo(codigoMetodo);
        metodo.setFilial(filial);
        LayoutVO layout = new LayoutVO();
        layout.setFilial(filial);
        layout.setCodigo(codigoLayout);
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setIdadeInicial(idadeInicial);
        bean.setIdadeInicioTipo(tipoIdadeInicial);
        bean.setIdadeFim(idadeFinal);
        bean.setIdadeFimTipo(tipoIdadeFinal);
        bean.setLayout(layout);
        bean.setMatColeta(material);
        bean.setMetodologia(metodo);
        bean.setDadosBrutos("");
        bean.setExportarTexto("");
        bean.setFormato("");
        bean.setNormal("");
        new ExameLayoutMetodoService().insert(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
    }

    private IdentificacaoJSON montarIdentificacao(Registro registro) throws XMLStringBuilderException {
        IdentificacaoJSON identificacao = null;
        if (registro != null) {
            identificacao = new IdentificacaoJSON();
            identificacao.setEmail(registro.getString("email"));
            identificacao.setLaboratorioConveniado(registro.getString("razaosocial"));
            identificacao.setCNPJ(StringUtil.limpaString(registro.getString("cnpj"), new String[]{"/", ".", "-"}));
            identificacao.setCodigoLC(Integer.parseInt(registro.getString("codigolc")));
            identificacao.setNomeUsuario(Variaveis.nomeUsuario);
            identificacao.setCargoUsuario(Variaveis.nomeUsuario);
            identificacao.setSoftwareHouse("THREAD");
            identificacao.setLis("JALIS");
            identificacao.setTipoEnvio("API");
        }
        return identificacao;
    }

    private ExameJSON montarExame(Registro registro) {
        ExameJSON exame = null;
        if (registro != null) {
            exame = new ExameJSON();
            exame.setCodExmLab(registro.getString("codexmlab"));
            exame.setDescExmLab(registro.getString("descexmlab"));
            exame.setDescMatLab(registro.getString("descmatlab"));
        }
        return exame;
    }

    private boolean exameFoiSelecionado(String exame, int material, List<ExameSelecionado> examesParaEnviar) {
        boolean retorno;
        block1: {
            ExameSelecionado e;
            retorno = false;
            if (null == examesParaEnviar) break block1;
            Iterator<ExameSelecionado> iterator = examesParaEnviar.iterator();
            while (iterator.hasNext() && !(retorno = exame.equals((e = iterator.next()).getExame()) && material == e.getMaterial())) {
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Registro> getListaExamesPardini(int filial, int labexterno, List<ExameSelecionado> examesParaEnviar) {
        ArrayList<Registro> retorno = new ArrayList<Registro>();
        String sql = "select distinct 'THREAD' as softwarehouse, 'suporte@thread.com.br' as email, c.fil_cnpj as cnpj, c.fil_descricao as laboratorio, c.fil_razaosocial as razaosocial, 'View' as tipoenvio, (case when not validarxml(pegartag(f.lae_configuracao, 'hpardini')) then '' else pegarvalortag(pegartag(f.lae_configuracao, 'hpardini'), 'codigoProtocolo') end) as codigolc, (case when not validarxml(pegartag(f.lae_configuracao, 'hpardini')) then '' else pegarvalortag(pegartag(f.lae_configuracao, 'hpardini'), 'senhaWeb') end) as senhaweb, d.mco_descricao as descmatlab, (a.exa_codigo || '|' || a.mco_codigo) as codexmlab, b.exa_descricao as descexmlab, a.exa_codigo, a.mco_codigo, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'codigo-exame') end) as codexm, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'material-selecionado') end) as descmat, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'descricao-exame') end) as descexm,'' as codigoformato,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>Altura</info-complementar>') > 0 end)  as altura,false as hematocrito,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>LinfocitosAbsoluto</info-complementar>') > 0 end) as linfocitosabsoluto,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>Glicemia</info-complementar>') > 0 end) as glicemia,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>Peso</info-complementar>') > 0 end) as peso,false as pesoamostra,false as tempoamostra,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>TempoDiurese</info-complementar>') > 0 end) as tempodiurese,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>VolumeDiurese</info-complementar>') > 0 end) as volumediurese,(case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'grupo-amostra') end) as grupo, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'ori-admissivel') end) as regiao, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'conservante-selecionado') end) as conservante,'' as condicao,false as grafico,false as imagem, (select count(exa_codigo) from examematcoletalabextdesm where fil_codigo = a.fil_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo) > 0 as curva,coalesce(upper((case when not validarxml(e.ele_xmllabexterno) then 'nao' else pegarvalortag(e.ele_xmllabexterno, 'codigo-material') end)), 'nao') = upper('DIV') as materialdiversos,false as contrato from examematcoleta a join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo join filiais_postocoleta c on a.fil_codigo = c.fil_codigo join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo left join labexterno f on a.fil_codigo = f.fil_codigo and f.lae_codigo = ? left join examematcoletalabexterno e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo and e.lae_codigo = f.lae_codigo where a.fil_codigo = ? order by 7";
        PreparedStatement pst = Conexao.getPreparedStatement("select distinct 'THREAD' as softwarehouse, 'suporte@thread.com.br' as email, c.fil_cnpj as cnpj, c.fil_descricao as laboratorio, c.fil_razaosocial as razaosocial, 'View' as tipoenvio, (case when not validarxml(pegartag(f.lae_configuracao, 'hpardini')) then '' else pegarvalortag(pegartag(f.lae_configuracao, 'hpardini'), 'codigoProtocolo') end) as codigolc, (case when not validarxml(pegartag(f.lae_configuracao, 'hpardini')) then '' else pegarvalortag(pegartag(f.lae_configuracao, 'hpardini'), 'senhaWeb') end) as senhaweb, d.mco_descricao as descmatlab, (a.exa_codigo || '|' || a.mco_codigo) as codexmlab, b.exa_descricao as descexmlab, a.exa_codigo, a.mco_codigo, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'codigo-exame') end) as codexm, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'material-selecionado') end) as descmat, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'descricao-exame') end) as descexm,'' as codigoformato,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>Altura</info-complementar>') > 0 end)  as altura,false as hematocrito,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>LinfocitosAbsoluto</info-complementar>') > 0 end) as linfocitosabsoluto,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>Glicemia</info-complementar>') > 0 end) as glicemia,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>Peso</info-complementar>') > 0 end) as peso,false as pesoamostra,false as tempoamostra,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>TempoDiurese</info-complementar>') > 0 end) as tempodiurese,(case when not validarxml(e.ele_xmllabexterno) then 'false' else strpos(e.ele_xmllabexterno, '<info-complementar>VolumeDiurese</info-complementar>') > 0 end) as volumediurese,(case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'grupo-amostra') end) as grupo, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'ori-admissivel') end) as regiao, (case when not validarxml(e.ele_xmllabexterno) then '' else pegarvalortag(e.ele_xmllabexterno, 'conservante-selecionado') end) as conservante,'' as condicao,false as grafico,false as imagem, (select count(exa_codigo) from examematcoletalabextdesm where fil_codigo = a.fil_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo) > 0 as curva,coalesce(upper((case when not validarxml(e.ele_xmllabexterno) then 'nao' else pegarvalortag(e.ele_xmllabexterno, 'codigo-material') end)), 'nao') = upper('DIV') as materialdiversos,false as contrato from examematcoleta a join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo join filiais_postocoleta c on a.fil_codigo = c.fil_codigo join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo left join labexterno f on a.fil_codigo = f.fil_codigo and f.lae_codigo = ? left join examematcoletalabexterno e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo and e.lae_codigo = f.lae_codigo where a.fil_codigo = ? order by 7");
        try {
            pst.setInt(1, labexterno);
            pst.setInt(2, filial);
            ResultSet rs = Conexao.executeQuery(pst);
            while (rs.next()) {
                if (!this.exameFoiSelecionado(rs.getString("exa_codigo"), rs.getInt("mco_codigo"), examesParaEnviar)) continue;
                retorno.add(new Registro(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "IntegracaoDeParaHPardini (169)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(pst);
                throw throwable;
            }
            Conexao.fecharStatement(pst);
        }
        Conexao.fecharStatement(pst);
        return retorno;
    }

    @Override
    public boolean validarConfiguracaoParaExportar(String xml) {
        return xml != null && !xml.isEmpty() && !Funcoes.textoVazio(StringUtil.getValor(xml, "codigoProtocolo"));
    }

    @Override
    public boolean validarConfiguracaoParaImportar(String xml, String xmlParametros) {
        boolean protocoloOK = xml != null && !xml.isEmpty() && !Funcoes.textoVazio(StringUtil.getValor(xml, "codigoProtocolo"));
        boolean metodoOK = xmlParametros != null && !xmlParametros.isEmpty() && !Funcoes.textoVazio(StringUtil.getValor(xmlParametros, "metodo"));
        return protocoloOK && metodoOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean termoJaAdicionado(int filial, int labExterno, String versao) {
        boolean retorno = false;
        Statement st = Conexao.getStatement();
        String sql = "select fil_codigo, lae_codigo, lat_versao, lat_datahoraatualizacao, lat_termo, lat_datahoraaceite, usr_codaceite from labexternoversaotermo where fil_codigo = " + filial + "  and lae_codigo = " + labExterno + "  and lat_versao = " + StringUtil.textoDBEscape(versao);
        try {
            ResultSet rs = Conexao.executeQuery(st, sql);
            retorno = rs.next();
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar a vers\u00e3o do termo de aceite", e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    @Override
    public LabExternoVersaoTermoVO getTermoDeAceite(int filial, int labExterno) {
        LabExternoVersaoTermoVO retorno = null;
        try {
            LabExternoVersaoTermoService service = new LabExternoVersaoTermoService();
            retorno = service.getTermoAceiteMaisNovo(filial, labExterno);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao buscar o termo de aceite", e.getStackTrace());
        }
        return retorno;
    }

    @Override
    public boolean isTermoAceito(int filial, int labexterno) {
        LabExternoVersaoTermoVO termo = this.getTermoDeAceite(filial, labexterno);
        return termo != null && termo.getDataHoraAceite() != null;
    }

    @Override
    public void aceitarTermoAceite(int filial, int labExterno, String versao, String usuario) throws Exception {
        LabExternoVersaoTermoService service = new LabExternoVersaoTermoService();
        service.atualizaDataAceiteTermo(String.valueOf(filial), labExterno, versao, usuario);
    }

    @Override
    public void importarTermoAceite(int filial, int labExterno, String codigoLC, String senhaLC) {
        String token = this.loginComToken(codigoLC, senhaLC);
        if (!Funcoes.textoVazio(token)) {
            this.solicitarTermoDeAceite(filial, labExterno, token);
        }
    }

    @Override
    public NomeModeloWeb[] importarNomesModelosWeb(int filial, int labExterno) {
        ArrayList<NomeModeloWeb> retorno = new ArrayList<NomeModeloWeb>();
        try {
            URL url = new URL(BUSCAR_MODELOS);
            HttpURLConnection lista = (HttpURLConnection)url.openConnection();
            lista.setRequestProperty("User-Agent", USER_AGENT);
            if (lista.getResponseCode() == 200) {
                String retornoJson = this.inpuStreamToString(lista.getInputStream());
                if (!Funcoes.textoVazio(retornoJson)) {
                    JSONArray array = new JSONArray(retornoJson);
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject json = array.getJSONObject(i);
                        NomeModeloWeb modelo = new NomeModeloWeb();
                        modelo.setCodigo(json.getInt("codigo"));
                        modelo.setDescricao(json.getString("descricao"));
                        retorno.add(modelo);
                    }
                }
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar os modelos na web.\n" + lista.getResponseMessage(), 1);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Erro ao buscar os modelos na web.\n" + e.getMessage(), 1);
        }
        return retorno.toArray(new NomeModeloWeb[retorno.size()]);
    }

    @Override
    public boolean verificaVersaoModeloNaWeb(String codigoLC, String codigoThread, int modelo, String exame, String material, String versao) {
        boolean retorno = false;
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("modelo", String.valueOf(modelo));
            params.put("exame", exame);
            params.put("material", material);
            params.put("versao", versao);
            params.put("codigothread", codigoThread);
            params.put("codigolc", codigoLC);
            HttpURLConnection link = this.configurarLink(new URL(TEM_VERSAO), params);
            if (link.getResponseCode() == 200) {
                String retornoJson = this.inpuStreamToString(link.getInputStream());
                if (!Funcoes.textoVazio(retornoJson)) {
                    JSONObject json = new JSONObject(retornoJson);
                    retorno = json != null && json.getBoolean("retorno");
                }
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel consultar a vers\u00e3o do modelo na web.\n" + link.getResponseMessage(), 1);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Erro ao consultar a vers\u00e3o do modelo na web.\n" + e.getMessage(), 1);
        }
        return retorno;
    }

    private HttpURLConnection configurarLink(URL url, Map<String, Object> parametros) throws IOException {
        StringBuilder postData = new StringBuilder();
        byte[] postDataBytes = null;
        if (parametros != null && parametros.size() > 0) {
            for (Map.Entry<String, Object> param : parametros.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode(param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            postDataBytes = postData.toString().getBytes("UTF-8");
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("User-Agent", USER_AGENT);
        conn.setDoOutput(true);
        if (parametros != null && parametros.size() > 0 && postDataBytes != null && postDataBytes.length > 0) {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.getOutputStream().write(postDataBytes);
        }
        return conn;
    }

    @Override
    public String importarVersaoModeloNaWeb(String codigoLC, String codigoThread, int modelo, String exame, String material, String versao) {
        String retorno = "";
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("modelo", String.valueOf(modelo));
            params.put("exame", exame);
            params.put("material", material);
            params.put("versao", versao);
            params.put("codigothread", codigoThread);
            params.put("codigolc", codigoLC);
            HttpURLConnection link = this.configurarLink(new URL(PEGA_FORMATO), params);
            if (link.getResponseCode() == 200) {
                String retornoJson = this.inpuStreamToString(link.getInputStream());
                if (!Funcoes.textoVazio(retornoJson)) {
                    JSONObject json = new JSONObject(retornoJson);
                    String string = retorno = json != null ? json.getString("xml") : "";
                    if (!Funcoes.textoVazio(retorno)) {
                        retorno = new String(new Base64().decode(retorno.getBytes()), StandardCharsets.ISO_8859_1);
                    }
                }
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel importar a vers\u00e3o do modelo na web.\n" + link.getResponseMessage(), 1);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Erro ao importar a vers\u00e3o do modelo na web.\n" + e.getMessage(), 1);
        }
        return retorno;
    }

    private String inpuStreamToString(InputStream buffer) {
        try {
            BufferedInputStream in = new BufferedInputStream(buffer);
            StringBuilder retorno = new StringBuilder();
            int valor = in.read();
            while (valor != -1) {
                retorno.append((char)valor);
                valor = in.read();
            }
            return retorno.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private CloseableHttpResponse ping() throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get((String)URL_PING).addHeader("Content-Type", APPLICATION_JSON).setCharset(StandardCharsets.UTF_8).build();
        return client.execute(request);
    }

    private CloseableHttpResponse autenticar(String usuario, String senha) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get((String)URL_AUTENTICACAO).addHeader("Content-Type", APPLICATION_JSON).setCharset(StandardCharsets.UTF_8).addParameter("codigoLc", usuario).addParameter("senha", senha).build();
        return client.execute(request);
    }

    private boolean processarPing(String json) {
        boolean retorno;
        block3: {
            retorno = false;
            JSONTokener jt = new JSONTokener(json);
            if (null != jt) {
                try {
                    JSONArray j = new JSONArray(jt);
                    JSONObject o = j.getJSONObject(0);
                    retorno = j.length() > 0 && o.has("status") ? o.getString("status").equalsIgnoreCase("rodando") : false;
                }
                catch (JSONException e) {
                    if (!this.debug) break block3;
                    e.printStackTrace();
                }
            }
        }
        return retorno;
    }

    @Override
    public boolean pingar() {
        boolean retorno;
        block3: {
            retorno = false;
            try {
                CloseableHttpResponse response = this.ping();
                if (this.statusOK(response)) {
                    HttpEntity entity = response.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity);
                    retorno = this.processarPing(responseString);
                }
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                if (!this.debug) break block3;
                e.printStackTrace();
            }
        }
        return retorno;
    }

    private boolean statusOK(CloseableHttpResponse response) {
        return null != response && response.getStatusLine().getStatusCode() == 200;
    }

    private String loginComToken(String codigoLc, String senha) {
        String token;
        block3: {
            token = "";
            try {
                HttpEntity entity;
                String responseString;
                JSONTokener tk;
                JSONObject jo;
                CloseableHttpResponse response = this.autenticar(codigoLc, senha);
                if (this.statusOK(response) && (jo = new JSONObject(tk = new JSONTokener(responseString = EntityUtils.toString((HttpEntity)(entity = response.getEntity()))))).has("token")) {
                    token = jo.getString("token");
                }
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | JSONException e) {
                if (!this.debug) break block3;
                e.printStackTrace();
            }
        }
        return token;
    }

    private CloseableHttpResponse enviarListaDePara(String token, String json) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.post((String)"https://lab2lab.grupopardini.com.br/symphony/v2/depara").addHeader("Content-Type", APPLICATION_JSON).addHeader("Authorization", "Bearer " + token).setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(json, "UTF-8")).build();
        return client.execute(request);
    }

    private CloseableHttpResponse enviarListaDeParaConfigurados(String token, String json) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.post((String)URL_PRE_CONFIGURADOS).addHeader("Content-Type", APPLICATION_JSON).addHeader("Authorization", "Bearer " + token).setCharset(StandardCharsets.UTF_8).setEntity((HttpEntity)new StringEntity(json, "UTF-8")).build();
        return client.execute(request);
    }

    private RequestConfig buildRequestConfig() {
        int timeout = 60;
        return RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
    }

    private CloseableHttpResponse enviarSolicitacaoTermo(String token) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_TERMO).addHeader("Authorization", "Bearer " + token).build();
        return client.execute(request);
    }

    private CloseableHttpResponse enviarSolicitacaoDePara(String token, String lote) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri("https://lab2lab.grupopardini.com.br/symphony/v2/depara").addHeader("Authorization", "Bearer " + token).addParameter("numeroLote", lote).build();
        return client.execute(request);
    }

    private CloseableHttpResponse solicitarStatusLote(String token, String lote) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_STATUS_LOTE).addHeader("Authorization", "Bearer " + token).addParameter("numeroLote", lote).build();
        return client.execute(request);
    }

    private String verificarRetornoStatusLote(String token, String lote) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        String retorno = "";
        CloseableHttpResponse response = this.solicitarStatusLote(token, lote);
        if (response != null && this.statusOK(response)) {
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
            RetornoStatusLoteJSON retornoJson = (RetornoStatusLoteJSON)mapper.readValue(responseString, RetornoStatusLoteJSON.class);
            if (null != retornoJson) {
                if (retornoJson.getStatusLote() != 70 && retornoJson.getStatusLote() != 80) {
                    return "O lote n\u00e3o pode ser importado, a situa\u00e7\u00e3o atual ? \"" + retornoJson.getDescricaoStatusLote() + "\", a previs\u00e3o de retorno do lote ? " + Funcoes.formataData("dd/MM/yyyy kk:mm", retornoJson.getPrevisaoRetorno());
                }
            } else {
                return "N\u00e3o foi poss\u00edvel obter o status do lote no laborat\u00f3rio de apoio";
            }
        }
        return retorno;
    }

    private CloseableHttpResponse solicitarHistoricoExamesSuspensos(String token) throws IOException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_EXAMES_SUSPENSO).addHeader("Authorization", "Bearer " + token).build();
        return client.execute(request);
    }

    private RetornoHistoricoExameSuspensoJSON carregarHistoricoExamesSuspensos(String token) throws KeyManagementException, ClientProtocolException, NoSuchAlgorithmException, KeyStoreException, IOException {
        HttpEntity entity;
        String responseString;
        RetornoHistoricoExameSuspensoJSON retorno = null;
        CloseableHttpResponse response = this.solicitarHistoricoExamesSuspensos(token);
        if (response != null && this.statusOK(response) && this.jsonHistoricoExameSuspensoValido(responseString = EntityUtils.toString((HttpEntity)(entity = response.getEntity())))) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
            retorno = (RetornoHistoricoExameSuspensoJSON)mapper.readValue(responseString, RetornoHistoricoExameSuspensoJSON.class);
        }
        return retorno;
    }

    private boolean jsonImportarDeParaValido(String json) {
        return !Funcoes.textoVazio(json) && json.toUpperCase().indexOf("codigoLc".toUpperCase()) > -1;
    }

    private boolean jsonTabelaV2ModeloValido(String json) {
        return !Funcoes.textoVazio(json) && json.toUpperCase().indexOf("paginaAtual".toUpperCase()) > -1 && json.toUpperCase().indexOf("exames".toUpperCase()) > -1;
    }

    private boolean jsonTabelaV2ModelosAtualizadosValido(String json) {
        return !Funcoes.textoVazio(json) && json.toUpperCase().indexOf("quantidadeExames".toUpperCase()) > -1 && json.toUpperCase().indexOf("exames".toUpperCase()) > -1;
    }

    private boolean jsonHistoricoTabelaExamesValido(String json) {
        return !Funcoes.textoVazio(json) && json.toUpperCase().indexOf("quantidadeExames".toUpperCase()) > -1 && json.toUpperCase().indexOf("exames".toUpperCase()) > -1;
    }

    private boolean jsonHistoricoExameSuspensoValido(String json) {
        return !Funcoes.textoVazio(json) && json.toUpperCase().indexOf("codigoLc".toUpperCase()) > -1;
    }

    @Override
    public void apresentarHistoricoExamesSuspensos(Object pai, String xmlCodigoLC) {
        String senhaJalis;
        if (Funcoes.textoVazio(xmlCodigoLC)) {
            Funcoes.mensagem(pai instanceof JFrame ? (JFrame)pai : (JDialog)pai, "Configura\u00e7\u00f5es de acesso ao servidor laborat\u00f3rio de apoio n\u00e3o informadas, verifique o c\u00f3digo e senha informado na configura\u00e7\u00e3o e tente novamente", 2);
            return;
        }
        String codigoLCJalis = StringUtil.getValor(xmlCodigoLC, "codigoProtocolo");
        String token = this.loginComToken(codigoLCJalis, senhaJalis = StringUtil.getValor(xmlCodigoLC, "senhaWeb"));
        if (Funcoes.textoVazio(token)) {
            Funcoes.mensagem(pai instanceof JFrame ? (JFrame)pai : (JDialog)pai, "N\u00e3o foi poss\u00edvel autenticar no servidor do laborat\u00f3rio de apoio, verifique o c\u00f3digo e senha informado na configura\u00e7\u00e3o e tente novamente", 2);
            return;
        }
        try {
            RetornoHistoricoExameSuspensoJSON historico = this.carregarHistoricoExamesSuspensos(token);
            if (null != historico) {
                JanelaHistoricoExamesSuspensos janela = pai instanceof Frame ? new JanelaHistoricoExamesSuspensos((Frame)pai, historico) : new JanelaHistoricoExamesSuspensos((Dialog)pai, historico);
                janela.setVisible(true);
                janela.dispose();
            } else {
                Funcoes.mensagem(pai instanceof JFrame ? (JFrame)pai : (JDialog)pai, "N\u00e3o foi poss\u00edvel obter o hist\u00f3rico de exames do laborat\u00f3rio de apoio", 2);
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(pai instanceof JFrame ? (JFrame)pai : (JDialog)pai, "N\u00e3o foi poss\u00edvel iniciar o hist\u00f3rico de exames do laborat\u00f3rio de apoio.\nMensagem: " + e.getMessage(), 2);
        }
    }

    private void apresentarMensagens(JTextArea text, String mensagem) {
        if (null != text && !Funcoes.textoVazio(mensagem)) {
            text.setText(mensagem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetornoImportacaoCadastroModelos importarCadastrosExames(JTextArea textMensagens, String codigoLC, String senha, boolean apenasAtualizados, Date data) {
        RetornoImportacaoCadastroModelos retorno = new RetornoImportacaoCadastroModelos();
        retorno.setQuantidade(0);
        this.apresentarMensagens(textMensagens, "Solicitando cadastro de exames");
        try {
            block13: {
                block14: {
                    block15: {
                        block11: {
                            block10: {
                                String responseString;
                                String token;
                                block12: {
                                    token = this.loginComToken(codigoLC, senha);
                                    CloseableHttpResponse response = apenasAtualizados ? this.solicitarCadastroExamesAtualizados(token, data) : this.solicitarCadastroExames(token, 1, 100);
                                    if (response == null) break block10;
                                    if (!this.statusOK(response)) break block11;
                                    HttpEntity entity = response.getEntity();
                                    responseString = EntityUtils.toString((HttpEntity)entity);
                                    if (!apenasAtualizados || !this.jsonTabelaV2ModelosAtualizadosValido(responseString)) break block12;
                                    ObjectMapper mapper = new ObjectMapper();
                                    mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                                    RespostaTabelaV2Atualizados exames = (RespostaTabelaV2Atualizados)mapper.readValue(responseString, RespostaTabelaV2Atualizados.class);
                                    if (null == exames) break block13;
                                    if (exames.getQuantidadeExames() <= 0) break block14;
                                    retorno.setApenasAtualizados(true);
                                    retorno.setDatahora(exames.getDataHoraDownloadDocumento());
                                    retorno.setQuantidade(exames.getQuantidadeExames());
                                    for (RespostaExameTabelaV2 r : exames.getExames()) {
                                        retorno.getRetorno().add(new String(new Base64().decode(r.getExameV2()), StandardCharsets.UTF_8));
                                    }
                                    break block15;
                                }
                                if (this.jsonTabelaV2ModeloValido(responseString)) {
                                    ObjectMapper mapper = new ObjectMapper();
                                    mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                                    RespostaTabelaV2 exames = (RespostaTabelaV2)mapper.readValue(responseString, RespostaTabelaV2.class);
                                    retorno.setApenasAtualizados(false);
                                    retorno.setDatahora(exames.getDataHoraDownloadDocumento());
                                    this.apresentarMensagens(textMensagens, "Analisando retorno de cadastro de exames");
                                    for (RespostaExameTabelaV2 r : exames.getExames()) {
                                        retorno.getRetorno().add(new String(new Base64().decode(r.getExameV2()), StandardCharsets.UTF_8));
                                    }
                                    while (exames.isTemProximaPagina()) {
                                        String responseStringW;
                                        CloseableHttpResponse responseW = this.solicitarCadastroExames(token, exames.getPaginaAtual() + 1, 100);
                                        if (null == responseW || !this.statusOK(responseW) || !this.jsonTabelaV2ModeloValido(responseStringW = EntityUtils.toString((HttpEntity)responseW.getEntity()))) continue;
                                        ObjectMapper mapperW = new ObjectMapper();
                                        mapperW.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                                        exames = (RespostaTabelaV2)mapperW.readValue(responseStringW, RespostaTabelaV2.class);
                                        for (RespostaExameTabelaV2 r : exames.getExames()) {
                                            retorno.getRetorno().add(new String(new Base64().decode(r.getExameV2()), StandardCharsets.UTF_8));
                                        }
                                    }
                                    retorno.setQuantidade(retorno.getRetorno().size());
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            retorno.setDatahora(new Date());
            retorno.setQuantidade(0);
            retorno.setMensagem(e.getMessage());
            retorno.setErro(true);
            e.printStackTrace();
        }
        finally {
            return retorno;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetornoImportacaoCadastroModelos importarModelosExames(JTextArea textMensagens, String codigoLC, String senha, boolean apenasAtualizados, Date data, String tipoValorReferencia) {
        RetornoImportacaoCadastroModelos retorno = new RetornoImportacaoCadastroModelos();
        retorno.setQuantidade(0);
        this.apresentarMensagens(textMensagens, "Solicitando modelos de exames");
        try {
            block13: {
                block14: {
                    block15: {
                        block11: {
                            block10: {
                                String responseString;
                                String token;
                                block12: {
                                    token = this.loginComToken(codigoLC, senha);
                                    CloseableHttpResponse response = apenasAtualizados ? this.solicitarModelosAtualizados(token, data, tipoValorReferencia) : this.solicitarModeloExames(token, 1, 100, tipoValorReferencia);
                                    if (response == null) break block10;
                                    if (!this.statusOK(response)) break block11;
                                    HttpEntity entity = response.getEntity();
                                    responseString = EntityUtils.toString((HttpEntity)entity);
                                    if (!apenasAtualizados || !this.jsonTabelaV2ModelosAtualizadosValido(responseString)) break block12;
                                    ObjectMapper mapper = new ObjectMapper();
                                    mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                                    RespostaModelosAtualizados exames = (RespostaModelosAtualizados)mapper.readValue(responseString, RespostaModelosAtualizados.class);
                                    if (null == exames) break block13;
                                    if (exames.getQuantidadeExames() <= 0) break block14;
                                    retorno.setApenasAtualizados(true);
                                    retorno.setDatahora(exames.getDataHoraDownloadDocumento());
                                    retorno.setQuantidade(exames.getQuantidadeExames());
                                    for (RespostaExameModelo r : exames.getExames()) {
                                        retorno.getRetorno().add(new String(new Base64().decode(r.getModelo()), StandardCharsets.UTF_8));
                                    }
                                    break block15;
                                }
                                if (this.jsonTabelaV2ModeloValido(responseString)) {
                                    ObjectMapper mapper = new ObjectMapper();
                                    mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                                    RespostaModelos exames = (RespostaModelos)mapper.readValue(responseString, RespostaModelos.class);
                                    retorno.setApenasAtualizados(false);
                                    retorno.setDatahora(exames.getDataHoraDownloadDocumento());
                                    this.apresentarMensagens(textMensagens, "Analisando retorno de modelos\n");
                                    for (RespostaExameModelo r : exames.getExames()) {
                                        retorno.getRetorno().add(new String(new Base64().decode(r.getModelo()), StandardCharsets.UTF_8));
                                    }
                                    while (exames.isTemProximaPagina()) {
                                        String responseStringW;
                                        CloseableHttpResponse responseW = this.solicitarModeloExames(token, exames.getPaginaAtual() + 1, 100, tipoValorReferencia);
                                        if (null == responseW || !this.statusOK(responseW) || !this.jsonTabelaV2ModeloValido(responseStringW = EntityUtils.toString((HttpEntity)responseW.getEntity()))) continue;
                                        ObjectMapper mapperW = new ObjectMapper();
                                        mapperW.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
                                        exames = (RespostaModelos)mapperW.readValue(responseStringW, RespostaModelos.class);
                                        for (RespostaExameModelo r : exames.getExames()) {
                                            retorno.getRetorno().add(new String(new Base64().decode(r.getModelo()), StandardCharsets.UTF_8));
                                        }
                                    }
                                    retorno.setQuantidade(retorno.getRetorno().size());
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            retorno.setDatahora(new Date());
            retorno.setQuantidade(0);
            retorno.setMensagem(e.getMessage());
            retorno.setErro(true);
            e.printStackTrace();
        }
        finally {
            return retorno;
        }
    }

    private CloseableHttpResponse solicitarCadastroExames(String token, int pagina, int tamanhoPagina) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_CADASTRO_EXAMES_TODOS).addHeader("Authorization", "Bearer " + token).addParameter("pagina", String.valueOf(pagina)).addParameter("tamanhoPagina", String.valueOf(tamanhoPagina)).build();
        return client.execute(request);
    }

    private CloseableHttpResponse solicitarCadastroExamesAtualizados(String token, Date data) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_CADASTRO_EXAMES_ATUALIZADOS).addHeader("Authorization", "Bearer " + token).addParameter("dataAtualizacao", Funcoes.formataData("yyyy-MM-dd", data)).build();
        return client.execute(request);
    }

    private CloseableHttpResponse solicitarModeloExames(String token, int pagina, int tamanhoPagina, String tipoReferencia) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_MODELO_EXAMES_TODOS).addHeader("Authorization", "Bearer " + token).addParameter("pagina", String.valueOf(pagina)).addParameter("tamanhoPagina", String.valueOf(tamanhoPagina)).addParameter("tipoValorReferencia", tipoReferencia).build();
        return client.execute(request);
    }

    private CloseableHttpResponse solicitarModelosAtualizados(String token, Date data, String tipoReferencia) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(this.buildRequestConfig()).setSSLSocketFactory((LayeredConnectionSocketFactory)this.construirSSL()).build();
        HttpUriRequest request = RequestBuilder.get().setUri(URL_MODELO_EXAMES_ATUALIZADOS).addHeader("Authorization", "Bearer " + token).addParameter("dataAtualizacao", Funcoes.formataData("yyyy-MM-dd", data)).addParameter("tipoValorReferencia", tipoReferencia).build();
        return client.execute(request);
    }
}

