/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import br.com.hermespardini.b2b.apoio.schemas.RastreabilidadeAmostra;
import br.com.hermespardini.b2b.apoio.schemas.XMLRastreabilidade;
import br.com.hermespardini.b2b.apoio.schemas.XMLServerSoapProxy;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.AbstractIntegracaoProtocolo;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.FabricaIntegracaoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.pardini.FiltroDataPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.CamposRelacionamentoHPardiniUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.model.bean.cadastro.exame.ExameLayoutMetodoBean;
import jalis.model.dao.util.parsers.pardini.ImportacaoResultadoHPardiniDao;
import jalis.model.vo.cadastro.LayoutVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.consultas.ConfiguracaoExameHPardiniVO;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.ExameLayoutMetodoService;
import jalis.service.integracaolaboratorioexterno.LoteExternoRequisicaoRastreioService;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.service.util.parsers.pardini.ImportacaoResultadoHPardiniService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;

public class ImportacaoResultadoHPardini
extends AbstractImportadorResultadoLabExterno {
    public static final String TAG_COD_LAB = "CodLab";
    public static final String TAG_COD_LOTE_LAB = "CodLoteLab";
    public static final String TAG_PROTOCOLO = "Protocolo";
    public static final String TAG_ID = "ID";
    public static final String TAG_CONSULTA = "Consulta";
    public static final String TAG_SOLICITA_RESULTADO = "SolicitaResultado";
    public static final String TAG_SOLICITA_LOTE = "SolicitaLote";
    public static final String TAG_OPERACAO = "Operacao";
    public static final String TAG_ACAO = "Acao";
    public static final String TAG_DATA_INICIAL = "DataInicial";
    public static final String TAG_HORA_INICIAL = "HoraInicial";
    public static final String TAG_DATA_FINAL = "DataFinal";
    public static final String TAG_HORA_FINAL = "HoraFinal";
    public static final String TAG_GRAFICO = "Grafico";
    public static final String TAG_UNIDADE_VALOR = "UnidadeNoValor";
    public static final String TAG_DADOS_CONSTANTES = "DadosConstantes";
    public static final String TAG_EXAMES_NAO_ESTRUTURADOS = "examesNaoEstruturadosLiberados";
    private JButton buttonImportarWebService = ComponenteFactory.novoJButton("Importar Webservice", 'W', this);
    private JButton buttonRastrear = ComponenteFactory.novoJButton("Consultar Rastreabilidade", this);
    private static String ULTIMO_SQL = "";
    private static final String FORMATO = "formato";
    private static final String FORMATOS = "Formatos";
    private static final String EXAME = "Exame";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final String TAG_FORMATO = "Formato";
    private static final String MSG_IMPORTACAO_PDF = "\nResultado recebido para: %s - %s | %s - Formato PDF";
    private final int SITUACAO_FORMATO_OK = 0;
    private final int SITUACAO_FORMATO_INCORRETO = 1;
    private final int SITUACAO_FORMATO_VERSAO_NAO_LOCALIZADA = 2;
    private final int SITUACAO_FORMATO_IMPORTAR_ESTRUTURA_DIFERENTE = 3;
    private final int SITUACAO_FORMATO_ATRIBUTOS_DIFERENTES = 4;
    private final int SITUACAO_FORMATO_ATUALIZADO_WEB = 5;
    private final int SITUACAO_XML_INCORRETO = 6;
    private static final SimpleDateFormat dataHPardini = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dataUsuario = new SimpleDateFormat("dd/MM/yyyy");
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private LaboratorioExterno labExterno = null;
    private AbstractIntegracaoProtocolo integracaoModeloWeb = null;
    private int codigoModeloWeb = -1;
    private String dadosConstante = "0";
    private String grafico = "0";
    private String unidadeValor = "0";
    public int codigoLabExterno;
    public LoteExternoExameRequisicaoService loteExternoExameRequisicaoService = new LoteExternoExameRequisicaoService();
    private ImportacaoResultadoHPardiniDao dao;
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private ImportacaoResultadoHPardiniService service;
    private Map<String, Map<String, Map<String, String>>> historicosExame = null;
    private Map<String, Map<String, Map<String, String>>> historicosExameFilial = null;
    private HashMap<String, String> requisicoesNotificar = new HashMap();

    public ImportacaoResultadoHPardini(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. H. Pardini a partir de arquivo XML", codigoLabExterno, Protocolo.HPardini, new JPanel(new FlowLayout(2)));
        boolean enviarUsandoWS;
        this.modeloRelatorio.clear();
        this.codigoLabExterno = codigoLabExterno;
        this.getPanelAdicional().add(this.buttonImprimir);
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        boolean bl = enviarUsandoWS = this.labExterno.configuracao.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(this.labExterno.configuracao, "enviarLoteWebservice") : false;
        if (enviarUsandoWS) {
            this.getPanelAdicional().add(this.buttonImportarWebService);
            this.getPanelAdicional().remove(this.buttonImportar);
            this.buttonImportar.setText("Importar Arquivo");
            this.getPanelAdicional().add(this.buttonImportar);
            this.getPanelAdicional().add(this.buttonRastrear);
        }
        this.service = new ImportacaoResultadoHPardiniService();
        this.dao = new ImportacaoResultadoHPardiniDao();
        this.historicosExame = null;
        this.historicosExameFilial = null;
        try {
            LabExternoVO vo = this.service.pesquisarPorCodLabExterno(codigoLabExterno);
            if (vo.getCodigo() != null) {
                this.conferirAutomatico = vo.getConferirAutomatico();
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(vo.getCodigoUsuarioConferir()) || Funcoes.textoVazio(vo.getCodigoUsuarioConferir()) ? null : vo.getCodigoUsuarioConferir();
                this.service.setConferirAutomatico(this.conferirAutomatico);
                this.service.setCodigoUsuarioConferenciaAutomatica(this.codigoUsuarioConferenciaAutomatica);
                this.codigoModeloWeb = vo.getCodigoModeloWeb();
            }
            if (Protocolo.HPardini.isImportarModeloLayoutWeb() && this.codigoModeloWeb > -1) {
                this.integracaoModeloWeb = FabricaIntegracaoLabExterno.novaIntegracaoLabExterno(Protocolo.HPardini);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini (122)");
        }
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        try {
            ElementoHPardini res;
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. H. Pardini (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0 && (res = ParserResultadoHPardini.analisarXMLHPardini(chooser.getSelectedFile())) != null) {
                StringBuilder str = new StringBuilder();
                if (!res.getNome().equals("Resultados")) {
                    this.setTextoInformacoes("O arquivo \"" + chooser.getSelectedFile().getPath() + "\" n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                    return;
                }
                if (res.contemFilho("ControleDeLote")) {
                    ElementoHPardini aux = res.getFilho("ControleDeLote");
                    str.append("Controle de Lote \n");
                    str.append("  Emissor: ").append(aux.getFilho("Emissor").getValor()).append(" \n");
                    str.append("  Data Emiss\u00e3o: ").append(this.formataData(aux.getFilho("DataEmissao").getValor())).append(" \n");
                    str.append("  Hora Emiss\u00e3o:   ").append(aux.getFilho("HoraEmissao").getValor()).append(" \n");
                    aux = aux.getFilho("Periodo");
                    if (aux != null) {
                        str.append("Per\u00edodo \n");
                        if (aux.getFilho(TAG_DATA_INICIAL) != null) {
                            str.append("  Data Inicial: ").append(this.formataData(aux.getFilho(TAG_DATA_INICIAL).getValor())).append(" \n");
                        }
                        if (aux.getFilho(TAG_HORA_INICIAL) != null) {
                            str.append("  Hora Inicial:   ").append(aux.getFilho(TAG_HORA_INICIAL).getValor()).append(" \n");
                        }
                        if (aux.getFilho(TAG_DATA_FINAL) != null) {
                            str.append("  Data Final:   ").append(this.formataData(aux.getFilho(TAG_DATA_FINAL).getValor())).append(" \n");
                        }
                        if (aux.getFilho(TAG_HORA_FINAL) != null) {
                            str.append("  Hora Final:     ").append(aux.getFilho(TAG_HORA_FINAL).getValor()).append(" \n");
                        }
                    }
                    this.setTextoInformacoes(str.toString());
                }
                this.importarResultados(res.getFilhos("Pedido"), false);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoHPardini: 35");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importarResultados(List<ElementoHPardini> pedidos, boolean importacaoWebService) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st != null) {
            try {
                Integer total = 0;
                for (ElementoHPardini ped : pedidos) {
                    total = total + ped.getFilhos("SuperExame").size();
                }
                this.progress.setMaximum(total);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                String dataEmissaoLotePardini = "";
                String codigoPedidoApoio = "";
                ArrayList<String> lancadosNoRelatorio = new ArrayList<String>();
                for (ElementoHPardini pedido : pedidos) {
                    if (Funcoes.textoVazio(dataEmissaoLotePardini) && pedido.getNome().equals("ControleDeLote")) {
                        dataEmissaoLotePardini = pedido.getFilho("DataEmissao").getValor();
                    }
                    LinkedList<Object> listaRegistros = new LinkedList();
                    for (ElementoHPardini superExame : pedido.getFilhos("SuperExame")) {
                        String situacaoExame;
                        this.progress.setValue(this.progress.getValue() + 1);
                        codigoPedidoApoio = pedido.getFilho("CodPedApoio").getValor();
                        if (pedido.getFilho("CodPedLab") == null || Funcoes.textoVazio(pedido.getFilho("CodPedLab").getValor())) {
                            this.setTextoInformacoes("\nNenhuma requisi\u00e7\u00e3o encontrada para o codigo apoio: " + codigoPedidoApoio, false);
                            break;
                        }
                        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                        if (pedido.getFilho("CodPedLab").getValor().length() != tamTubo) {
                            this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + pedido.getFilho("CodPedLab").getValor(), false);
                            break;
                        }
                        if (!Funcoes.isNumeric(pedido.getFilho("CodPedLab").getValor()) || pedido.getFilho("CodPedLab").getValor().contains(".") || pedido.getFilho("CodPedLab").getValor().contains(",")) {
                            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o: " + pedido.getFilho("CodPedLab").getValor() + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o (verifique o valor de " + "CodPedLab" + ")", false);
                            break;
                        }
                        if (superExame.getFilho("CodExmLab") == null || !superExame.getFilho("CodExmLab").getValor().contains("|")) {
                            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o: " + pedido.getFilho("CodPedLab").getValor() + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o(verifique o valor de " + "CodExmLab" + ")", false);
                            continue;
                        }
                        String filCodigo = pedido.getFilho("CodPedLab").getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
                        String reqCodigo = pedido.getFilho("CodPedLab").getValor().substring(ParametrosGerais.getDigitosTuboFilial());
                        int possuiDivisor = superExame.getFilho("CodExmLab").getValor().indexOf(124);
                        if (possuiDivisor < 0) continue;
                        String exameJalis = superExame.getFilho("CodExmLab").getValor().split("[|]")[0];
                        String materialJalis = superExame.getFilho("CodExmLab").getValor().split("[|]")[1];
                        if (!Funcoes.isNumeric(materialJalis)) continue;
                        Integer[] multiguias = this.verificarRequisicaoMultiguia(filCodigo, reqCodigo);
                        if (exameJalis != null && materialJalis != null && !Funcoes.textoVazio(situacaoExame = this.dao.pesquisarSituacaoExame(filCodigo, this.labExterno.codigoLab, multiguias, exameJalis, materialJalis)) && !situacaoExame.equals("P")) {
                            String string = Tipos.tipoSituacaoExame(situacaoExame);
                            this.setTextoInformacoes(String.format("\n Exame %s %s", exameJalis, string), false);
                            continue;
                        }
                        listaRegistros = this.processarPaiFilhos(st, superExame, filCodigo, multiguias, codigoPedidoApoio);
                        if (listaRegistros == null || listaRegistros.isEmpty()) {
                            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada: " + filCodigo + reqCodigo, false);
                            continue;
                        }
                        for (Registro registro : listaRegistros) {
                            boolean importarComVersaoDiferenteEstruturaIgual;
                            String codExame;
                            if (!this.existeExameSeparado(registro)) continue;
                            String string = codExame = this.exameDesmembrado(registro) ? registro.getString("examePai") : registro.getString("exa_codigo");
                            if (this.exameJaLancado(registro)) {
                                if (this.importaEmPDF(registro) || !lancadosNoRelatorio.isEmpty() && lancadosNoRelatorio.contains(codigoPedidoApoio + "|" + codExame)) continue;
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), codigoPedidoApoio, codExame, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao), false);
                                lancadosNoRelatorio.add(codigoPedidoApoio + "|" + codExame);
                                continue;
                            }
                            if (!this.exameColetado(registro) && this.existeExameSeparado(registro) && !registro.getString("exr_situacao").equals("P")) {
                                this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), codigoPedidoApoio, codExame, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL.descricao), false);
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                continue;
                            }
                            if (!this.exameRelacionado(registro)) {
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                this.setTextoInformacoes("\nResultado de " + registro.getString("req_codigo") + "|" + codExame + " - Sem relacionamento", false);
                                continue;
                            }
                            this.requisicoesNotificar.put(Funcoes.getChaveFilReq(registro.getString("fil_codigo"), registro.getString("req_codigo")), registro.getString("req_codigo"));
                            boolean resultadoEmPDF = false;
                            if (importacaoWebService) {
                                resultadoEmPDF = this.resultadoImportadoEmPDF(registro, superExame, dataEmissaoLotePardini);
                            }
                            if (resultadoEmPDF) continue;
                            if (registro.nulo("examePai")) {
                                registro.setValor("examePai", registro.getString("exa_codigo"));
                            }
                            boolean salvoParcial = registro.getString("exr_situacao").equals("P");
                            this.carregarLayoutPorIdade(registro);
                            Registro formato = new Registro();
                            formato.setValor(FORMATO, registro.getValor("formatoPadrao"));
                            formato.setValor("met_codigo", registro.getValor("met_codigo"));
                            Registro formatacao = salvoParcial ? (Registro)registro.getValor(FORMATACAO) : formato;
                            int situacaoFormato = this.validaSituacaoVersaoIncorreta(formatacao, superExame, registro);
                            boolean bl = importarComVersaoDiferenteEstruturaIgual = situacaoFormato == 3;
                            if (superExame.getFilho("CodigoFormato").getValor().equalsIgnoreCase("PDF")) {
                                this.setTextoInformacoes("\nResultado em PDF para: " + Funcoes.preencheZero(registro.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(registro.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + registro.getString("exa_codigo") + " - Dispon\u00edvel em PDF no site do Laborat\u00f3rio Hermes Pardini", false);
                                continue;
                            }
                            if (situacaoFormato == 1 || situacaoFormato == 2) {
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                String mensagem = "";
                                mensagem = superExame.getFilho(EXAME) == null ? mensagem + " - Formato do arquivo de importa\u00e7\u00e3o incorreto" : mensagem + " - Vers\u00e3o incorreta (Vers\u00e3o e estrutura incorreta)";
                                if (situacaoFormato == 2) {
                                    mensagem = mensagem + " (N\u00e3o localizado modelo para importa\u00e7\u00e3o)";
                                }
                                this.setTextoInformacoes("\nResultado de  " + registro.getString("req_codigo") + "|" + registro.getString("exa_codigo") + mensagem, false);
                                continue;
                            }
                            if (situacaoFormato == 4) {
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                this.setTextoInformacoes("\nResultado de " + registro.getString("req_codigo") + "|" + registro.getString("exa_codigo") + " - Estrutura incorreta", false);
                                continue;
                            }
                            if (situacaoFormato == 6) {
                                this.setTextoInformacoes("\nResultado de " + registro.getString("req_codigo") + "|" + registro.getString("exa_codigo") + " - O XML especificado est\u00e1 incorreto, o conte\u00fado possui caracteres inv\u00e1lidos.", false);
                                continue;
                            }
                            StringBuilder resultadoAtual = new StringBuilder();
                            Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"), registro.getString("fil_codigo"), false, false);
                            dados.putAll(CamposRelacionamentoHPardiniUtil.getMapCampoValor(superExame, resultadoAtual, registro));
                            Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("pac_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"), registro.getString("met_codigo"));
                            Map<String, Map<String, String>> historicos = this.getHistoricosPorExame(registro.getString("exa_codigo"), registro.getString("fil_codigo"));
                            if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                                historicos = this.getHistoricosPorFilial(registro.getString("fil_codigo"));
                            }
                            dados.putAll(RecepcaoUtil.preencheHashDados(registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo")));
                            Map<String, Object> resposta = Resultado.getCamposResultado(registro.getString("exr_resposta"));
                            Resultado res = new Resultado(formatacao.getString(FORMATO), dados);
                            res.atualizarComponentes();
                            res = new Resultado(null, formatacao.getString(FORMATO), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                            res.atualizarComponentes();
                            if (!res.verificarCondicao()) {
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                this.setTextoInformacoes("\nResultado de " + registro.getString("req_codigo") + "|" + registro.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                                continue;
                            }
                            if (importarComVersaoDiferenteEstruturaIgual) {
                                this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                this.setTextoInformacoes("\nResultado de " + registro.getString("req_codigo") + "|" + registro.getString("exa_codigo") + " - Resultado importado com a vers\u00e3o diferenciada.", false);
                            }
                            boolean completo = true;
                            if (registro.getBoolean("exa_salvaparcial")) {
                                completo = res.resultadoCompleto(true);
                            }
                            if (!completo && registro.getBoolean("exa_salvaparcial")) {
                                completo = res.resultadoCompleto(false);
                            }
                            String novaSituacao = completo ? "L" : "P";
                            String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                            Util.gravaAlteracaoExameRequisicao(st, registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"));
                            boolean marcarConferido = false;
                            if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                                int verificacao = res.verificarValidacao();
                                boolean bl2 = marcarConferido = verificacao == 1;
                                if (!marcarConferido && verificacao != 2) {
                                    this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                                    this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + registro.getString("req_codigo") + "|" + registro.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                                }
                            }
                            if (!this.existeRequisicaoLabExterno(registro.getInt("fil_codigo"), this.codigoLabExterno, registro.getInt("req_codigo"), pedido.getFilho("CodPedApoio").getValor())) {
                                this.inserirDadosRequisicao(st, this.codigoLabExterno, pedido.getFilho("CodPedApoio").getValor(), registro.getString("fil_codigo"), registro.getInt("req_codigo"));
                            }
                            if (registro.getValor("examePai") != null) {
                                registro.setValor("exa_codigo", registro.getString("examePai"));
                            }
                            boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                            boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                            this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), registro, registro, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                            if (this.exportarBaseWeb(registro)) {
                                Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, registro.getString("fil_codigo"), registro.getString("req_codigo"), registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultado, false);
                                this.exportarParaWeb(st, this.getCodigoBaseWeb(registro.getString("fil_codigo")), novaSituacao, registro, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                                if (ExportaWeb.isGerarPdfResultado(st2, registro.getString("fil_codigo"))) {
                                    ExportaWeb.enviarResultadoPDF(st2, registro.getString("fil_codigo"), registro.getString("req_codigo"), this.getCodigoBaseWeb(registro.getString("fil_codigo")));
                                }
                            }
                            this.adicionarAoModeloRelatorio(superExame, completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE, registro.getString("req_codigo"), registro.getString("exa_codigo"));
                            if (completo) {
                                Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registro.getDate("exr_datamaterial") : new Date();
                                Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? registro.getDate("exr_datamaterial") : new Date();
                                this.atualizarTabelaExamesControle(st, registro, res.getResultadoAnterior(dataColeta, horaColeta));
                            }
                            this.atualizarPaginaOrdemExameWeb(st, registro);
                            this.editarRequisicaoExportaFiliais(registro);
                            this.atualizarSituacaoExameInterfaceamento(st, registro);
                            this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(registro.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(registro.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + registro.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE)), false);
                        }
                    }
                    ResultadosUtil.enviarNotificacoes(this.requisicoesNotificar, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoHPardini: 114");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
        }
        this.progress.setVisible(false);
    }

    private void carregarLayoutPorIdade(Registro reg) {
        ExameUtil.pegaLayoutIdade(reg.getString("fil_codigo"), Integer.parseInt(reg.getString("req_idade")), reg.getString("req_anomes"), reg.getString(CODIGO_LAYOUT), reg.getString("examePai"), Integer.parseInt(reg.getString("mco_codigo")), Integer.parseInt(reg.getString("met_codigo")), "elm_formato", reg);
    }

    private boolean resultadoImportadoEmPDF(Registro reg, ElementoHPardini examePardini, String dataEmissaoLotePardini) throws Exception {
        boolean conferido;
        boolean importouPDF = false;
        boolean bl = conferido = this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica);
        if (this.importaEmPDF(reg)) {
            if (this.exameDesmembrado(reg)) {
                byte[] resultadosDesmembrados = null;
                List<ConfiguracaoExameHPardiniVO> desmembrados = this.service.getExamesDesmembradosPDF(reg);
                Base64 base64 = new Base64();
                int resultadosRecebidos = 0;
                for (ConfiguracaoExameHPardiniVO desm : desmembrados) {
                    String resultadoPDFBase64 = this.service.importarResultadoPDFWebServiceEmBase64(this.labExterno.configuracao, dataEmissaoLotePardini, desm);
                    if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() > 1000 && ResultadosUtil.verificaIntegridadePDFImportado(Base64.decodeBase64((String)resultadoPDFBase64))) {
                        byte[] resultadoEmBytes = Base64.decodeBase64((String)resultadoPDFBase64);
                        resultadosDesmembrados = ResultadosUtil.concatenarPdfs(resultadosDesmembrados, resultadoEmBytes, "Resultado");
                        ++resultadosRecebidos;
                        continue;
                    }
                    if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() < 1000) {
                        this.setTextoInformacoes(String.format("\nFalha na importa\u00e7\u00e3o do exame %s desmembrado em PDF - motivo: %s", desm.getCodigoExame(), resultadoPDFBase64), false);
                        continue;
                    }
                    if (ResultadosUtil.verificaIntegridadePDFImportado(Base64.decodeBase64((String)resultadoPDFBase64))) continue;
                    this.setTextoInformacoes(String.format("\nFalha na importa\u00e7\u00e3o do exame %s desmembrado em PDF - motivo: PDF inv\u00e1lido", desm.getCodigoExame()), false);
                }
                if (resultadosRecebidos == desmembrados.size()) {
                    String resultadoDesmembradosBase64 = base64.encodeAsString(resultadosDesmembrados);
                    ConfiguracaoExameHPardiniVO examePai = ConfiguracaoExameHPardiniVO.fromRegistro(reg);
                    examePai.setCodigoExame(reg.getString("examePai"));
                    this.service.salvarResultadoPDF(examePai, resultadoDesmembradosBase64, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
                    this.setTextoInformacoes(String.format(MSG_IMPORTACAO_PDF, examePai.getCodigoFilial(), examePai.getCodigoRequisicao(), examePai.getCodigoExame()), false);
                    this.adicionarAoModeloRelatorio(examePardini, conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO, examePai.getCodigoRequisicao(), examePai.getCodigoExame());
                    importouPDF = true;
                }
            } else {
                ConfiguracaoExameHPardiniVO exame = ConfiguracaoExameHPardiniVO.fromRegistro(reg);
                String resultadoPDFBase64 = this.service.importarResultadoPDFWebServiceEmBase64(this.labExterno.configuracao, dataEmissaoLotePardini, exame);
                if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() > 1000 && ResultadosUtil.verificaIntegridadePDFImportado(Base64.decodeBase64((String)resultadoPDFBase64))) {
                    this.service.salvarResultadoPDF(exame, resultadoPDFBase64, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
                    this.setTextoInformacoes(String.format(MSG_IMPORTACAO_PDF, exame.getCodigoFilial(), exame.getCodigoRequisicao(), exame.getCodigoExame()), false);
                    this.adicionarAoModeloRelatorio(examePardini, conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO, exame.getCodigoRequisicao(), exame.getCodigoExame());
                    importouPDF = true;
                } else if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() < 1000) {
                    this.setTextoInformacoes(String.format("\nFalha na importa\u00e7\u00e3o do exame %s em PDF - motivo: %s", exame.getCodigoExame(), resultadoPDFBase64), false);
                } else if (!ResultadosUtil.verificaIntegridadePDFImportado(Base64.decodeBase64((String)resultadoPDFBase64))) {
                    this.setTextoInformacoes(String.format("\nFalha na importa\u00e7\u00e3o do exame %s desmembrado em PDF - motivo: PDF inv\u00e1lido", exame.getCodigoExame()), false);
                }
            }
        }
        return importouPDF;
    }

    private boolean exameDesmembrado(Registro reg) {
        return !Funcoes.textoVazio(reg.getString("examePai")) && !reg.getString("examePai").equals(reg.getString("exa_codigo"));
    }

    private boolean importaEmPDF(Registro reg) {
        String nomeColuna = this.exameDesmembrado(reg) ? "xmllabexternopai" : "ele_xmllabexterno";
        return reg.getString(nomeColuna).contains("<formato_pdf>SIM</formato_pdf>") || reg.getString("lae_configuracao").contains("<importarResultadoPdf>true</importarResultadoPdf>");
    }

    private int validaSituacaoVersaoIncorreta(Registro formatacao, ElementoHPardini superExame, Registro reg) throws Exception {
        ElementoHPardini res = this.xmlPardini(superExame, reg.getString("fil_codigo"));
        boolean mesmaVersao = this.mesmaVersao(formatacao.getString(FORMATO), superExame);
        boolean mesmaVersaoEstrutura = this.mesmaVersaoEstrutura(formatacao.getString(FORMATO), superExame, reg.getString("fil_codigo"), res);
        boolean mesmosAtributos = this.mesmosAtributos(formatacao.getString(FORMATO), superExame, reg.getString("fil_codigo"), res);
        boolean xmlValido = res != null;
        boolean importouDaWeb = false;
        if (!(this.integracaoModeloWeb == null || this.codigoModeloWeb <= -1 || mesmaVersao && mesmaVersaoEstrutura && mesmosAtributos)) {
            String versaoLocal = this.getVersaoExameLabExternoLocal(formatacao.getString(FORMATO));
            String versaoRecebida = this.getVersaoExameElementoPardini(superExame);
            String codExmApoio = superExame.getFilho("CodExmApoio").getValor();
            String[] campos = codExmApoio.split("\\|");
            String exame = campos[1];
            String material = campos[0];
            String codigoThread = String.valueOf(ParametrosGerais.getCodigoCliente());
            String codigoLC = this.labExterno.configuracao.indexOf("codigoProtocolo") > 0 ? StringUtil.getValor(this.labExterno.configuracao, "codigoProtocolo") : "0000";
            boolean podeImportarNovaVersao = this.integracaoModeloWeb.verificaVersaoModeloNaWeb(codigoLC, codigoThread, this.codigoModeloWeb, exame, material, versaoRecebida);
            if (podeImportarNovaVersao) {
                String importado = this.integracaoModeloWeb.importarVersaoModeloNaWeb(codigoLC, codigoThread, this.codigoModeloWeb, exame, material, versaoRecebida);
                formatacao.setValor(FORMATO, importado);
                String versaoImportada = this.getVersaoExameLabExternoLocal(formatacao.getString(FORMATO));
                if (Funcoes.textoVazio(versaoImportada) || versaoImportada.equalsIgnoreCase("null")) {
                    formatacao.setValor(FORMATO, this.adicionarVersaoAoFormato(versaoRecebida, formatacao.getString(FORMATO)));
                }
                if (mesmaVersao) {
                    mesmaVersaoEstrutura = true;
                    mesmosAtributos = true;
                }
                importouDaWeb = true;
                this.alterarFormatoLayout(reg, formatacao.getString(FORMATO));
            } else {
                return 2;
            }
        }
        if (!xmlValido) {
            return 6;
        }
        if (!mesmaVersao) {
            if (!mesmaVersaoEstrutura) {
                return 1;
            }
            return 3;
        }
        if (!mesmosAtributos) {
            return 4;
        }
        return importouDaWeb ? 5 : 0;
    }

    private void alterarFormatoLayout(Registro reg, String formato) throws Exception {
        ExameLayoutMetodoService service = new ExameLayoutMetodoService();
        FilialVO filial = new FilialVO();
        filial.setCodigo(reg.getInt("fil_codigo"));
        ExameVO exame = new ExameVO();
        exame.setFilial(filial);
        exame.setCodigo(reg.getString("exa_codigo"));
        MaterialColetaVO material = new MaterialColetaVO();
        material.setFilial(filial);
        material.setCodigo(reg.getInt("mco_codigo"));
        LayoutVO layout = new LayoutVO();
        layout.setFilial(filial);
        layout.setCodigo(reg.getInt("lay_codigo"));
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setFilial(filial);
        metodo.setCodigo(reg.getInt("met_codigo"));
        ExameLayoutMetodoBean bean = new ExameLayoutMetodoBean();
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setMatColeta(material);
        bean.setLayout(layout);
        bean.setMetodologia(metodo);
        bean.setIdadeFim(reg.getInt("ela_idadefim"));
        bean.setIdadeInicial(reg.getInt("ela_idadeini"));
        bean.setIdadeFimTipo(reg.getString("ela_idadefimtipo"));
        bean.setIdadeInicioTipo(reg.getString("ela_idadeinitipo"));
        bean.setFormato(formato);
        service.update(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
    }

    private String adicionarVersaoAoFormato(String numeroVersaoRecebida, String xml) {
        int posInicial = xml.indexOf("<versaoExameLabExterno>");
        int posFinal = xml.indexOf("</versaoExameLabExterno>");
        StringBuilder buf = new StringBuilder(xml);
        buf.delete(posInicial, posFinal + "</versaoExameLabExterno>".length());
        buf.insert(posInicial, "<versaoExameLabExterno>" + numeroVersaoRecebida + "</versaoExameLabExterno>");
        return buf.toString();
    }

    private boolean mesmosAtributos(String formato, ElementoHPardini superExame, String filial, ElementoHPardini res) {
        if (res != null) {
            ElementoHPardini exameNew = superExame.getFilho(EXAME);
            ElementoHPardini exameOld = res.getFilho("SuperExame").getFilho(FORMATOS);
            if (exameOld != null) {
                List<ElementoHPardini> formatos = exameOld.getFilhos(TAG_FORMATO);
                for (ElementoHPardini elementoHPardini : formatos) {
                    if (exameNew == null || superExame.getFilho("CodigoFormato").getValor().equalsIgnoreCase("PDF")) {
                        return false;
                    }
                    if (null == exameNew.getValorAtributo("idExame") || null == elementoHPardini.getFilho(EXAME) || !exameNew.getValorAtributo("idExame").equals(elementoHPardini.getFilho(EXAME).getValorAtributo("idExame"))) continue;
                    List<ElementoHPardini> idNew = exameNew.getFilhos("ItemDeExame");
                    List<ElementoHPardini> idOld = elementoHPardini.getFilhos("ItemDeExame");
                    ElementoHPardini codigoNew = superExame.getFilho("CodigoFormato");
                    ElementoHPardini codigoOld = elementoHPardini.getFilho("CodigoFormato");
                    block1: for (ElementoHPardini hNew : idNew) {
                        if (hNew.getFilho("ComentarioDoPatologista") != null && hNew.getFilho("Resultado") == null) continue;
                        boolean aux = false;
                        for (ElementoHPardini hOld : idOld) {
                            ElementoHPardini cNew;
                            if (!hNew.getValorAtributo("idItemDeExame").equals(hOld.getValorAtributo("idItemDeExame")) || Funcoes.objectIsNull(hOld.getFilho("Resultado")) || !hNew.getFilho("Resultado").getValorAtributo("idResultado").equals(hOld.getFilho("Resultado").getValorAtributo("idResultado"))) continue;
                            ElementoHPardini cOld = hOld.getFilho("Resultado") != null && hOld.getFilho("Resultado").getFilho("Conteudo") != null ? hOld.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor") : null;
                            ElementoHPardini elementoHPardini2 = cNew = hNew.getFilho("Resultado") != null && hNew.getFilho("Resultado").getFilho("Conteudo") != null ? hNew.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor") : null;
                            if (cNew == null || cOld == null || cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() <= 0 && codigoNew.getValor().equals(codigoOld.getValor())) {
                                return true;
                            }
                            if (cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() <= 0 && !codigoNew.getValor().equals(codigoOld.getValor())) {
                                return false;
                            }
                            if (cNew.getAtributos().size() > 0 && cOld.getAtributos().size() <= 0 || cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() > 0 || !cNew.getValorAtributo("idValor").equals(cOld.getValorAtributo("idValor")) || !cNew.getValorAtributo("Tipo").equals(cOld.getValorAtributo("Tipo")) || !cNew.getValorAtributo("TamanhoMaximo").equals(cOld.getValorAtributo("TamanhoMaximo"))) continue;
                            aux = true;
                            continue block1;
                        }
                    }
                }
            } else {
                exameOld = res.getFilho("SuperExame").getFilho(EXAME);
                if (exameOld != null) {
                    if (exameNew.getValorAtributo("idExame").equals(exameOld.getValorAtributo("idExame"))) {
                        List<ElementoHPardini> idNew = exameNew.getFilhos("ItemDeExame");
                        List<ElementoHPardini> idOld = exameOld.getFilhos("ItemDeExame");
                        for (ElementoHPardini hNew : idNew) {
                            if (hNew.getFilho("ComentarioDoPatologista") != null && hNew.getFilho("Resultado") == null) continue;
                            boolean aux = false;
                            for (ElementoHPardini hOld : idOld) {
                                ElementoHPardini cNew;
                                if (!hNew.getValorAtributo("idItemDeExame").equals(hOld.getValorAtributo("idItemDeExame"))) continue;
                                ElementoHPardini cOld = hOld.getFilho("Resultado") != null && hOld.getFilho("Resultado").getFilho("Conteudo") != null ? hOld.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor") : null;
                                ElementoHPardini elementoHPardini = cNew = hNew.getFilho("Resultado") != null && hNew.getFilho("Resultado").getFilho("Conteudo") != null ? hNew.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor") : null;
                                if (cNew == null || cOld == null || cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() <= 0) {
                                    return true;
                                }
                                if (cNew.getAtributos().size() > 0 && cOld.getAtributos().size() <= 0 || cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() > 0 || !cNew.getValorAtributo("idValor").equals(cOld.getValorAtributo("idValor")) || !cNew.getValorAtributo("Tipo").equals(cOld.getValorAtributo("Tipo")) || !cNew.getValorAtributo("TamanhoMaximo").equals(cOld.getValorAtributo("TamanhoMaximo")) || !hNew.getValorAtributo("idItemDeExame").equals(hOld.getValorAtributo("idItemDeExame")) || !hNew.getFilho("Resultado").getValorAtributo("idResultado").equals(hOld.getFilho("Resultado").getValorAtributo("idResultado"))) continue;
                                aux = true;
                                break;
                            }
                            if (aux) continue;
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private Integer[] verificarRequisicaoMultiguia(String codFilial, String codRequisicao) throws SQLException {
        Integer[] multiguias = null;
        multiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true) : new Integer[]{Integer.parseInt(codRequisicao)};
        return multiguias;
    }

    private LinkedList<Registro> processarPaiFilhos(Statement st, ElementoHPardini exResultado, String fil_codigo, Integer[] multiguias, String codigoPedidoApoio) throws Exception {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        boolean agrupaMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias;
        String[] exameJalis = new String[2];
        if (exResultado.contemFilho("CodExmLab") && !Funcoes.textoVazio(exResultado.getFilho("CodExmLab").getValor()) && exResultado.getFilho("CodExmLab").getValor().contains("|") && ((exameJalis = exResultado.getFilho("CodExmLab").getValor().split("[|]")).length < 2 || Funcoes.textoVazio(exameJalis[0]) || !Funcoes.isNumeric(exameJalis[1]))) {
            return retorno;
        }
        for (Integer multiguia : multiguias) {
            ExameDesmembrado pai;
            boolean isExameLabExterno = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, multiguia.toString(), exameJalis[0], exameJalis[1], fil_codigo, st);
            if (isExameLabExterno) {
                String codigoJalis = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                Registro exameSeparado = this.localizarExameRequisicao(fil_codigo, multiguia.toString(), exameJalis[0], exameJalis[1]);
                if (this.existeExameSeparado(exameSeparado)) {
                    exameSeparado.setValor("leq_codigoreqapoio", codigoPedidoApoio);
                    retorno.add(exameSeparado);
                }
            }
            if (!this.existePai(pai = this.service.getExameDesmembrado(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exameJalis[0], exameJalis[1]))) continue;
            boolean isExameLabExternoDesm = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, multiguia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()), fil_codigo, st);
            if (!isExameLabExternoDesm) continue;
            String codigoJalisTemp = exameJalis[0];
            Registro reg = this.localizarExameRequisicao(fil_codigo, multiguia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()));
            if (!this.existeExameSeparado(reg)) continue;
            reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
            reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
            reg.setValor("xmllabexternopai", pai.getXmlLabExterno());
            reg.setValor("examePai", pai.getCodigoExame());
            reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
            reg.setValor("leq_codigoreqapoio", codigoPedidoApoio);
            retorno.add(reg);
        }
        return retorno;
    }

    private boolean existePai(ExameDesmembrado pai) {
        return pai != null;
    }

    private boolean existeExameSeparado(Registro exameSeparado) {
        return exameSeparado != null;
    }

    private Registro localizarExameRequisicao(ElementoHPardini pedido, ElementoHPardini superExame) throws SQLException {
        if (pedido.contemFilho("CodPedLab")) {
            if (!superExame.contemFilho("CodExmLab")) {
                String req = pedido.getFilho("CodPedLab").getValor();
                if (req.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                    this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.SEM_COD_EXM_LAB, req, "");
                }
            } else {
                String req = pedido.getFilho("CodPedLab").getValor();
                if (req.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                    this.adicionarAoModeloRelatorio(superExame, AbstractImportadorResultadoLabExterno.Situacao.SEM_COD_EXM_LAB, req, "");
                    return null;
                }
                if (!Funcoes.isNumeric(req) || req.contains(".") || req.contains(",")) {
                    this.setTextoInformacoes("Requisi\u00e7\u00e3o: " + req + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o (verifique o valor de CodPedLab)\n", false);
                    return null;
                }
                String filial = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req = req.substring(ParametrosGerais.getDigitosTuboFilial());
                String str = superExame.getFilho("CodExmLab").getValor();
                if (!str.contains("|")) {
                    this.setTextoInformacoes("C\u00f3digo do exame do Lab. da requisi\u00e7\u00e3o: " + req + " em descordo com o padr\u00e3o do Jalis\n", false);
                    return null;
                }
                String exa = str.substring(0, str.indexOf(124));
                String mco = str.substring(str.indexOf(124) + 1);
                if (!Funcoes.isNumeric(mco) || mco.contains(".") || mco.contains(",")) {
                    this.setTextoInformacoes("Material da requisi\u00e7\u00e3o: " + req + " em descordo com o padr\u00e3o do Jalis\n", false);
                    return null;
                }
                return this.localizarExameRequisicao(filial, req, exa, mco);
            }
        }
        return null;
    }

    protected StringBuilder getSqlLocalizaExame(String fil, String req, String exa, String mco) {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(COALESCE(g.met_codigo, gb.met_codigo), e.met_codigo) as met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, b.exr_resposta, \n");
        sql.append("  a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao, le.lae_codigo, le.lae_configuracao \n");
        sql.append(" from requisicao a \n");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append(" left join requisicaorequisicao rr on a.fil_codigo = rr.fil_codigo and a.req_codigo = rr.req_kodigo  \n");
        sql.append(" left join loteexternoexamerequisicao fb on rr.fil_codigo = fb.fil_kodigo and rr.req_codigo = fb.req_codigo and b.exa_codigo = fb.exa_codigo and b.mco_codigo = fb.mco_codigo \n");
        sql.append(" left join examematcoletalabexterno gb on fb.fil_codigo = gb.fil_codigo and fb.exa_codigo = gb.exa_codigo and fb.mco_codigo = gb.mco_codigo and fb.lae_codigo = gb.lae_codigo and gb.ele_xmllabexterno is not null and gb.ele_xmllabexterno <> '' \n");
        sql.append(" left join labexterno le on g.fil_codigo = le.fil_codigo and g.lae_codigo = le.lae_codigo ");
        sql.append(" where \n");
        sql.append(" a.fil_codigo = ").append(fil).append(" and \n");
        sql.append(" a.req_codigo = ").append(req).append(" and \n");
        sql.append(" b.exa_codigo = '").append(exa).append("' and \n");
        sql.append(" b.mco_codigo = ").append(mco);
        sql.append(" and a.req_excluida = false and b.exr_excluido = false \n");
        sql.append(" and f.ler_datahoraestorno is null and f.usr_codestorno is null \n");
        sql.append(" and fb.ler_datahoraestorno is null and fb.usr_codestorno is null");
        return sql;
    }

    private Registro localizarExameRequisicao(String filial, String requisicao, String exame, String material) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder sql = this.getSqlLocalizaExame(filial, requisicao, exame, material);
            ULTIMO_SQL = sql.toString();
            ResultSet res = Conexao.executeQuery(st, ULTIMO_SQL);
            if (res.next()) {
                Registro reg = new Registro(res);
                reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(filial, reg.getString(CODIGO_LAYOUT)));
                Registro formatacao = new Registro();
                formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor(FORMATACAO, formatacao);
                return reg;
            }
            if (!(Funcoes.textoVazio(exame) || Funcoes.textoVazio(material) || Funcoes.textoVazio(requisicao))) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, requisicao, exame, Integer.parseInt(material), AbstractImportadorResultadoLabExterno.Situacao.NAO_LOCALIZADO.descricao);
            }
        }
        return null;
    }

    private boolean exameJaLancado(Registro reg) {
        String sit = reg.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    private boolean exameColetado(Registro reg) {
        return this.existeExameSeparado(reg) && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private synchronized String formataData(String data) throws ParseException {
        return dataUsuario.format(dataHPardini.parse(data));
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Registro dados) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, dados.getString("fil_codigo"), dados.getString("req_codigo"), Variaveis.codigoBaseWeb);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini (1506)");
        }
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private boolean mesmaVersao(String formato, ElementoHPardini superExame) {
        String versao = this.getVersaoExameLabExternoLocal(formato);
        return superExame.contemFilho("CodigoFormato") && versao.contains(superExame.getFilho("CodigoFormato").getValor()) || versao.equals("0");
    }

    private String getVersaoExameLabExternoLocal(String formato) {
        return StringUtil.getValor(StringUtil.getValor(formato, "exame"), "versaoExameLabExterno");
    }

    private String getVersaoExameElementoPardini(ElementoHPardini superExame) {
        return superExame.contemFilho("CodigoFormato") ? superExame.getFilho("CodigoFormato").getValor() : "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean mesmaVersaoEstrutura(String formato, ElementoHPardini superExame, String filial, ElementoHPardini res) {
        if (res == null) return true;
        ElementoHPardini exameNew = superExame.getFilho(EXAME);
        ElementoHPardini exameOld = res.getFilho("SuperExame").getFilho(EXAME);
        if (exameOld != null) {
            if (!exameNew.getValorAtributo("idExame").equals(exameOld.getValorAtributo("idExame"))) return false;
            List<ElementoHPardini> idNew = exameNew.getFilhos("ItemDeExame");
            List<ElementoHPardini> idOld = exameOld.getFilhos("ItemDeExame");
            Iterator<ElementoHPardini> iterator = idNew.iterator();
            while (iterator.hasNext()) {
                ElementoHPardini hNew = iterator.next();
                if (hNew.getFilho("ComentarioDoPatologista") != null && hNew.getFilho("Resultado") == null) continue;
                boolean aux = false;
                for (ElementoHPardini hOld : idOld) {
                    if (!hNew.getValorAtributo("idItemDeExame").equals(hOld.getValorAtributo("idItemDeExame")) || !hNew.getFilho("Resultado").getValorAtributo("idResultado").equals(hOld.getFilho("Resultado").getValorAtributo("idResultado"))) continue;
                    ElementoHPardini cOld = hOld.getFilho("Resultado") != null && hOld.getFilho("Resultado").getFilho("Conteudo") != null ? hOld.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor") : null;
                    if (hNew.getFilho("Resultado") == null) return true;
                    if (hNew.getFilho("Resultado").getFilho("Conteudo") == null) return true;
                    ElementoHPardini elementoHPardini = hNew.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor");
                    ElementoHPardini cNew = elementoHPardini;
                    if (cNew == null) return true;
                    if (cOld == null) return true;
                    if (cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() <= 0) {
                        return true;
                    }
                    if (cNew.getAtributos().size() > 0 && cOld.getAtributos().size() <= 0 || cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() > 0 || !cNew.getValorAtributo("idValor").equals(cOld.getValorAtributo("idValor")) || !cNew.getValorAtributo("Tipo").equals(cOld.getValorAtributo("Tipo")) || !cNew.getValorAtributo("TamanhoMaximo").equals(cOld.getValorAtributo("TamanhoMaximo"))) continue;
                    aux = true;
                    break;
                }
                if (!aux) return false;
            }
            return true;
        }
        exameOld = res.getFilho("SuperExame").getFilho(FORMATOS);
        List<ElementoHPardini> formatos = exameOld.getFilhos(TAG_FORMATO);
        boolean aux = false;
        if (exameNew == null) return false;
        if (null == exameNew.getValorAtributo("idExame")) return false;
        if (null == exameOld.getFilho(TAG_FORMATO).getFilho(EXAME)) return false;
        if (!exameNew.getValorAtributo("idExame").equals(exameOld.getFilho(TAG_FORMATO).getFilho(EXAME).getValorAtributo("idExame"))) return false;
        for (ElementoHPardini elementoHPardini : formatos) {
            List<ElementoHPardini> idNew = exameNew.getFilhos("ItemDeExame");
            List<ElementoHPardini> idOld = elementoHPardini.getFilhos("ItemDeExame");
            ElementoHPardini codigoNew = superExame.getFilho("CodigoFormato");
            ElementoHPardini codigoOld = elementoHPardini.getFilho("CodigoFormato");
            for (ElementoHPardini hpNew : idNew) {
                if (hpNew.getFilho("ComentarioDoPatologista") != null && hpNew.getFilho("Resultado") == null) continue;
                for (ElementoHPardini hpOld : idOld) {
                    ElementoHPardini cNew;
                    ElementoHPardini cOld;
                    if (!hpNew.getValorAtributo("idItemDeExame").equals(hpOld.getValorAtributo("idItemDeExame")) || Funcoes.objectIsNull(hpOld.getFilho("Resultado")) || !hpNew.getFilho("Resultado").getValorAtributo("idResultado").equals(hpOld.getFilho("Resultado").getValorAtributo("idResultado"))) continue;
                    cOld = hpOld.getFilho("Resultado") != null && hpOld.getFilho("Resultado").getFilho("Conteudo") != null ? (cOld = hpOld.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor")) : null;
                    if (hpNew.getFilho("Resultado") == null) return true;
                    if (hpNew.getFilho("Resultado").getFilho("Conteudo") == null) return true;
                    ElementoHPardini elementoHPardini2 = cNew = hpNew.getFilho("Resultado").getFilho("Conteudo").getFilho("Valor");
                    cNew = elementoHPardini2;
                    if (cNew == null) return true;
                    if (cOld == null) return true;
                    if (cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() <= 0 && codigoNew.getValor().equals(codigoOld.getValor())) {
                        return true;
                    }
                    if (cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() <= 0 && !codigoNew.getValor().equals(codigoOld.getValor())) {
                        return false;
                    }
                    if (cNew.getAtributos().size() > 0 && cOld.getAtributos().size() <= 0 || cNew.getAtributos().size() <= 0 && cOld.getAtributos().size() > 0 || !cNew.getValorAtributo("idValor").equals(cOld.getValorAtributo("idValor")) || !cNew.getValorAtributo("Tipo").equals(cOld.getValorAtributo("Tipo")) || !cNew.getValorAtributo("TamanhoMaximo").equals(cOld.getValorAtributo("TamanhoMaximo")) || !hpNew.getFilho("Resultado").getValorAtributo("idResultado").equals(hpOld.getFilho("Resultado").getValorAtributo("idResultado")) || !codigoNew.getValor().equals(codigoOld.getValor())) continue;
                    return true;
                }
            }
        }
        if (aux) return true;
        return false;
    }

    private static boolean verificaCDDATA(String campo, String valor, String xml) {
        String abre = "<" + campo + ">";
        String fecha = "</" + campo + ">";
        if (valor.toLowerCase().indexOf(abre) >= 0) {
            xml = xml + valor.substring(0, valor.toLowerCase().indexOf(abre) + abre.length()) + "<![CDATA[" + valor.substring(valor.toLowerCase().indexOf(abre) + abre.length(), valor.toLowerCase().indexOf(fecha)) + "]]>" + valor.substring(valor.toLowerCase().indexOf(fecha)) + "\n";
            return true;
        }
        return false;
    }

    private boolean exportarBaseWeb(Registro reg) {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, reg.getString("fil_codigo"));
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini: 261");
        }
        return false;
    }

    private boolean carregouVO(FilialVO filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private void adicionarAoModeloRelatorio(ElementoHPardini superExame, AbstractImportadorResultadoLabExterno.Situacao situacao, String req, String exaCodigo) {
        ElementoHPardini pedido = superExame.getPai();
        if (pedido != null && pedido.contemFilho("CodPedLab") && pedido.getFilho("CodPedLab").getValor().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && superExame.contemFilho("CodExmLab")) {
            ExameDesmembrado pai;
            String str = superExame.getFilho("CodExmLab").getValor();
            String exa = !Funcoes.textoVazio(exaCodigo) ? exaCodigo : str.substring(0, str.indexOf(124));
            String mco = str.substring(str.indexOf(124) + 1);
            String requisicao = pedido.getFilho("CodPedLab").getValor();
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            Statement st = Conexao.getStatement();
            String exames = "";
            try {
                exames = BDUtil.getCodigoExames(filial, req, st);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini (1264)");
            }
            if (!exames.contains(exa) && this.existePai(pai = this.service.getExameDesmembrado(filial, req, String.valueOf(this.codigoLabExterno), exa, mco))) {
                exa = pai.getCodigoExame();
                mco = String.valueOf(pai.getCodigomaterial());
            }
            if (!situacao.equals((Object)AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL)) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, req, exa, Integer.parseInt(mco), situacao.descricao);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else if (e.getSource() == this.buttonImportarWebService) {
            FiltroDataPardini filtroDataPardini = new FiltroDataPardini(Laboratorio.getInstancia(), "Importa\u00e7\u00e3o via Webservice", true);
            filtroDataPardini.setVisible(true);
            try {
                if (filtroDataPardini.isOk()) {
                    this.dadosConstante = filtroDataPardini.getDadosConstante();
                    this.unidadeValor = filtroDataPardini.getUnidadeValor();
                    this.grafico = filtroDataPardini.getGrafico();
                    this.importarResultadoWebservice(filtroDataPardini);
                    ParametrosLocais.setParametro("mostraDataInicial", filtroDataPardini.getDataFinal());
                    ParametrosLocais.setParametro("mostrarHoraInicial", filtroDataPardini.getHoraInicial());
                    ParametrosLocais.setParametro("dadosConstantes", this.dadosConstante);
                    ParametrosLocais.setParametro("grafico", this.grafico);
                    ParametrosLocais.setParametro("unidadeValor", this.unidadeValor);
                    ParametrosLocais.salvaParametros();
                    ParametrosLocais.carregaParametros();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.buttonRastrear) {
            FiltroDataPardini filtroDataPardini = new FiltroDataPardini(Laboratorio.getInstancia(), "Consultar rastreabilidade de amostras", false);
            filtroDataPardini.setVisible(true);
            if (filtroDataPardini.isOk()) {
                SplashMensagem spl = SplashMensagem.getInstancia(this);
                try {
                    spl.mostrar("Aguarde... Consultando logs de rastreabilidade");
                    this.consultarRastreabilidade(filtroDataPardini.getDataInicial(), filtroDataPardini.getDataFinal(), filtroDataPardini.getHoraInicial(), filtroDataPardini.getHoraFinal());
                    spl.apagar();
                }
                finally {
                    spl.apagar();
                }
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void consultarRastreabilidade(String dataInicial, String dataFinal, String horaInicial, String horaFinal) {
        try {
            String codigoWebservice = this.labExterno.configuracao.indexOf("codigoProtocolo") > 0 ? StringUtil.getValor(this.labExterno.configuracao, "codigoProtocolo") : null;
            String senhaWebservice = this.labExterno.configuracao.indexOf("senhaWeb") > 0 ? StringUtil.getValor(this.labExterno.configuracao, "senhaWeb") : null;
            XMLServerSoapProxy xmlServerSoapProxy = new XMLServerSoapProxy();
            dataInicial = Funcoes.formataData("yyyy-MM-dd", dataInicial);
            dataFinal = Funcoes.formataData("yyyy-MM-dd", dataFinal);
            horaInicial = horaInicial.concat(":00");
            horaFinal = horaFinal.concat(":00");
            XMLRastreabilidade rastreabilidade = xmlServerSoapProxy.getRastreabilidade(codigoWebservice, senhaWebservice, dataInicial, dataFinal, horaInicial, horaFinal);
            RastreabilidadeAmostra[] registros = rastreabilidade.getRastreabilidade();
            LoteExternoRequisicaoRastreioService loteRastro = new LoteExternoRequisicaoRastreioService();
            loteRastro.registraRastreabilidade(registros, Variaveis.filialPadrao);
        }
        catch (RemoteException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConsultaRastreabilidade ");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConsultaRastreabilidade ");
        }
    }

    private void importarResultadoWebservice(FiltroDataPardini filtroDataPardini) throws Exception {
        String codificado;
        this.setTextoInformacoes("Aguarde... Consultando resultados");
        this.setTextoInformacoes("\nSolicitando os resultados do Per\u00edodo informado...", false);
        String retornoHPardini = this.service.getResultadosWebServicePardini(this.labExterno, filtroDataPardini);
        this.service.salvarArquivoImportadoNoDiretorioDoUsuario(this.labExterno.descricao, retornoHPardini);
        String xmlResultado = codificado = new String(retornoHPardini.getBytes(), "ISO-8859-1");
        xmlResultado = StringUtil.escreveCabecalho(codificado);
        ElementoHPardini resultados = ParserResultadoHPardini.analisarXMLHPardini(new ByteArrayInputStream(xmlResultado.getBytes()));
        new Thread(() -> this.importarResultados(resultados.getFilhos(), true)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirRelatorio() {
        Statement st;
        block5: {
            if (this.modeloRelatorio.getRowCount() <= 0) {
                return;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioSituacaoLote.getModuloAcesso());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block5;
                final JDialog dialogo = new JDialog(Laboratorio.getInstancia());
                dialogo.setSize(new Dimension(750, 600));
                dialogo.getContentPane().setLayout(new BorderLayout());
                dialogo.setModal(true);
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(dialogo.getContentPane());
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        dialogo.dispose();
                    }
                });
                gerador.executar(rs.getString("rel_xml"), this.modeloRelatorio);
                ScreenUtil.centralizar(dialogo);
                dialogo.setVisible(true);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ImportacaoResultadoHPardini (715)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (this.existeExameSeparado(reg)) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo-exame");
                    mco = StringUtil.getValor(xml, "codigo-material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select ehp_xml from examespardini where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and ehp_codexame = '").append(exa).append("' and ehp_codmaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("ehp_xml", rs.getString("ehp_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private String dataHoraAtual(String tipo) {
        if (tipo == TAG_DATA_FINAL) {
            SimpleDateFormat sf = new SimpleDateFormat("dd/MM/yyyy");
            String dataAtual = sf.format(new Date());
            return dataAtual;
        }
        if (tipo == TAG_HORA_FINAL) {
            SimpleDateFormat sf1 = new SimpleDateFormat("HH:mm");
            String horaAtual = sf1.format(new Date());
            return horaAtual;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ElementoHPardini xmlPardini(ElementoHPardini superExame, String filial) {
        String codExmApoio = superExame.getFilho("CodExmApoio").getValor();
        String[] campos = codExmApoio.split("\\|");
        StringBuilder sql = new StringBuilder();
        sql.append("select ehp_xml from examespardini where ehp_codmaterial = '");
        sql.append(campos[0]).append("' and ehp_codexame = '").append(campos[1]).append("'");
        sql.append(" and fil_codigo = ").append(filial);
        sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
        Statement st = null;
        ElementoHPardini res = null;
        try {
            String tmp;
            st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next() && (tmp = rs.getString("ehp_xml")).indexOf("<SuperExame>") > -1) {
                String codificado;
                tmp = tmp.substring(tmp.indexOf("<SuperExame>"), tmp.indexOf("</SuperExame>") + "</SuperExame>".length());
                String[] linhas = tmp.split("\n");
                String se = "";
                for (String s : linhas) {
                    if (s.toLowerCase().indexOf("![cdata[") >= 0) {
                        se = se + s + "\n";
                        continue;
                    }
                    if (ImportacaoResultadoHPardini.verificaCDDATA("metodo", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("descricao", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("nota", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("observacao", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("metodo", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("examenome", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("valor", s, se) || ImportacaoResultadoHPardini.verificaCDDATA("interpretacao", s, se)) continue;
                    se = se + s + "\n";
                }
                String xml = codificado = StringUtil.removerAcentos(se);
                xml = StringUtil.escreveCabecalho(codificado);
                res = ParserResultadoHPardini.analisarXMLHPardini(new ByteArrayInputStream(xml.getBytes()));
            }
        }
        catch (SQLException e) {
            ElementoHPardini elementoHPardini = null;
            Conexao.fecharStatement(st);
            return elementoHPardini;
        }
        catch (ParserResultadoHPardiniException e2) {
            ElementoHPardini elementoHPardini = null;
            {
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            return elementoHPardini;
        }
        Conexao.fecharStatement(st);
        return res;
    }

    private Map<String, Map<String, String>> getHistoricosPorExame(String codigoExame, String codigoFilial) {
        HashMap<String, Map<String, Map<String, String>>> tmp = new HashMap<String, Map<String, Map<String, String>>>();
        String key = codigoFilial + "|" + codigoExame;
        if (this.historicosExame == null || this.historicosExame.isEmpty()) {
            tmp.put(key, ExameUtil.getHistoricos(codigoExame, codigoFilial));
            this.historicosExame = tmp;
        } else if (this.historicosExame.get(key) == null || this.historicosExame.get(key).isEmpty()) {
            tmp.put(key, ExameUtil.getHistoricos(codigoExame, codigoFilial));
            this.historicosExame = tmp;
        }
        return this.historicosExame.get(key);
    }

    private Map<String, Map<String, String>> getHistoricosPorFilial(String codigoFilial) {
        HashMap<String, Map<String, Map<String, String>>> tmp = new HashMap<String, Map<String, Map<String, String>>>();
        if (this.historicosExameFilial == null || this.historicosExameFilial.isEmpty()) {
            tmp.put(codigoFilial, ExameUtil.getHistoricos(null, codigoFilial));
            this.historicosExameFilial = tmp;
        } else if (this.historicosExameFilial.get(codigoFilial) == null || this.historicosExameFilial.get(codigoFilial).isEmpty()) {
            tmp.put(codigoFilial, ExameUtil.getHistoricos(null, codigoFilial));
            this.historicosExameFilial = tmp;
        }
        return this.historicosExameFilial.get(codigoFilial);
    }

    @Override
    protected void importarResultadoWs() {
    }
}

