/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.AbstractIntegracaoProtocolo;
import jalis.laboratorio.util.parsers.FabricaIntegracaoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RetornoImportacaoCadastroModelos;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.pardini.JalisAuthenticator;
import jalis.laboratorio.util.parsers.pardini.ParserImportacaoHPardini;
import jalis.laboratorio.util.parsers.pardini.SolicitarData;
import jalis.laboratorio.util.parsers.pardini.SolicitarTipoValorReferencia;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;

public class ImportacaoHPardini
extends AbstractImportadorLabExterno {
    public static final String LINK_SITE_ARQUIVO_HERMES_PARDINI = "http://www.hermespardini.com.br/cal/tabexalhpV3.xml";
    private JButton buttonImportarCamposResultado = ComponenteFactory.novoJButton("Importar Campos", 'R', this);
    private JButton buttonBaixarArquivoExamesWeb = ComponenteFactory.novoJButton("Download arquivo de exames", 'B', this);
    private File arquivoExames = null;
    public String configuracoes = null;
    private JButton buttonImportarWS = ComponenteFactory.novoJButton("Webservice \u25bc", this);
    private JMenuItem itemTodosExamesWS = ComponenteFactory.novoJMenuItem("Todos", this);
    private JMenuItem itemAtualizadosExamesWS = ComponenteFactory.novoJMenuItem("Atualizados", this);
    private JMenu menuExamesWS = new JMenu("Exames");
    private JMenuItem itemTodosModelosWS = ComponenteFactory.novoJMenuItem("Todos", this);
    private JMenuItem itemAtualizadosModelosWS = ComponenteFactory.novoJMenuItem("Atualizados", this);
    private JMenu menuModelosWS = new JMenu("Campos");
    private JPopupMenu popup = new JPopupMenu();
    private AbstractIntegracaoProtocolo integrador;
    private int codigoLabExterno = -1;
    private String descricaoLabExterno = "";

    public ImportacaoHPardini(int codigoLabExterno, String configuracoes) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. H. Pardini a partir de arquivo XML", codigoLabExterno, Protocolo.HPardini);
        this.configuracoes = configuracoes;
        this.configurar(configuracoes);
        this.codigoLabExterno = codigoLabExterno;
        this.descricaoLabExterno = this.buscaDescricaoLabExterno(codigoLabExterno);
    }

    public ImportacaoHPardini(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. H. Pardini a partir de arquivo XML", codigoLabExterno, Protocolo.HPardini);
        this.configurar(this.buscaConfiguracoesLabExternp(codigoLabExterno));
        this.codigoLabExterno = codigoLabExterno;
        this.descricaoLabExterno = this.buscaDescricaoLabExterno(codigoLabExterno);
    }

    private void configurar(String configuracoes) {
        if (Funcoes.textoVazio(configuracoes)) {
            configuracoes = this.verificaUtilizaHPDirect(this.codigoLabExterno);
        }
        this.configuracoes = configuracoes;
        boolean isUtilizarHPDirect = StringUtil.getBoolean(configuracoes, "enviarEtiquetaHpDirect");
        if (isUtilizarHPDirect) {
            this.getPanelBotoes().add((Component)this.buttonBaixarArquivoExamesWeb, 2);
        }
        this.integrador = FabricaIntegracaoLabExterno.novaIntegracaoLabExterno(Protocolo.HPardini);
        this.adicionarBotoes();
    }

    private void adicionarBotoes() {
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarCamposResultado, 1);
        if (null != this.integrador) {
            this.getPanelBotoes().add((Component)this.buttonImportarWS, 0);
            this.popup.add(this.menuExamesWS);
            this.popup.add(this.menuModelosWS);
            this.menuExamesWS.add(this.itemAtualizadosExamesWS);
            this.menuExamesWS.add(this.itemTodosExamesWS);
            this.menuModelosWS.add(this.itemAtualizadosModelosWS);
            this.menuModelosWS.add(this.itemTodosModelosWS);
        }
    }

    private String verificaUtilizaHPDirect(int codigoLabExterno) {
        return this.buscaConfiguracoesLabExternp(codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buscaConfiguracoesLabExternp(int codigoLabExterno) {
        Statement st = Conexao.getStatement();
        String configuracao = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select lae_configuracao ");
                bui.append("from labexterno ");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append("  and lae_codigo = ").append(codigoLabExterno);
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                if (res.next()) {
                    configuracao = res.getString("lae_configuracao");
                }
                res.close();
            }
            catch (Exception e) {
                try {
                    Conexao.fecharStatement(st);
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter as configura\u00e7\u00f5es do laborat\u00f3rio externo." + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return configuracao;
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (e.getSource() == this.buttonImportarCamposResultado) {
            this.habilitarBotoes(false);
            new Thread("Thread de Importa\u00e7\u00e3o de Campos de Resultados"){

                @Override
                public void run() {
                    ImportacaoHPardini.this.importarCamposResultado();
                }
            }.start();
        } else if (e.getSource() == this.buttonBaixarArquivoExamesWeb) {
            this.arquivoExames = null;
            this.baixarArquivoExames();
        } else if (e.getSource() == this.buttonImportarWS) {
            Dimension dim = this.popup.getPreferredSize();
            this.popup.show(this.buttonImportarWS.getParent(), this.buttonImportarWS.getX(), this.buttonImportarWS.getY() - dim.height - 1);
        } else if (e.getSource() == this.itemAtualizadosExamesWS || e.getSource() == this.itemTodosExamesWS) {
            new Thread("ImportacaoWS"){

                @Override
                public void run() {
                    try {
                        ImportacaoHPardini.this.importarTabelaExamesWS(e.getSource() == ImportacaoHPardini.this.itemTodosExamesWS);
                    }
                    catch (Exception e2) {
                        ImportacaoHPardini.this.getTextAreaInformacoes().append("N\u00e3o foi poss\u00edvel importar a listagem de exames (" + e2.getMessage() + ")");
                    }
                }
            }.start();
        } else if (e.getSource() == this.itemAtualizadosModelosWS || e.getSource() == this.itemTodosModelosWS) {
            new Thread("ImportacaoModeloWS"){

                @Override
                public void run() {
                    try {
                        ImportacaoHPardini.this.importarModelosWS(e.getSource() == ImportacaoHPardini.this.itemTodosModelosWS);
                    }
                    catch (Exception e2) {
                        ImportacaoHPardini.this.getTextAreaInformacoes().append("N\u00e3o foi poss\u00edvel importar a listagem de modelos (" + e2.getMessage() + ")");
                    }
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    private void importarTabelaExamesWS(boolean todos) throws IOException, Exception {
        if (null != this.integrador) {
            String senhaJalis;
            boolean continuar = true;
            String codigoLCJalis = StringUtil.getValor(this.configuracoes, "codigoProtocolo");
            if (this.temCodigoSenhaAcesso(codigoLCJalis, senhaJalis = StringUtil.getValor(this.configuracoes, "senhaWeb"))) {
                if (!todos) {
                    SolicitarData sd = SolicitarData.getInstancia(this.getTopLevelAncestor());
                    if (null != sd) {
                        sd.setVisible(true);
                        if (sd.getOK()) {
                            RetornoImportacaoCadastroModelos importados = this.integrador.importarCadastrosExames(this.getTextAreaInformacoes(), codigoLCJalis, senhaJalis, true, Funcoes.stringToDate("dd/MM/yyyy", sd.getDataPesquisa()));
                            if (null != importados && importados.getQuantidade() > 0 && !importados.isErro()) {
                                this.getTextAreaInformacoes().append("\nIniciando importa\u00e7\u00e3o de exames atualizados desde " + sd.getDataPesquisa());
                                this.esperar(20);
                                for (String ex : importados.getRetorno()) {
                                    String x = this.formatarXMLTabela(ex);
                                    this.gravarArquivoTabelaV2(x);
                                    ParserImportacaoHPardini.importarExamesHPardini(x, this.codigoLabExterno, this.progress, Variaveis.filialPadrao, true);
                                }
                                this.getTextAreaInformacoes().append("\nImporta\u00e7\u00e3o de " + importados.getQuantidade() + " exame(s) finalizada");
                            } else if (importados.isErro()) {
                                this.getTextAreaInformacoes().append("\nOcorreu algo inesperado ao processar a importa\u00e7\u00e3o dos cadastros, mensagem apresentada:\n" + importados.getMensagem());
                            } else {
                                this.getTextAreaInformacoes().append("\nN\u00e3o foi localizado nenhum exame para importa\u00e7\u00e3o");
                            }
                        }
                    }
                } else {
                    RetornoImportacaoCadastroModelos importados = this.integrador.importarCadastrosExames(this.getTextAreaInformacoes(), codigoLCJalis, senhaJalis, false, null);
                    if (null != importados && importados.getQuantidade() > 0 && !importados.isErro()) {
                        this.getTextAreaInformacoes().append("\nIniciando importa\u00e7\u00e3o de exames");
                        this.esperar(10);
                        StringBuilder buf = new StringBuilder();
                        for (String ex : importados.getRetorno()) {
                            buf.append(ex).append("\n");
                        }
                        String x = this.formatarXMLTabela(buf.toString());
                        this.gravarArquivoTabelaV2(x);
                        System.gc();
                        if (!this.progress.isVisible()) {
                            this.progress.setValue(0);
                            this.progress.setVisible(true);
                        }
                        this.repaint();
                        Set<ExameHPardini> excluidos = ParserImportacaoHPardini.importarExamesHPardini(x, this.codigoLabExterno, this.progress, Variaveis.filialPadrao, false);
                        this.progress.setVisible(false);
                        this.getTextAreaInformacoes().append("\nImporta\u00e7\u00e3o finalizada");
                        this.esperar(10);
                        if (excluidos.size() > 0) {
                            this.getTextAreaInformacoes().append(this.montarTabelaExcluidos(excluidos));
                        }
                    } else if (importados.isErro()) {
                        this.getTextAreaInformacoes().append("\nOcorreu algo inesperado ao processar a importa\u00e7\u00e3o dos cadastros, mensagem apresentada:\n" + importados.getMensagem());
                    } else {
                        this.getTextAreaInformacoes().append("\nN\u00e3o foi localizado nenhum exame para importa\u00e7\u00e3o");
                    }
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel solicitar os dados para o laborat\u00f3rio de apoio.\nVerifique a configura\u00e7\u00e3o de c\u00f3digo de senha do laborat\u00f3rio de apoio", 2);
            }
        }
    }

    private void importarModelosWS(boolean todos) throws IOException, Exception {
        if (null != this.integrador) {
            String senhaJalis;
            boolean continuar = true;
            String codigoLCJalis = StringUtil.getValor(this.configuracoes, "codigoProtocolo");
            if (this.temCodigoSenhaAcesso(codigoLCJalis, senhaJalis = StringUtil.getValor(this.configuracoes, "senhaWeb"))) {
                int referencia = -1;
                if (!todos) {
                    SolicitarData sd = SolicitarData.getInstancia(this.getTopLevelAncestor());
                    if (null != sd) {
                        sd.setVisible(true);
                        if (sd.getOK() && (referencia = this.pedirTipoReferencia()) > -1) {
                            RetornoImportacaoCadastroModelos importados = this.integrador.importarModelosExames(this.getTextAreaInformacoes(), codigoLCJalis, senhaJalis, true, Funcoes.stringToDate("dd/MM/yyyy", sd.getDataPesquisa()), String.valueOf(referencia));
                            if (null != importados && importados.getQuantidade() > 0 && !importados.isErro()) {
                                this.getTextAreaInformacoes().append("\nIniciando importa\u00e7\u00e3o de modelos atualizados desde " + sd.getDataPesquisa());
                                this.esperar(20);
                                for (String ex : importados.getRetorno()) {
                                    String x = this.formatarXMLModelo(ex);
                                    this.gravarArquivoModelo(x);
                                    this.importarCamposResultadoWS(x);
                                }
                                this.getTextAreaInformacoes().append("\nImporta\u00e7\u00e3o de " + importados.getQuantidade() + " modelos(s) finalizada");
                            } else if (importados.isErro()) {
                                this.getTextAreaInformacoes().append("\nOcorreu algo inesperado ao processar a importa\u00e7\u00e3o dos modelos, mensagem apresentada:\n" + importados.getMensagem());
                            } else {
                                this.getTextAreaInformacoes().append("\nN\u00e3o foi localizado nenhum modelo para importa\u00e7\u00e3o");
                            }
                        }
                    }
                } else {
                    referencia = this.pedirTipoReferencia();
                    if (referencia > -1) {
                        RetornoImportacaoCadastroModelos importados = this.integrador.importarModelosExames(this.getTextAreaInformacoes(), codigoLCJalis, senhaJalis, false, null, String.valueOf(referencia));
                        if (null != importados && importados.getQuantidade() > 0 && !importados.isErro()) {
                            this.getTextAreaInformacoes().append("\nIniciando importa\u00e7\u00e3o de modelos");
                            this.esperar(10);
                            StringBuilder buf = new StringBuilder();
                            for (String ex : importados.getRetorno()) {
                                buf.append(ex).append("\n");
                            }
                            String x = this.formatarXMLModelo(buf.toString());
                            this.gravarArquivoModelo(x);
                            this.importarCamposResultadoWS(x);
                        } else if (importados.isErro()) {
                            this.getTextAreaInformacoes().append("\nOcorreu algo inesperado ao processar a importa\u00e7\u00e3o dos modelos, mensagem apresentada:\n" + importados.getMensagem());
                        } else {
                            this.getTextAreaInformacoes().append("\nN\u00e3o foi localizado nenhum modelo para importa\u00e7\u00e3o");
                        }
                    }
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel solicitar os modelos para o laborat\u00f3rio de apoio.\nVerifique a configura\u00e7\u00e3o de c\u00f3digo de senha do laborat\u00f3rio de apoio", 2);
            }
        }
    }

    private int pedirTipoReferencia() {
        int retorno = -1;
        SolicitarTipoValorReferencia sd = SolicitarTipoValorReferencia.getInstancia(this.getTopLevelAncestor());
        if (null != sd) {
            sd.setVisible(true);
            if (sd.getOK()) {
                retorno = sd.getTipoReferencia();
            }
        }
        return retorno;
    }

    private String montarTabelaExcluidos(Set<ExameHPardini> excluidos) {
        StringBuilder bui = new StringBuilder();
        bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
        bui.append("\t+-----------------+----------------+\n");
        bui.append("\t|      EXAME      |    MATERIAL    |\n");
        bui.append("\t+-----------------+----------------+");
        for (ExameHPardini ep : excluidos) {
            bui.append("\n\t|").append(StringUtil.formatarColuna(ep.getMnemonicoExame(), 17, 'c'));
            bui.append("|").append(StringUtil.formatarColuna(ep.getMnemonicoMaterial(), 16, 'c')).append("|");
        }
        bui.append("\n\t+-----------------+----------------+");
        return bui.toString();
    }

    private void esperar(int tempo) {
        try {
            Thread.sleep(tempo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buscaDescricaoLabExterno(int codigoLabExterno) {
        Statement st = Conexao.getStatement();
        String configuracao = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select lae_descricao ");
                bui.append("from labexterno ");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append("  and lae_codigo = ").append(codigoLabExterno);
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                if (res.next()) {
                    configuracao = res.getString("lae_descricao");
                }
                res.close();
            }
            catch (Exception e) {
                try {
                    Conexao.fecharStatement(st);
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel obter a descri\u00e7\u00e3o do laborat\u00f3rio externo." + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return configuracao;
    }

    private void gravarArquivoTabelaV2(String xml) throws IOException, Exception {
        String diretorio = System.getProperty("user.home") + "/" + this.descricaoLabExterno;
        File f = new File(diretorio);
        boolean dirOK = f.exists();
        if (!dirOK) {
            dirOK = f.mkdir();
        }
        if (dirOK) {
            StringUtil.escreverArquivoTexto(diretorio + "/tabelaV2_" + Funcoes.formataData("yyyyMMddkkmmssS", new Date()) + ".xml", xml);
        }
    }

    private void gravarArquivoModelo(String xml) throws IOException, Exception {
        String diretorio = System.getProperty("user.home") + "/" + this.descricaoLabExterno;
        File f = new File(diretorio);
        boolean dirOK = f.exists();
        if (!dirOK) {
            dirOK = f.mkdir();
        }
        if (dirOK) {
            StringUtil.escreverArquivoTexto(diretorio + "/modelo_" + Funcoes.formataData("yyyyMMddkkmmssS", new Date()) + ".xml", xml);
        }
    }

    private String formatarXMLTabela(String xml) {
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        b.append("\n");
        b.append("<TABELA>\n");
        b.append("  <DATAGERACAO>").append(Funcoes.formataData("yyyy-MM-dd", new Date())).append("</DATAGERACAO>\n");
        b.append("  <HORAGERACAO>").append(Funcoes.formataData("kk:mm:ss", new Date())).append("</HORAGERACAO>\n");
        b.append(xml);
        b.append("</TABELA>");
        return b.toString();
    }

    private String formatarXMLModelo(String xml) {
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n");
        b.append("\n");
        b.append("<Resultados>\n");
        b.append("  <Protocolo>1</Protocolo>");
        b.append(xml);
        b.append("</Resultados>");
        return b.toString();
    }

    private boolean temCodigoSenhaAcesso(String codigo, String senha) {
        return !Funcoes.textoVazio(codigo) && !Funcoes.textoVazio(senha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void baixarArquivoExames() {
        JalisAuthenticator aut = new JalisAuthenticator(StringUtil.getValor(this.configuracoes, "codigoProtocolo"), StringUtil.getValor(this.configuracoes, "senhaWeb"));
        Authenticator.setDefault(aut);
        URL url = null;
        URLConnection con = null;
        try {
            url = new URL(LINK_SITE_ARQUIVO_HERMES_PARDINI);
            con = url.openConnection();
            con.connect();
            con.getInputStream().available();
        }
        catch (IOException e1) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel fazer o download do arquivo.", 2);
            return;
        }
        String path = "";
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileSelectionMode(1);
        if (file.showSaveDialog(this) != 0) {
            return;
        }
        path = file.getSelectedFile().getAbsolutePath();
        path = path + System.getProperty("file.separator") + url.getFile().substring(5, url.getFile().length());
        File arquivo = new File(path);
        if (arquivo.exists()) {
            if (Funcoes.mensagem(this, "O arquivo j\u00e1 existe.\nDeseja sobrescrev\u00ea-lo?", 4) == 0) {
                arquivo.delete();
            } else {
                return;
            }
        }
        if (!arquivo.exists()) {
            FileOutputStream newFile = null;
            try {
                newFile = new FileOutputStream(arquivo);
                int c = 0;
                while ((c = con.getInputStream().read()) != -1) {
                    newFile.write(c);
                }
            }
            catch (FileNotFoundException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel localizar o arquivo para leitura." + e.getMessage(), e.getStackTrace());
                return;
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar o arquivo." + e.getMessage(), e.getStackTrace());
                if (arquivo.exists() && arquivo.length() == 0L) {
                    arquivo.delete();
                }
                return;
            }
            finally {
                if (newFile != null) {
                    try {
                        newFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (arquivo.exists()) {
                this.arquivoExames = arquivo;
                if (Funcoes.mensagem(this, "Download do arquivo conclu\u00eddo.\nDeseja realizar a importa\u00e7\u00e3o do mesmo?", 4) == 0) {
                    this.getButtonImportar().doClick();
                }
            }
        }
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
        this.buttonImportarCamposResultado.setEnabled(habilitar);
        this.buttonBaixarArquivoExamesWeb.setEnabled(habilitar);
    }

    public File lerArquivoExames() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. H. Pardini (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        if (this.arquivoExames == null) {
            this.arquivoExames = this.lerArquivoExames();
        }
        if (this.arquivoExames == null) {
            return retorno;
        }
        try {
            retorno = this.importaArquivo(StringUtil.lerArquivoTexto(this.arquivoExames.getPath()), this.progress, Variaveis.filialPadrao);
            if (!retorno) {
                this.arquivoExames = null;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoPardini: 112");
        }
        this.progress.setVisible(false);
        return retorno;
    }

    public boolean importaArquivo(String xmlTabela, JProgressBar progress, String filialPadrao) throws InterruptedException, SQLException, NumberFormatException, SalvaDadosException {
        return this.importaArquivo(xmlTabela, progress, filialPadrao, true);
    }

    public boolean importaArquivo(String xmlTabela, JProgressBar progress, String filialPadrao, boolean mostrarLog) throws InterruptedException, SQLException, NumberFormatException, SalvaDadosException {
        boolean isXmlValido;
        boolean retorno = false;
        String[] dataHora = ParserImportacaoHPardini.getDataHoraGeracao(xmlTabela);
        Thread.sleep(50L);
        boolean bl = isXmlValido = StringUtil.getValor(xmlTabela, "TABELA").length() > 0;
        if (!isXmlValido || dataHora[0].equals("") && dataHora[1].equals("")) {
            this.setTextoInformacoes("O arquivo \"" + this.arquivoExames.getPath() + "\" \u00e9 inv\u00e1lido.");
        } else {
            StringBuilder bui = new StringBuilder("Informa\u00e7\u00f5es do arquivo: \n");
            bui.append("  Data da gera\u00e7\u00e3o: ").append(dataHora[0]).append(" \n");
            bui.append("  Hora da gera\u00e7\u00e3o: ").append(dataHora[1]).append(" \n\n");
            bui.append("Importando exames...");
            this.setTextoInformacoes(bui.toString());
            Thread.sleep(50L);
            if (progress != null) {
                progress.setValue(0);
                progress.setVisible(true);
            }
            Set<ExameHPardini> excluidos = ParserImportacaoHPardini.importarExamesHPardini(xmlTabela, this.codigoLabExterno, progress, filialPadrao, false);
            this.arquivoExames = null;
            bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
            this.setTextoInformacoes(bui.toString());
            Thread.sleep(50L);
            if (excluidos.size() > 0 && mostrarLog) {
                this.setTextoInformacoes(this.montarTabelaExcluidos(excluidos));
            }
            retorno = true;
        }
        return retorno;
    }

    private void importarCamposResultado() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. H. Pardini (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) == 0) {
            this.setTextoInformacoes("Carregando arquivo \"" + chooser.getSelectedFile().getName() + "\"\n");
            try {
                ElementoHPardini resultados = ParserResultadoHPardini.analisarXMLHPardini(chooser.getSelectedFile());
                if (resultados == null || !resultados.getNome().equals("Resultados")) {
                    this.anexarTextoInformacoes("O arquivo especificado n\u00e3o \u00e9 um XML de campos de resultados do laborat\u00f3rio Hermes Pardini");
                    this.habilitarBotoes(true);
                    return;
                }
                this.progress.setValue(0);
                this.progress.setVisible(true);
                this.anexarTextoInformacoes("Importando campos de resultado...\n");
                List<ElementoHPardini> rejeitados = ParserImportacaoHPardini.importarCamposResultadoHPardini(resultados, this.codigoLabExterno, this.progress, this.configuracoes);
                this.anexarTextoInformacoes("Importa\u00e7\u00e3o conclu\u00edda.\n");
                if (rejeitados.size() > 0) {
                    this.anexarTextoInformacoes(this.formatarTextoRejeitados(rejeitados));
                }
            }
            catch (ParserResultadoHPardiniException e) {
                this.anexarTextoInformacoes(e.getMessage());
                return;
            }
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }

    private void importarCamposResultadoWS(String xml) {
        if (!Funcoes.textoVazio(xml)) {
            this.setTextoInformacoes("Analisando modelos importados\n");
            try {
                ElementoHPardini resultados = ParserResultadoHPardini.analisarXMLHPardini(new ByteArrayInputStream(xml.getBytes()));
                if (resultados == null || !resultados.getNome().equals("Resultados")) {
                    this.anexarTextoInformacoes("Os dados importados n\u00e3o correspondem a um XML de campos de resultados do laborat\u00f3rio Hermes Pardini");
                    this.habilitarBotoes(true);
                    return;
                }
                this.progress.setValue(0);
                this.progress.setVisible(true);
                this.anexarTextoInformacoes("Importando campos de resultado...\n");
                List<ElementoHPardini> rejeitados = ParserImportacaoHPardini.importarCamposResultadoHPardini(resultados, this.codigoLabExterno, this.progress, this.configuracoes);
                this.anexarTextoInformacoes("Importa\u00e7\u00e3o conclu\u00edda.\n");
                if (rejeitados.size() > 0) {
                    this.anexarTextoInformacoes(this.formatarTextoRejeitados(rejeitados));
                }
            }
            catch (ParserResultadoHPardiniException e) {
                this.anexarTextoInformacoes(e.getMessage());
                return;
            }
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }

    private String formatarTextoRejeitados(List<ElementoHPardini> rejeitados) {
        StringBuilder buf = new StringBuilder();
        buf.append("\nOs campos de resultado dos exames listados abaixo n\u00e3o foram importados, pois\n");
        buf.append("esses exames ainda n\u00e3o foram importados.\n\n");
        buf.append("\t+-----------------+----------------+\n");
        buf.append("\t|      EXAME      |    MATERIAL    |\n");
        buf.append("\t+-----------------+----------------+");
        for (ElementoHPardini ele : rejeitados) {
            String tmp = ele.getFilho("CodExmApoio").getValor();
            String mat = tmp.substring(0, tmp.indexOf(124));
            String exa = tmp.substring(tmp.indexOf(124) + 1, tmp.lastIndexOf(124));
            buf.append("\n\t|");
            buf.append(StringUtil.formatarColuna(exa, 17, 'c'));
            buf.append("|");
            buf.append(StringUtil.formatarColuna(mat, 16, 'c'));
            buf.append("|");
        }
        buf.append("\n\t+-----------------+----------------+");
        return buf.toString();
    }
}

