/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.ParametrosLocais;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FiltroDataPardini
extends JDialog {
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelTopo = new JPanel(null);
    private Date hora = new Date();
    private TTextField txtDataInicial = new TTextField(10, 4);
    private TTextField txtDataFinal = new TTextField(10, 4);
    private TTextField txtHoraInicial = new TTextField(5, 6);
    private TTextField txtHoraFinal = new TTextField(5, 6);
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelHoraInicial = new JLabel("Hora Inicial:");
    private JLabel labelHoraFinal = new JLabel("Hora Final:");
    private JButton buttonImportar = new JButton("Consultar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JCheckBox checkDadosConstantes = new JCheckBox("Dados constantes");
    private JCheckBox checkGraficos = new JCheckBox("Gr\u00e1ficos");
    private JCheckBox checkUnidadeJuntoComValor = new JCheckBox("Unidade junto c/ valor");
    public static final String TAG_DATA_FINAL = "DataFinal";
    public static final String TAG_HORA_FINAL = "HoraFinal";
    private JButton buttonBuscaDataInicial = new JButton();
    private JButton buttonBuscaDataFinal = new JButton();
    private String dadosConstante = "0";
    private String grafico = "0";
    private String unidadeValor = "0";
    private int codigoLabExterno;
    private boolean importarArquivo = false;
    private boolean isOk = false;

    public FiltroDataPardini(Frame owner, String title, boolean importarArquivo) {
        this.importarArquivo = importarArquivo;
        this.setTitle(title);
        this.inicializar();
    }

    private void inicializar() {
        this.setLayout(new BorderLayout());
        this.setBounds(410, 250, 290, 160);
        this.setLocationRelativeTo(Laboratorio.getInstancia());
        this.setPreferredSize(new Dimension(290, 160));
        this.setSize(290, 170);
        this.setModal(true);
        this.setResizable(false);
        this.isOk = false;
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelTopo, "Center");
        this.panelBotoes.add(this.buttonImportar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelTopo.add(this.labelDataInicial);
        this.panelTopo.add(this.txtDataInicial);
        this.panelTopo.add(this.buttonBuscaDataInicial);
        this.panelTopo.add(this.labelDataFinal);
        this.panelTopo.add(this.txtDataFinal);
        this.panelTopo.add(this.buttonBuscaDataFinal);
        this.panelTopo.add(this.labelHoraInicial);
        this.panelTopo.add(this.txtHoraInicial);
        this.panelTopo.add(this.labelHoraFinal);
        this.panelTopo.add(this.txtHoraFinal);
        if (this.importarArquivo) {
            this.setSize(290, 220);
            this.buttonImportar.setText("Importar");
            this.panelTopo.add(this.checkDadosConstantes);
            this.panelTopo.add(this.checkGraficos);
            this.panelTopo.add(this.checkUnidadeJuntoComValor);
        }
        this.labelDataInicial.setBounds(5, 5, 130, 14);
        this.txtDataInicial.setBounds(5, 20, 110, 21);
        this.buttonBuscaDataInicial.setBounds(116, 20, 20, 20);
        this.buttonBuscaDataInicial.setFocusable(false);
        this.labelDataFinal.setBounds(5, 50, 130, 14);
        this.txtDataFinal.setBounds(5, 64, 110, 21);
        this.buttonBuscaDataFinal.setBounds(116, 64, 20, 20);
        this.buttonBuscaDataFinal.setFocusable(false);
        this.labelHoraInicial.setBounds(150, 5, 130, 14);
        this.txtHoraInicial.setBounds(150, 20, 110, 21);
        this.labelHoraFinal.setBounds(150, 50, 130, 14);
        this.txtHoraFinal.setBounds(150, 64, 110, 21);
        this.checkDadosConstantes.setBounds(new Rectangle(5, 90, 200, 20));
        this.checkGraficos.setBounds(new Rectangle(5, 110, 200, 20));
        this.checkUnidadeJuntoComValor.setBounds(new Rectangle(5, 130, 200, 20));
        if (this.importarArquivo && !Funcoes.textoVazio(ParametrosLocais.getParametro("dadosConstantes"))) {
            if (ParametrosLocais.getParametro("dadosConstantes").equals("1")) {
                this.checkDadosConstantes.setSelected(true);
                this.dadosConstante = "1";
            } else {
                this.checkDadosConstantes.setSelected(false);
                this.dadosConstante = "0";
            }
        }
        if (this.importarArquivo && !Funcoes.textoVazio(ParametrosLocais.getParametro("grafico"))) {
            if (ParametrosLocais.getParametro("grafico").equals("1")) {
                this.checkGraficos.setSelected(true);
                this.grafico = "1";
            } else {
                this.checkGraficos.setSelected(false);
                this.grafico = "0";
            }
        }
        if (this.importarArquivo && !Funcoes.textoVazio(ParametrosLocais.getParametro("unidadeValor"))) {
            if (ParametrosLocais.getParametro("unidadeValor").equals("1")) {
                this.checkUnidadeJuntoComValor.setSelected(true);
                this.unidadeValor = "1";
            } else {
                this.checkUnidadeJuntoComValor.setSelected(false);
                this.unidadeValor = "0";
            }
        }
        if (!this.importarArquivo || Funcoes.textoVazio(ParametrosLocais.getParametro("mostraDataInicial")) || Funcoes.textoVazio(ParametrosLocais.getParametro("mostrarHoraInicial"))) {
            this.txtDataInicial.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
            this.txtHoraInicial.setText(Funcoes.formataData("HH:mm", new Date()));
        } else {
            this.txtDataInicial.setText(ParametrosLocais.getParametro("mostraDataInicial"));
            this.txtHoraInicial.setText(ParametrosLocais.getParametro("mostrarHoraInicial"));
        }
        this.buttonBuscaDataInicial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FiltroDataPardini.this.txtDataInicial, FiltroDataPardini.this.buttonBuscaDataInicial, FiltroDataPardini.this.panelTopo, true);
            }
        });
        this.buttonBuscaDataFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FiltroDataPardini.this.txtDataFinal, FiltroDataPardini.this.buttonBuscaDataFinal, FiltroDataPardini.this.panelTopo, true);
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FiltroDataPardini.this.setVisible(false);
            }
        });
        this.checkDadosConstantes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltroDataPardini.this.checkDadosConstantes.isSelected()) {
                    FiltroDataPardini.this.dadosConstante = "1";
                } else {
                    FiltroDataPardini.this.dadosConstante = "0";
                }
            }
        });
        this.checkUnidadeJuntoComValor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltroDataPardini.this.checkUnidadeJuntoComValor.isSelected()) {
                    FiltroDataPardini.this.unidadeValor = "1";
                } else {
                    FiltroDataPardini.this.unidadeValor = "0";
                }
            }
        });
        this.checkGraficos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FiltroDataPardini.this.checkGraficos.isSelected()) {
                    FiltroDataPardini.this.grafico = "1";
                } else {
                    FiltroDataPardini.this.grafico = "0";
                }
            }
        });
        this.buttonImportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FiltroDataPardini.this.validaCampos()) {
                    return;
                }
                if (!FiltroDataPardini.this.dataValida()) {
                    return;
                }
                try {
                    FiltroDataPardini.this.isOk = true;
                    FiltroDataPardini.this.setVisible(false);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.txtDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(FiltroDataPardini.this.txtDataInicial, FiltroDataPardini.this.buttonBuscaDataInicial, FiltroDataPardini.this.panelTopo, true);
                }
            }
        });
        this.txtDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(FiltroDataPardini.this.txtDataFinal, FiltroDataPardini.this.buttonBuscaDataFinal, FiltroDataPardini.this.panelTopo, true);
                }
            }
        });
        this.buttonBuscaDataInicial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FiltroDataPardini.this.txtDataInicial, FiltroDataPardini.this.buttonBuscaDataInicial, FiltroDataPardini.this.panelTopo, true);
            }
        });
        this.buttonBuscaDataFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FiltroDataPardini.this.txtDataFinal, FiltroDataPardini.this.buttonBuscaDataFinal, FiltroDataPardini.this.panelTopo, true);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                FiltroDataPardini.this.txtDataInicial.selectAll();
                ScreenUtil.requisitarFoco(FiltroDataPardini.this.txtDataInicial);
            }
        });
        Funcoes.montaEnter((JComponent)this.panelTopo);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.imagemPesquisa(this.buttonBuscaDataInicial);
        Funcoes.imagemPesquisa(this.buttonBuscaDataFinal);
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtDataInicial) || !Funcoes.verificaData(this.txtDataInicial.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data incorreta.", 2);
            ScreenUtil.requisitarFoco(this.txtDataInicial);
            return false;
        }
        if (Funcoes.textoVazio(this.txtDataFinal) || !Funcoes.verificaData(this.txtDataFinal.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data incorreta.", 2);
            ScreenUtil.requisitarFoco(this.txtDataFinal);
            return false;
        }
        if (Funcoes.textoVazio(this.txtHoraInicial.getText()) && Funcoes.textoVazio(this.txtHoraFinal.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Hora n\u00e3o informada", 2);
            this.txtHoraInicial.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtHoraInicial.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Hora Inicial n\u00e3o informada", 2);
            this.txtHoraInicial.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtHoraFinal.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Hora Final n\u00e3o informada", 2);
            this.txtHoraFinal.grabFocus();
            return false;
        }
        return true;
    }

    private boolean dataValida() {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
        DateTime dtInicial = formatter.parseDateTime(this.txtDataInicial.getText());
        DateTime dtFinal = formatter.parseDateTime(this.txtDataFinal.getText());
        formatter = DateTimeFormat.forPattern((String)"HH:mm");
        DateTime hrInicial = formatter.parseDateTime(this.txtHoraInicial.getText());
        DateTime hrFinal = formatter.parseDateTime(this.txtHoraFinal.getText());
        LocalDate localDate = new LocalDate();
        if (dtInicial.isAfter((ReadableInstant)dtFinal)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data inicial maior que data final.", 2);
            ScreenUtil.requisitarFoco(this.txtDataInicial);
            return false;
        }
        if (localDate.isBefore((ReadablePartial)dtFinal.toLocalDate())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data final maior que data atual", 2);
            ScreenUtil.requisitarFoco(this.txtDataInicial);
            return false;
        }
        if (Days.daysBetween((ReadablePartial)dtInicial.toLocalDate(), (ReadablePartial)dtFinal.toLocalDate()).getDays() > 7) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Per\u00edodo n\u00e3o pode ser superior a 7 dias", 2);
            ScreenUtil.requisitarFoco(this.txtDataInicial);
            return false;
        }
        if (dtInicial.compareTo((ReadableInstant)dtFinal) == 0 && hrInicial.isAfter((ReadableInstant)hrFinal)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Hora Inicial Maior que hora final", 1);
            this.txtHoraInicial.grabFocus();
            return false;
        }
        return true;
    }

    public Date getHora() {
        return this.hora;
    }

    public void setHora(Date hora) {
        this.hora = hora;
    }

    public String getDataInicial() {
        return this.txtDataInicial.getText();
    }

    public String getDataFinal() {
        return this.txtDataFinal.getText();
    }

    public String getHoraInicial() {
        return this.txtHoraInicial.getText();
    }

    public String getHoraFinal() {
        return this.txtHoraFinal.getText();
    }

    public String getDadosConstante() {
        return this.dadosConstante;
    }

    public void setDadosConstante(String dadosConstante) {
        this.dadosConstante = dadosConstante;
    }

    public String getGrafico() {
        return this.grafico;
    }

    public void setGrafico(String grafico) {
        this.grafico = grafico;
    }

    public String getUnidadeValor() {
        return this.unidadeValor;
    }

    public void setUnidadeValor(String unidadeValor) {
        this.unidadeValor = unidadeValor;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

