/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import com.fasterxml.jackson.annotation.JsonProperty;
import jalis.util.Funcoes;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

class ExameRetornoDePara {
    private String codExmLab;
    private String descExmLab;
    private String descMatLab;
    private String descMat;
    private String codMat;
    private String codExm;
    private String descExm;
    private int altura;
    private String codigoFormato;
    private String condicao;
    private String conservante;
    private int contrato;
    private int curva;
    private int glicemia;
    private int grafico;
    private String grupo;
    private int hematocrito;
    private int imagem;
    private int linfocitosAbsoluto;
    private int materialDiversos;
    private int peso;
    private int pesoAmostra;
    private String regiao;
    private int tempoAmostra;
    private int tempoDiurese;
    private int volumeDiurese;
    private String codigoExameJalis;
    private String codigoMaterialJalis;

    ExameRetornoDePara() {
    }

    public int getAltura() {
        return this.altura;
    }

    @JsonProperty(value="altura")
    public void setAltura(int altura) {
        this.altura = altura;
    }

    public String getCodExm() {
        return this.codExm;
    }

    @JsonProperty(value="codExm")
    public void setCodExm(String codExm) {
        this.codExm = codExm;
    }

    public String getCodExmLab() {
        return this.codExmLab;
    }

    @JsonProperty(value="codExmLab")
    public void setCodExmLab(String codExmLab) {
        this.codExmLab = codExmLab;
    }

    public String getCodigoFormato() {
        return this.codigoFormato;
    }

    @JsonProperty(value="codigoFormato")
    public void setCodigoFormato(String codigoFormato) {
        this.codigoFormato = codigoFormato;
    }

    public String getCondicao() {
        return this.condicao;
    }

    @JsonProperty(value="condicao")
    public void setCondicao(String condicao) {
        this.condicao = condicao;
    }

    public String getConservante() {
        return this.conservante;
    }

    @JsonProperty(value="conservante")
    public void setConservante(String conservante) {
        this.conservante = conservante;
    }

    public int getContrato() {
        return this.contrato;
    }

    @JsonProperty(value="contrato")
    public void setContrato(int contrato) {
        this.contrato = contrato;
    }

    public int getCurva() {
        return this.curva;
    }

    @JsonProperty(value="curva")
    public void setCurva(int curva) {
        this.curva = curva;
    }

    public String getDescExm() {
        return this.descExm;
    }

    @JsonProperty(value="descExm")
    public void setDescExm(String descExm) {
        this.descExm = descExm;
    }

    public String getDescExmLab() {
        return this.descExmLab;
    }

    @JsonProperty(value="descExmLab")
    public void setDescExmLab(String descExmLab) {
        this.descExmLab = descExmLab;
    }

    public String getCodMat() {
        return this.codMat;
    }

    @JsonProperty(value="codMat")
    public void setCodMat(String codMat) {
        this.codMat = codMat;
    }

    public String getDescMat() {
        return this.descMat;
    }

    @JsonProperty(value="descMat")
    public void setDescMat(String descMat) {
        this.descMat = descMat;
    }

    public String getDescMatLab() {
        return this.descMatLab;
    }

    @JsonProperty(value="descMatLab")
    public void setDescMatLab(String descMatLab) {
        this.descMatLab = descMatLab;
    }

    public int getGlicemia() {
        return this.glicemia;
    }

    @JsonProperty(value="glicemia")
    public void setGlicemia(int glicemia) {
        this.glicemia = glicemia;
    }

    public int getGrafico() {
        return this.grafico;
    }

    @JsonProperty(value="grafico")
    public void setGrafico(int grafico) {
        this.grafico = grafico;
    }

    public String getGrupo() {
        return this.grupo;
    }

    @JsonProperty(value="grupo")
    public void setGrupo(String grupo) {
        this.grupo = grupo;
    }

    public int getHematocrito() {
        return this.hematocrito;
    }

    @JsonProperty(value="hematocrito")
    public void setHematocrito(int hematocrito) {
        this.hematocrito = hematocrito;
    }

    public int getImagem() {
        return this.imagem;
    }

    @JsonProperty(value="imagem")
    public void setImagem(int imagem) {
        this.imagem = imagem;
    }

    public int getLinfocitosAbsoluto() {
        return this.linfocitosAbsoluto;
    }

    @JsonProperty(value="linfocitosAbsoluto")
    public void setLinfocitosAbsoluto(int linfocitosAbsoluto) {
        this.linfocitosAbsoluto = linfocitosAbsoluto;
    }

    public int getMaterialDiversos() {
        return this.materialDiversos;
    }

    @JsonProperty(value="materialDiversos")
    public void setMaterialDiversos(int materialDiversos) {
        this.materialDiversos = materialDiversos;
    }

    public int getPeso() {
        return this.peso;
    }

    @JsonProperty(value="peso")
    public void setPeso(int peso) {
        this.peso = peso;
    }

    public int getPesoAmostra() {
        return this.pesoAmostra;
    }

    @JsonProperty(value="pesoAmostra")
    public void setPesoAmostra(int pesoAmostra) {
        this.pesoAmostra = pesoAmostra;
    }

    public String getRegiao() {
        return this.regiao;
    }

    @JsonProperty(value="regiao")
    public void setRegiao(String regiao) {
        this.regiao = regiao;
    }

    public int getTempoAmostra() {
        return this.tempoAmostra;
    }

    @JsonProperty(value="tempoAmostra")
    public void setTempoAmostra(int tempoAmostra) {
        this.tempoAmostra = tempoAmostra;
    }

    public int getTempoDiurese() {
        return this.tempoDiurese;
    }

    @JsonProperty(value="tempoDiurese")
    public void setTempoDiurese(int tempoDiurese) {
        this.tempoDiurese = tempoDiurese;
    }

    public int getVolumeDiurese() {
        return this.volumeDiurese;
    }

    @JsonProperty(value="volumeDiurese")
    public void setVolumeDiurese(int volumeDiurese) {
        this.volumeDiurese = volumeDiurese;
    }

    public boolean isSemPredicao() {
        String SEM_PREDICAO = "Sem_Predi\u00e7\u00e3o";
        boolean nenhumVazio = !Funcoes.textoVazio(this.codExm) && !Funcoes.textoVazio(this.descExm) && !Funcoes.textoVazio(this.descMat) && !Funcoes.textoVazio(this.codMat);
        boolean algumSemPredicao = this.codExm.toUpperCase().indexOf("Sem_Predi\u00e7\u00e3o".toUpperCase()) > -1 || this.descExm.toUpperCase().indexOf("Sem_Predi\u00e7\u00e3o".toUpperCase()) > -1 || this.codMat.toUpperCase().indexOf("Sem_Predi\u00e7\u00e3o".toUpperCase()) > -1 || this.descMat.toUpperCase().indexOf("Sem_Predi\u00e7\u00e3o".toUpperCase()) > -1;
        return nenhumVazio && algumSemPredicao;
    }

    public boolean temDeParaJalisConfigurado() {
        this.identificarCodigoJalis();
        return !Funcoes.textoVazio(this.codigoExameJalis) && !Funcoes.textoVazio(this.codigoMaterialJalis);
    }

    public String getCodigoExameJalis() {
        this.identificarCodigoJalis();
        return this.codigoExameJalis;
    }

    public String getCodigoMaterialJalis() {
        this.identificarCodigoJalis();
        return this.codigoMaterialJalis;
    }

    private void identificarCodigoJalis() {
        String[] tmp = null;
        if (!Funcoes.textoVazio(this.codExmLab) && (tmp = this.codExmLab.split("\\|")) != null && tmp.length == 2) {
            this.codigoExameJalis = tmp[0];
            this.codigoMaterialJalis = tmp[1];
        }
    }

    public String getXML() throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("ehp");
        xml.abrir("exame");
        xml.escrever("codigo-exame", this.codExm);
        xml.escrever("codigo-material", this.codMat);
        xml.escrever("descricao-exame", this.descExm);
        xml.abrir("detalhes");
        xml.escrever("descricao-exame", this.descExm);
        xml.escrever("ori-admissivel", this.regiao);
        if (!Funcoes.textoVazio(this.grupo)) {
            xml.escrever("grupo-amostra", this.grupo);
        }
        xml.abrir("mat-real");
        xml.escrever("desc-mat-real", this.descMat);
        if (!Funcoes.textoVazio(this.conservante)) {
            xml.escrever("conservante", this.conservante);
        }
        xml.fechar("mat-real");
        if (this.peso == 1) {
            xml.escrever("info-complementar", "Peso");
        }
        if (this.altura == 1) {
            xml.escrever("info-complementar", "Altura");
        }
        if (this.tempoDiurese == 1) {
            xml.escrever("info-complementar", "TempoDiurese");
        }
        if (this.volumeDiurese == 1) {
            xml.escrever("info-complementar", "VolumeDiurese");
        }
        if (this.glicemia == 1) {
            xml.escrever("info-complementar", "Glicemia");
        }
        if (this.pesoAmostra == 1) {
            xml.escrever("info-complementar", "PesoAmostra");
        }
        if (this.tempoAmostra == 1) {
            xml.escrever("info-complementar", "TempoAmostra");
        }
        if (this.linfocitosAbsoluto == 1) {
            xml.escrever("info-complementar", "LinfocitosAbsoluto");
        }
        if (this.hematocrito == 1) {
            xml.escrever("info-complementar", "Hematocrito");
        }
        xml.fechar("detalhes");
        xml.fechar("exame");
        xml.escrever("utilizar-mat-requisicao", String.valueOf(this.materialDiversos));
        xml.escrever("material-selecionado", this.descMat);
        xml.escrever("material-espec-configuracao", "false");
        if (!Funcoes.textoVazio(this.conservante)) {
            xml.escrever("conservante-selecionado", this.conservante);
        }
        if (!Funcoes.textoVazio(this.condicao)) {
            xml.escrever("condicao-selecionada", this.condicao);
        }
        xml.fechar("ehp");
        return xml.getXML();
    }
}

