/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.pardini.MatRealHPardini;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExameHPardini {
    public static final String TAG_EHP = "ehp";
    public static final String TAG_UTILIZAR_MAT_REQUISICAO = "utilizar-mat-requisicao";
    public static final String TAG_MATERIAL_ESPEC_CONFIGURACAO = "material-espec-configuracao";
    public static final String TAG_MATERIAL_SELECIONADO = "material-selecionado";
    public static final String TAG_CONSERVANTE_SELECIONADO = "conservante-selecionado";
    public static final String TAG_CONDICAO_SELECIONADA = "condicao-selecionada";
    public static final String TAG_NUMERO_AMOSTRA = "numero-amostra";
    public static final String TAG_EXAME = "exame";
    public static final String TAG_DESCRICAO_EXAME = "descricao-exame";
    public static final String TAG_CODIGO_EXAME = "codigo-exame";
    public static final String TAG_CODIGO_MATERIAL = "codigo-material";
    public static final String TAG_INFO_COMPLEMENTAR = "info-complementar";
    public static final String TAG_CONSERVANTE = "conservante";
    public static final String TAG_DESCRICAO_MATERIAL_REAL = "desc-mat-real";
    public static final String TAG_MATERIAL_REAL = "mat-real";
    public static final String TAG_ORIGEM_ADMISSIVEL = "ori-admissivel";
    public static final String TAG_DETALHES = "detalhes";
    public static final String TAG_SUPEREXAME = "SuperExame";
    public static final String TAG_GRUPO_AMOSTRA = "grupo-amostra";
    public static final String TAG_FORMATO_PDF = "formato_pdf";
    public static final String TAG_AMOSTRA = "AMOSTRA";
    private static final String TAG_GRUPO = "GRUPO";
    private boolean contemTagAmostra = false;
    public static final String PESO = "Peso";
    public static final String ALTURA = "Altura";
    public static final String VOLUME_DIURESE = "VolumeDiurese";
    public static final String TEMPO_DIURESE = "TempoDiurese";
    public static final String PESO_AMOSTRA = "PesoAmostra";
    public static final String TEMPO_AMOSTRA = "TempoAmostra";
    public static final String LINFOCITOS_ABSOLUTO = "LinfocitosAbsoluto";
    public static final String INFO_COMP = "infoComp";
    public static final String HEMATOCRITO = "Hematocrito";
    public static final String GLICEMIA = "Glicemia";
    public static final String SEMANA_GESTACAO = "SemanaGestacao";
    public static final String SEXO_COLHEDOR = "SexoColhedor";
    public static final String DATA_SINTOMA = "DataSintoma";
    public static final String MUNICIPIO_RESIDENCIA = "MunicipioResidencia";
    public static final String APRESENTOU_SINTOMA = "Sintoma";
    private static final String SIM = "SIM";
    private static final String NAO = "NAO";
    public String codExaJalis = "";
    public String codMatJalis = "";
    public String codLabExterno = "";
    private boolean isSelecionado = false;
    private boolean utilizarMatRequisicao;
    private boolean materialEspecConfig;
    private String materialSelecionado = "";
    private String conservanteSelecionado = "";
    private boolean condicaoSelecionada;
    private String numeroAmostra = "";
    private String mncMaterial = "";
    private String mncExame = "";
    private String descExame;
    private XMLStringBuilder xmlDetalhes = new XMLStringBuilder();
    private XMLStringBuilder superExame;
    private List<MatRealHPardini> matReais;
    private List<String> infoComp;
    private String grupoAmostra = null;
    private String xmlAmostra = "";
    private boolean solucao = false;
    private boolean formatoPDF;
    private LabExternoService labExternoService = new LabExternoService();

    private ExameHPardini() {
    }

    public ExameHPardini(String descMatLab, String codExmLab, String descExmLab, String codExm, String codMat, String descMat, String descExm, String codigoFormato, boolean altura, boolean hematocrito, boolean linfocitosAbsoluto, boolean glicemia, boolean peso, boolean pesoAmostra, boolean tempoAmostra, boolean tempoDiurese, boolean volumeDiurese, String grupo, String regiao, String conservante, String condicao, boolean grafico, boolean imagem, boolean curva, boolean materialDiversos) {
        this.mncExame = codExm;
        this.mncMaterial = codMat;
        this.descExame = descExm;
        this.grupoAmostra = grupo;
        this.utilizarMatRequisicao = materialDiversos;
        ArrayList<String> conservantes = new ArrayList<String>();
        if (!Funcoes.textoVazio(conservante)) {
            conservantes.add(conservante);
        }
        this.matReais.add(new MatRealHPardini(codMat, descMat, conservantes));
    }

    public static ExameHPardini novaInstancia(String xml) {
        Funcoes.validarNaoNull(xml, "xml");
        ExameHPardini exa = new ExameHPardini();
        exa.carregarXMLExame(xml);
        return exa;
    }

    public ExameHPardini(String xmlExame, boolean solucao) {
        this.contemTagAmostra = !Funcoes.textoVazio(StringUtil.getValor(xmlExame, TAG_AMOSTRA));
        this.solucao = solucao;
        Funcoes.validarNaoNull(xmlExame, "xmlExame");
        this.mncMaterial = StringUtil.getValor(xmlExame, "MNMAT");
        this.mncExame = StringUtil.getValor(xmlExame, "MNEXA");
        this.descExame = StringUtil.getValor(xmlExame, "DESCEXA");
        if (this.contemTagAmostra) {
            this.xmlAmostra = StringUtil.getValor(xmlExame, TAG_AMOSTRA);
            this.grupoAmostra = StringUtil.getValor(this.xmlAmostra, TAG_GRUPO);
        }
        this.matReais = new ArrayList<MatRealHPardini>();
        String[] matReal = StringUtil.getValores(xmlExame, "MATREAL");
        if (matReal == null || matReal.length == 0) {
            matReal = StringUtil.getValores(xmlExame, "MATERIAL");
        }
        for (String material : matReal) {
            this.matReais.add(new MatRealHPardini(material, false));
        }
        this.infoComp = StringUtil.getListValores(xmlExame, "INFOCOMP");
        try {
            this.xmlDetalhes.escrever(TAG_DESCRICAO_EXAME, StringUtil.getValor(xmlExame, "DESCEXA"));
            this.xmlDetalhes.escrever(TAG_ORIGEM_ADMISSIVEL, StringUtil.getValor(xmlExame, "ORIGEMADMISSIVEL"));
            if (this.contemTagAmostra) {
                this.xmlDetalhes.escrever(TAG_GRUPO_AMOSTRA, this.grupoAmostra);
            }
            this.carregarDetalhesMaterialReal();
            this.carregaInfoAdicionalSolucao();
            String[] infoAdicionais = StringUtil.getValores(xmlExame, "INFOCOMP");
            if ((infoAdicionais == null || infoAdicionais.length == 0) && solucao) {
                for (String info : this.infoComp) {
                    this.xmlDetalhes.escrever(TAG_INFO_COMPLEMENTAR, info);
                }
            } else {
                for (String info : infoAdicionais) {
                    this.xmlDetalhes.escrever(TAG_INFO_COMPLEMENTAR, info);
                }
            }
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameHPardini: 96");
        }
    }

    ExameHPardini(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.codExaJalis = res.getString("exa_codigo");
        this.codMatJalis = res.getString("mco_codigo");
        this.codLabExterno = res.getString("lae_codigo");
        this.carregarXMLExame(res.getString("ele_xmllabexterno"));
    }

    public void setMncMaterial(String mncMaterial) {
        this.mncMaterial = mncMaterial;
    }

    public void setMncExame(String mncExame) {
        this.mncExame = mncExame;
    }

    public void setDescExame(String descExame) {
        this.descExame = descExame;
    }

    public String getXMLExame() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_EHP);
            xml.abrir(TAG_EXAME);
            xml.escrever(TAG_CODIGO_EXAME, this.mncExame);
            xml.escrever(TAG_CODIGO_MATERIAL, this.mncMaterial);
            xml.escrever(TAG_DESCRICAO_EXAME, this.descExame);
            if (this.contemTagAmostra) {
                xml.escrever(TAG_GRUPO_AMOSTRA, this.grupoAmostra);
            }
            xml.escrever(TAG_DETALHES, this.xmlDetalhes);
            xml.fechar(TAG_EXAME);
            xml.escrever(TAG_UTILIZAR_MAT_REQUISICAO, String.valueOf(this.utilizarMatRequisicao));
            xml.escrever(TAG_CONDICAO_SELECIONADA, String.valueOf(this.condicaoSelecionada));
            xml.escrever(TAG_NUMERO_AMOSTRA, this.numeroAmostra);
            xml.escrever(TAG_MATERIAL_ESPEC_CONFIGURACAO, String.valueOf(this.materialEspecConfig));
            xml.escrever(TAG_MATERIAL_SELECIONADO, this.materialSelecionado);
            xml.escrever(TAG_CONSERVANTE_SELECIONADO, this.conservanteSelecionado);
            xml.escrever(TAG_FORMATO_PDF, this.formatoPDF ? SIM : NAO);
            xml.fechar(TAG_EHP);
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameHPardini: 153");
        }
        return xml.getXML();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorEhp = StringUtil.getValor(xml, TAG_EHP);
        return valorEhp != null && valorEhp.trim().length() > 0 && (valorExame = StringUtil.getValor(valorEhp, TAG_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public boolean mesmoExame(String xml) {
        return StringUtil.getValor(xml, TAG_CODIGO_EXAME).equals(this.mncExame) && StringUtil.getValor(xml, TAG_CODIGO_MATERIAL).equals(this.mncMaterial);
    }

    public static Set<ExameHPardini> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameHPardini> list = new HashSet<ExameHPardini>();
        if (res.first()) {
            do {
                list.add(new ExameHPardini(res));
            } while (res.next());
        }
        return list;
    }

    public static List<ExameHPardini> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameHPardini> exames = new ArrayList<ExameHPardini>();
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        if (st != null) {
            try {
                bui.append("select * \n");
                bui.append("from examespardini \n");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("      lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("order by ehp_descricaoexame");
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                while (res.next()) {
                    ExameHPardini exa = new ExameHPardini();
                    exa.mncExame = res.getString("ehp_codexame");
                    exa.mncMaterial = res.getString("ehp_codmaterial");
                    exa.descExame = res.getString("ehp_descricaoexame");
                    exa.codLabExterno = codigoLabExterno;
                    exa.carregarXMLDetalhes(res.getString("ehp_xml"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + bui.toString(), e.getStackTrace(), "ExameHPardini: 156");
            }
        }
        return exames;
    }

    public String getMnemonicoMaterial() {
        return this.mncMaterial;
    }

    public String getMnemonicoExame() {
        return this.mncExame;
    }

    public String getDescricaoExame() {
        return this.descExame;
    }

    public String getXMLDetalhes() {
        XMLStringBuilder temp = new XMLStringBuilder();
        temp.escrever(TAG_DETALHES, this.xmlDetalhes);
        return temp.getXML();
    }

    public List<MatRealHPardini> getMateriaisReais() {
        return this.matReais;
    }

    public boolean contemInfoComp(String valor) {
        return this.infoComp.contains(valor);
    }

    public List<String> getInformacoesComplementares() {
        return this.infoComp;
    }

    public boolean equals(Object o) {
        if (o instanceof ExameHPardini) {
            ExameHPardini ep = (ExameHPardini)o;
            return this.mncExame.equals(ep.mncExame) && this.mncMaterial.equals(ep.mncMaterial);
        }
        return false;
    }

    public int hashCode() {
        return this.mncExame.hashCode() + this.mncMaterial.hashCode();
    }

    private void carregarXMLExame(String xml) {
        String exame = StringUtil.getValor(xml, TAG_EHP);
        this.utilizarMatRequisicao = StringUtil.getBoolean(exame, TAG_UTILIZAR_MAT_REQUISICAO);
        this.condicaoSelecionada = StringUtil.getBoolean(exame, TAG_CONDICAO_SELECIONADA);
        this.materialEspecConfig = StringUtil.getBoolean(exame, TAG_MATERIAL_ESPEC_CONFIGURACAO);
        this.materialSelecionado = StringUtil.getValor(exame, TAG_MATERIAL_SELECIONADO);
        this.conservanteSelecionado = StringUtil.getValor(exame, TAG_CONSERVANTE_SELECIONADO);
        this.numeroAmostra = StringUtil.getValor(exame, TAG_NUMERO_AMOSTRA);
        this.mncExame = StringUtil.getValor(exame, TAG_CODIGO_EXAME);
        this.mncMaterial = StringUtil.getValor(exame, TAG_CODIGO_MATERIAL);
        this.descExame = StringUtil.getValor(exame, TAG_DESCRICAO_EXAME);
        this.grupoAmostra = StringUtil.getValor(exame, TAG_GRUPO_AMOSTRA);
        this.formatoPDF = StringUtil.getValor(exame, TAG_FORMATO_PDF).equals(SIM);
        this.carregarXMLDetalhes(exame);
    }

    public void carregarXMLDetalhes(String xml) {
        try {
            String detalhes = StringUtil.getValor(xml, TAG_DETALHES);
            this.infoComp = StringUtil.getListValores(detalhes, TAG_INFO_COMPLEMENTAR);
            this.matReais = MatRealHPardini.getMateriaisReais(xml);
            this.xmlDetalhes.limpar();
            this.xmlDetalhes.escrever(TAG_DESCRICAO_EXAME, StringUtil.getValor(detalhes, TAG_DESCRICAO_EXAME));
            this.xmlDetalhes.escrever(TAG_ORIGEM_ADMISSIVEL, StringUtil.getValor(detalhes, TAG_ORIGEM_ADMISSIVEL));
            this.xmlDetalhes.escrever(TAG_GRUPO_AMOSTRA, StringUtil.getValor(detalhes, TAG_GRUPO_AMOSTRA));
            this.grupoAmostra = StringUtil.getValor(detalhes, TAG_GRUPO_AMOSTRA);
            this.carregarDetalhesMaterialReal();
            this.carregaInfoAdicionalSolucao();
            for (String info : this.infoComp) {
                this.xmlDetalhes.escrever(TAG_INFO_COMPLEMENTAR, info);
            }
        }
        catch (XMLStringBuilderException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ExameHPardini: 348");
        }
    }

    private void carregaInfoAdicionalSolucao() {
        if (this.isSolucao() && this.infoComp.isEmpty() && this.getMnemonicoMaterial().length() > 2 && this.getMnemonicoMaterial().charAt(0) == 'U' && this.getMnemonicoMaterial().substring(1).matches("\\d[0-9]")) {
            this.infoComp.add(PESO);
            this.infoComp.add(ALTURA);
            this.infoComp.add(VOLUME_DIURESE);
        }
    }

    private void carregarDetalhesMaterialReal() throws XMLStringBuilderException {
        for (MatRealHPardini matReal : this.matReais) {
            if (!MatRealHPardini.validaMaterialDuplicado(StringUtil.getValor(this.xmlDetalhes.toString(), TAG_DESCRICAO_MATERIAL_REAL), matReal.getDescricaoMatReal())) continue;
            this.xmlDetalhes.abrir(TAG_MATERIAL_REAL);
            this.xmlDetalhes.escrever(TAG_DESCRICAO_MATERIAL_REAL, matReal.getDescricaoMatReal());
            for (String conservante : matReal.getConservantes()) {
                this.xmlDetalhes.escrever(TAG_CONSERVANTE, conservante);
            }
            this.xmlDetalhes.fechar(TAG_MATERIAL_REAL);
        }
    }

    public void setSelecionado(boolean isSelecionado) {
        this.isSelecionado = isSelecionado;
    }

    public boolean isSelecionado() {
        return this.isSelecionado;
    }

    public void setUtilizarMatRequisicao(boolean utilizarMatRequisicao) {
        this.utilizarMatRequisicao = utilizarMatRequisicao;
    }

    public boolean utilizarMatRequisicao() {
        return this.utilizarMatRequisicao;
    }

    public boolean isCondicaoSelecionada() {
        return this.condicaoSelecionada;
    }

    public void setCondicaoSelecionada(boolean condicaoSelecionada) {
        this.condicaoSelecionada = condicaoSelecionada;
    }

    public void setMaterialEspecConfig(boolean materialEspecConfig) {
        this.materialEspecConfig = materialEspecConfig;
    }

    public boolean materialEspecConfiguracao() {
        return this.materialEspecConfig;
    }

    public void setMaterialSelecionado(String materialSelecinado) {
        this.materialSelecionado = materialSelecinado;
    }

    public String getMaterialSelecinado() {
        return this.materialSelecionado;
    }

    public void setConservanteSelecionado(String conservanteSelecionado) {
        this.conservanteSelecionado = conservanteSelecionado;
    }

    public String getConservanteSelecionado() {
        return this.conservanteSelecionado;
    }

    public String getGrupoAmostra() {
        return this.grupoAmostra;
    }

    public void setCodLabExterno(String codLabExterno) {
        this.codLabExterno = codLabExterno;
    }

    private boolean isSolucao() {
        return this.solucao;
    }

    private void setSolucao(boolean solucao) {
        this.solucao = solucao;
    }

    public String getNumeroAmostra() {
        return this.numeroAmostra;
    }

    public void setNumeroAmostra(String numeroAmostra) {
        this.numeroAmostra = numeroAmostra;
    }

    public boolean isFormatoPDF() {
        return this.formatoPDF;
    }

    public void setFormatoPDF(boolean formatoPDF) {
        this.formatoPDF = formatoPDF;
    }

    public void setXMLDetalhes(String xml) {
        XMLStringBuilder temp = new XMLStringBuilder();
        temp.escrever(StringUtil.getValor(xml, TAG_DETALHES));
        this.xmlDetalhes = temp;
    }

    public String getXMLEHP(String xmlDetalhes, String xmlSuperExame) {
        XMLStringBuilder temp = new XMLStringBuilder();
        temp.escrever(TAG_DETALHES, StringUtil.getValor(xmlDetalhes, TAG_DETALHES));
        temp.escrever(TAG_SUPEREXAME, StringUtil.getValor(xmlSuperExame, TAG_SUPEREXAME, false, null, false));
        StringUtil.preencheCData(temp.toString());
        return temp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStringBuilder getDadosSuperExame(int codigoLabExterno, ExameHPardini exmHP) throws SQLException {
        Statement st = Conexao.getStatement();
        XMLStringBuilder xmlSuperExame = new XMLStringBuilder();
        StringBuilder bui = new StringBuilder();
        if (st != null) {
            try {
                bui.append("select * ");
                bui.append("from examespardini ");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                bui.append(" and lae_codigo = ").append(codigoLabExterno);
                bui.append(" and ehp_codmaterial = ").append(StringUtil.textoDBEscape(exmHP.getMnemonicoMaterial()));
                bui.append(" and ehp_codexame = ").append(StringUtil.textoDBEscape(exmHP.getMnemonicoExame()));
                ResultSet res = Conexao.executeQuery(st, bui.toString());
                if (res.next()) {
                    xmlSuperExame.escrever(TAG_SUPEREXAME, StringUtil.getValor(res.getString("ehp_xml"), TAG_SUPEREXAME, false, null, false));
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + bui.toString(), e.getStackTrace(), "ExameHPardini: 156");
            }
            finally {
                st.close();
            }
        }
        return xmlSuperExame;
    }

    public void setSuperExame(XMLStringBuilder superExame) {
        this.superExame = superExame;
    }

    public String getSuperExame() {
        XMLStringBuilder temp = new XMLStringBuilder();
        temp.escrever(this.superExame.toString());
        return temp.getXML();
    }
}

