/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.DialogoCamposImportacaoSelecionavel;
import jalis.laboratorio.util.parsers.pardini.CamposImportacaoRenderer;
import jalis.laboratorio.util.parsers.pardini.NoArvore;
import jalis.laboratorio.util.parsers.pardini.resultado.CamposRelacionamentoHPardiniUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardiniImpl;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TableUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DialogoCamposImportacaoHPardini
extends DialogoCamposImportacaoSelecionavel {
    private JTree arvore;
    private ElementoHPardini superExame;
    private String campoSelecionado = "";
    private JTabbedPane abaCampos;
    private HashMap<String, String[]> campos;

    public static DialogoCamposImportacaoHPardini novaInstancia(Object pai, Object camposImportacao, ArrayList<CamposImportacao> examesDesm) {
        if (pai instanceof Frame) {
            return new DialogoCamposImportacaoHPardini((Frame)pai, camposImportacao, examesDesm);
        }
        if (pai instanceof Dialog) {
            return new DialogoCamposImportacaoHPardini((Dialog)pai, camposImportacao, examesDesm);
        }
        return null;
    }

    public DialogoCamposImportacaoHPardini(Frame pai, Object camposImportacao, ArrayList<CamposImportacao> examesDesm) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. H. Pardini", camposImportacao, examesDesm);
    }

    public DialogoCamposImportacaoHPardini(Dialog pai, Object camposImportacao, ArrayList<CamposImportacao> examesDesm) {
        super(pai, "Sele\u00e7\u00e3o de campo de importa\u00e7\u00e3o do lab. H. Pardini", camposImportacao, examesDesm);
    }

    @Override
    public void iniciar(Object camposImportacao) {
        this.modelo = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o"});
        this.table = ComponenteFactory.novoJTable((TableModel)this.modelo, 0);
        this.scroll = new JScrollPane(this.table);
        this.getPanelCentral().setLayout(new BorderLayout());
        if (this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty()) {
            for (CamposImportacao campo : this.getListaExamesDesmLabExterno()) {
                this.getComboDesm().addItem(campo.getCodigoExame());
                this.getMapTabs().put(campo.getCodigoExame(), campo);
            }
            this.carregaCamposDesm(this.getListaExamesDesmLabExterno().get(0));
            this.getComboDesm().setBorder(new TitledBorder("Desmembramento"));
            this.getPanelCentral().add((Component)this.getComboDesm(), "North");
            this.getPanelCentral().add((Component)this.abaCampos, "Center");
        } else {
            Funcoes.validarInstanciaDe(ElementoHPardini.class, camposImportacao, "camposImportacao");
            this.superExame = (ElementoHPardini)camposImportacao;
            if (!this.superExame.getNome().equals("SuperExame")) {
                throw new IllegalArgumentException("A raiz dos campos de importa\u00e7\u00e3o n\u00e3o \u00e9 o elemento SuperExame do XML do H. Pardini");
            }
            this.abaCampos = new JTabbedPane();
            this.getPanelCentral().setLayout(new BorderLayout());
            this.getPanelCentral().add((Component)this.abaCampos, "Center");
            this.abaCampos.addTab("Simplificado", this.scroll);
            this.abaCampos.addTab("Complexo", new JScrollPane(this.carregarArvore()));
            this.modelo.addLine(new String[]{"", ""});
            for (String key : this.campos.keySet()) {
                Object[] linha = new String[2];
                String[] lin = this.campos.get(key);
                linha[0] = lin[1].concat(lin[0]);
                linha[1] = key;
                this.modelo.addLine(linha);
            }
            this.modelo.ordenarColuna(0);
            this.modelo.setValueAt("Nenhum", 0, 0);
            this.table.setAutoResizeMode(4);
            this.getPanelCentral().add((Component)this.abaCampos, "Center");
        }
        this.getComboDesm().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CamposImportacao campo = DialogoCamposImportacaoHPardini.this.getMapTabs().get(DialogoCamposImportacaoHPardini.this.getComboDesm().getSelectedItem());
                DialogoCamposImportacaoHPardini.this.carregaCamposDesm(campo);
            }
        });
        this.setSize(new Dimension(400, 500));
        ScreenUtil.centralizar(this);
    }

    @Override
    public String getCampoSelecionado() {
        if (this.table.getSelectedRow() > -1 && this.abaCampos.getSelectedIndex() == 0) {
            String exameDesmSelecionado;
            String string = exameDesmSelecionado = this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty() ? "@" + this.getComboDesm().getSelectedItem() : "";
            if (!Funcoes.textoVazio(this.campoSelecionado) && this.campoSelecionado.contains("@")) {
                if (this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty()) {
                    return this.campoSelecionado + "#" + this.getMapTabs().get(this.getComboDesm().getSelectedItem().toString()).getMaterialPaiDesm();
                }
                return this.campoSelecionado;
            }
            if (!Funcoes.textoVazio(this.campoSelecionado)) {
                return this.campoSelecionado;
            }
        } else {
            if (this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty() && !Funcoes.textoVazio(this.campoSelecionado)) {
                return this.campoSelecionado + "#" + this.getMapTabs().get(this.getComboDesm().getSelectedItem().toString()).getMaterialPaiDesm();
            }
            return this.campoSelecionado;
        }
        return "";
    }

    @Override
    public void setCampoSelecionado(String campoSelecionado) {
        Funcoes.validarNaoNull(campoSelecionado, "campo");
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("@") && campoSelecionado.contains("#")) {
            Scanner scanner = new Scanner(campoSelecionado).useDelimiter("\\@");
            campoSelecionado = scanner.next();
            scanner = new Scanner(scanner.next()).useDelimiter("\\#");
            String exameDesmSelecionado = scanner.next();
            String materialPaiDesm = scanner.next();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        } else if (campoSelecionado.contains("~")) {
            campoSelecionado = campoSelecionado.substring(campoSelecionado.indexOf("|") + 1, campoSelecionado.length());
        } else if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.contains("#")) {
            String exameDesmSelecionado = campoSelecionado.split("#")[1];
            campoSelecionado = campoSelecionado.split("#")[0].trim();
            this.getComboDesm().setSelectedItem(exameDesmSelecionado.trim());
        }
        if (!Funcoes.textoVazio(campoSelecionado) && campoSelecionado.startsWith("~") && this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty()) {
            campoSelecionado = campoSelecionado.substring(campoSelecionado.indexOf("|") + 1);
        }
        this.campoSelecionado = campoSelecionado;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.arvore.getModel().getRoot();
        ElementoHPardini ele = CamposRelacionamentoHPardiniUtil.getCampoDoSuperExame(this.superExame, campoSelecionado);
        this.setRowCampoSelecionado(campoSelecionado);
        this.selecionarCampo(node, ele);
    }

    private void setRowCampoSelecionado(String campo) {
        int row;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.arvore.getModel().getRoot();
        if (this.abaCampos.getSelectedIndex() == 0) {
            this.desmarcaTodos(treeNode, campo);
        }
        if (this.modelo.getRowCount() > 0 && (row = this.modelo.localizar(1, campo)) > -1) {
            this.table.setRowSelectionInterval(row, row);
            TableUtil.scrollToVisible(this.table, row);
        }
    }

    private void desmarcaTodos(TreeNode treeNode, String campo) {
        Enumeration<? extends TreeNode> en = treeNode.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            NoArvore noArvore = (NoArvore)node.getUserObject();
            if (noArvore.checado && !campo.equals(CamposRelacionamentoHPardiniUtil.getStringCaminhoDeCampoSelecionado(this.getCaminhoSelecionado(node)))) {
                noArvore.checado = false;
                return;
            }
            this.desmarcaTodos(node, campo);
        }
    }

    @Override
    protected boolean acaoOk() {
        String exameDesmSelecionado;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.arvore.getModel().getRoot();
        String string = exameDesmSelecionado = this.getListaExamesDesmLabExterno() != null && !this.getListaExamesDesmLabExterno().isEmpty() ? "@" + this.getComboDesm().getSelectedItem() : "";
        if (this.abaCampos.getSelectedIndex() == 0 && !Funcoes.textoVazio(this.campoSelecionado)) {
            this.campoSelecionado = !this.campoSelecionado.contains("@") && !Funcoes.textoVazio(exameDesmSelecionado) ? this.campoSelecionado + exameDesmSelecionado : this.modelo.getValueAt(this.table.getSelectedRow(), 1).toString();
        } else if (this.verificaSeTemNoChecado(node)) {
            DefaultMutableTreeNode selecionado = this.getTreeNodeSelecionado(node);
            if (selecionado != null) {
                this.campoSelecionado = CamposRelacionamentoHPardiniUtil.getStringCaminhoDeCampoSelecionado(this.getCaminhoSelecionado(selecionado)) + exameDesmSelecionado;
            }
        } else {
            this.campoSelecionado = "";
        }
        return true;
    }

    private boolean verificaSeTemNoChecado(TreeNode node) {
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode filho = (DefaultMutableTreeNode)en.nextElement();
            NoArvore noArvore = (NoArvore)filho.getUserObject();
            if (!noArvore.checado && !this.verificaSeTemNoChecado(filho)) continue;
            return true;
        }
        return false;
    }

    private ElementoHPardini[] getCaminhoSelecionado(DefaultMutableTreeNode noSelecionado) {
        TreeNode[] path = noSelecionado.getPath();
        ElementoHPardini[] caminho = new ElementoHPardini[path.length];
        for (int i = 0; i < path.length; ++i) {
            caminho[i] = ((NoArvore)((DefaultMutableTreeNode)path[i]).getUserObject()).elemento;
        }
        return caminho;
    }

    private DefaultMutableTreeNode getTreeNodeSelecionado(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode filho = (DefaultMutableTreeNode)en.nextElement();
            NoArvore noArvore = (NoArvore)filho.getUserObject();
            if (!noArvore.checado && (filho = this.getTreeNodeSelecionado(filho)) == null) continue;
            return filho;
        }
        return null;
    }

    private DefaultMutableTreeNode getTreeNode(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode filho = (DefaultMutableTreeNode)en.nextElement();
            if ((filho = this.getTreeNode(filho)) == null) continue;
            return filho;
        }
        return null;
    }

    private void checarNoSelecionado() {
        TreePath path = this.arvore.getSelectionPath();
        if (path != null && path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
            NoArvore noArvore = (NoArvore)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (noArvore.checavel) {
                boolean bl = noArvore.checado = !noArvore.checado;
                if (this.abaCampos.getSelectedIndex() == 0) {
                    this.setCampoSelecionado(CamposRelacionamentoHPardiniUtil.getStringCaminhoDeCampoSelecionado(this.getCaminhoSelecionado((DefaultMutableTreeNode)path.getLastPathComponent())));
                }
                this.removerChecagemDeOutroNo((TreeNode)this.arvore.getModel().getRoot(), noArvore);
                if (this.abaCampos.getSelectedIndex() == 1) {
                    this.setRowCampoSelecionado(noArvore.checado ? CamposRelacionamentoHPardiniUtil.getStringCaminhoDeCampoSelecionado(this.getCaminhoSelecionado((DefaultMutableTreeNode)path.getLastPathComponent())) : "");
                }
                this.arvore.revalidate();
                this.arvore.repaint();
            }
        }
    }

    private void removerChecagemDeOutroNo(TreeNode treeNode, NoArvore novoChecado) {
        Enumeration<? extends TreeNode> en = treeNode.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            NoArvore noArvore = (NoArvore)node.getUserObject();
            if (noArvore != novoChecado && noArvore.checado) {
                noArvore.checado = false;
                return;
            }
            this.removerChecagemDeOutroNo(node, novoChecado);
        }
    }

    private boolean selecionarCampo(DefaultMutableTreeNode node, ElementoHPardini elemento) {
        NoArvore noArvore = (NoArvore)node.getUserObject();
        if (elemento == noArvore.elemento) {
            noArvore.checado = true;
            this.removerChecagemDeOutroNo(node, noArvore);
            this.setRowCampoSelecionado(this.campoSelecionado);
            TreePath path = this.getTreePath(node.getPath());
            this.arvore.setSelectionPath(path);
            this.arvore.scrollPathToVisible(path);
            return true;
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode filho = (DefaultMutableTreeNode)en.nextElement();
            if (!this.selecionarCampo(filho, elemento)) continue;
            this.arvore.expandPath(this.getTreePath(node.getPath()));
            return true;
        }
        return false;
    }

    private TreePath getTreePath(TreeNode[] path) {
        TreePath treePath = new TreePath(path[0]);
        for (int i = 1; i < path.length; ++i) {
            treePath = treePath.pathByAddingChild(path[i]);
        }
        return treePath;
    }

    private JTree carregarArvore() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new NoArvore(this.superExame));
        this.addCampo(this.superExame, "SuperExame", "ValorReferenciaBlocoTexto");
        this.addCampo(this.superExame, "SuperExame", "Grafico");
        this.carregarFilhos(node, this.superExame.getFilhos());
        this.campos = new HashMap();
        this.getCamposSimplificado(node, "");
        this.arvore = new JTree(node);
        this.arvore.setCellRenderer(new CamposImportacaoRenderer());
        this.arvore.setRowHeight(18);
        this.arvore.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    DialogoCamposImportacaoHPardini.this.checarNoSelecionado();
                }
            }
        });
        this.arvore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DialogoCamposImportacaoHPardini.this.checarNoSelecionado();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DialogoCamposImportacaoHPardini.this.setCampoSelecionado(DialogoCamposImportacaoHPardini.this.modelo.getValueAt(DialogoCamposImportacaoHPardini.this.table.getSelectedRow(), 1).toString());
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    DialogoCamposImportacaoHPardini.this.setCampoSelecionado(DialogoCamposImportacaoHPardini.this.modelo.getValueAt(DialogoCamposImportacaoHPardini.this.table.getSelectedRow(), 1).toString());
                }
            }
        });
        return this.arvore;
    }

    private void getCamposSimplificado(DefaultMutableTreeNode nodeCampos, String itemNome) {
        Enumeration<TreeNode> en = nodeCampos.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode filho = (DefaultMutableTreeNode)en.nextElement();
            NoArvore noArvore = (NoArvore)filho.getUserObject();
            int ini = noArvore.nome.indexOf("(");
            if (ini > 1 && noArvore.nome.contains(")")) {
                itemNome = noArvore.nome.substring(ini + 1, noArvore.nome.length() - 1);
            }
            if (!filho.isLeaf()) {
                this.getCamposSimplificado(filho, itemNome);
                continue;
            }
            String s = CamposRelacionamentoHPardiniUtil.getStringCaminhoDeCampoSelecionado(this.getCaminhoSelecionado(filho));
            StringBuilder desc = new StringBuilder();
            String[] fields = s.replace("|", ";").split(";");
            String[] campo = fields[fields.length - 1].split(":");
            String idRes = "";
            String idLin = "";
            campo[0] = campo.length > 1 && campo[1].contains("=") ? " do campo ".concat(campo[0]).concat(campo[1].split("=")[1]) : (!campo[0].equalsIgnoreCase("Observacao") ? " do campo ".concat(campo[0]) : "");
            for (String st : fields) {
                if (st.contains("Resultado:idResultado=")) {
                    idRes = st.split("=")[1];
                }
                if (!st.contains("Linha:idLinha=")) continue;
                idLin = st.split("=")[1];
            }
            if (!s.contains("Exame".concat(":")) || s.contains("Nome") || s.contains("Metodo")) continue;
            if (s.contains("Linha".concat(":"))) {
                desc.append("Linha").append(idLin).append(" do ");
                if (s.contains("ValorDeReferencia".concat("|"))) {
                    desc.append("ValorDeReferencia");
                }
            } else if (s.contains("ValorDeReferencia".concat("|"))) {
                desc.append("ValorDeReferencia");
            } else if (s.contains("Resultado".concat(":"))) {
                desc.append("Resultado").append(idRes);
            }
            if (!Funcoes.textoVazio(itemNome)) {
                desc.append(" do item ").append(itemNome);
            }
            if (Funcoes.textoVazio(desc.toString())) {
                desc.append(noArvore.nome).append(" do ").append("Exame");
            }
            this.campos.put(CamposRelacionamentoHPardiniUtil.getStringCaminhoDeCampoSelecionado(this.getCaminhoSelecionado(filho)), new String[]{campo[0], desc.toString()});
        }
    }

    private void carregarFilhos(DefaultMutableTreeNode node, List<ElementoHPardini> filhos) {
        for (ElementoHPardini filho : filhos) {
            DefaultMutableTreeNode noFilho = new DefaultMutableTreeNode(new NoArvore(filho));
            this.addCampo(filho, "Exame", "Observacao");
            this.carregarFilhos(noFilho, filho.getFilhos());
            node.add(noFilho);
        }
    }

    private void addCampo(ElementoHPardini filho, String tag, String novaTagDeResultado) {
        if (filho.getNome().equalsIgnoreCase(tag) && !filho.contemFilho(novaTagDeResultado) && filho instanceof ElementoHPardiniImpl) {
            ((ElementoHPardiniImpl)filho).addFilho(new ElementoHPardiniImpl(filho, novaTagDeResultado));
        }
    }

    public void carregaCamposDesm(CamposImportacao campo) {
        Funcoes.validarInstanciaDe(ElementoHPardini.class, campo.getCamposImportacao(), "camposImportacao");
        this.superExame = (ElementoHPardini)campo.getCamposImportacao();
        if (!this.superExame.getNome().equals("SuperExame")) {
            throw new IllegalArgumentException("A raiz dos campos de importa\u00e7\u00e3o n\u00e3o \u00e9 o elemento SuperExame do XML do H. Pardini");
        }
        if (this.abaCampos == null) {
            this.abaCampos = new JTabbedPane();
        }
        if (this.abaCampos.getComponentCount() > 0) {
            this.abaCampos.setComponentAt(0, this.scroll);
        } else {
            this.abaCampos.addTab("Simplificado", this.scroll);
        }
        if (this.abaCampos.getComponentCount() > 1) {
            this.abaCampos.setComponentAt(1, new JScrollPane(this.carregarArvore()));
        } else {
            this.abaCampos.addTab("Complexo", new JScrollPane(this.carregarArvore()));
        }
        this.modelo.clear();
        Object[] linha = new String[]{"Nenhum", ""};
        this.modelo.addLine(linha);
        ArrayList<Object[]> linhas = new ArrayList<Object[]>();
        for (String string : this.campos.keySet()) {
            linha = new String[2];
            String[] lin = this.campos.get(string);
            linha[0] = lin[1].concat(lin[0]);
            linha[1] = string;
            linhas.add(linha);
        }
        this.ordenaCampos(linhas);
        for (String string : linhas) {
            this.modelo.addLine((String[])string);
        }
        this.table.setAutoResizeMode(4);
    }

    private void ordenaCampos(ArrayList linhas) {
        Collections.sort(linhas, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof String[] && o2 instanceof String[]) {
                    String ordem1 = ((String[])o1)[0];
                    String ordem2 = ((String[])o2)[0];
                    return ordem1 != null && ordem2 != null ? ordem1.compareToIgnoreCase(ordem2) : 0;
                }
                return 0;
            }
        });
    }
}

